#### Aya - A Gemini server
#### Copyright (C) 2021 Remilia Scarlet <remilia@posteo.jp>
####
#### This program is free software: you can redistribute it and/or modify
#### it under the terms of the GNU Affero General Public License as
#### published by the Free Software Foundation, either version 3 of the
#### License, or (at your option) any later version.
####
#### This program is distributed in the hope that it will be useful,
#### but WITHOUT ANY WARRANTY; without even the implied warranty of
#### MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#### GNU Affero General Public License for more details.
####
#### You should have received a copy of the GNU Affero General Public License
#### along with this program.  If not, see <https://www.gnu.org/licenses/>.
require "socket"

{% if flag?(:win32) %}
  @[Link(ldflags: "#{__DIR__}\\support.obj")]
{% else %}
  @[Link(ldflags: "#{__DIR__}/support.o")]
{% end %}
lib SupportExt
  alias Char = LibC::Char
  fun get_addresses(fd : Int32, addrs : Pointer(Char*)) : Int32
end

module Aya::Support
  extend self

  def getAddresses(sock : Socket) : Array(String)
    addrs = StaticArray(Pointer(UInt8), 16).new(Pointer(UInt8).new(0))
    numAddrs = SupportExt.get_addresses(sock.fd, addrs.to_unsafe)
    ret = [] of String

    numAddrs.times do |addr|
      ret << String.new(addrs[addr])
    end

    ret
  end
end
