static    char    sccsid[]="%Z% %M% %I% %E% %U%";
/*
 *	akxsEList.c
 *
 *		coded   by A.Kobayashi 2004.4.18
 *
 *
 */
#include "akxcommon.h"

tdtRB_CTL *akxs_elist_new(lBS,lRM)
int lBS,lRM;
{
	return akxs_list_new(lBS,lRM);
}

int akxs_elist_free(pCt,opt)
tdtRB_CTL *pCt;
int opt;
{
	tdtRB_CHAIN *pr, *pn;
	char *p;

	if (!pCt) return -1;
	pr = pCt->rb_raddr;
	while (pr) {
		if (p = pr->rbc_buf) {
			if (opt && p) Free(p);
		}
		pn = pr;
		pr = pr->rbc_next;
		Free(pn);
	}
	Free(pCt);
	return 0;
}

int akxs_elist_get(pCt,pp)
tdtRB_CTL *pCt;
char **pp;
{
	tdtRB_CHAIN *pr;
	char *p;

	if (!pCt) return -1;
	pr = pCt->rb_raddr;
	while (pr) {
/*
printf("akxs_elist_get: pr=%08x cpBuff=%08x\n",pr,pr->rbc_buf);
*/
		if (p = pr->rbc_buf) {
			*pp = p;
			pr->rbc_buf = NULL;
			pCt->rb_used--;
			return 1;
		}
		pr = pr->rbc_next;
	}
	return 0;
}

int akxs_elist_set(pCt, addr)
tdtRB_CTL *pCt;
char *addr;
{
	tdtRB_CHAIN *pr, *pn, *pre;

	if (!pCt) return -1;
	if (!addr) return -2;
	pre = NULL;
	pr = pCt->rb_raddr;
	while (pr) {
/*
printf("akxs_elist_set: pr=%08x cpBuff=%08x\n",pr,pr->rbc_buf);
*/
		if (!pr->rbc_buf) {
			pr->rbc_buf = addr;
			pCt->rb_used++;
			return 1;
		}
		pre = pr;
		pr = pr->rbc_next;
	}
	if (!(pn = (tdtRB_CHAIN *)Malloc(sizeof(tdtRB_CHAIN)))) return 0;
	pn->rbc_buf = addr;
	pn->rbc_next = NULL;
/*
printf("akxs_elist_set: pre=%08x pn=%08x\n",pre,pn);
*/
	if (pre) pre->rbc_next = pn;
	else pCt->rb_raddr = pn;
	pCt->rb_used++;
	return 1;
}

int akxs_elist_srch(pCt, addr, compar, opt)
tdtRB_CTL *pCt;
char *addr;
int (*compar)();
int opt;
{
	int f;
	tdtRB_CHAIN *pr, *pre;
	char *p;

	if (!pCt) return -1;
	pre = NULL;
	pr = pCt->rb_raddr;
	while (pr) {
/*
printf("akxs_elist_srch: pr=%08x cpBuff=%08x\n",pr,pr->rbc_buf);
*/
		if (p = pr->rbc_buf) {
			if (compar) f = !compar(addr,p);
			else f = (addr == p);
			if (f) {
				if (opt) {
					pr->rbc_buf = NULL;
					pCt->rb_used--;
				}
				return 1;
			}
		}
		pr = pr->rbc_next;
	}
	return 0;
}

int akxs_elist_read(pCt, cmd, pp)
tdtRB_CTL *pCt;
int     cmd;
char   **pp;
{
	return akxs_list_read(pCt, cmd, pp);
}

int akxs_uchain_set(iMax,iUChain,iSet)
int iMax,iUChain[],iSet;
{
	/* iUChain[0]: First Used Point */
	int i,next;

	if (!iUChain) return -1;
	if (iSet<1 || iSet>iMax) return -2;
	i = 0;
	next = iUChain[i];
	while (next) {
		if (next == iSet) return iSet;
		i = next;
		next = iUChain[i];
	}
	iUChain[i] = iSet;

printf("akxs_uchain_set: iSet=%d i=%d\n",iSet,i);

	return 0;
}

int akxs_uchain_del(iMax,iUChain,iDel)
int iMax,iUChain[],iDel;
{
	/* iUChain[0]: First Used Point */
	int i,next;
/*
printf("akxs_uchain_del: iMax=%d iDel=%d\n",iMax,iDel);
*/
	if (!iUChain) return -1;
	if (iDel<1 || iDel>iMax) return -2;
	i = 0;
	next = iUChain[i];
	while (next) {
/*
printf("akxs_uchain_del: next=%d\n",next);
*/
		if (next == iDel) break;
		i = next;
		next = iUChain[i];
	}
	if (!next) return -3;
	iUChain[i] = iUChain[next];
	iUChain[next] = 0;

printf("akxs_uchain_del: iDel=%d i=%d\n",iDel,i);

	return 0;
}

int akxs_uchain_setAll(iMax,iUChain)
int iMax,iUChain[];
{
	int i;

	if (!iUChain) return -1;

	iMax--;
	for (i=0;i<iMax;i++) {
		iUChain[i] = i + 1;
	}
	iUChain[iMax] = 0;

	return 0;
}

int akxs_uchain_delAll(iMax,iUChain)
int iMax,iUChain[];
{
	if (!iUChain) return -1;
	memset(iUChain,0,iMax*sizeof(int));

	return 0;
}
