static    char    sccsid[]="%Z% %M% %I% %E% %U%";
/****************************************************************************
*																			*
*	@\@F																*
*																			*
*	́@F@int cl_user_func(pLeaf, name)									*
*	@F@(IN    ) Leaf	*pLeaf											*
*			@(IN    ) char	*name											*
*																			*
*	ߒl@F@ERROR															*
*			@NORMAL														*
*	쐬@F																*
*	XV@F																*
*																			*
*****************************************************************************/
#include <colmn.h>

#define DEBUGP(x)

extern CLPRTBL *pCLprocTable;
extern GlobalCt  *pGlobTable;
extern int giOptions[];

static int _print_info();
static int _print_info_data();
static void _print_list();

#define MAX_FLGS	MAX_PRINT_FLGS

#define PRN_OPT_QUOT	0x0001	/* "string" */
#define PRN_OPT_DCMA	0x0002	/* output ',' delimiter */
#define PRN_OPT_NAME	0x0004	/* output 'name=' */
#define PRN_OPT_HEXO	0x0008	/* output hex mode */
#define PRN_OPT_ERRO	0x0010	/* use ERROROUT() to output */
#define PRN_OPT_DUMP	0x0020	/* dump mode */
#define PRN_OPT_MCMA	0x0040	/* output money ',' */
#define PRN_OPT_UMCA	0x0080	/* use PRN_OPT_MCMA */
#define PRN_OPT_INFO	0x0100	/* output info */
#define PRN_OPT_EXPF	0x0200	/* display exp format */
#define PRN_OPT_NEXF	0x0400	/* display not exp format */
#define PRN_OPT_EXPZ	0x0800	/* display exp zero suppress */
#define PRN_OPT_EXPN	0x1000	/* display exp zero not suppress */
#define PRN_OPT_TABS	0x2000	/* output delimiter Tab insted of ' ' */
#define PRN_OPT_NGEN	D_PRN_OPT_NGEN	/* ʃf[^ȊOG[ɂȂ */
#define PRN_OPT_LTGT	D_PRN_OPT_LTGT	/* enclosed in angle brackets */

#define q_flg	(flgs[0] & PRN_OPT_QUOT)	/* "string" */
#define c_flg	(flgs[0] & PRN_OPT_DCMA)	/* output ',' */
#define n_flg	(flgs[0] & PRN_OPT_NAME)	/* output 'name=' */
#define x_flg	(flgs[0] & PRN_OPT_HEXO)	/* output hex mode */
#define e_flg	(flgs[0] & PRN_OPT_ERRO)	/* output ERROROUT() */
#define d_flg	(flgs[0] & PRN_OPT_DUMP)	/* dump mode */
/*		m_flg	*/							/* output money ',' */
#define i_flg	(flgs[0] & PRN_OPT_INFO)	/* output info */
#define p_flg	(flgs[0] & PRN_OPT_EXPF)	/* display exp */
#define np_flg	(flgs[0] & PRN_OPT_NEXF)	/* display not exp */
#define pz_flg	(flgs[0] & PRN_OPT_EXPZ)	/* display exp zero suppress */
#define pn_flg	(flgs[0] & PRN_OPT_EXPN)	/* display exp not zero suppress */
#define t_flg	(flgs[0] & PRN_OPT_TABS)	/* output delimiter Tab insted of ' ' */

#define exp_pre	flgs[1]
#define exp_inx	flgs[2]
/*				flgs[3]  DEF_ZOK_DATA */
/*				flgs[4]  byte interval in hex mode */

/********************************************/
/*											*/
/********************************************/
int cl_user_func(pLeaf, proc, name )
Leaf *pLeaf;
ProcCT  *proc;
char *name;
{
	int rc;
	parmList  *pparmList;
	tdtInfoParm InfoParm;
	char dummy[256];
	ProcCT  *procct;

DEBUGOUTL1(190,"cl_user_func:start.[%s]",name);
	if (!stricmp(name,"UserFunc")) {
		if (pLeaf->cmd.prmnum > 3) {
			pparmList = pLeaf->cmd.prmp[2];
			if (rc=cl_arg_to_char(pparmList,proc->Obj,&InfoParm,"UserFunc proc")) return rc;
			strnzcpy(dummy,InfoParm.pi_data,sizeof(dummy)-1);
		}
		else {
			ERROROUT("cl_user_func:no proc name");
			return (ECL_EX_EXEC);
		}
	}
	else strnzcpy(dummy,name,sizeof(dummy)-1);

DEBUGOUTL1(190,"cl_user_func:dummy=[%s]",dummy);
	if (!stricmp(dummy,"print") || !stricmp(dummy,"DT")) {
		cl_print_text(&pLeaf->cmd.prmp[3],proc->Obj,
		              pLeaf->cmd.prmnum-3,"Print: ");
	}
	else {
		ERROROUT("cl_user_func:undeifinition proc.");
		return (ECL_EX_EXEC);
	}
	if (!strcmp(name,"UserFunc")) {
		if (!(procct = cl_search_proc_ct())) return (ECL_SYSTEM_ERROR);
		cmn_set_stat(RET_PR,&procct->ptype,L_ON);
	}
	return NORMAL;
}

/********************************************/
/*											*/
/********************************************/
static void _set_flag_sub(p,flgs)
char *p;
int flgs[];
{
	char c,c1,w[2];
	int i,print_opt,opt,iset;
/*
printf("\n_set_flag_sub: *p=[%s]\n",p);
*/
	p++;
	c = *p++;
	c1 = *p;
	print_opt = flgs[0];
	iset = 0;
	if (c == 'm') {
		if (c1 == '-') iset = -1;
		else if (c1 == '+') iset = 1;
		if (iset) {
			print_opt |= PRN_OPT_UMCA;
			if (iset > 0)
				print_opt |= PRN_OPT_MCMA;
			else
				print_opt &= ~PRN_OPT_MCMA;
		}
		else
			print_opt &= ~(PRN_OPT_UMCA | PRN_OPT_MCMA);
	}
	else {
		if (c1 == '-') iset = -1;
		else iset = 1;
		w[0] = c;
		w[1] = '\0';
		i = akxs_in_str_opt("qcnxedm,ip   t",w,0);
		if (i >0) {
			opt = 1;
			if (i > 1) opt = 1<<(i-1);
			if (iset > 0) print_opt |= opt;
			else print_opt &= ~opt;
		}
	}
/*
printf("_set_flag_sub: i=%d print_opt=%08x\n",i,print_opt);
*/
	flgs[0] = print_opt;
}

/********************************************/
/*	/p[+|-][pre][Z|N|R][,[inx[R]]]			*/
/*	/x[+|-][intval[Z]]						*/
/********************************************/
static void _set_flag(p,len,flgs)
char *p;
int len,flgs[];
{
	char c,c1,*pp,w[4];
	int i,is,ie,n,pos,nlen,val;

	w[0] = '/';
	w[3] = '\0';
	p++;
	len--;
	n = 0;
	pp = p;
	while (len >= 0) {
/*
printf("_set_flag: len=%d p=[%s]\n",len,p);
*/
		c = *p++;
		len--;
/*
printf("_set_flag:1 len=%d c=[%c]\n",len,c);
*/
		if (c=='+' || c=='-' || !c) {
			w[2] = c;
			while (n-- > 0) {
				w[1] = *pp++;
				_set_flag_sub(w,flgs);
			}
			if (!c) break;
			n = 0;
			pp = p;
		}
		else if (c=='p' || c=='x') {
/*
printf("_set_flag:2 len=%d c=[%c]\n",len,*p);
*/
			if (c == 'x') flgs[0] |= PRN_OPT_HEXO;
			c1 = c;
			if ((c=*p)=='+' || c=='-') {
				p++;
				len--;
				if (c1 == 'x') {
					if (c == '+') flgs[0] |= PRN_OPT_HEXO;
					else flgs[0] &= ~PRN_OPT_HEXO;
				}
				else {
					if (c == '+') {
						flgs[0] |= PRN_OPT_EXPF;
						flgs[0] &= ~PRN_OPT_NEXF;
					}
					else {
						flgs[0] |= PRN_OPT_NEXF;
						flgs[0] &= ~PRN_OPT_EXPF;
					}
				}
			}
/*
printf("_set_flag:3 len=%d c=[%c]\n",len,*p);
*/
			c = akxcupper(*p);
			if (c>='0' && c<='9') {
				pos = akxccvn2(10,p,len,&val,&nlen);
/*
printf("_set_flag:akxccvn2 1: pos=%d nlen=%d p=[%s]\n",pos,nlen,p);
*/
				if (pos < 0) break;
				if (c1 == 'x') flgs[4] = val;
				else {
					exp_pre = val;
					if (exp_pre > NMPA10) exp_pre = NMPA10;
				}
				p += nlen;
				len -= nlen;
				c = akxcupper(*p);
				if (c1=='x' && c=='Z') flgs[4] = -flgs[4];
			}
			if (c1 == 'p') {
				if (c=='Z' || c=='N' || c=='R') {
					if (c == 'Z') {
						flgs[0] |= PRN_OPT_EXPZ;
						flgs[0] &= ~PRN_OPT_EXPN;
					}
					else if (c == 'N') {
						flgs[0] |= PRN_OPT_EXPN;
						flgs[0] &= ~PRN_OPT_EXPZ;
					}
					else exp_pre = -1;
					p++;
					len--;
					c = *p;
				}
				if (c == ',') {
					p++;
					len--;
					c = akxcupper(*p);
					if (c>='0' && c<='9') {
						pos = akxccvn2(10,p,len,&exp_inx,&nlen);
/*
printf("_set_flag:akxccvn2 2: pos=%d nlen=%d p=[%s]\n",pos,nlen,p);
*/
						if (pos < 0) break;
						if (exp_inx > 5) exp_inx = 5;
						p += nlen;
						len -= nlen;
						c = akxcupper(*p);
					}
					if (c == 'R') {
						exp_inx = -1;
						p++;
						len--;
						c = *p;
					}
					if (c && c!=' ') break;
				}
			}
/*
printf("_set_flag: flgs[0]=%08x exp_pre=%d  exp_inx=%d\n",flgs[0],exp_pre,exp_inx);
*/
			pp = p;
		}
		else n++;
	}
/*
printf("_set_flag: flgs=%08x %d %d\n",flgs[0],flgs[1],flgs[2]);
*/
}

/********************************************/
/*											*/
/********************************************/
static int _do_print_name(line,line_len)
char *line;
int  line_len;
{
	char buf[256],c;
	int ret,rc,n,iParm[3],n0;
	SSPL_S ssp;
/*
printf("_do_print_name:Enter line_len=%d line=[%s]\n",line_len,line);
*/
	ssp.sp = 0;
	ssp.wd = buf;
	ssp.wdmax = sizeof(buf);
	n0 = ret = 0;
	while (!ret) {
		n = cmpgwnsl(line,line_len,&ssp);
/*
printf("_do_print_name: n0=%d n=%d wd=[%s]\n",n0,n,ssp.wd);
*/
		if (n <= 0) break;
		if (n <= 100) {		/* L */
			if ((n0<=8 || n0==98) && (n==24 || n==25)) ;	/* PZq(+-) */
			else ret = 1;
		}
		else if (n>=5000 && n<6000) {	/* 萔 */
			if ((c=*ssp.wd)=='\'' || c=='"') ;
			else {
				rc = akxqnumber(ssp.wd,n,0,iParm);
/*
printf("_do_print_name: rc=%d\n",rc);
*/
				if (rc < 2) ret = 1;
			}
		}
		else ret = 1;
		n0 = n;
	}
/*
printf("_do_print_name:Exit ret=%d\n",ret);
*/
	return ret;
}

/********************************************/
/*	opt : 0x01 :=0 "," or " " or TAB		*/
/*				=1 "," + (" " or TAB)		*/
/*		  0x02 :=1 Ignore c_flg				*/
/*		  0x04 :=1 Ignore t_flg				*/
/********************************************/
static void _print_dlm(mcat,flgs,opt)
MCAT *mcat;
int flgs[],opt;
{
	char dlm[3],*p;
	int ic_flg,it_flg;

	ic_flg = c_flg;
	it_flg = t_flg;
	if (opt & 0x02) ic_flg = 0;
	if (opt & 0x04) it_flg = 0;
	p = dlm;
	if (ic_flg) *p++ = ',';
	if (!ic_flg || (opt & 0x01)) {
		if (!(opt & 0x01)) p = dlm;
		if (it_flg) *p = '\t';
		else *p = ' ';
		p++;
	}
	*p = '\0';
/*
printf("_print_dlm:Exit opt=%02x ic_flg=%08x it_flg=%08x dlm=[%s]\n",opt,ic_flg,it_flg,dlm);
*/
	akxtmcats(mcat,dlm);
}

/********************************************/
/*											*/
/********************************************/
char *cl_get_attr_name(iParm)
int  iParm[];
{
	static char *name[]={"variant","char","int","double","dec","bulk","date","variant",""};
	static char dummy[30];
	int attr,size,pre,sca;
	char *p;

	attr = iParm[0];
	size = iParm[1];
	pre  = iParm[2];
	sca  = iParm[3];
	if (attr>=0 && attr<=7) p = name[attr];
	else p = "other";
	switch (attr) {
	case DEF_ZOK_CHAR:
	case DEF_ZOK_BULK:
		if (size > 0) {
			sprintf(dummy,"%s(%d)",p,size);
			p = dummy;
		}
		break;
	case DEF_ZOK_DECI:
		if (pre > 0) {
			sprintf(dummy,"dec(%d,%d)",pre,sca);
			p = dummy;
		}
		break;
	}
	return p;
}

/****************************************/
/*										*/
/****************************************/
char *cl_get_scope_name_from_aux1(i)
int i;
{
/*
	static char *scope[]={"",D_STR_NAME_LOCAL,D_STR_NAME_PRIVATE,D_STR_NAME_PUBLIC,D_STR_NAME_GLOBAL};
*/
	char *nam;
/*
	i &= D_AUX1_VAR_SCOPE;
	if (i <= 4) nam = scope[i];
*/
	if (i & D_AUX1_LOCAL_VAR) nam = D_STR_NAME_LOCAL;
	else if (i & D_AUX1_PRIVATE_VAR) nam = D_STR_NAME_PRIVATE;
	else if (i & D_AUX1_PUBLIC_VAR) nam = D_STR_NAME_PUBLIC;
	else if (i & D_AUX1_GLOBAL_VAR) nam = D_STR_NAME_GLOBAL;
	else nam = "";
	return nam;
}

/********************************************/
/*											*/
/********************************************/
static int _print_attr(mcat,pInfoParm,iParm)
MCAT *mcat;
tdtInfoParm *pInfoParm;
int  iParm[];
{
	int attr,size,pre,sca,iPm[4],*ipParm,fixed;

	fixed = 0;
	if (pInfoParm) {
		iPm[0] = pInfoParm->pi_attr;
		if (pInfoParm->pi_aux[0] & 0x0f) {
			size = pInfoParm->pi_len;
			fixed = 1;
		}
		else size = pInfoParm->pi_dlen;
		iPm[1] = size;
		iPm[2] = pInfoParm->pi_hlen;
		iPm[3] = pInfoParm->pi_pos;
		ipParm = iPm;
	}
	else if (iParm) {
		ipParm = iParm;
		if (iParm[0] && iParm[0]!=DEF_ZOK_VARI) fixed = 1;
	}
	if (fixed) akxtmcats(mcat,"fixed ");
	akxtmcats(mcat,cl_get_attr_name(ipParm));
	return 0;
}

/********************************************/
/*											*/
/********************************************/
static int _print_data(mcat,pInfoParm,flgs)
MCAT *mcat;
tdtInfoParm *pInfoParm;
int flgs[];
{
	int rc,i,len,opt,pre,m_opt,intval,iVal[2];
	long Value;
	double dValue,dw;
	char dummy[513],*p,id,*fmt,wrk[10],c;
	MPA *mpa;
	tdtInfoParm tInfoParm,tInfo[3],*ppParm[3];

DEBUGOUT_InfoParm(LVL_GXEXOBJ,"_print_data:",pInfoParm,0,0);

	if (cl_is_null_parm(pInfoParm)) return 0;

	id = pInfoParm->pi_id;
	len = pInfoParm->pi_dlen;
	p = pInfoParm->pi_data;
	switch (pInfoParm->pi_attr) {
	case DEF_ZOK_CHAR:
		if (x_flg && id==' ') {
			len = X_MIN((sizeof(dummy)-1)/2,len);
		/*	akxcxtoc(p,len,dummy);
			akxtmcatz(mcat,dummy,len*2);	*/
			if (!(intval=flgs[4])) intval = -16;
			i = akxcxtocn(p,len,dummy,sizeof(dummy),intval);
			akxtmcatz(mcat,dummy,i);
		}
		else {
			if (q_flg) akxtmcats(mcat,"\"");
			if (p) {
				if (id==D_DATA_ID_FUNCTION && (c=*p)>='0' && c<='9') {
					len = akxstrnlen(p,len);
					i = akxnskipto(p,len," ");
					p += i+1;
				}
				len = akxstrnlen(p,len);
				akxtmcatz(mcat,p,len);
				if (id==D_DATA_ID_FUNCTION || id==D_DATA_ID_CLMETHOD || id==D_DATA_ID_PROC)
					akxtmcats(mcat,"()");
			}
			if (q_flg) akxtmcats(mcat,"\"");
		}
		break;
	case DEF_ZOK_BINA:
		if (len) {
			Value = cl_get_data_long(pInfoParm);
#if defined(_LP64)
			if (x_flg) fmt = "0x%016x";
			else fmt = "%ld";
#else
			if (x_flg) fmt = "0x%08x";
			else fmt = "%d";
#endif
			sprintf(dummy,fmt,Value);
			akxtmcats(mcat,dummy);
		}
		else akxtmcats(mcat,"null");
		break;
	case DEF_ZOK_FLOA:
		if (len) {
			memcpy((char *)&dValue,p,sizeof(double));
			if (x_flg) {
				akxcxtoc(&dValue,sizeof(double),dummy);
				dummy[len*2] = '\0';
			}
			else {
				cl_double_to_str(dummy,sizeof(dummy),dValue);
			}
			akxtmcats(mcat,dummy);
		}
		else akxtmcats(mcat,"null");
		break;
	case DEF_ZOK_DECI:
		if (len > 0) {
			mpa = (MPA *)p;
			if (x_flg) {
			/*	akxcxtoc(mpa,len,dummy);
				dummy[len*2] = '\0';	*/
				if (!(intval=flgs[4])) intval = -2;
				akxcxtocn(p,len,dummy,sizeof(dummy),intval);
			}
			else {
/*
printf("_print_data: options[10],[19]=%08x %08x\n",pGlobTable->options[10],pGlobTable->options[19]);
*/
				if (flgs[0] & PRN_OPT_UMCA) {
					if (flgs[0] & PRN_OPT_MCMA) m_opt = 1;
					else m_opt = -1;
				}
				else
					m_opt = pGlobTable->options[12] & 0x20;
				cl_mpa2an(mpa,dummy,sizeof(dummy),m_opt,pInfoParm->pi_hlen,pInfoParm->pi_pos);
			}
			akxtmcats(mcat,dummy);
		}
		else akxtmcats(mcat,"null");
		break;
	case DEF_ZOK_DATE:
		if (len > 0) {
			mpa = (MPA *)p;
			if (x_flg) {
				len = mpa->len;
				akxcxtoc(mpa->num,len,dummy);
				dummy[len*2] = '\0';
				p = dummy;
			}
			else {
#if 1	/* 2021.6.1 */
				p = D_SQL_DATE_FORMAT;
				*dummy = '(';
				cl_date2str(dummy+1,sizeof(dummy)-2,p,strlen(p),mpa);
				p = dummy;
				strcpy(p+strlen(p),")");
#else
				m_mpa2an(mpa,dummy,sizeof(dummy),0);
				p = dummy + strlen(dummy) + 1;
				strcpy(p,"YYYY/MM/DD HH:MM:SS");
				memcpy(p,dummy,4);
				memcpy(p+5,dummy+4,2);
				memcpy(p+8,dummy+6,2);
				memcpy(p+11,dummy+8,2);
				memcpy(p+14,dummy+10,2);
				memcpy(p+17,dummy+12,2);
#endif
/*
printf("_print_data: p=[%s]\n",p);
*/
			}
		}
		else p = "null";
		akxtmcats(mcat,p);
		break;
	case DEF_ZOK_VARI:
		akxtmcats(mcat,"**VARI:no data**");
		break;
	case 0:
		akxtmcats(mcat,"**no data**");
		break;
	case DEF_ZOK_BULK:
		akxtmcats(mcat,"**BULK**");
		if (len > 0) {
			if ((intval=flgs[4]) > 0) {
				if (intval < len) len = intval;
				if (len > 4096) len = 4096;
			}
			else if (len > 512) {
				len = 512;
				PRINTOUTL1(0,"BULK data too long len=%d",pInfoParm->pi_dlen);
			}
			akxaxdump("BULK",p,len);
			printf("\n");
		}
		break;
	default:
		akxtmcats(mcat,"**INVALID**");
		if (len > 0) {
			if (len > 512) {
				len = 512;
			}
			akxaxdump("INVALID",p,len);
			printf("\n");
		}
	}
	if (pInfoParm->pi_alen & D_AULN_RANGE_DATA) {
		akxtmcats(mcat,"..");
		for (i=0;i<3;i++) ppParm[i] = &tInfo[i];
		if ((rc=cl_get_range_info(pInfoParm,ppParm,iVal,0)) < 0) return rc;
		_print_data(mcat,ppParm[1],flgs);
		if (pInfoParm->pi_alen & D_AULN_RANGE_INTVAL) {
			akxtmcats(mcat,"..");
/*
printf("_print_data: term=%d interval=%d\n",ppParm[2]->pi_hlen,ppParm[2]->pi_pos);
*/
			if (pInfoParm->pi_attr==DEF_ZOK_DATE && (i=ppParm[2]->pi_hlen)>0) {
				wrk[0] = cl_get_term_char(i);
				wrk[1] = '\0';
				sprintf(dummy,"'%s %d'",wrk,ppParm[2]->pi_pos);
				akxtmcats(mcat,dummy);
			}
			else _print_data(mcat,ppParm[2],flgs);
		}
	}
	return 0;
}

/********************************************/
/*											*/
/********************************************/
static int _print_info_struct(mcat,pInfoParm,flgs)
MCAT *mcat;
tdtInfoParm *pInfoParm;
int flgs[];
{
	tdtDefType *pDeftype;
	parmList  **parmName;
	char *varnam;
	int j,pos;

	if (!(varnam=(char *)pInfoParm->pi_pos)) varnam="NONA";
	pos = cl_get_struct_name_len(varnam);
	akxtmcat(mcat,varnam,pos);
	akxtmcats(mcat,"{");
	pDeftype = (tdtDefType *)pInfoParm->pi_data;
	parmName = pDeftype->vname;
	for (j=0;j<pDeftype->ntype;j++) {
		if (j > 0) akxtmcats(mcat,", ");
		/* o擾 */
		varnam = strtemp(parmName[j]->prp,parmName[j]->prmlen);
/*
printf("_print_info: varnam=[%s]\n",varnam);
*/
		_print_info(mcat,pDeftype->pType[j],varnam,flgs);
	}
	akxtmcats(mcat,"}");
	return 0;
}

/********************************************/
/*											*/
/********************************************/
static int _print_info_array(mcat,pInfoParm,flgs)
MCAT *mcat;
tdtInfoParm *pInfoParm;
int flgs[];
{
	int i,*index,f,k1,k2,iParm[4],ndim;
	char dummy[256],wrk[128],id,*varnam;
	tdtArrayIndex *pIndex,tIndex;
	XHASHB *xhp;
	tdtInfoParm *pInfo;

DEBUGOUT_InfoParm(LVL_GXEXOBJ,"_print_info_array:",pInfoParm,0,0);

	id = pInfoParm->pi_id;
	/* ` */
	if (!(varnam=(char *)pInfoParm->pi_pos)) varnam=AKX_NULL_PRINT;
	if (id=='R' && (pInfo=(tdtInfoParm *)pInfoParm->pi_paux)) {
		if (pInfo->pi_id != 'R') {
					/* %s: Rs[̔z[%s]łB */
			ERROROUT2(FORMAT(231),"_print_info_array",varnam);
			akxtmcats(mcat,"##ERROR##,");
		}
	}
	else {
		if (pGlobTable->options[12] & 0x01) {
			/* ` */
			akxtmcats(mcat,varnam);
			akxtmcats(mcat,"[]");
			cl_debug_array_info(dummy,0,pInfoParm);
		}
		else {
			if (id == 'A') {
				pIndex = &tIndex;
				cl_get_array_index_tbl(pInfoParm,pIndex,NULL,NULL);
			}
			else pIndex = (tdtArrayIndex *)pInfoParm->pi_data;
			/* f[^^ */
			if (id=='A' || id=='R') {
				if (pInfo = pIndex->pInfoType) {
					_print_info_struct(mcat,pInfo,flgs);
				}
				else {
					iParm[0] = pIndex->uAttr[0];
					iParm[2] = pIndex->uAttr[2];
					iParm[3] = pIndex->uAttr[3];
					iParm[1] = pIndex->size;
					_print_attr(mcat,NULL,iParm);
				}
			}
			else
				_print_attr(mcat,pInfoParm,NULL);
			akxtmcats(mcat," ");

			/* ` */
			akxtmcats(mcat,varnam);

			/* z` */
			index = pIndex->index;
/*
printf("_print_info_array: index=%d %d %d %d %d %d\n",
index[0],index[1],index[2],index[3],index[4],index[5]);
*/
			if ((xhp=pIndex->xhp) || (id=='R' && (index[2] < 0))) {
				sprintf(dummy," Hash(%d)",index[4]);
			}
			else {
				if (id=='A') sprintf(dummy,"[(%d),",index[3]);
				else strcpy(dummy,"[");
				ndim = index[0];
				for (i=0;i<ndim;i++) {
					if (i > 0) strcat(dummy,",");
					k1 = index[i+4];
					k2 = index[i+ndim+4];
					if (k2) {
						sprintf(wrk,"%d..%d",k2,k2+k1-1);
					}
					else sprintf(wrk,"%d",k1);
					strcat(dummy,wrk);
				}
				strcat(dummy,"]");
			}
		}
		akxtmcats(mcat,dummy);
	}
	return 0;
}

/********************************************/
/*											*/
/********************************************/
static void _print_list(mcat,pInfoParm,_print_info,_print_info_array,flgs)
MCAT *mcat;
tdtInfoParm *pInfoParm;
int (*_print_info)(),(*_print_info_array)(),flgs[];
{
	tdtRbCtl *pCt;
	int i;
	char *p1,*p2,id;

	if (pInfoParm->pi_id == D_DATA_ID_LIST) {
		p1 = "{";
		p2 = "}";
	}
	else {	/* id====D_DATA_ID_NARABI */
		p1 = "[";
		p2 = "]";
	}

DEBUGOUT_InfoParm(LVL_GXEXOBJ,"_print_list: p1=[%s] p2=[%s]",pInfoParm,p1,p2);

	akxtmcats(mcat,p1);
	i = 0;
	if (pInfoParm->pi_attr==DEF_ZOK_BULK && pInfoParm->pi_dlen==sizeof(tdtRbCtl)) {
		pCt = (tdtRbCtl *)pInfoParm->pi_data;
		if (akxs_rb_used(pCt)) {
			akxs_rb_read(pCt,0);
			i = 0;
			while (pInfoParm=(tdtInfoParm *)akxs_rb_read(pCt,1)) {
				if (i > 0) _print_dlm(mcat,flgs,0);
				if (pInfoParm->pi_aux[0] & DEF_ZOK_DATA)
					_print_info(mcat,pInfoParm,NULL,flgs);	/* _print_info͎ŕς */
				else if ((id=pInfoParm->pi_id)=='A' || id=='R' || id=='T')
					_print_info_array(mcat,pInfoParm,NULL,flgs);	/* _print_info_array͎ŕς */
				else
					_print_info(mcat,pInfoParm,NULL,flgs);	/* _print_info͎ŕς */
				i++;
			}
		}
	}
	if (!i) akxtmcats(mcat,"**NIL**");
	akxtmcats(mcat,p2);
}

/********************************************/
/*											*/
/********************************************/
static int _print_info_data_kako(mcat,pInfoParm,varnam0,flgs)
MCAT *mcat;
tdtInfoParm *pInfoParm;
char *varnam0;
int flgs[];
{
	char id;
	int f;

	f = 0;
	id = pInfoParm->pi_id;
	if (id=='P' || id=='T' || id=='A' || id=='R' ||
	    (id==' ' && (pInfoParm->pi_alen & D_AULN_RANGE_DATA) &&
	                    ((pInfoParm->pi_aux[0] & DEF_ZOK_DATA) || flgs[3]))) {
		akxtmcats(mcat,"*(");
		f = 1;
	}
	_print_info_data(mcat,pInfoParm,varnam0,flgs);
	if (f) akxtmcats(mcat,")");
	return 0;
}

/********************************************/
/*											*/
/********************************************/
static int _print_info_data(mcat,pInfoParm,varnam0,flgs)
MCAT *mcat;
tdtInfoParm *pInfoParm;
char *varnam0;
int flgs[];
{
	int i,j,iParm[4],ix1,nm1,iRc,iAux1,*index,f,k1,k2,type,m1,ic,iAux0;
	int interval,iINTVAL,atr1,len,iVal[2];
	char dummy[256],wrk[128],id,*varnam,*scope,*p1,term;
	tdtArrayIndex *pIndex,tIndex1;
	XHASHB *xhp;
	parmList  **parmName;
	tdtDefType *pDeftype;
	tdtInfoParm *pParmI,***pTBL1,tInfoParm,*pInfo,tInfoParm2,*pInfo2,tInfoParm3,*pInfo3,*ppParm[3];
	tdtInfoParm *ppInfo[3],tInfo[3];

DEBUGOUT_InfoParm(LVL_GXEXOBJ,"_print_info_data: varnam0=[%s]",pInfoParm,varnam0,0);

	if ((id=pInfoParm->pi_id)==D_DATA_ID_LIST || id==D_DATA_ID_NARABI) {
		if (flgs[3])
			_print_list(mcat,pInfoParm,_print_info_data,_print_info_data,flgs);
		else
			_print_list(mcat,pInfoParm,_print_info_data,_print_info,flgs);
	}
	else if (id=='P' || id=='T') {
		if (id == 'P') type = pInfoParm->pi_aux[0] & ~DEF_ZOK_DATA;
		else type = D_AUX0_TYPE_STRUCT;
		if (type == D_AUX0_TYPE_STRUCT) {
			akxtmcats(mcat,"{");
			pDeftype = (tdtDefType *)pInfoParm->pi_data;
			parmName = pDeftype->vname;
			for (j=0;j<pDeftype->ntype;j++) {
				if (j > 0) {
					_print_dlm(mcat,flgs,0);
				}
				akxtmcat(mcat,parmName[j]->prp,parmName[j]->prmlen);
				akxtmcats(mcat,"=");
				_print_info_data_kako(mcat,pDeftype->pType[j],NULL,flgs);
			}
			akxtmcats(mcat,"}");
		}
		else {
			if (type == D_AUX0_TYPE_ARRAY) id = 'R';
			else id = 'A';
			pInfoParm->pi_id = id;
			_print_info_data_kako(mcat,pInfoParm,NULL,flgs);
		}
	}
	else if (id=='A' || id=='R') {
		if (iRc=cl_get_array_info(pInfoParm,&tIndex1,&pTBL1,iParm)) {
			akxtmcats(mcat,"##ERROR##");
			return iRc;
		}

DEBUGOUTL1(120,"_print_info_data: tIndex1.xhp=%08x",tIndex1.xhp);

		if (xhp=tIndex1.xhp) {
			nm1 = iParm[1];
			m1  = iParm[3];
			if (!m1) nm1 = 0;
		}
		else {
			nm1 = iParm[3] - iParm[2] + 1;	/* iParm[2],iParm[3]́AParmNoł̒lɂȂĂ */
			m1  = nm1;
		}
		ix1  = iParm[2];

DEBUGOUTL2(120,"_print_info_data: nm1=%d ix1=%d",nm1,ix1);

		ic = 0;
		for (i=0;i<nm1;i++,ix1++) {
			if ((iRc=cl_array_get_info_parm(&pParmI,&tIndex1,pTBL1,ix1,'r')) < 0) return iRc;

DEBUGOUT_InfoParm(120,"_print_info_data: id=[%c] i=%d",pParmI,id,i);

			if (xhp) {
				if (ic >= m1) break;
				if (pParmI) {
					if (ic > 0) _print_dlm(mcat,flgs,0);
					*dummy = '[';
					strnzcpy(dummy+1,xhp->xha_hashb->ha_key,sizeof(dummy)-4);
					strcat(dummy,"]=");
					akxtmcats(mcat,dummy);
					_print_info_data_kako(mcat,pParmI,NULL,flgs);
					ic++;
				}
			}
			else {
				if (i > 0) {
					_print_dlm(mcat,flgs,0);
				}
				if (pParmI && !cl_is_undef_parm(pParmI) && !cl_is_null_parm(pParmI)) {
					_print_info_data_kako(mcat,pParmI,NULL,flgs);
				}
			}
		}
	}
	else if (id==' ' && (pInfoParm->pi_alen & D_AULN_RANGE_DATA) &&
	                    ((pInfoParm->pi_aux[0] & DEF_ZOK_DATA) || flgs[3])) {
		ppParm[0] = &tInfoParm;
		ppParm[1] = &tInfoParm2;
		ppParm[2] = &tInfoParm3;
		if ((iRc=cl_get_range_info(pInfoParm,ppParm,iVal,1)) < 0) return iRc;
		pInfo  = ppParm[0];
		pInfo2 = ppParm[1];
		pInfo3 = ppParm[2];
		nm1      = iVal[0];
		interval = iVal[1];
		atr1 = pInfoParm->pi_attr;
		len  = pInfoParm->pi_dlen;
/*
printf("_print_info_data: atr1=%d len=%d nm1=%d interval=%d\n",atr1,len,nm1,interval);
*/
		iINTVAL = iRc & 0x01;
		if (atr1 != DEF_ZOK_BINA) {
			if (!(p1=cl_tmp_const_malloc(len))) return ECL_MALLOC_ERROR;
			memcpy(p1,pInfo->pi_data,len);
			pInfo->pi_data = p1;
			if (atr1 == DEF_ZOK_CHAR) {
				m1 = akxqkanjilen(p1);
				ic  = akxcmb2ul(p1,m1);
			}
			else if (atr1 == DEF_ZOK_DATE) {
				for (i=0;i<3;i++) ppInfo[i] = &tInfo[i];
				cl_set_parm_long(ppInfo[2],interval);
/*
printf("_print_info_data: term=%d interval=%d\n",pInfo3->pi_hlen,interval);
*/
				if (!(i=pInfo3->pi_hlen)) i = 3;
				cl_set_parm_long(ppInfo[1],i);
			}
		}
		for (i=0;i<nm1;i++) {
			if (i > 0) {
				_print_dlm(mcat,flgs,0);
			}
			if (atr1 == DEF_ZOK_CHAR) {
				m1 = akxcul2mb(wrk,ic);
				cl_set_parm_char(pInfo,wrk,m1);
				ic += interval;
			}
			_print_data(mcat,pInfo,flgs);
			if (atr1 != DEF_ZOK_CHAR) {
				if (iINTVAL) {
					if (atr1 == DEF_ZOK_DATE) {
						ppInfo[0] = pInfo;
						if ((iRc=cl_func_add_to_date(pInfo2,3,ppInfo)) < 0) return iRc;
					}
					else {
						if ((iRc=cl_gx_bexp(pInfo2,pInfo,"+",pInfo3,0,0)) < 0) return iRc;
					}
					pParmI = pInfo;
					pInfo  = pInfo2;
					pInfo2 = pParmI;
				}
				else if ((iRc=_gx_ppmm(14,pInfo)) < 0) return iRc;
			}
		}
	}
	else if (id==D_DATA_ID_STOREVAR) {
		if (pInfoParm->pi_aux[0] & DEF_ZOK_DATA)
			_print_data(mcat,(tdtInfoParm *)pInfoParm->pi_pos,flgs);
		else
			_print_info(mcat,pInfoParm,varnam0,flgs);
	}
	else if (id==D_DATA_ID_PNAME) {
		_print_info(mcat,pInfoParm,varnam0,flgs);
	}
	else if (id==D_DATA_ID_UNDEFVAR) akxtmcats(mcat,"**undef**");
	else _print_data(mcat,pInfoParm,flgs);

	return 0;
}

/********************************************/
/*											*/
/********************************************/
static int _print_info(mcat,pInfoParm,varnam0,flgs)
MCAT *mcat;
tdtInfoParm *pInfoParm;
char *varnam0;
int flgs[];
{
	int i,j,iParm[4],ix1,nm1,iRc,iAux1,*index,f,k1,k2,type,len;
	char dummy[256],wrk[128],id,*varnam,*scope,*p,id0;
	tdtArrayIndex *pIndex,tIndex1;
	XHASHB *xhp;
	ScrPrCT *pScCT;
	parmList  **parmName;
	tdtDefType *pDeftype;
	tdtInfoParm *pParmI,***pTBL1,*pInfo;
	Leaf *wkleaf;

DEBUGOUT_InfoParm(LVL_GXEXOBJ,"_print_info: varnam0=[%s]",pInfoParm,varnam0,0);

	if ((id=pInfoParm->pi_id)==D_DATA_ID_LIST || id==D_DATA_ID_NARABI) {
		_print_list(mcat,pInfoParm,_print_info,_print_info,flgs);
	}
	else if (id=='F')
		_print_data(mcat,pInfoParm,flgs);
	else if (id=='P' || id=='T' || id=='A' || id=='R' || varnam0 || id==' ' || id=='S') {
		/* XR[v */
		iAux1 = pInfoParm->pi_aux[1];
#if 1	/* 2021.1.22 */
		scope = cl_get_scope_name_from_aux1(iAux1);
		if (*scope) {
			akxclowern(wrk,scope,strlen(scope));
			akxtmcats(mcat,wrk);
			akxtmcats(mcat," ");
		}
#else
		scope = "";
		if (iAux1 & D_AUX1_LOCAL_VAR) scope = "local ";
		else if (iAux1 & D_AUX1_PRIVATE_VAR) scope = "private ";
		else if (iAux1 & D_AUX1_PUBLIC_VAR) scope = "public ";
		else if (iAux1 & D_AUX1_GLOBAL_VAR) scope = "global ";
		if (*scope) akxtmcats(mcat,scope);
#endif

#if 1	/* 2021.3.9 */
		id0 = id;
		if (id == D_DATA_ID_STOREVAR) {
			pInfoParm = (tdtInfoParm *)pInfoParm->pi_pos;
			id = pInfoParm->pi_id;
			iAux1 = pInfoParm->pi_aux[1];
		}
#endif
		/* CONST */
		if (iAux1 & D_AUX1_PROTECTED) akxtmcats(mcat,"const ");

		if (id == 'P') {
			type = pInfoParm->pi_aux[0] & ~DEF_ZOK_DATA;
			/* ^` */
			akxtmcats(mcat,"type ");
		}
		else if (id == 'T') type = D_AUX0_TYPE_STRUCT;
		else type = 0;
		if (type == D_AUX0_TYPE_STRUCT) {
					/* \ */
			flgs[0] |= PRN_OPT_DCMA;
			/* ^` */
		/*	if (id=='P') akxtmcats(mcat,"type ");	*/

			/* ` */
#if 1	/* 2021.1.23 */
			_print_info_struct(mcat,pInfoParm,flgs);
#else
			if (!(varnam=(char *)pInfoParm->pi_pos)) varnam="NONA";
			akxtmcats(mcat,varnam);
			akxtmcats(mcat,"{");
			pDeftype = (tdtDefType *)pInfoParm->pi_data;
			parmName = pDeftype->vname;
			for (j=0;j<pDeftype->ntype;j++) {
				if (j > 0) akxtmcats(mcat,", ");
				/* o擾 */
				varnam = strtemp(parmName[j]->prp,parmName[j]->prmlen);
/*
printf("_print_info: varnam=[%s]\n",varnam);
*/
				_print_info(mcat,pDeftype->pType[j],varnam,flgs);
			}
			akxtmcats(mcat,"}");
#endif
			if (q_flg) flgs[0] |= PRN_OPT_DCMA;
			else flgs[0] &= ~PRN_OPT_DCMA;
		}
		else if (id == D_DATA_ID_STOREVAR) {
			akxtmcats(mcat," pointer");
		}
		else {
			if (type == D_AUX0_TYPE_ARRAY) id = 'R';
			else if (type == D_AUX0_TYPE_MAPPED) id = 'A';
			pInfoParm->pi_id = id;
			/* z */
			if (id=='A' || id=='R')
				_print_info_array(mcat,pInfoParm);
			else {
				/* f[^^ */
				_print_attr(mcat,pInfoParm,NULL);
				if (pInfoParm->pi_alen & D_AULN_RANGE_DATA) {
					akxtmcats(mcat,"..");
					_print_attr(mcat,pInfoParm,NULL);
				}

				/* ` */
				if (varnam0) {
					if (*varnam0) {
						akxtmcats(mcat," ");
						/*if (varnam0) */akxtmcats(mcat,varnam0);
					}
				}
			}
		}
		if (id0 == D_DATA_ID_STOREVAR) akxtmcats(mcat," pointer");
	}
	else if (id==D_DATA_ID_CLASS || id==D_DATA_ID_INSTANCE) {
		*dummy = '\0';
		if (q_flg) strcat(dummy,"\"");
		if (id == D_DATA_ID_CLASS) {
			strcat(dummy,"Class ");
			if (varnam=pInfoParm->pi_data)
				len = akxstrnlen(varnam,pInfoParm->pi_dlen);
		}
		else if (id == D_DATA_ID_INSTANCE) {
			strcat(dummy,"Instance as ");
			if (wkleaf = (Leaf *)pInfoParm->pi_paux) {
				if (varnam=wkleaf->cmd.prmp[0]->prp) len = strlen(varnam);
			}
			else varnam = NULL;
		}
		if (varnam) memcat(dummy,varnam,len);
		else strcat(dummy,AKX_NULL_PRINT);
		if (q_flg) strcat(dummy,"\"");
		akxtmcats(mcat,dummy);
	}
	else if (id==D_DATA_ID_PNAME) {
		if (pInfoParm->pi_attr==2) {
/*
DEBUGOUT_InfoParm(0,"_print_info:",pInfoParm,0,0);
*/
			 akxtmcats(mcat,pInfoParm->pi_paux);
			 akxtmcats(mcat,"==>");
			_print_data(mcat,pInfoParm->pi_pos,flgs);
		}
		else {
			_print_data(mcat,pInfoParm->pi_data,flgs);
			 akxtmcats(mcat,"==>");
		}
	}
	else if (id==D_DATA_ID_UNDEFVAR) akxtmcats(mcat,"**undef**");
	else if (!id) {
		scope = cl_get_scope_name_from_aux1(pInfoParm->pi_aux[1]);
		if (*scope) {
			akxclowern(wrk,scope,strlen(scope));
			akxtmcats(mcat,wrk);
			akxtmcats(mcat," ");
		}
		akxtmcats(mcat,"(no data)");
	}
	else _print_data(mcat,pInfoParm,flgs);
	return 0;
}

/********************************************/
/*											*/
/********************************************/
static int _check_set_flag(ppInfoParm,opt,flgs)
tdtInfoParm **ppInfoParm;
int opt,flgs[];
{
	tdtInfoParm *pInfoParm,tInfoParm;
	int len,ret;
	char *p;

	ret = 0;
	if (opt & 0x02) {
		pInfoParm = *ppInfoParm;
		if (pInfoParm->pi_id==' ' && pInfoParm->pi_attr==DEF_ZOK_CHAR && (len=pInfoParm->pi_dlen)>=2) {
			if (p = pInfoParm->pi_data) {
				if (*p == '/') {
					_set_flag(p,len,flgs);
					ret = 1;
				}
				else if (!memcmp(p,"\\/",2)) {
					cl_set_parm_char(&tInfoParm,p+1,len-1);
					*ppInfoParm = &tInfoParm;
				}
			}
		}
	}
	return ret;
}

/********************************************/
/*											*/
/********************************************/
static int _mcat_text_infoparm(mcat,tInfoParm2,k,flgs)
MCAT *mcat;
tdtInfoParm tInfoParm2[];
int k,flgs[];
{
	int j,nparm,iPARMINFO2,opt,len,data_flg,opt10,opt19,optw,w_pre,w_inx,iCON,iDLM,rc;
	tdtInfoParm *pInfoParm,tInfoParm;
	char name[30],name2[30],*p,id;

DEBUGOUT_InfoParm(LVL_GXEXOBJ,"_mcat_text_infoparm: k=%d",tInfoParm2,k,0);

	if ((tInfoParm2[0].pi_alen & D_AULN_PARMINFO2) &&
	    (nparm=tInfoParm2[1].pi_pos)) {
		pInfoParm = (tdtInfoParm *)tInfoParm2[1].pi_data;
		if (d_flg) {
			sprintf(name,"DUMP%d",k+1);
			cl_dump_info(&tInfoParm2[0],"%s=",name);
			sprintf(name2,"#%s#->",name);
			akxtmcats(mcat,name2);
		}
		iPARMINFO2 = 1;
	}
	else {
		nparm = 1;
		pInfoParm = tInfoParm2;
	/* 2021.3.8
		if (pInfoParm->pi_id == D_DATA_ID_STOREVAR) 
			pInfoParm = (tdtInfoParm *)pInfoParm->pi_pos;
	*/
		iPARMINFO2 = 0;
	}

DEBUGOUTL2(LVL_GXEXOBJ,"_mcat_text_infoparm: nparm=%d,iPARMINFO2=%d",nparm,iPARMINFO2);

	iDLM = iCON = 0;
	opt = cl_get_option(13,0);
	for (j=0;j<nparm;j++,pInfoParm++) {
#if 0	/* 2021.4.4 */
		if ((id=pInfoParm->pi_id)=='A' || id=='R') _check_gid_alive(pInfoParm,"_mcat_text_infoparm",NULL,1);
#endif
/*
DEBUGOUT_InfoParm(LVL_GXEXOBJ,"_mcat_text_infoparm: j=%d",pInfoParm,j,0);
*/
/*
printf("\n_mcat_text_infoparm: c_flg=%d\n",c_flg);
*/
#if 1	/* 2021.3.11 */
		if (_check_set_flag(&pInfoParm,opt,flgs)) {
			if (!iCON) iCON = 1;
			continue;
		}
#else
		if (opt & 0x02) {
			if (pInfoParm->pi_id==' ' && pInfoParm->pi_attr==DEF_ZOK_CHAR && (len=pInfoParm->pi_dlen)>=2) {
				if (p = pInfoParm->pi_data) {
					if (*p == '/') {
						_set_flag(p,len,flgs);
						continue;
					}
					else if (!memcmp(p,"\\/",2)) {
						cl_set_parm_char(&tInfoParm,p+1,len-1);
						pInfoParm = &tInfoParm;
					}
				}
			}
		}
#endif
		iCON = 2;
		if (iDLM) {
			_print_dlm(mcat,flgs,1);
		}
		if (d_flg) {
			if (iPARMINFO2) sprintf(name,"DUMP%d-%d",k+1,j+1);
			else sprintf(name,"DUMP%d",k+1);
			cl_dump_info(pInfoParm,"%s=",name);
			sprintf(name2,"#%s#",name);
			akxtmcats(mcat,name2);
		}
		else {
			flgs[3] = 0;
			if (i_flg==0 &&
			    ((pInfoParm->pi_aux[0] & DEF_ZOK_DATA) ||
				 (id=pInfoParm->pi_id)==' ' || id==D_DATA_ID_LIST || id==D_DATA_ID_NARABI)) {
				opt10 = pGlobTable->options[10];
				opt19 = pGlobTable->options[19];
				optw = opt10;
				if (p_flg)  optw |= 0x40;
				if (np_flg) optw &= ~0x40;
				if (pz_flg) optw |= 0x0100;
				if (pn_flg) optw &= ~0x0100;
				pGlobTable->options[10] = optw;
				w_pre = opt19 & 0xff;
				w_inx = (opt19>>8) & 0xff;
				if (exp_pre >= 0) w_pre = exp_pre;
				if (exp_inx >= 0) w_inx = exp_inx;
				pGlobTable->options[19] = (w_inx<<8) + w_pre;
				flgs[3] = pInfoParm->pi_aux[0] & DEF_ZOK_DATA;
/*
printf("_mcat_text_infoparm:1 p_flg=%d options[10],[19]=%08x %08x\n",p_flg,pGlobTable->options[10],pGlobTable->options[19]);
*/
				rc = _print_info_data(mcat,pInfoParm,NULL,flgs);
				pGlobTable->options[10] = opt10;
				pGlobTable->options[19] = opt19;
/*
printf("_mcat_text_infoparm:2 p_flg=%d options[10],[19]=%08x %08x\n",p_flg,pGlobTable->options[10],pGlobTable->options[19]);
*/
			}
			else
				rc = _print_info(mcat,pInfoParm,NULL,flgs);
DEBUGOUTL1(LVL_GXEXOBJ,"_mcat_text_infoparm: rc=%d",rc);
		}
		iDLM = 1;
	}
	if (iCON > 1) iCON = 0;
	return iCON;
}

/********************************************/
/*											*/
/********************************************/
static int _mcat_text(mcat,prmp,Obj,prmnum,flgs)
MCAT *mcat;
parmList *prmp[];
int      *Obj;
int      prmnum,flgs[];
{
#if 1	/* 2021.3.12 */
	MCAT mcat2;
	int rc,i,j,nparm,len,k,nn_opt,iPARMINFO2,optW,iDLM,iCON;
	parmList  *pparmList;
	tdtInfoParm tInfoParm2[2],*pInfoParm;
	char *p,c,c1,name[30],name2[30];
	SSPL_S sspl;

	memset(&mcat2,0,sizeof(MCAT));
	mcat2.mc_extlen = 256;
	iDLM = 0;
	flgs[0] &= ~PRN_OPT_DUMP;
	exp_pre = -1;
	exp_inx = -1;
	for (i=0,k=0;i<prmnum;i++) {
		pparmList = prmp[i];
		len = pparmList->prmlen;
		len = akxtsapb(0,p=strtemp(pparmList->prp,len),len);	/* 1-->0 2017.11.03 */
		if (*p == '/') {
			_set_flag(p,len,flgs);
			continue;
		}
		mcat2.mc_ipos = 0;
		if (mcat2.mc_bufp) *mcat2.mc_bufp = '\0';
		optW = D_GX_OPT_PARMINFO2|D_GX_OPT_GET_RANGE;
	/*	if (i_flg) optW |= D_GX_OPT_NOERROR_NDEF | D_GX_OPT_NOEROUT_NDEF;	*/
		if (i_flg) optW |= D_GX_OPT_INFO_MODE;
		rc=cl_gx_exp_obj_opt(1,&pparmList,Obj,tInfoParm2,optW);

DEBUGOUT_InfoParm(LVL_GXEXOBJ,"_mcat_text: i=%d rc=%d",tInfoParm2,i,rc);

		if (rc!=NORMAL/* || InfoParm.pi_data==NULL*/) {
			if (rc == 100) {
				if (q_flg) akxtmcats(&mcat2,"\"\"");
			}
			else akxtmcats(&mcat2,"##ERROR##");
		}
		else {
			iCON = _mcat_text_infoparm(&mcat2,tInfoParm2,k,flgs);
			if (iCON) continue;
		}
		if (iDLM) {
			_print_dlm(mcat,flgs,1);
		}
		nn_opt = n_flg;
		if (nn_opt && !d_flg && !x_flg) {
			if (!_do_print_name(p,len)) nn_opt = 0;
		}
		if (nn_opt) {
			akxtmcat(mcat,p,len);
			akxtmcats(mcat,"=");
		}
		akxtmcats(mcat,mcat2.mc_bufp);
		iDLM = 1;
		k++;
	}
	if (p = mcat2.mc_bufp) Free(p);
#else
	int rc,i,j,nparm,len,k,nn_opt,iPARMINFO2,optW,iDLM,iCON;
	parmList  *pparmList;
	tdtInfoParm tInfoParm2[2],*pInfoParm;
	char *p,c,c1,name[30],name2[30];
	SSPL_S sspl;

	iDLM = 0;
	flgs[0] &= ~PRN_OPT_DUMP;
	exp_pre = -1;
	exp_inx = -1;
	for (i=0,k=0;i<prmnum;i++) {
		pparmList = prmp[i];
		len = pparmList->prmlen;
		len = akxtsapb(0,p=strtemp(pparmList->prp,len),len);	/* 1-->0 2017.11.03 */
		if (*p == '/') {
			_set_flag(p,len,flgs);
			continue;
		}
		if (iDLM) {
			_print_dlm(mcat,flgs,1);
		}
		nn_opt = n_flg;
		if (nn_opt && !d_flg && !x_flg) {
			if (!_do_print_name(p,len)) nn_opt = 0;
		}
		if (nn_opt) {
			akxtmcat(mcat,p,len);
			akxtmcats(mcat,"=");
		}
		optW = D_GX_OPT_PARMINFO2|D_GX_OPT_GET_RANGE;
	/*	if (i_flg) optW |= D_GX_OPT_NOERROR_NDEF | D_GX_OPT_NOEROUT_NDEF;	*/
		if (i_flg) optW |= D_GX_OPT_INFO_MODE;
		rc=cl_gx_exp_obj_opt(1,&pparmList,Obj,tInfoParm2,optW);

DEBUGOUT_InfoParm(LVL_GXEXOBJ,"_mcat_text: i=%d rc=%d",tInfoParm2,i,rc);

		if (rc!=NORMAL/* || InfoParm.pi_data==NULL*/) {
			if (rc == 100) {
				if (q_flg) akxtmcats(mcat,"\"\"");
			}
			else akxtmcats(mcat,"##ERROR##");
			iDLM = 1;
		}
		else {
			iCON = _mcat_text_infoparm(mcat,tInfoParm2,k,flgs);
			if (!iCON) iDLM = 1;
		}
		k++;
	}
#endif
	return 0;
}

/********************************************/
/*											*/
/********************************************/
static void _option_to_flag(opt,flgs)
int opt,flgs[];
{
	if (opt & 0x04) flgs[0] |= PRN_OPT_DCMA;
	if (opt & 0x08) flgs[0] |= PRN_OPT_QUOT;
	if (opt & 0x10) flgs[0] |= PRN_OPT_NAME;
	if (opt & 0x20) flgs[0] |= PRN_OPT_MCMA;
}

/********************************************/
/*											*/
/********************************************/
static int _flag_to_option(flgs)
int flgs[];
{
	int opt;

	opt = 0;
	if (c_flg) opt |= 0x04;
	if (q_flg) opt |= 0x08;
	if (n_flg) opt |= 0x10;
	if (flgs[0] & PRN_OPT_MCMA) opt |= 0x20;
	return opt;
}

/********************************************/
/*											*/
/********************************************/
static void cl_print_echo_text_init(mcat,name,opt,flgs)
MCAT *mcat;
char *name;
int  opt,flgs[];
{
	int qcn_opt;

	memset(mcat,0,sizeof(MCAT));
	mcat->mc_extlen = 256;
	if (!name) name = "";
	akxtmcats(mcat,name);
	mem_set_int(flgs,0,MAX_FLGS);
	qcn_opt = PRN_OPT_QUOT | PRN_OPT_DCMA | PRN_OPT_NAME;
	if (opt & 0x01) flgs[0] |= qcn_opt;
	_option_to_flag(pGlobTable->options[12],flgs);
}

/********************************************/
/*											*/
/********************************************/
static void cl_print_echo_text_out(mcat,opt,flgs)
MCAT *mcat;
int  opt,flgs[];
{
	char *p,*pp,*pw;
	FILE *fp;
	int ex_opt,ret,try_lvl;

	p = mcat->mc_bufp;
	ex_opt = cl_get_option(21,0);
/*
printf("cl_print_echo_text_out: ex_opt=%08x\n",ex_opt);
*/
	if (opt & 0x02) {
#if 0	/* 2021.7.1 */
		try_lvl = pGlobTable->try_level;
		pGlobTable->try_level = 0;
#endif
		if (e_flg) ERROROUTL(0,p);
		else PRINTOUTL(0,p);
#if 0	/* 2021.7.1 */
		pGlobTable->try_level = try_lvl;
#endif
	}
	else {
		if (e_flg) fp = stderr;
		else fp = stdout;
		pp = p;
		if (ex_opt & D_CODE_OUTPUT_MASK) {
			ret = cl_file_code_conv(&pp,p,mcat->mc_ipos,1,0);
		}
		fprintf(fp,"%s",pp);
		if (p != pp) Free(pp);
		akxa_log_new_line(fp,pGlobTable->options[2]);
	}
	if (p) Free(p);
}

/************************************************/
/*	ECHO		opt = 0							*/
/*	PRINT		opt = 1							*/
/*	LPRINT		opt = 3							*/
/* 				0x01:c_flg=1,q_flg=1,n_flg=1	*/
/*				0x02:PRINTOUT					*/
/************************************************/
int cl_print_echo_text(prmp,Obj,prmnum,name,opt)
parmList *prmp[];
int      *Obj;
int      prmnum;
char     *name;
int      opt;
{
	MCAT mcat;
	FILE *fp;
	int flgs[MAX_FLGS],try_lvl;
/*
printf("cl_print_echo_text:Enter name=[%s] opt=%08x\n",name,opt);
*/
	if (!prmp) return 0;
/* 2021.7.1 */
	try_lvl = pGlobTable->try_level;
	pGlobTable->try_level = 0;
/* */
	cl_print_echo_text_init(&mcat,name,opt,flgs);
	_mcat_text(&mcat,prmp,Obj,prmnum,flgs);
	cl_print_echo_text_out(&mcat,opt,flgs);
	pGlobTable->try_level = try_lvl;	/* 2021.7.1 */
	return 0;
}

/********************************************/
/*											*/
/********************************************/
int cl_print_text(prmp,Obj,prmnum,name)
parmList *prmp[];
int      *Obj;
int      prmnum;
char     *name;
{
	return cl_print_echo_text(prmp,Obj,prmnum,name,0x03);
}

/****************************************/
/*										*/
/****************************************/
int cl_echo_text(prmp,Obj,prmnum,opt)
parmList *prmp[];
int      *Obj;
int      prmnum;
int      opt;
{
	return cl_print_echo_text(prmp,Obj,prmnum,NULL,opt & 0x01);
}

/********************************************/
/*											*/
/********************************************/
int cl_dump_info(pInfoParm,fmt,name)
tdtInfoParm *pInfoParm;
char *fmt,*name;
{
	char *p;
	int f;

	if (!fmt) fmt = "";
	if (!name) name = "";
	f = LOGFLG(D_LOG_NO_DEBUG,D_LOG_FLG_CHECK);
	LOGFLG(D_LOG_NO_DEBUG,f | D_LOG_FLG_STDOUT);
	if (pInfoParm->pi_id == 'A') cl_update_map_array_max(pInfoParm);
	DEBUGOUT_InfoParm(0,fmt,pInfoParm,name,0);
	LOGFLG(D_LOG_NO_DEBUG,f);
	return 0;
}

/********************************************/
/*											*/
/********************************************/
/*int cl_dump(prmp,prmnum,Obj,flgs)*/
int cl_dump(prmp,prmnum,Obj)
parmList *prmp[];
int      prmnum/*,flgs[]*/;
char     *Obj;
{
	int rc,i,len,try_lvl;
	parmList *pparmList;
	tdtInfoParm tInfoParm2[2];
	char *p,c;

	try_lvl = pGlobTable->try_level;
	pGlobTable->try_level = 0;
/*	flgs[0] |= PRN_OPT_NAME;	*/
	for (i=0;i<prmnum;i++) {
		pparmList = prmp[i];
		len = pparmList->prmlen;
		len = akxtsapb(0,p=strtemp(pparmList->prp,len),len);	/* 1-->0 2017.11.03 */
		rc = cl_gx_exp_obj_opt(1,&pparmList,Obj,tInfoParm2,D_GX_OPT_PARMINFO2|D_GX_OPT_GET_RANGE);
		if (rc) DEBUGOUT1("%s=##ERROR##",p);
		else cl_dump_info(tInfoParm2,"%s=",p);
	}
	pGlobTable->try_level = try_lvl;
	return 0;
}

/********************************************/
/*											*/
/********************************************/
int cl_func_print(pAns,pOperator,nparm,ppParm,ope,gx_opt)
char *pAns,*pOperator;
int ope,nparm,gx_opt;
tdtInfoParm *ppParm[];
{
	MCAT mcat;
	int opt,k,rc,flgs[MAX_FLGS],iOpt[MAX_PRINT_FLGS+1],iDLM,try_lvl;
	tdtInfoParm tParm2[2],*pInfoParm;
	char *p1;

	if (ope == D_FUC_LPRINT) opt = 3;
	else if (ope == D_FUC_PRINT) opt = 1;
	else opt = 0;
#if 1	/* 2021.7.21 */
	try_lvl = pGlobTable->try_level;
	pGlobTable->try_level = 0;
#endif
	cl_print_echo_text_init(&mcat,NULL,opt,flgs);
	iOpt[0] = 0;
	mem_cpy_int(iOpt+1,flgs,MAX_FLGS);

	iDLM = 0;
	for (k=0;k<nparm;k++) {
		pInfoParm = ppParm[k];
#if 1	/* 2021.3.11 */
		rc = cl_str_print(&p1,pInfoParm,iOpt);
		mem_cpy_int(flgs,iOpt+1,MAX_FLGS);
		if (rc < 0) {
			if (rc == ECL_EX_CONTINUE) continue;
			break;
		}
#endif
		if (iDLM) {
/*
printf("cl_func_print: flgs[0]=%08x\n",flgs[0]);
*/
			_print_dlm(&mcat,flgs,1);
		/*	if (c_flg) akxtmcats(&mcat,",");
			akxtmcats(&mcat," ");	*/
		}
#if 1	/* 2021.3.11 */
		akxtmcats(&mcat,p1);
		iDLM = 1;
#else
		cl_gx_copy_info(tParm2,pInfoParm);
		memset(&tParm2[1],0,sizeof(tdtInfoParm));
		_mcat_text_infoparm(&mcat,tParm2,k,flgs);
#endif
	}
	cl_print_echo_text_out(&mcat,opt,flgs);
	pGlobTable->try_level = try_lvl;	/* 2021.7.21 */
	rc = 0;
	memcpy(pAns,&rc,sizeof(int));
	return 0;
}

/********************************************/
/*											*/
/********************************************/
int cl_str_print(ppAns,pParm,iOpt)
char **ppAns;
tdtInfoParm *pParm;
int iOpt[];
{
	static MCAT mcat={'M','C',256,0,0,0,NULL,0};
	tdtInfoParm tParm2[2];
	int flgs[MAX_FLGS],iCON,len,iLTGT;

	if (!ppAns || !pParm) return -1;
	if (iOpt[0]) {
		_option_to_flag(iOpt[0],iOpt+1);
		iOpt[0] = 0;
	}
	mem_cpy_int(flgs,iOpt+1,MAX_FLGS);
	mcat.mc_ipos = 0;
	cl_gx_copy_info(tParm2,pParm);
	memset(&tParm2[1],0,sizeof(tdtInfoParm));
	iLTGT = tParm2[0].pi_id!=' ' && (iOpt[1] & PRN_OPT_LTGT);
	if (iLTGT) akxtmcats(&mcat,"<");
	iCON = _mcat_text_infoparm(&mcat,tParm2,0,flgs);
	if (iLTGT) akxtmcats(&mcat,">");
/*
printf("cl_str_print: flgs[0]=%08x\n",flgs[0]);
*/
	mem_cpy_int(iOpt+1,flgs,MAX_FLGS);
	*ppAns = mcat.mc_bufp;
	if (iCON) len = ECL_EX_CONTINUE;
	else len = mcat.mc_ipos;
/*
printf("cl_str_print: len=%d *ppAns=[%s]\n",len,*ppAns);
*/
	return len;
}

/********************************************/
/*											*/
/********************************************/
int cl_func_printf(pAns,pOperator,nparm,ppParm,ope,gx_opt)
char *pAns,*pOperator;
int ope,nparm,gx_opt;
tdtInfoParm *ppParm[];
{
	int rc,is,fope,iParm[5],try_lvl;
	char *pWork,*pOpe;
	tdtInfoParm tInfoParm,tParm[2];

	if (ope == D_FUC_PRINTF) {
		is = 0;
		fope = D_FUC_ELWRITE1;
		pOpe = "ELWRITE1";
	}
	else if (ope == D_FUC_FPRINTF) {
		is = 1;
		fope = D_FUC_FELWRITE1;
		pOpe = "FELWRITE1";
	}
	else return -1;

#if 1	/* 2021.7.21 */
	try_lvl = pGlobTable->try_level;
	pGlobTable->try_level = 0;
#endif
	if ((rc=cl_eedit(&pWork,nparm-is,&ppParm[is])) < 0) return rc;
/*
printf("cl_func_printf: rc=%d pWork=[%s]\n",rc,pWork);
*/
	cl_set_parm_char(&tInfoParm,pWork,strlen(pWork));

	is = 0;
	if (ope == D_FUC_FPRINTF) tParm[is++] = *ppParm[0];
	tParm[is] = tInfoParm;
	rc = func_file(&pAns,pOpe,is+1,tParm,fope,iParm);
	pGlobTable->try_level = try_lvl;	/* 2021.7.21 */

	return rc;
}

/********************************************/
/*											*/
/********************************************/
int cl_printf_text(prmp,Obj,prmnum,name,opt)
parmList *prmp[];
int      *Obj;
int      prmnum;
char     *name;
int      opt;
{
	MCAT mcat;
	FILE *fp;
	int flgs[MAX_FLGS],try_lvl,i,rc,nparm,optW,iOpta[MAX_FLGS+1],opt13;
	char *pWork;
	tdtInfoParm tInfoParm2[2],**pparm,*parm;
/*
printf("cl_printf_text:Enter prmnum=%d name=[%s] opt=%08x\n",prmnum,nval1(name),opt);
*/
	if (!prmp || prmnum<=0) return 0;

	try_lvl = pGlobTable->try_level;
	pGlobTable->try_level = 0;
	cl_print_echo_text_init(&mcat,name,opt,flgs);

	iOpta[0] = 0;
	mem_cpy_int(iOpta+1,flgs,MAX_FLGS);
	optW = D_GX_OPT_PARMINFO2|D_GX_OPT_GET_RANGE;
	rc = cl_gx_parm_conv_arg(NULL,0,prmnum,prmp,Obj,optW,&pparm,&nparm);
	if (nparm >= 2) {
		opt13 = cl_get_option(13,0);
		if (opt13 & 0x40) iOpta[1] & ~PRN_OPT_NGEN;
		else iOpta[1] |= PRN_OPT_NGEN;
		if (opt13 & 0x80) iOpta[1] &= ~PRN_OPT_LTGT;
		else iOpta[1] |= PRN_OPT_LTGT;
		if ((rc=cl_edit_opta(&pWork,nparm,pparm,iOpta)) >= 0) {
/*
printf("cl_printf_text: rc=%d pWork=[%s]\n",rc,pWork);
*/
			akxtmcat(&mcat,pWork,rc+1);
			rc = 0;
		}
	}
	cl_print_echo_text_out(&mcat,opt,flgs);
	pGlobTable->try_level = try_lvl;
	return rc;
}
