static    char    sccsid[]="%Z% %M% %I% %E% %U%";
/*****************************************************/
/* <clprdef.c>                                       */
/*      Define process   @                          */
/*****************************************************/
#include "colmn.h"
extern condList CLcList;

extern CLPRTBL *pGLprocTable;
extern CLPRTBL *pCLprocTable;
extern int giOptions[];
extern CLCOMMON  CLcommon;

int cl_pr_ex_define();
int cl_pr_ex_dim();
int cl_process_define_exec();
int cl_pr_ex_def_array();
static int _chk_array();
static char *gsep=" \t()[],'=";

/************************************/
/* cl_process_top_exec              */
/************************************/
int cl_process_top_exec(scrct,top_leaf,func1,ncmd,cmd_cid,func2)
ScrPrCT  *scrct;
Leaf *top_leaf;
int (*func1)();
int ncmd,cmd_cid[];
int (*func2[])();
{
	Leaf *leaf,*leafw;
	int cno,rc=0;

	if (!scrct || !top_leaf || !func1) return ECL_SYSTEM_ERROR;
/*
	leaf = scrct->TreeTop;
*/
	leaf = top_leaf;
	while (leaf) {
		if ((cno=leaf->cmd.cid)==C_NODE_SCRIPT || cno==C_NODE_IMPORT) {
			if (leafw=leaf->leftleaf) {
				rc = func1(scrct,leafw,ncmd,cmd_cid,func2);
				if (rc) break;
			}
			leaf = leaf->rightleaf;
		}
		else {
			rc = func1(scrct,leaf,ncmd,cmd_cid,func2);
			break;
		}
	}
	return rc;
}

/************************************/
/* cl_process_define_exec           */
/************************************/
/*int cl_process_define_exec(scrct, cmd_cid, func)*/
int cl_process_define_exec(scrct,leaf,ncmd,cmd_cid,func)
ScrPrCT  *scrct;
Leaf *leaf;
int ncmd,cmd_cid[];
int (*func[])();
{
	int rc,cno,i;
 
	if (!leaf) return ECL_SYSTEM_ERROR;

	rc = 0;
	while ((cno=leaf->cmd.cid) != C_PROC && cno != C_FUNCTION && cno != C_CLASS &&
	       leaf->rightleaf != NULL && rc == NormalEnd) {
		for (i=0;i<ncmd;i++) {
			if (cno == cmd_cid[i]) {
DEBUGOUTL1(100,"[ %s ]",cl_get_pcmd_line(leaf));
				if (CLcommon.dbgopt[0]) {
					cl_debug_mode(leaf,NULL,0);
				}
				rc = func[i](leaf,scrct,NULL,0);
				if (rc) {
					clerrdisp(rc,leaf);
					return rc;
				}
				break;
			}
		}
		leaf = leaf->rightleaf;
	}
	return rc;
}

/************************************/
/* cl_process_define                */
/************************************/
int cl_process_define(scrct,top_leaf)
ScrPrCT  *scrct;
Leaf     *top_leaf;
{
	int cmd[2];
	int (*func[2])();

	cmd[0] = C_DEFINE;
	cmd[1] = C_DIM;
	func[0] = cl_pr_ex_define;
	func[1] = cl_pr_ex_dim;
	return cl_process_top_exec(scrct,top_leaf,cl_process_define_exec,2,cmd,func);
}
#if 0
/************************************/
/* cl_process_dim                   */
/************************************/
int cl_process_dim(scrct)
ScrPrCT  *scrct;
{
	return cl_process_top_exec(scrct,C_DIM,cl_process_define_exec,cl_pr_ex_dim);
}
#endif
/************************************/
/* cl_pr_ex_define                  */
/************************************/
int cl_pr_ex_define(leaf, scrct, proc, opt)
Leaf    *leaf;
ScrPrCT *scrct;
ProcCT  *proc;
int     opt;
{
	int  i, n, rc, scno, *obj;
	parmList **pprmp;
	char **da;
	CMDObject *cmdobj;

	if (!leaf || !scrct) return ECL_SYSTEM_ERROR;

	/* parameter check */
	if ( (n=leaf->cmd.prmnum) < 1 ) {
		/* cl_pr_ex_define:p[^܂ */
		ERROROUT1(FORMAT(42),"cl_pr_ex_define");
		return ECL_EX_DEFINE;
	}

	pprmp = leaf->cmd.prmp;
	if (scno=leaf->cmd.sub_cid) {
		switch (scno) {
			case CS_MAPPEDARRAY:
				rc = cl_pr_ex_def_map_ary(n, pprmp, scrct, proc, opt);
				break;
			case CS_TYPE:
				rc = cl_pr_ex_def_type(n, pprmp, scrct, proc, opt);
				break;
			case CS_VAR:
				rc = cl_pr_ex_def_var(n-1, pprmp+1, scrct, proc, opt);
				break;
			case CS_OPTION:
				rc = let_option(n,pprmp,NULL);
				break;
			default:
				cmdobj = leaf->cmd.cmdobj;
#if 0
				obj = cmdobj->exobj;
				if (cmdobj->nobj && cmdobj->cid==CS_SCALAR)
					rc = cl_pr_ex_def_scalar_attr_info(obj[1],pprmp,scrct,proc,obj[2],&obj[3],NULL);
				else
#endif
				rc = cl_pr_ex_def_array(cmdobj,n,pprmp,scrct,proc,opt);
		}
	}
	else {
		sswitch ( pprmp[0]->prp )
			sicase ("MAPPEDARRAY")
				rc = cl_pr_ex_def_map_ary(n, pprmp, scrct, proc, opt);
			sicase ("TYPE")
				rc = cl_pr_ex_def_type(n, pprmp, scrct, proc, opt);
			sicase ("VAR")
				rc = cl_pr_ex_def_var(n-1, pprmp+1, scrct, proc, opt);
			sicase ("OPTION")
				rc = let_option(n,pprmp,NULL);
			sdefault
				rc = cl_pr_ex_def_array(n, pprmp, scrct, proc, opt);
		endssw
	}
	return rc;
}

/************************************/
/* cl_pr_ex_re_define               */
/************************************/
int cl_pr_ex_re_define(leaf, proc)
Leaf    *leaf;
ProcCT  *proc;
{
	ScrPrCT *scrct;

	if (!(scrct = cl_search_src_ct())) return ECL_SYSTEM_ERROR;
	return cl_pr_ex_define(leaf,scrct,proc,D_GX_OPT_REDEFINE);
}

/****************************************/
/*										*/
/****************************************/
int cl_gx_check_define(pScCT,proc,varnam,vnlen,opt,argv)
ScrPrCT	*pScCT;
ProcCT  *proc;
char    *varnam;
int      vnlen;
int      opt;
char    *argv[];
{
	int ret,iParmNo,iLGopt,iNONE;
	tdtInfoParm ***pTBL_vnam;
	char *p,*pp,*parm[3];

DEBUGOUTL4(190,"cl_gx_check_define: pScCT=%08x proc=%08x [%s] opt=%08x",
pScCT,proc,varnam,opt);
	iNONE = !(opt & D_GX_OPT_SET_SCOPE);
	iParmNo = 0;
	pTBL_vnam = NULL;
	iLGopt= 0;
	parm[0] = (char *)pTBL_vnam;
	parm[1] = (char *)iLGopt;
	parm[2] = NULL;
	if (proc && proc->pha_vnam) {
#if 1
		iLGopt = D_AUX1_LOCAL_VAR;
		parm[1] = (char *)iLGopt
		if ((ret=cl_gx_get_parm_no_static(pScCT,proc,varnam,vnlen,'r',opt,parm)) > 0)
#else
		if ((ret=cl_gx_chk_vnam('r',proc->pha_vnam,varnam,vnlen)) > 0) {
#endif
			if (iNONE || (opt & D_GX_OPT_SET_LOCAL)) {
				pTBL_vnam = proc->pTBL_vnam;
				iParmNo = ret;
				p = "LOCAL";
			}
#if 1
			iLGopt = (int)parm[1];
#else
			iLGopt = D_AUX1_LOCAL_VAR;
#endif
DEBUGOUTL1(190,"cl_gx_check_define: LOCAL ParmNo=%d",ret);
			if (argv[0] && (opt & (D_GX_OPT_SET_PRIVATE | D_GX_OPT_SET_PUBLIC))) {
				if (opt & D_GX_OPT_SET_PRIVATE) pp = "SCRIPT";
				else pp = "PUBLIC";
				/* %s:%s:(W)LOCALϐ[%s]`ς݂łB */
				ERROROUT3(FORMAT(421),argv[0],pp,varnam);
			}
		}
	}
	if (pScCT) {
#if 1
		parm[1] = (char *)D_AUX1_PRIVATE_VAR;
		if ((ret=cl_gx_get_parm_no_static(pScCT,proc,varnam,vnlen,'r',opt,parm)) > 0)
#else
		if ((ret=cl_gx_chk_vnam('r',pScCT->Vary->pha_vnam,varnam,vnlen)) > 0) {
#endif
			if (!iParmNo && (iNONE || (opt & D_GX_OPT_SET_PRIVATE))) {
				pTBL_vnam = pScCT->Vary->pTBL_vnam;
				iParmNo = ret;
				p = "SCRIPT";
			}
#if 1
			iLGopt |= (int)parm[1];
#else
			iLGopt |= D_AUX1_PRIVATE_VAR;
#endif
DEBUGOUTL1(190,"cl_gx_check_define: SCRIPT ParmNo=%d",ret);
			if (argv[0] && (opt & D_GX_OPT_SET_PUBLIC))
				/* %s:PUBLIC:(W)SCRIPTϐ[%s]`ς݂łB */
				ERROROUT2(FORMAT(422),argv[0],varnam);
		}
	}
#if 1
	parm[1] = (char *)D_AUX1_PUBLIC_VAR
	if ((ret=cl_gx_get_parm_no_static(pScCT,proc,varnam,vnlen,'r',opt,parm)) > 0)
#else
	if ((ret=cl_gx_chk_vnam('r',pCLprocTable->pha_vnam,varnam,vnlen)) > 0) {
#endif
		if (!iParmNo && (iNONE || (opt & D_GX_OPT_SET_PUBLIC))) {
			pTBL_vnam = pCLprocTable->pTBL_vnam;
			iParmNo = ret;
			p = "PUBLIC";
		}
#if 1
		iLGopt |= (int)parm[1];
#else
		iLGopt |= D_AUX1_PUBLIC_VAR;
#endif
DEBUGOUTL1(190,"cl_gx_check_define: PUBLIC ParmNo=%d",ret);
	}
#if 1
	parm[1] = (char *)D_AUX1_GLOBAL_VAR
	if ((ret=cl_gx_get_parm_no_static(pScCT,proc,varnam,vnlen,'r',opt,parm)) > 0)
#else
	if ((ret=cl_gx_chk_vnam('r',pGLprocTable->pha_vnam,varnam,vnlen)) > 0) {
#endif
		if (!iParmNo && (iNONE || (opt & D_GX_OPT_SET_GLOBAL))) {
			pTBL_vnam = pGLprocTable->pTBL_vnam;
			iParmNo = ret;
			p = "GLOBAL";
		}
#if 1
		iLGopt |= (int)parm[1];
#else
		iLGopt |= D_AUX1_GLOBAL_VAR;
#endif
DEBUGOUTL1(190,"cl_gx_check_define: GLOBAL ParmNo=%d",ret);
	}
	if (cl_chk_sysvar_name(varnam, vnlen)) {
						/* %s:(E)SYSTEMϐ[%s]`ς݂łB */
		if (argv[0]) ERROROUT2(FORMAT(423),argv[0],varnam);
		iParmNo = ECL_SCRIPT_ERROR;
	}
#if 1
	argv[1] = parm[0];
#else
	argv[1] = (char *)pTBL_vnam;
#endif
	argv[2] = (char *)iLGopt;
	argv[3] = p;
	argv[6] = parm[2];
	return iParmNo;
}

/************************************/
/*	_chk_define                     */
/************************************/
int _chk_define(scrct,proc,varnam,vnlen,opt,argv)
ScrPrCT *scrct;
ProcCT  *proc;
char    *varnam;
int      vnlen;
int      opt;
char    *argv[];
{
	XHASHB  *pha_vname;
	tdtInfoParm ***pTBL_vname;
	int ret,iAux,iARRAY;
	char *name;
/*
printf("_chk_define: scrct=%08x proc=%08x varnam=%s vnlen=%d opt=%08x\n",scrct,proc,varnam,vnlen,opt);
*/
	name = argv[0];
	if ((ret=cl_gx_check_define(scrct,proc,varnam,vnlen,opt,argv)) < 0) return ret;
	iAux = (int)argv[2];
	iARRAY = opt & D_GX_OPT_SET_ARRAY;
	if (opt & D_GX_OPT_SET_LOCAL) {
		if (!proc) {
			/* %s: 葱OłLOCALϐ͒`ł܂B */
			ERROROUT1(FORMAT(424),name);
			return ECL_SCRIPT_ERROR;
		}
		if (pha_vname=proc->pha_vnam) {
			if (iARRAY && (iAux & D_AUX1_LOCAL_VAR)) {
				/* %s: LOCALϐ[%s]`ς݂łB */
				ERROROUT2(FORMAT(425),name,varnam);
				return ECL_SCRIPT_ERROR;
			}
			pTBL_vname = proc->pTBL_vnam;
		}
		else return -1;
	}
	else if (opt & D_GX_OPT_SET_PUBLIC) {
		pha_vname = pCLprocTable->pha_vnam;
		pTBL_vname = pCLprocTable->pTBL_vnam;
	}
	else if (opt & D_GX_OPT_SET_GLOBAL) {
		pha_vname = pGLprocTable->pha_vnam;
		pTBL_vname = pGLprocTable->pTBL_vnam;
	}
	else {
		if (!scrct) return -1;
		pha_vname = scrct->Vary->pha_vnam;
		if ((iARRAY || !proc) && (iAux & D_AUX1_PRIVATE_VAR)) {
			/* %s: SCRIPTϐ[%s]`ς݂łB */
			ERROROUT2(FORMAT(426),name,varnam);
			return ECL_SCRIPT_ERROR;
		}
		pTBL_vname = scrct->Vary->pTBL_vnam;
	}
#if 1
	if (opt & D_GX_OPT_SET_STATIC) {
		if (opt & D_GX_OPT_SET_GLOBAL) {
			pha_vname = pGLprocTable->pha_vnam;
			pTBL_vnam = pGLprocTable->pTBL_vnam;
		}
		else if (!(opt & D_GX_OPT_SET_IMPORT)) {
			pha_vname = pCLprocTable->pha_vnam;
			pTBL_vnam = pCLprocTable->pTBL_vnam;
		}
	}
#endif
	argv[4] = (char *)pha_vname;
	argv[5] = (char *)pTBL_vname;
/*
printf("_chk_define: ret=%3d varnam=[%s]\n",ret,varnam);
*/
	return ret;
}

/************************************/
/*	_set_index                      */
/************************************/
int _set_index(is,prmnum,pprmp,offset,index,msg)
int is,prmnum;
parmList **pprmp;
int offset,index[];
char *msg;
{
	int i,rc,ixlen,ix,len,k,f;
	char *ixnam,*p;
	tdtInfoParm tInfoParm;
	tdtObjHead *Obj;

	if (prmnum-(is+1) > MAX_ARRAY_DIM) {
		ERROROUT2(FORMAT(427),msg,prmnum);	/* %s: (%d)܂B */
		return ECL_SCRIPT_ERROR;
	}
	Obj = cl_gx_get_proc_obj();
	ix = is;
	f = 1;
	for (i=0;i<prmnum;i++,ix++) {
#if 1
		if (ixlen = pprmp[i+offset]->prmlen) {
#else
		if (!(ixlen = pprmp[i+offset]->prmlen)) index[ix] = 1;
		else {
#endif
			ixnam = pprmp[i+offset]->prp;
			if (rc = cl_gx_exp_obj(1,&pprmp[i+offset],Obj,&tInfoParm)) return ECL_SCRIPT_ERROR;
			if (tInfoParm.pi_dlen > 0) {
				rc = cl_get_parm_bin(&tInfoParm,&index[ix],msg);
				if (!rc && ix>0 && (tInfoParm.pi_alen & D_AULN_RANGE_DATA)) {
					memcpy(tInfoParm.pi_data,tInfoParm.pi_data+tInfoParm.pi_dlen,tInfoParm.pi_dlen);
					if (!(rc=cl_get_parm_bin(&tInfoParm,&index[ix+MAX_ARRAY_DIM+1],msg))) {
						if (index[ix] > index[ix+MAX_ARRAY_DIM+1]) {
							/* %s: i=%d ͈͎w[%s]słB */
							ERROROUT3(FORMAT(428),msg,i,ixnam);
							return ECL_SCRIPT_ERROR;
						}
						k = index[ix+MAX_ARRAY_DIM+1];
						index[ix+MAX_ARRAY_DIM+1] = index[ix];
						index[ix] = k - index[ix] + 1;
						index[MAX_ARRAY_DIM+1] |= f;
					}
				}
				if (rc) {
					/* %s: i=%d ͈͎w[%s]lł͂܂B */
					ERROROUT3(FORMAT(429),msg,i,ixnam);
					return ECL_SCRIPT_ERROR;
				}
			}
			if (index[ix] <= 0) {
				/* %s: i=%d ͈͎w[%s]=%dsłB */
				ERROROUT4(FORMAT(430),msg,i,ixnam,index[ix]);
				return ECL_SCRIPT_ERROR;
			}
		}
		if (ix > 0) f <<= 1;
/*
printf("%s: index[%d]=%d,%d f=%x index[MAX_ARRAY_DIM+1]=%x\n",
msg,ix,index[ix],index[ix+MAX_ARRAY_DIM+1],f,index[MAX_ARRAY_DIM+1]);
*/
	}
	return 0;
}

/************************************/
/*	_check_redefine                 */
/************************************/
static int _check_redefine(varnam,vnlen,ppInfoParm,id,msg)
char *varnam;
int vnlen;
tdtInfoParm **ppInfoParm;
char id,*msg;
{
	int rc;
	char *ary;
	tdtInfoParm tInfoParm,*pInfoParm;
	parmList prmp;

	pInfoParm = &tInfoParm;
	prmp.prp = varnam;
	prmp.prmlen = vnlen;
	if (rc=cl_conv_parm_opt(&prmp,pInfoParm,D_GX_OPT_SET_ADDR)) {
		if (rc == ECL_DEFINED_ARRAY) rc = 0;
		else {
			ERROROUT2(FORMAT(125),msg,varnam);	/* %s: [%s]Ă܂B */
			return rc;
		}
	}
	if (pInfoParm->pi_id == 'S') {
		pInfoParm = (tdtInfoParm *)pInfoParm->pi_pos;
	}
	if (id=='A' || id=='R') {
		if (id && pInfoParm->pi_id != id) {
			if (id == 'A') ary = "MAPPEDARRAY";
			else ary = "ARRAY";
			/* %s: ϐ(%s)%sł͂܂B */
			ERROROUT3(FORMAT(431),msg,varnam,ary);
			rc = ECL_SCRIPT_ERROR;
		}
	}
	*ppInfoParm = pInfoParm;
	return rc;
}

/************************************/
/*	cl_get_def_scope				*/
/************************************/
int cl_get_def_scope(p)
char *p;
{
	int opt;

	opt = 0;
	if (!stricmp(p,"GLOBAL") || !stricmp(p,D_STR_SCOPE_GLOBAL))
		opt = D_GX_OPT_SET_GLOBAL;
	else if (!stricmp(p,"PUBLIC") || !stricmp(p,D_STR_SCOPE_PUBLIC))
		opt = D_GX_OPT_SET_PUBLIC;
	else if (!stricmp(p,"PRIVATE") || !stricmp(p,D_STR_SCOPE_PRIVATE))
		opt = D_GX_OPT_SET_PRIVATE;
	else if (!stricmp(p,"LOCAL") || !stricmp(p,D_STR_SCOPE_LOCAL))
		opt = D_GX_OPT_SET_LOCAL;
	return opt;
}
#if 0
/************************************/
/*	cl_get_def_modifier				*/
/************************************/
int cl_get_def_modifier(Prmnum,Pprmp,check,iParm)
int      Prmnum;
parmList **Pprmp;
int      check[],iParm[];
{
	parmList **pprmp;
	int  prmnum,np,i,n,iCONST,iOpt,iARRAY,iCHK,iOK,rc,opt;
	char *p;

	n = iCONST = iOpt = iARRAY = iOK = opt = 0;
	np   = check[0];
	iCHK = check[1];
	prmnum = Prmnum;
	pprmp  = Pprmp;
	if (prmnum < np) np = prmnum;
	for (i=0;i<np;i++) {
		p = pprmp[0]->prp;
		if (!iOpt && (iOpt=cl_get_def_scope(p))) {
			n++;
			pprmp++;
			opt |= iOpt;
			iOK |= 0x01;
		}
		else if (!iCONST && !stricmp(p,"CONST")) {
			n++;
			pprmp++;
			iCONST = D_AUX1_PROTECTED;
			opt |= D_GX_OPT_SET_CONST;
			iOK |= 0x02;
		}
		else if (!iARRAY && !stricmp(p,"ARRAY")) {
			n++;
			pprmp++;
			iARRAY = 1;
			opt |= D_GX_OPT_SET_ARRAY;
			iOK |= 0x04;
		}
		if (iCHK & iOK) ;
		else break;
		iCHK &= ~iOK;
	}
	check[2] = iOK;
	check[3] = opt;

	if (prmnum > n) {
		if (rc=cl_get_def_attr(pprmp[0]->prp,pprmp[0]->prmlen,iParm,NULL,NULL)) return rc;
		else if (iParm[0] > 0) n++;
	}
/*
printf("cl_get_def_modifier: np=%d n=%d iOk=%02x opt=%08x\n",np,n,check[2],check[3]);
*/
	return n;
}
#endif
/************************************/
/*	cl_get_def_modifier_SSP			*/
/************************************/
int cl_get_def_modifier_SSP(s,slen,ssp,sep,check,iParm,bxobj,Obj)
char   *s;
int    slen;
SSPL_S *ssp;
char   *sep;
int    check[],iParm[];
GXObject *bxobj[];
tdtObjHead *Obj;
{
	int  np,i,n,iCONST,iOpt,iARRAY,iCHK,iOK,rc,opt,len,spw,iSTATIC;
	char *p;

	n = iCONST = iOpt = iARRAY = iOK = opt = iSTATIC= 0;
	iCHK = check[1];
	spw = ssp->sp;
	while ((len=akxtgwnsl(s,slen,ssp,sep,0x41)) > 0) {
		p = strtemp(ssp->wd,len);
/*
printf("cl_get_def_modifier_SSP: p=[%s]\n",p);
*/
		if (!iOpt && (iOpt=cl_get_def_scope(p))) {
			n++;
			opt |= iOpt;
			iOK |= 0x01;
		}
		else if (!iCONST && !stricmp(p,"CONST")) {
			n++;
			iCONST = D_AUX1_PROTECTED;
			opt |= D_GX_OPT_SET_CONST;
			iOK |= 0x02;
		}
		else if (!iARRAY && !stricmp(p,"ARRAY")) {
			n++;
			iARRAY = 1;
			opt |= D_GX_OPT_SET_ARRAY;
			iOK |= 0x04;
		}
		else if (!iSTATIC && !stricmp(p,"STATIC")) {
			n++;
			iSTATIC = 1;
			opt |= D_GX_OPT_SET_STATIC;
			iOK |= 0x08;
		}
		if (!(iCHK & iOK)) {
			ssp->sp = spw;
			break;
		}
		iCHK &= ~iOK;
		spw = ssp->sp;
/*
printf("cl_get_def_modifier_SSP: spw=%d\n",spw);
*/
	}
	check[2] = iOK;
	check[3] = opt;
/*
printf("cl_get_def_modifier_SSP: sp=%d\n",ssp->sp);
*/
	if (rc=cl_get_def_attr_SSP(s,slen,ssp,sep,iParm,bxobj,Obj)) return rc;
	else if (iParm[0] > 0) n++;
	else {
		ssp->sp = spw;
	}
/*
printf("cl_get_def_modifier_SSP: sp=%d n=%d iOk=%02x opt=%08x iParm[0]=%d\n",
ssp->sp,n,check[2],check[3],iParm[0]);
*/
	return n;
}

/************************************/
/*	cl_def_chk_name_opt				*/
/************************************/
int cl_def_chk_name_opt(varnam,vnlen,func,msg,redef_flg)
char *varnam;
int   vnlen;
char *func,*msg;
int   redef_flg;
{
	static char *p0=NULL;
	char work[256],*p;
	int  opt;

	if (redef_flg) opt = 0x01;	/* sIhnj */
	else opt = 0;
	strnzcpy(work,varnam,vnlen,sizeof(work)-1);
	if (vnlen > Var_NM_MAX) {
		ERROROUT3(FORMAT(496),func,work,vnlen);	/* %s: ϐ(%s)̒(%d)܂B */
		return ECL_SCRIPT_ERROR;
	}
	else if (cl_chk_name_opt(varnam,vnlen,opt)) {
		if (func && msg) {
			if (vnlen > 0)
				/* %s: %s(%s)Ă܂B */
				ERROROUT3(FORMAT(432),func,msg,work);
			else
				ERROROUT2(FORMAT(76),func,msg);	/* %s: %s܂B */
		}
		return ECL_SCRIPT_ERROR;
	}
#if 1
	if (cl_chk_sysvar_name(varnam,vnlen)) {
		ERROROUT2(FORMAT(453),func,work);
		return ECL_EX_DEFINE;
	}
#else
	else if (cl_is_yoyakugo(work)) {
		ERROROUT2(FORMAT(121),func,work);
		return ECL_EX_DEFINE;
	}
#endif
	return 0;
}

/************************************/
/*	cl_def_chk_name					*/
/************************************/
int cl_def_chk_name(varnam,vnlen,func,msg)
char *varnam;
int   vnlen;
char *func,*msg;
{
	return cl_def_chk_name_opt(varnam,vnlen,func,msg,0);
}

/************************************/
/*	_get_varname					*/
/************************************/
int _get_varname(s,slen,ssp,proc,bxobj,pp)
char *s;
int  slen;
SSPL_S *ssp;
ProcCT *proc;
GXObject *bxobj[];
char **pp;
{
	int rc,pos,llen,vnlen,iSKIP,len;
	tdtObjHead *pObj;
	tdtInfoParm tInfoParm;
	char c,*p,*line,*varnam;

	if (bxobj && bxobj[0]) {
		line = NULL;
		llen = 0;
		c = '(';
	}
	else {
		iSKIP = 0;
		pos = ssp->sp;
/*
printf("_get_varname: pos=%d s+pos=[%s]\n",pos,s+pos);
*/
		ssp->sp += akxnskipin(s+pos,slen-pos," \t");
		pos = ssp->sp;
/*
printf("_get_varname: pos=%d s+pos=[%s]\n",pos,s+pos);
*/
		if ((c=*(s+pos)) == '(') iSKIP = pos + 1;
		else {
			vnlen = akxtgwnsl(s,slen,ssp,gsep,0x41);
			varnam = ssp->wd;
			len = akxnskipin(varnam,vnlen,"$%#");
			if (len<=0 || (vnlen>1 && len<=1)) {
				return 0;
			}
			pos++;
			llen = vnlen - 1;
			if (len >= vnlen) {
				clpeeksl(s,slen,ssp,gsep,0x41);
				if (*ssp->wd == '(') iSKIP = ssp->sp + 1;
				else {
					/* _get_varname: [%s]͕ϐɕϊł܂B */
					ERROROUT1(FORMAT(585),strtemp(varnam,vnlen));
					return ECL_SCRIPT_ERROR;
				}
			}
		}
		line = s + pos;
		if (iSKIP) {
			ssp->sp = iSKIP - 1;
			if (rc=cl_skip_to_delm(s,slen,"()",ssp,gsep,0)) {
				ERROROUT1(FORMAT(433),"_get_varname");	/* %s: JbRĂ܂B */
				return ECL_SCRIPT_ERROR;
			}
			llen = ssp->sp - pos;
		}
	}
	if (bxobj) {
		if (proc) pObj = proc->Obj;
		else pObj = cl_gx_get_scr_obj();
	}
	else pObj = NULL;
/*
printf("_get_varname: llen=%d line=[%s]\n",llen,line);
*/
	if (rc=cl_gx_expsn_obj_opt(line,llen,bxobj,pObj,&tInfoParm,0)) return rc;
	if ((llen=parm_to_char_tmp(&tInfoParm,pp,0)) < 0) return rc;
	if (c != '(') {
		if (!(p=cl_tmp_const_malloc(llen+2))) return -1;
		*p = c;
		memzcpy(p+1,*pp,llen);
		*pp = p;
		llen++;
	}
/*
printf("_get_varname: vnlen=%d varnam=[%s]\n",llen,*pp);
*/
	return llen;
}

/************************************/
/*	_set_array_values				*/
/************************************/
int _set_array_values(pInfoParm,prmnum,pprmp,Obj)
tdtInfoParm *pInfoParm;
int      prmnum;
parmList **pprmp;
tdtObjHead *Obj;
{
	int  i,rc,len;
	int  nparm;
	char *prnam,id;
	tdtInfoParm tInfoParm,tInfoParm2[2],**ppParm,*pInfoParmW;

	if (rc=cl_gx_exp_obj_opt(prmnum,pprmp,Obj,tInfoParm2,D_GX_OPT_PARMINFO2)) return rc;
	if (nparm=tInfoParm2[1].pi_pos) {
		pInfoParmW = (tdtInfoParm *)tInfoParm2[1].pi_data;
		rc = tInfoParm2[1].pi_hlen;
	}
	else {
		nparm = 1;
		pInfoParmW = tInfoParm2;
	}
	if ((id=pInfoParm->pi_id)=='A' || id=='R') {
		if (!(ppParm=(tdtInfoParm **)cl_tmp_const_malloc(sizeof(tdtInfoParm *)*(nparm+2)))) return -1;
		ppParm[0] = pInfoParm;
		ppParm[1] = &tInfoParm;
		cl_set_parm_bin(&tInfoParm,0);
		for (i=0;i<nparm;i++) ppParm[i+2] = pInfoParmW++;
		rc = cl_set_array(&len,nparm+2,ppParm);
	}
	else if (id == ' ') rc = cl_gx_rep_info_set(pInfoParm,&pInfoParmW[nparm-1],1);
	else rc = -1;
	return rc;
}

/************************************/
/*	cl_def_map_ary_max_chk				*/
/************************************/
int cl_def_map_ary_max_chk(c,index,scrct,proc,opt)
char c;
int *index;
ScrPrCT *scrct;
ProcCT  *proc;
int     opt;
{
	int *pSize;
	tdtInfoParm ***pTBL_pas;

/*	if      (c == '$') pSize = (int *)scrct->Vary->pTBL_dolu[0];
	else */if (c == '#') pSize = (int *)scrct->Vary->pTBL_igeta[0];
	else if (c == '%') {
		if (opt & D_GX_OPT_SET_LOCAL) {
			if (!proc) return -1;
			if (!(pTBL_pas=proc->pTBL_pasento)) return -1;
		}
		else pTBL_pas =scrct->Vary->pTBL_pasento;
		pSize = (int *)pTBL_pas[0];
	}
	else pSize = (int *)scrct->Vary->pTBL_dolu[0];
	if (index[0]+index[1]*index[2]*index[3]-1 > pSize[2]) {
		/* cl_pr_ex_def_map_ary: ͈͎w(%d[%d,%d,%d])ϐž(%d)𒴂Ă܂B */
		ERROROUT5(FORMAT(434),index[0],index[1],index[2],index[3],pSize[2]);
		return ECL_SCRIPT_ERROR;
	}
	return 0;
}

/************************************/
/*	cl_pr_ex_def_map_ary					*/
/************************************/
int cl_pr_ex_def_map_ary(prmnum, pprmp, scrct, proc, opt)
int      prmnum;
parmList **pprmp;
ScrPrCT  *scrct;
ProcCT   *proc;
int      opt;
{
	char *argv[7], *_name_;
	XHASHB *pha_vname;
	int  i, iParmNo, rc, vnlen, n, *pSize, ixlen, nparm,len,is,line_len;
	char c, *varnam, *p, *ixnam, wrk[128],*line,*pp;
	tdtInfoParm *pInfoParm,tInfoParm;
	tdtArrayIndex tIndex;
	int *index;
	tdtInfoParm ***pTBL_vname,***pTBL_pas;
	uchar ucLOCAL=0;
	int iARRAY,iEQU,iSET,iCONST;
	SSPL_S ssp;
	parmList *qprmp[4];
	tdtObjHead *pObj;
/*
printf("cl_pr_ex_def_map_ary: prmnum=%d pprmp=%08x scrct=%08x proc=%08x opt=%d\n",
prmnum, pprmp, scrct, proc, opt);
*/
	argv[0] = _name_ = "cl_pr_ex_def_map_ary";

	/* parameter check */
	if (!proc && prmnum<2) {
		ERROROUT1(FORMAT(42),_name_);	/* %s: p[^܂B */
		return ECL_EX_DEFINE;
	}
	iEQU = iSET = iCONST = 0;
	iARRAY = 1;
	line = pprmp[1]->prp;
	line_len  = pprmp[1]->prmlen;
/*
printf("%s: prmnum=%d line_len=%d line=[%s]\n",argv[0],prmnum,line_len,line);
*/
	memset(&ssp,0,sizeof(SSPL_S));
	is = ssp.sp;
	/* ϐ̎擾 */
	vnlen = akxtgwnsl(line,line_len,&ssp,gsep,0x41);
	if (vnlen <= 0) {
		ERROROUT1(FORMAT(435),argv[0]);	/* %s: ϐ܂B */
		return ECL_EX_DEFINE;
	}
	memnzcpy(wrk,ssp.wd,vnlen,sizeof(wrk)-1);
	varnam = wrk;
	c = *varnam;
	/* z񖼂ɕϐw\Ƃ */
	if (c=='(' || c=='$' || c=='#' || c=='%') {
		ssp.sp = is;
		if ((len=_get_varname(line,line_len,&ssp,proc,&pprmp[0]->bxobj,&pp)) < 0) return len;
		else if (len > 0) {
			varnam = pp;
			vnlen = len;
			c = *varnam;
		}
	}
/*
printf("%s: vnlen=%d varnam=[%s]\n",argv[0],vnlen,strtemp(varnam,vnlen));
*/
	/* z񖼂̃`FbN */
	if (c=='$') {
		vnlen--;
		varnam++;
	}
	else if (c!='#' && c!='%') c = '$';
#if 1
	p = varnam;
	len = vnlen;
	if (c=='%' || c=='#') {
		p++;
		len--;
	}
	if (rc=cl_def_chk_name(p,len,_name_,FORMAT(441))) return rc;
#else
	if (((c=='%' || c=='#') && cl_chk_name(varnam+1,vnlen-1)) ||
	    (c!='%' && c!='#' && cl_chk_name(varnam,vnlen))) {
		ERROROUT2(FORMAT(436),_name_,varnam);	/* %s: ϐ(%s)Ă܂B */
		return ECL_SCRIPT_ERROR;
	}
#endif
	/* z`̎擾 */
	nparm = cl_get_array_def_parm(line,line_len,"=",&ssp,gsep,4,qprmp,&iEQU);
	if (nparm < 0) return n;
	else if (!nparm) {
		if (proc) iARRAY = 2;
	}
/*
printf("%s: nparm=%d iARRAY=%d\n",_name_,nparm,iARRAY);
*/
#if 0
	if (iARRAY==1 && nparm<2) {
		/* %s: CfbNX܂͎̎w肪܂B */
		ERROROUT1(FORMAT(437),_name_);
		return ECL_SCRIPT_ERROR;
	}
#endif
	if (opt & D_GX_OPT_REDEFINE) {
		if (rc=_check_redefine(varnam,vnlen,&pInfoParm,'A',_name_)) return rc;
		iParmNo = 0;
	}
	else {
		if ((iParmNo=_chk_define(scrct,proc,varnam,vnlen,opt,argv)) < 0) return iParmNo;
		if (iARRAY==2 && !iParmNo) {
			ERROROUT2(FORMAT(438),argv[0],varnam);	/* %s: [%s]͖`łB */
			return ECL_SCRIPT_ERROR;
		}
/*
printf("%s: iParmNo=%d\n",_name_,iParmNo);
*/
	}
#if 1
	if (iARRAY == 1) {
		if (nparm>0 && iParmNo>0) {
#else
	if (nparm > 0) {
		if (iParmNo > 0) {
#endif
			/* %s: `ςMAPPEDARRAŶ߃CfbNX܂͎͎wł܂B */
			ERROROUT1(FORMAT(439),_name_);
			return ECL_SCRIPT_ERROR;
		}
		memset(&tIndex,0,sizeof(tdtArrayIndex));
		tIndex.uAttr[0] = DEF_ZOK_VARI;
		tIndex.size = sizeof(tdtInfoParm *);
		index = tIndex.index;
		for (i=0;i<4;i++) index[i] = 1;
		index[1] = 10;
		if (rc = _set_index(0,nparm,qprmp,0,index,_name_)) return rc;
		if ((rc=cl_def_map_ary_max_chk(c,index,scrct,proc,opt)) < 0) return rc;
	}

	if (opt & D_GX_OPT_REDEFINE) {
		memcpy(pInfoParm->pi_data,&tIndex,sizeof(tdtArrayIndex));
	}
	else if (iParmNo > 0) {
		pTBL_vname = (tdtInfoParm ***)argv[1];
		pInfoParm = cl_get_var_ent(pTBL_vname,iParmNo);
	}
	else {
		pha_vname  = (XHASHB *)argv[4];
		if ((iParmNo=cl_gx_chk_vnam('s',pha_vname,varnam,vnlen))<1){
					/* %s: %s%sGgp̋󂫂܂B */
			ERROROUT3(FORMAT(323),_name_,varnam,argv[3]);
			return ECL_SCRIPT_ERROR;
		}
/*
printf("%s: pha_vname=%08x varnam=[%s] vnlen=%d iParmNo=%d\n",
argv[0],pha_vname,varnam,vnlen,iParmNo);
*/
		pTBL_vname = (tdtInfoParm ***)argv[5];
		pInfoParm = cl_get_var_ent(pTBL_vname,iParmNo);
		if (!pInfoParm) return (ECL_SCRIPT_ERROR);
		info_parm_clear(pInfoParm);
		pInfoParm->pi_id   = 'A';
		pInfoParm->pi_scale = D_DATA_MALLOC | D_DATA_INDEX_FREE;
		pInfoParm->pi_attr = DEF_ZOK_VARI;
		pInfoParm->pi_dlen  = sizeof(tdtArrayIndex);

		if (!(pInfoParm->pi_data = Malloc(sizeof(tdtArrayIndex)))) return ECL_MALLOC_ERROR;
		memcpy(pInfoParm->pi_data,&tIndex,sizeof(tdtArrayIndex));

		if (!(p=Malloc(vnlen+1))) {
			ERROROUT("Array name area malloc");
			return ECL_MALLOC_ERROR;
		}
		strnzcpy(p,varnam,vnlen);
		pInfoParm->pi_pos = (long)p;

		if (opt & D_GX_OPT_SET_LOCAL) pInfoParm->pi_hlen = proc->ProcGid;
		else pInfoParm->pi_hlen = scrct->ScrGid;

		if (c=='%' && (opt & D_GX_OPT_SET_LOCAL)) ucLOCAL = D_AUX1_LOCAL_VAR;
		pInfoParm->pi_aux[1] = ucLOCAL;

		if ((rc=cl_gx_clear_var_define(scrct,proc,p,opt)) < 0) return rc;
	}
	if (iEQU) {
/*
printf("%s: iARRAY=%d is=%d prmnum=%d\n",argv[0],iARRAY,is,prmnum);
printf("%s: iEQU=%d ssp.sp=%d\n",argv[0],iEQU,ssp.sp);
*/
		pprmp[2]->prp = line + iEQU;
		pprmp[2]->prmlen = line_len - iEQU;
		if (proc) pObj = proc->Obj;
		else pObj = scrct->Obj;
		if (rc = _set_array_values(pInfoParm,1,&pprmp[2],pObj)) return rc;
	}
	return 0;
}
#if 0
/************************************/
/*	cl_pr_ex_def_scalar                 */
/************************************/
int cl_pr_ex_def_scalar(prmnum, pprmp, scrct, proc, opt)
int      prmnum;
parmList **pprmp;
ScrPrCT  *scrct;
ProcCT  *proc;
int      opt;	/* =0:`ς݂̂Ƃ́A̒lݒ肵Ȃ/!=0:ɐݒ肷 */
{
	return cl_pr_ex_def_scalar_info(prmnum, pprmp, scrct, proc, opt, NULL);
}
#endif

#define PRT_18(x) x
/************************************/
/*	cl_pr_ex_def_scalar_attr_info	*/
/************************************/
int cl_pr_ex_def_scalar_attr_info(prmnum, pprmp, scrct, proc, opt, iParm, ppInfoParm)
int      prmnum;
parmList **pprmp;
ScrPrCT  *scrct;
ProcCT  *proc;	/* defineR}ĥƂ́ANULL */
int      opt;	/* =0:`ς݂̂Ƃ́A̒lݒ肵Ȃ/!=0:ɐݒ肷 */
int      iParm[];
tdtInfoParm  **ppInfoParm;
{
	int  i,iParmNo,rc,vnlen,iOpt,iNew,len,iCONST,isp,iAux,iSet,tmpvnlen,iFound;
	char c, *varnam,*p,*argv[7],*pp,cLET,*vrn;
	prmList *pprmList;
	GWPRM_S gwprm;
	SSPL_S ssp;
	char wrk[4096],tmpvname[40];
	int atr,attr,atr0,size,size_old,attr_old,alsize;
	Leaf tLeaf;
	tdtInfoParm  *pInfoParm;
	parmList   qpL;
	tdtInfoParm ***pTBL_vname;
	XHASHB *pha_vname;
	MCAT mcat;

	argv[0] = "cl_pr_ex_def_scalar_attr_info";

	iCONST = 0;
	if (opt & D_GX_OPT_SET_CONST) iCONST = D_AUX1_PROTECTED;
	iOpt = opt & D_GX_OPT_SET_SCOPE;
	if (!proc && !iOpt) {
		opt |= D_GX_OPT_SET_PRIVATE;
	}
	if (opt & D_GX_OPT_SET_PUBLIC) {
		iOpt |= D_GX_OPT_ALC_CONST;
	}
#if 0
	if ((attr=iParm[0]) == DEF_ZOK_VARI) {
		attr = iParm[0] = 0;
	}
#else
	attr = iParm[0];
#endif
	gwprm.line = pprmp[0]->prp;
	gwprm.line_len = pprmp[0]->prmlen;

PRT_18(printf("%s:Enter: iParm[0]=%d attr=%d iOpt=%08x prmnum=%d\n",argv[0],iParm[0],attr,iOpt,prmnum);)
PRT_18(printf("%s: line_len=%d line=[%s]\n",argv[0],gwprm.line_len,gwprm.line);)

	pprmp[1]->prp = gwprm.line + prmnum;
	pprmp[1]->prmlen = gwprm.line_len - prmnum;

	ssp.sp = prmnum;
	ssp.wd = wrk;
	ssp.wdmax = sizeof(wrk);
	atr0 = cmp_gtwd(&gwprm,&ssp);
	vnlen  = strlen(wrk);
	varnam = wrk;

PRT_18(printf("%s: vnlen=%d varnam=[%s] atr0=%d ssp.sp=%d\n",argv[0],vnlen,varnam,atr0,ssp.sp);)

	ssp.wd = wrk + vnlen + 1;
	ssp.wdmax -= vnlen + 1;
	atr = cmp_gtwd(&gwprm,&ssp);
	c = *ssp.wd;

PRT_18(printf("%s: c=%c\n",argv[0],c);)

	rc = iNew = isp = 0;
	if (proc) {
		if (!attr && !(opt & (D_GX_OPT_SET_SCOPE | D_GX_OPT_SET_CONST))) iNew = 1;
		else if (!attr && (atr0>=14 && atr0<=17)) iNew = 1;
		else {
			while ((atr<71 || atr>90)&&(atr<14 || atr>17)) {
				if ((atr=cmp_gtwd(&gwprm,&ssp)) <= 0) break;

PRT_18(printf("%s: atr=%d\n",argv[0],atr);)

			}
			if ((atr>=71 && atr<=90)||(atr>=14 && atr<=17)) {
				if (!attr) iNew = 1;
			/*	else if (c != '=') rc = -1;	*/
				isp = ssp.sp;
			}
			else if (atr0<=100/* || c*/) rc = -2;
		}
	}
	else {
		if (c == '=') {
			if (!attr && !(opt & (D_GX_OPT_SET_PUBLIC | D_GX_OPT_SET_GLOBAL))) iNew = 1;
		}
	/*	else if (atr>0 && atr<=100) rc = -3;	*/
	}
	cLET = *ssp.wd;

PRT_18(printf("%s: attr=%d atr0=%d c=[%c] atr=%d iNew=%d wd=[%s]\n",argv[0],attr,atr0,c,atr,iNew,ssp.wd);)

	if (rc) {
		ERROROUT2(FORMAT(440),argv[0],rc);	/* %s: SYNTAXĂ܂Brc=%d */
		return ECL_SCRIPT_ERROR;
	}
	else if (iNew) {
		tLeaf.cmd.prmnum = 1;
		tLeaf.cmd.prmp = &pprmp[1];
		iOpt |= D_GX_OPT_GET_ADDR;
		pInfoParm = NULL;
		if ((rc=let_compute_info(&tLeaf,proc,iOpt,&pInfoParm)) < 0) return rc;
		if (pInfoParm && iCONST) pInfoParm->pi_aux[1] |= D_AUX1_PROTECTED;
		if (ppInfoParm) *ppInfoParm = pInfoParm;
/*
DEBUGOUT2("%s: bxobj=%08x",argv[0],pprmp[1]->bxobj);
*/
		return 0;
	}

	/* ϐ̎擾 */
	c = *varnam;
	/* ϐɕϐw\Ƃ */
	if (c=='(' || c=='$') {
		memset(&ssp,0,sizeof(SSPL_S));
		ssp.sp = prmnum;
		if ((len=_get_varname(gwprm.line,gwprm.line_len,&ssp,proc,&pprmp[0]->bxobj,&pp)) < 0) return len;
		else if (len > 0) {
			varnam = pp;
			vnlen = len;
			c = *varnam;
		}
	}
/*
printf("%s: vnlen=%d varnam=[%s]\n",argv[0],vnlen,strtemp(varnam,vnlen));
*/
	c = *varnam;
	if (c == '$') {
		varnam++;
		vnlen--;
	}
	else if (c=='%' || c=='#') {
		ERROROUT2(FORMAT(436),argv[0],varnam);	/* %s: ϐ(%s)Ă܂B */
		return ECL_SCRIPT_ERROR;
	}

	if (!proc) {
		if (rc=cl_def_chk_name(varnam,vnlen,argv[0],FORMAT(441))) return rc;	/* ϐ */
	}
	else if (cl_chk_name(varnam, vnlen)) {
		ERROROUT2(FORMAT(436),argv[0],varnam);	/* %s: ϐ(%s)Ă܂B */
		return ECL_SCRIPT_ERROR;
	}
#if 1
	if (proc && isp>0 && akxs_in_mem_opt(gwprm.line+isp,gwprm.line_len-isp,varnam,vnlen,0)>0) {
		i = ssp.sp;
		iFound = 0;
		while ((atr=cmp_gtwd(&gwprm,&ssp)) > 0) {
			if (atr==3000 || atr==10000) {
				vrn = ssp.wd;
				if (atr == 3000) vrn++;
				if (!strcmp(vrn,varnam)) {
					iFound = 1;
					break;
				}
			}
		}
		if (iFound) {
			ssp.sp = i;
			sprintf(tmpvname,"$_%x_%x ",proc,varnam);
			tmpvnlen = strlen(tmpvname);
			i = isp;
			isp = prmnum;
			cl_im_mman_init(&mcat,"DF",256,0,D_OPT_ALC_TMP);
			iFound = 0;
			while ((atr=cmp_gtwd(&gwprm,&ssp)) > 0) {
				if (atr==3000 || atr==10000) {
					vrn = ssp.wd;
					if (atr == 3000) vrn++;
					if (!strcmp(vrn,varnam)) {
						len = i - isp;
						cl_im_mcat(&mcat,gwprm.line+isp,len);
						cl_im_mcat(&mcat," ",1);
						cl_im_mcat(&mcat,tmpvname,tmpvnlen);
						isp = ssp.sp;
					}
				}
				i = ssp.sp;
			}
			cl_im_mcatz(&mcat,gwprm.line+isp,i-isp);
			p = mcat.mc_bufp;
/*
printf("p=[%s]\n",p);
*/
			sprintf(ssp.wd,"%s = %s",tmpvname,varnam);
			if (rc=cl_set_scalar_var_info(ssp.wd,NULL,
			        D_GX_OPT_SET_LOCAL|D_GX_OPT_SET_CONST,NULL)) return rc;
			pprmp[1]->prp = p;
			pprmp[1]->prmlen = mcat.mc_ipos;
		}
	}
#endif
	iSet = opt & 0x01;
	if (opt & D_GX_OPT_REDEFINE) {
		iSet = 1;
		if (rc=_check_redefine(varnam,vnlen,&pInfoParm,' ',argv[0])) return rc;
		attr_old = pInfoParm->pi_attr;
		if (!attr) attr = attr_old;
		if (attr != attr_old) {
			/* %s:̑(%d)ƍĒ`(%d)Ă܂B */
			ERROROUT3(FORMAT(442),argv[0],attr_old,attr);
			return ECL_SCRIPT_ERROR;
		}
		if (pInfoParm->pi_aux[0] && (attr_old==DEF_ZOK_CHAR || attr_old==DEF_ZOK_BULK)) {
			alsize = size = iParm[1];
			if (size > 0) {
				size_old = pInfoParm->pi_len;
				p = pInfoParm->pi_data;
				if (size > size_old) {
					if (attr == DEF_ZOK_CHAR) alsize++;
					else if (attr == DEF_ZOK_BULK) alsize += sizeof(int);
					if (!(p=Realloc(p,alsize))) return -1;
					pInfoParm->pi_paux = pInfoParm->pi_data = p;
					if (attr == DEF_ZOK_BULK) {
						memcpy(&len,p+size_old,sizeof(int));
						memcpy(p+size,&len,sizeof(int));
					}
				}
				else if (size < size_old) {
					if (attr == DEF_ZOK_BULK) {
						memcpy(&len,p+size_old,sizeof(int));
						len = X_MIN(size,len);
						memcpy(p+size,&len,sizeof(int));
					}
					else {
						*(p+size) = '\0';
						len = strlen(p);
					}
				}
				pInfoParm->pi_dlen = len;
			}
			pInfoParm->pi_len = size;
		}
	}
	else {
	 	if (!(opt & D_GX_OPT_SET_SCOPE) && proc) {
			if (!(giOptions[9] & 0x01) && (scrct->pFlag & D_SCRPT_NEW_LEX))
				opt |= D_GX_OPT_SET_LOCAL;
		}
		if ((iParmNo=_chk_define(scrct,proc,varnam,vnlen,opt,argv)) < 0) return iParmNo;
		iAux = (int)argv[2];
		if (iParmNo) {
			pTBL_vname = (tdtInfoParm ***)argv[1];
			if (!(opt & D_GX_OPT_SET_PUBLIC)) {
				iSet = 1;
				iNew = 1;	/* PUBLICłȂAredefinełȂƂ́AɎw̃f[^^ŏB */
			}
		}
		else {
			pha_vname  = (XHASHB *)argv[4];
			if ((iParmNo=cl_gx_chk_vnam('s',pha_vname,varnam,vnlen))<1){
					/* %s: %s%sGgp̋󂫂܂B */
				ERROROUT3(FORMAT(323),argv[0],varnam,argv[3]);
				return ECL_SCRIPT_ERROR;
			}
			pTBL_vname = (tdtInfoParm ***)argv[5];
			iSet = iNew = 1;
		}

		pInfoParm = cl_get_var_ent(pTBL_vname,iParmNo);

DEBUGOUTL4(111,"%s: iNew=%d iParmNo=%d pInfoParm=%08x",argv[0],iNew,iParmNo,pInfoParm);

		if (!pInfoParm) return ECL_SCRIPT_ERROR;

		if ((rc=cl_gx_clear_var_define(scrct,proc,varnam,opt)) < 0) return rc;

		if (iNew && ((c=pInfoParm->pi_id)==' ' || !c)) {
			if (c) info_parm_clear(pInfoParm);
			cl_set_parm_init(pInfoParm,iParm,0x01);
		}
	}

DEBUGOUT_InfoParm(160,"%s:",pInfoParm,argv[0],0);

	if (ppInfoParm) *ppInfoParm = pInfoParm;
/*
if (scrct) {
DEBUGOUTL3(111,"%s: ProCT=%08x Vary=%08x",argv[0],scrct->ProCT,scrct->Vary);
}
*/
	if (iSet) {
	/*	if ((atr=cmp_gtwd(&gwprm,&ssp)) > 0) {	*/
		if (cLET) {
			tLeaf.cmd.prmnum = 1;
			tLeaf.cmd.prmp = &pprmp[1];
			rc = let_compute_opt(&tLeaf,proc,iOpt);
/*
if (scrct) {
DEBUGOUTL3(111,"%s:after LET: ProCT=%08x Vary=%08x",argv[0],scrct->ProCT,scrct->Vary);
}
*/
/*
DEBUGOUT2("%s: bxobj=%08x",argv[0],pprmp[isp]->bxobj);
*/		}
	}
	if (iCONST) pInfoParm->pi_aux[1] |= D_AUX1_PROTECTED;
	return rc;

 Parm_Less:
	ERROROUT1(FORMAT(42),argv[0]);	/* %s: p[^܂B */
	return ECL_SCRIPT_ERROR;
}
#if 0
/************************************/
/*	cl_pr_ex_def_scalar_info		*/
/************************************/
int cl_pr_ex_def_scalar_info(prmnum, pprmp, scrct, proc, opt, ppInfoParm)
int      prmnum;
parmList **pprmp;
ScrPrCT  *scrct;
ProcCT  *proc;	/* defineR}ĥƂ́ANULL */
int      opt;	/* =0:`ς݂̂Ƃ́A̒lݒ肵Ȃ/!=0:ɐݒ肷 */
tdtInfoParm  **ppInfoParm;
{
	int  i, rc, iOpt, iCONST, n;
	int  iParm[4],check[4];
	char *p;

	check[0] = 2;
	check[1] = 0x03;
	if ((n=cl_get_def_modifier(prmnum,pprmp,check,iParm)) < 0) return n;
	else if (n > 0) {
		pprmp  += n;
		prmnum -= n;
		if (check[2] & 0x01) opt &= ~D_GX_OPT_SET_SCOPE;
		opt |= check[3];
	}
	return cl_pr_ex_def_scalar_attr_info(prmnum,pprmp,scrct,proc,opt,iParm,ppInfoParm);
}
#endif
#define PRT_19(x)
/************************************/
/*	cl_pr_ex_def_array              */
/************************************/
int cl_pr_ex_def_array(cmdobj,prmnum,pprmp,scrct,proc,opt)
CMDObject *cmdobj;
int      prmnum;
parmList **pprmp;
ScrPrCT  *scrct;
ProcCT   *proc;
int      opt;
{
	XHASHB *pha_vname,*xhp;
	tdtInfoParm ***pTBL_vname;
	int  i,iParmNo,rc,vnlen,n,len,id,iARRAY,iEQU,is,line_len,sp_save,pos;
	int  attr,size,nparm,attr_old;
	char c,*varnam,*prnam,*pp,*p,*p_old,*argv[7],*line,wrk[128],**da;
	tdtInfoParm *pInfoParm,tInfoParm,tInfoParm2[2],**ppParm,*pInfoParmW;
	tdtArrayIndex tIndex,*pIndex;
	int *index;
	int iParm[4],check[4],*obj,npr,iob,exec_flg,ipr,ida,ipr_pos,ida_nam;
	tdtObjHead *pObj;
	int iCONST,iOpt,iSET,iSKIP,iNAME_OPT,iGET_NAM,iREDEF,iSTATIC;
	Leaf tLeaf;
	SSPL_S ssp;
	parmList *qprmp[4];
	tdtObjHead *phObj;

	argv[0] = "cl_pr_ex_def_array";

	/* parameter check */
	if (prmnum < 1) goto Parm_Less;

	iSTATIC = iCONST = iOpt = iARRAY = iEQU = iSET = iSKIP = iParmNo = iNAME_OPT = iGET_NAM = 0;
	attr_old = attr = 0;
	size = sizeof(tdtInfoParm *);
	line = pprmp[0]->prp;
	line_len = pprmp[0]->prmlen;
/*
printf("%s: prmnum=%d line_len=%d line=[%s]\n",argv[0],prmnum,line_len,line);
*/
DEBUGOUTL4(170,"%s: prmnum=%d line_len=%d line=[%s]",argv[0],prmnum,line_len,line);
	memset(&ssp,0,sizeof(SSPL_S));

	exec_flg = 0;
	if (proc) pObj = proc->Obj;
	else pObj = scrct->Obj;
	if (cmdobj->nobj) goto Exobj;
	if (!(obj=cmdobj->exobj)) cl_im_expand(CLcList.mcat_obj,50,&obj);
	if (!(da=cmdobj->da)) cl_im_expand(CLcList.mcat_da,10,&da);
	npr = ida = 0;
	obj[0] = 0;	/* sub_id */
	obj[1] = 0;	/* npr */
	obj[2] = 3;	/* ipr_pos */
	iob = obj[2];

	/* ̎擾 */
	exec_flg = 1;
	npr++;
	obj[iob++] = 1;	/* hc̎擾 */
	ipr_pos = iob++;
	obj[iob++] = ida;	/* w莮 */
	da[ida] = NULL;
	check[1] = 0x0f;
	if ((n=cl_get_def_modifier_SSP(line,line_len,&ssp,gsep,check,iParm,&da[ida],pObj)) < 0) return n;
	else if (n > 0) {
		if (check[2]) {
			if (check[2] & 0x01) opt &= ~D_GX_OPT_SET_SCOPE;
			opt |= check[3];
			if (!proc && (opt & D_GX_OPT_SET_LOCAL)) {
				ERROROUT1(FORMAT(443),argv[0]);	/* %s: LOCAL͎wł܂B */
				return ECL_SCRIPT_ERROR;
			}
			if (opt & D_GX_OPT_SET_CONST) iCONST = D_AUX1_PROTECTED;
			if (opt & D_GX_OPT_SET_ARRAY) iARRAY = 1;
			if (opt & D_GX_OPT_SET_STATIC) iSTATIC = 1;
		}
		if (iParm[0] > 0) {
			attr = iParm[0];
			size = iParm[1];
		}
	}
	ida++;
	memcpy(&obj[iob],iParm,sizeof(int)*4);
	iob += 4;
	obj[iob++] = opt;
	obj[iob++] = iCONST;

	is = ssp.sp;
	obj[iob++] = is;
	/* ϐ̎擾(ł͕ϐǂݔ΂) */
	vnlen = akxtgwnsl(line,line_len,&ssp,gsep,0x41);
	if (vnlen <= 0) {
		ERROROUT1(FORMAT(435),argv[0]);	/* %s: ϐ܂B */
		return ECL_EX_DEFINE;
	}
	memnzcpy(wrk,ssp.wd,vnlen,sizeof(wrk)-1);
	varnam = wrk;
	if (*varnam == '(') iSKIP = 1;
	else {
		clpeeksl(line,line_len,&ssp,gsep,0x41);
		if (*ssp.wd == '(') {
			len = akxnskipin(varnam,vnlen,"$%#");
			if (len >= vnlen) iSKIP = 1;
		}
	}
	if (iSKIP) {
		ssp.sp = is;
		if (len=cl_skip_to_delm(line,line_len,"()",&ssp,gsep,0)) {
			ERROROUT1(FORMAT(433),argv[0]);	/* %s: JbRĂ܂B */
			return ECL_SCRIPT_ERROR;
		}
	}

	exec_flg = 2;
	npr++;
	obj[ipr_pos] = iob;
	obj[iob++] = 2;	/* hcz`擾̏ */
	ipr_pos = iob++;

	if (!(opt & D_GX_OPT_REDEFINE) && proc && !iARRAY && !iParm[0]) {
		clpeeksl(line,line_len,&ssp,gsep,0x41);
		if (*ssp.wd == '[') iARRAY = -1;	/* zvfƌȂ */
	}
	obj[iob++] = iARRAY;	/* z` */
	if (iARRAY >= 0) {
		/* z`̎擾 */
		n = cl_get_array_def_parm(line,line_len,"=",&ssp,gsep,3,qprmp,&iEQU);
		if (n < 0) return n;
		else if (n) iARRAY = 1;	/* z` */
		else {
			if (iARRAY) {
				if (proc) iARRAY = 2;	/* defineł͂ȂāAarray */
			}
			else iARRAY = -1;	/* arrayz`Ȃ==>ϐ̒`܂͎ */
		}
		if (iARRAY==2 && (iCONST || iParm[0]/* || (opt & D_GX_OPT_SET_SCOPE)*/)) iARRAY = 1;
		/* defineł͂ȂāAarrayAconstw肳Ă */
		/* ARRAY=1: zϐ̒` */
		/* ARRAY=2: zϐւ̃f[^ݒ */
		obj[iob++] = ida;	/* z` */
		obj[iob++] = n;
		obj[iob++] = iARRAY;
		obj[iob++] = iEQU;
		for (i=0;i<n;i++) {
			cl_im_parmcpy(D_OPT_ALC_LEAF,&da[ida++],qprmp[i]);
		}
		memcpy(qprmp,&da[ida-n],sizeof(parmList *)*n);
	}
/*
printf("%s: n=%d iARRAY=%d\n",argv[0],n,iARRAY);
*/
DEBUGOUTL3(170,"%s: n=%d iARRAY=%d",argv[0],n,iARRAY);
	if (iARRAY < 0) {
		obj[1] = npr;

if (DEBUGOUTCHECK(250)) {
for (i=0;i<iob;i++)
DEBUGOUTL2(250,"SCLR: obj[%d]=%d",i,obj[i]);
for (i=0;i<ida;i++)
DEBUGOUTL3(250,"SCLR: da[%d]=0x%08x[%s]",i,da[i],da[i]);
}
		cmdobj->nobj = iob;
		cmdobj->nda = ida;
		cmdobj->exobj = (int *)clmemdup(obj,iob*sizeof(int),0);
		cmdobj->da = (char **)clmemdup(da,ida*sizeof(char *),0);
		return cl_pr_ex_def_scalar_attr_info(is,pprmp,scrct,proc,opt,iParm,&pInfoParm);
	}

	/* ϐ̎擾 */
	exec_flg = 3;
	npr++;
	obj[ipr_pos] = iob;
	obj[iob++] = 3;	/* hcϐ擾̏ */
	ipr_pos = iob++;
/*
	memnzcpy(wrk,varnam,vnlen,sizeof(wrk)-1);
	varnam = wrk;
*/
	c = *varnam;
	obj[iob++] = ida;
	ida_nam = ida;
	da[ida++] = NULL;	/*clstrdup(varnam,0);*/
	/* z񖼂ɕϐw\Ƃ */
	obj[iob] = -1;
	da[ida] = NULL;
	if (iSKIP || c=='$') {
		ssp.sp = is;
	/*	da[ida] = NULL;	*/
		if ((len=_get_varname(line,line_len,&ssp,proc,&da[ida],&pp)) < 0) return len;
	/*	if ((len=_get_varname(line,line_len,&ssp,proc,&pprmp[0]->bxobj,&pp)) < 0) return len;	*/
		else if (len > 0) {
			varnam = pp;
			vnlen = len;
			c = *varnam;
		/*	obj[iob] = ida++;	*/
			obj[iob] = ida;
			iGET_NAM = 1;
		}
	}
/*	da[ida_nam] = clstrdup(varnam,0);	*/
	ida++;
	iob++;

	npr++;
	obj[ipr_pos] = iob;
	obj[iob++] = 4;	/* hcϐ`/Ē` */
	ipr_pos = iob++;
	npr++;
	obj[ipr_pos] = iob;
	obj[iob++] = 5;	/* hc */
	ipr_pos = iob++;
	npr++;
	obj[ipr_pos] = iob;
	obj[iob++] = 6;	/* hcCONST */
	ipr_pos = iob++;
	obj[1] = npr;

if (DEBUGOUTCHECK(250)) {
for (i=0;i<iob;i++)
DEBUGOUTL2(250,"ARRY: obj[%d]=%d",i,obj[i]);
for (i=0;i<ida;i++)
DEBUGOUTL3(250,"ARRY: da[%d]=0x%08x[%s]",i,da[i],da[i]);
}
	cmdobj->nobj = iob;
	cmdobj->nda = ida;
	cmdobj->exobj = (int *)clmemdup(obj,iob*sizeof(int),0);
	cmdobj->da = (char **)clmemdup(da,ida*sizeof(char *),0);

Exobj:
	obj = cmdobj->exobj;
	da = cmdobj->da;
	npr = obj[1];
	ipr_pos = obj[2];
DEBUGOUTL3(170,"%s: obj[1]=%d obj[2]=%d",argv[0],obj[1],obj[2]);
	while (npr-- > 0) {
		ipr = obj[ipr_pos];
		iob = ipr_pos + 2;
		ipr_pos = obj[ipr_pos+1];
/*
printf("%s: ipr=%d iob=%d ipr_pos=%d\n",argv[0],ipr,iob,ipr_pos);
*/
DEBUGOUTL4(170,"%s: ipr=%d iob=%d ipr_pos=%d",argv[0],ipr,iob,ipr_pos);
		if (ipr==1 && exec_flg<1) {	/* hc̎擾 */
			ida = obj[iob++];
			memcpy(iParm,&obj[iob],sizeof(int)*4);
			attr = iParm[0];
			size = iParm[1];
			iob += 4;
			if (rc=cl_get_def_attr_opt(NULL,0,iParm,opt,&da[ida],pObj)) return rc;
			opt = obj[iob++];
			iCONST = obj[iob++];
			is = obj[iob++];
		}
		else if (ipr==2 && exec_flg<2) {
			iARRAY = obj[iob++];	/* z` */
			if (iARRAY >= 0) {
				/* z`̎擾 */
				ida = obj[iob++];	/* z` */
				n = obj[iob++];
				memcpy(qprmp,&da[ida],sizeof(parmList *)*n);
				iARRAY = obj[iob++];
				iEQU = obj[iob++];
			}
			if (iARRAY < 0) {
				return cl_pr_ex_def_scalar_attr_info(is,pprmp,scrct,proc,opt,iParm,&pInfoParm);
			}
		}
		else if (ipr == 3) {
			ida_nam = obj[iob++];
			if (exec_flg < 3) {
				varnam = da[ida_nam];
				vnlen = strlen(varnam);
/*
printf("%s: vnlen=%d varnam=[%s]\n",argv[0],vnlen,varnam);
*/
				c = '\0';
				if ((ida=obj[iob++]) >= 0) {
					if ((len=_get_varname(NULL,0,NULL,proc,&da[ida],&pp)) < 0) return len;
					else if (len > 0) {
						varnam = pp;
						vnlen = len;
						c = *varnam;
					}
					iGET_NAM = 1;
				}
			}
			if (c) {

PRT_19(printf("%s: vnlen=%d varnam=[%s]\n",argv[0],vnlen,varnam);)

				/*if (opt & D_GX_OPT_REDEFINE) */iNAME_OPT = 1;
				if (c=='$') {
					vnlen--;
					varnam++;
				}
				if (c=='%' || c=='#') {
					ERROROUT2(FORMAT(436),argv[0],varnam);	/* %s: ϐ(%s)Ă܂B */
					return ECL_SCRIPT_ERROR;
				}
				else if (rc=cl_def_chk_name_opt(varnam,vnlen,argv[0],FORMAT(441),opt & D_GX_OPT_REDEFINE)) return rc;
				if (iGET_NAM) p = "";
				else p = varnam;
				da[ida_nam] = clstrdup(p,0);
DEBUGOUTL3(170,"%s: ida_nam=%d da[ida_nam]=[%s]",argv[0],ida_nam,da[ida_nam]);
			}
DEBUGOUTL3(170,"%s: vnlen=%d varnam=[%s]",argv[0],vnlen,varnam);
		}
		else if (ipr == 4) {

 	if ((iARRAY==1) && !(opt & D_GX_OPT_SET_SCOPE)) {
		if (proc) {
			if (!(giOptions[9] & 0x01) && (scrct->pFlag & D_SCRPT_NEW_LEX))
				opt |= D_GX_OPT_SET_LOCAL;
			else opt |= D_GX_OPT_SET_PRIVATE;
		}
		else opt |= D_GX_OPT_SET_PRIVATE;
	}

	if (iARRAY == 1) opt |= D_GX_OPT_SET_ARRAY;
	else opt &= ~D_GX_OPT_SET_ARRAY;

	if (opt & D_GX_OPT_REDEFINE) {
		if (rc=_check_redefine(varnam,vnlen,&pInfoParm,'R',"cl_pr_ex_def_array")) return rc;
		pIndex = (tdtArrayIndex *)pInfoParm->pi_data;
	/*	attr_old = pInfoParm->pi_attr;	*/
		attr_old = pIndex->uAttr[0];
		if (!attr) {
			attr = attr_old;
			size = pIndex->size;
		}
	}
	else {
		if (!attr) attr = DEF_ZOK_VARI;
		len = akxnskipto(varnam,vnlen,".");
		if (iARRAY==1 && (len<vnlen)) {
			/* %s: STRUCT̃o[%s]͎wł܂B */
			ERROROUT2(FORMAT(444),argv[0],varnam);
			return ECL_SCRIPT_ERROR;
		}
		if ((iParmNo=_chk_define(scrct,proc,varnam,len,opt,argv)) < 0) return iParmNo;
		if (iARRAY==2 && !iParmNo) {
			ERROROUT2(FORMAT(438),argv[0],varnam);	/* %s: [%s]͖`łB */
			return ECL_SCRIPT_ERROR;
		}
/*
printf("%s: iParmNo=%d\n",argv[0],iParmNo);
*/
DEBUGOUTL2(170,"%s: iParmNo=%d",argv[0],iParmNo);
	}
	
#if 0
	if (size <= 0) {
		ERROROUT2(FORMAT(454),argv[0],size);
		return ECL_SCRIPT_ERROR;
	}
#endif
	iParm[0] = attr;
	iParm[1] = size;
	if (!iParmNo && iARRAY==1) {
		if (rc=_def_array(n,&qprmp[0],opt,iParm,&tIndex,attr_old,pIndex)) return rc;
/*
printf("%s: qprmp[0]=%08x qprmp[0]->bxobj=%08x\n",argv[0],qprmp[0],qprmp[0]->bxobj);
*/
DEBUGOUTL3(170,"%s: qprmp[0]=%08x qprmp[0]->bxobj=%08x",argv[0],qprmp[0],qprmp[0]->bxobj);
	}

	if (opt & D_GX_OPT_REDEFINE) {
		if (iARRAY == 1) {
			memcpy(pInfoParm->pi_data,&tIndex,sizeof(tdtArrayIndex));
		}
		iSET = 1;
	}
	else {
		if (iParmNo > 0) {
			pTBL_vname = (tdtInfoParm ***)argv[1];
			pInfoParm = cl_get_var_ent(pTBL_vname,iParmNo);
			if (iARRAY == 2) {
				if (pInfoParm->pi_id=='T') {
					if (++len < vnlen) {
						if (rc=_ex_get_member(&pInfoParm,opt,varnam+len,vnlen-len)) return rc;
					}
				}
				if ((c=pInfoParm->pi_id)!='R' && c!='A') {
					/* %s: [%s]͔zł͂܂B */
					ERROROUT2(FORMAT(445),argv[0],varnam);
					return ECL_SCRIPT_ERROR;
				}
				iSET = 1;
			}
			else {
				if (rc=_chk_array(n,&qprmp[0],iParm,iCONST,pInfoParm)) return rc;
			}
		}
		else {
			iSET = 1;
			pha_vname  = (XHASHB *)argv[4];
			if ((iParmNo=cl_gx_chk_vnam('s',pha_vname,varnam,vnlen)) < 1) {
					/* %s: %s%sGgp̋󂫂܂B */
				ERROROUT3(FORMAT(323),argv[0],varnam,argv[3]);
				goto Error;
			}
			pTBL_vname = (tdtInfoParm ***)argv[5];
			pInfoParm = cl_get_var_ent(pTBL_vname,iParmNo);
/*
printf("cl_pr_ex_def_array: pha_vname=%08x pTBL_vname=%08x pInfoParm=%08x\n",pha_vname,pTBL_vname,pInfoParm);
*/
DEBUGOUTL3(170,"cl_pr_ex_def_array: pha_vname=%08x pTBL_vname=%08x pInfoParm=%08x",pha_vname,pTBL_vname,pInfoParm);
			if (!pInfoParm) return ECL_SCRIPT_ERROR;
			info_parm_clear(pInfoParm);
			pInfoParm->pi_id   = 'R';
			pInfoParm->pi_scale = D_DATA_MALLOC | D_DATA_INDEX_FREE;
			pInfoParm->pi_attr = DEF_ZOK_BULK;	/* attr;	*/
			pInfoParm->pi_dlen  = sizeof(tdtArrayIndex);
			if (!(pInfoParm->pi_data = Malloc(sizeof(tdtArrayIndex)))) return -1;
			memcpy(pInfoParm->pi_data,&tIndex,sizeof(tdtArrayIndex));
			if (!(p=Malloc(vnlen+1))) {
				ERROROUT1("%s: Array name area malloc",argv[0]);
				goto Error;
			}
			strnzcpy(p,varnam,vnlen);
			pInfoParm->pi_pos = (long)p;
			if (opt & D_GX_OPT_SET_LOCAL) pInfoParm->pi_hlen = proc->ProcGid;
			else if (!(opt & D_GX_OPT_SET_PUBLIC)) pInfoParm->pi_hlen = scrct->ScrGid;
			pInfoParm->pi_paux = (char *)pInfoParm;	/* Rs[ꂽƂɁA̔z񂪗L`FbN邽߂ɕۑ */

			if ((rc=cl_gx_clear_var_define(scrct,proc,p,opt)) < 0) return rc;
		}
DEBUGOUT_InfoParm(194,"cl_pr_ex_def_array: attr=%d size=%d",pInfoParm,attr,size);
	}

		}
		else if (ipr == 5) {

	if (iSET && iEQU) {
/*
printf("cl_pr_ex_def_array: iARRAY=%d is=%d prmnum=%d\n",iARRAY,is,prmnum);
*/
		pprmp[1]->prp = line + iEQU;
		pprmp[1]->prmlen = line_len - iEQU;
		if (proc) phObj = proc->Obj;
		else phObj = scrct->Obj;
/*
printf("cl_pr_ex_def_array: proc=%08x scrct=%08x phObj=%08x\n",proc,scrct,phObj);
*/
		if (rc = _set_array_values(pInfoParm,1,&pprmp[1],phObj)) return rc;
	}

		}
		else if (ipr == 6) {

	if (iCONST) pInfoParm->pi_aux[1] |= D_AUX1_PROTECTED;

		}
		else if (ipr == 7) {	/* pInfoParmԂ */
			ida = obj[iob];
			da[ida] = (char *)pInfoParm;
		}
	}
	return 0;

 Parm_Less:
	ERROROUT1(FORMAT(42),argv[0]);	/* %s: p[^܂B */
	return ECL_SCRIPT_ERROR;
 Error:
 	if (tIndex.xhp) akxs_xhash_free(tIndex.xhp);
 	if (tIndex.pVarIndex) Free(tIndex.pVarIndex);
	return ECL_SCRIPT_ERROR;
}

/************************************/
/* cl_pr_ex_un_define				*/
/************************************/
int cl_pr_ex_un_define(leaf, proc)
Leaf    *leaf;
ProcCT  *proc;
{
	static char *_name_="cl_pr_ex_un_define";
	XHASHB *pha_vname;
	int  i, j, rc, vnlen, n, *pSize, ixlen, iHASHED_NAME, opt, scope;
	char c, *varnam, *p, *ixnam, buf[64];
	tdtInfoParm *pInfoParm,tInfoParm;
	tdtArrayIndex tIndex,*pIndex;
	int *index;
	tdtInfoParm ***pTBL_vname,***pTBL_pas;
	uchar ucLOCAL=0;
	ScrPrCT *scrct;
	parmList **pprmp;
	Leaf *topleaf,*curleaf;

	if (!leaf || !proc) return ECL_SYSTEM_ERROR;
	if (!(scrct = cl_search_src_ct())) return ECL_SYSTEM_ERROR;

	n = leaf->cmd.prmnum;
	pprmp = leaf->cmd.prmp;
	for (i=0;i<n;i++) {
		varnam = pprmp[i]->prp;
		if (rc=cl_gx_exp_obj_opt(1,&pprmp[i],proc->Obj,&tInfoParm,D_GX_OPT_GET_ADDR)) {
			ERROROUT2(FORMAT(125),_name_,varnam);	/* %s: [%s]Ă܂B */
			return ECL_SCRIPT_ERROR;
		}
DEBUGOUT_InfoParm(110,"%s: get rc=%d",&tInfoParm,_name_,rc);
		if ((c=tInfoParm.pi_id) != D_DATA_ID_STOREVAR) {
			ERROROUT2(FORMAT(446),_name_,varnam);	/* %s: %sUNDEFINEł܂B */
			return ECL_SCRIPT_ERROR;
		}
		pInfoParm = (tdtInfoParm *)tInfoParm.pi_pos;
		if ((tInfoParm.pi_aux[1] & D_AUX1_PROTECTED) ||
		    (pInfoParm->pi_aux[1] & D_AUX1_PROTECTED)) {
			ERROROUT2(FORMAT(446),_name_,varnam);	/* %s: %sUNDEFINEł܂B */
			return ECL_SCRIPT_ERROR;
		}
		vnlen = pprmp[i]->prmlen;
		opt = pInfoParm->pi_aux[1];
		if (opt & D_AUX1_HASHED_NAME) {
/*
printf("%s: opt=%08x\n",_name_,opt);
*/
			if (opt & D_AUX1_PUBLIC_VAR) {
				pha_vname = pCLprocTable->pha_vnam;
				scope = D_AUX1_PUBLIC_VAR;
			}
			else if (opt & D_AUX1_LOCAL_VAR) {
				pha_vname = proc->pha_vnam;
				scope = D_AUX1_PUBLIC_VAR | D_AUX1_PRIVATE_VAR | D_AUX1_LOCAL_VAR;
			}
			else {
				pha_vname = scrct->Vary->pha_vnam;
				scope = D_AUX1_PUBLIC_VAR | D_AUX1_PRIVATE_VAR;
			}
			if (pha_vname) {
				c = pInfoParm->pi_id;
				if (c=='R' || c=='A' || c=='T' || c=='P'/* || c=='L'*/) {
					varnam = (char *)pInfoParm->pi_pos;
					vnlen = strlen(varnam);
				}
				else if (*varnam == '$') {
					varnam++;
					vnlen--;
				}
				rc = cl_gx_chk_vnam('d',pha_vname,varnam,vnlen);
/*
printf("%s: delete name=[%s] ix=%d\n",_name_,varnam,rc);
*/
				if (rc > 0) {
					if ((c=*varnam)!='$' && c!='%' && c!='#') {
						p = buf;
						*buf = '$';
						memnzcpy(buf+1,varnam,vnlen,sizeof(buf)-1);
					}
					else p = varnam;
					if ((scope & D_AUX1_LOCAL_VAR) && pInfoParm->pi_id==' ') {
						topleaf = proc->ProcTop->leftleaf;
						curleaf = NULL;
					}
					else {
						topleaf = scrct->TreeTop;
						curleaf = leaf;
					}
					if ((rc=cl_gx_clear_var_obj(topleaf,curleaf,p,proc->Obj,scope)) < 0) return rc;
				}
			}
		}
		cl_free_info_parm(pInfoParm);
DEBUGOUT_InfoParm(110,"%s: FreeInfo",pInfoParm,_name_,0);
	}
	return 0;
}

/************************************/
/* _def_array                       */
/************************************/
int _def_array(prmnum, pprmp, opt, iParm, ptIndex, attr_old, pIndex)
int      prmnum;
parmList **pprmp;
int      opt,iParm[],attr_old;
tdtArrayIndex *ptIndex,*pIndex;
{
	static char *_fn_="cl_pr_ex_def_array";
	int  i,rc,n,len,id,attr,size,iHASH,prmnum0,iParmW[2];
	int  n_old,na,na_old,alsize,size_old,alsize_old,size_min;
	char c,*pp,*p,*p_old;;
	int *index;

	if (prmnum < 0) return 0;
	else if (!pprmp) return -1;

	prmnum0 = prmnum;
	attr = iParm[0];
	size = iParm[1];
/*
printf("prmnum=%d attr=%d size=%d\n",prmnum,attr,size);
*/
	if (opt & D_GX_OPT_REDEFINE) {
		if (!attr_old || !pIndex) return -2;
		else if (attr_old != attr) {
			/* %s: ̑(%d)ƍĒ`(%d)Ă܂B */
			ERROROUT3(FORMAT(442),_fn_,attr_old,attr);
			return ECL_SCRIPT_ERROR;
		}
		size_old = pIndex->size;
		index = pIndex->index;
		n_old = index[1]*index[2]*index[3];
printf("attr=%d size=%d attr_old=%d size_old=%d\n",attr,size,attr_old,size_old);
	}

	memset(ptIndex,0,sizeof(tdtArrayIndex));
	index = ptIndex->index;
	for (i=0;i<=MAX_ARRAY_DIM;i++) index[i] = 1;
	index[1] = 10;

	if (prmnum>0 && !stricmp(pprmp[0]->prp,"HASH")) {
		if (opt & D_GX_OPT_REDEFINE) {
			ERROROUT1(FORMAT(447),_fn_);	/* %s: HASHw͍Ē`ł܂B */
			return ECL_SCRIPT_ERROR;
		}
		index[MAX_ARRAY_DIM+1] = 0x80;
		iHASH = 1;
		pprmp++;
		prmnum--;
		if (prmnum > 1) goto Parm_More;
	}
	else iHASH = 0;
	if (prmnum > 0) {
		if (rc = _set_index(1,prmnum,pprmp,0,index,"_def_array: ")) return rc;
	}
	n = index[1]*index[2]*index[3];
	if (n < 0) {
		/* %s: ͈͎w([%d,%d,%d])z̍ő(%d)𒴂Ă܂B */
		ERROROUT5(FORMAT(448),_fn_,index[1],index[2],index[3],INT_MAX);
		return ECL_SCRIPT_ERROR;
	}
/*
printf("_def_array: %d[%d,%d,%d]\n",index[0],index[1],index[2],index[3]);
*/
	if (iHASH) {
		if (!(opt & D_GX_OPT_NOALLOC_INDX)) {
			if (!(ptIndex->xhp=akxs_xhash_new2(0,index[1],0,sizeof(tdtInfoParm *)))) return -9;
		}
	}
	else if (size_old==size && n==n_old) {
		ptIndex->pVarIndex = pIndex->pVarIndex;
	}
	else {
		if ((opt & D_GX_OPT_REDEFINE) &&
		    ((!size_old && size) || (size_old && !size))) {
			_redefine_size_zero(attr,size,n,size_old,n_old,ptIndex,pIndex);
		}
		else {
#if 1
			iParmW[0] = attr;
			iParmW[1] = size;
			if ((alsize=cl_get_def_alsize(iParmW)) < 0) return alsize;
#else
		  if (!size && (attr==DEF_ZOK_CHAR || attr==DEF_ZOK_BULK)) {
			attr = DEF_ZOK_VARI;
			size = sizeof(tdtInfoParm *);
		  }
		  alsize = size;
		  if (attr == DEF_ZOK_CHAR) alsize++;
		  else if (attr == DEF_ZOK_BULK) alsize += sizeof(int);
#endif
		  na = n*alsize;
		  if (na < 0) {
			/* %s: zf[^悪ől(%d)𒴂Ă܂B */
			ERROROUT4(FORMAT(456),_fn_,n,alsize,INT_MAX);
			return ECL_SCRIPT_ERROR;
		  }
		  if (opt & D_GX_OPT_REDEFINE) {
#if 1
			iParmW[0] = attr;
			iParmW[1] = size_old;
			if ((alsize_old=cl_get_def_alsize(iParmW)) < 0) return alsize_old;
#else
			alsize_old = size_old;
			if (attr == DEF_ZOK_CHAR) alsize_old++;
			else if (attr == DEF_ZOK_BULK) alsize_old += sizeof(int);
#endif
			na_old = n_old*alsize_old;
			if (!(pp=Malloc(na))) {
				/* "%s: %spMallocG[B */
				ERROROUT2(FORMAT(321),_fn_,FORMAT(586));	/*  zf[^ */
				return -11;
			}
			p_old = (char *)pIndex->pVarIndex;
			if ((attr==DEF_ZOK_CHAR || attr==DEF_ZOK_BULK) && size_old!=size) {
				p = pp;
				size_min = X_MIN(size,size_old);
				for (i=0;i<X_MIN(n,n_old);i++) {
					if (attr == DEF_ZOK_CHAR) strnzcpy(p,p_old,size_min);
					else if (attr == DEF_ZOK_BULK) {
						memcpy(&len,p_old+size_old,sizeof(int));
						memcpy(p,p_old,size_min);
						len = X_MIN(len,size);
						memcpy(p+size,&len,sizeof(int));
					}
					p += alsize;
					p_old += alsize_old;
				}
			}
			else memcpy(pp,p_old,X_MIN(na,na_old));
			if (na > na_old) memset(pp+na_old,0,na-na_old);
			ptIndex->pVarIndex=(tdtInfoParm **)pp;
			Free(pIndex->pVarIndex);
		  }
		  else if (!(opt & D_GX_OPT_NOALLOC_INDX)) {
			if (!(ptIndex->pVarIndex=(tdtInfoParm **)Malloc(na))) return -10;
			memset(ptIndex->pVarIndex,0,na);
		  }
		}
	}
	ptIndex->uAttr[0] = iParm[0];
	ptIndex->uAttr[2] = iParm[2];
	ptIndex->uAttr[3] = iParm[3];
	ptIndex->size = iParm[1];

	return 0;

 Parm_More:
 	/* "%s: ]ȃp[^(nparm=%d)܂B */
	ERROROUT2(FORMAT(267),_fn_,prmnum0);
	return ECL_SCRIPT_ERROR;
}

/************************************/
/* _chk_array                       */
/************************************/
static int _chk_array(prmnum,pprmp,iParm,iCONST,pInfoParm)
int      prmnum;
parmList **pprmp;
int      iParm[],iCONST;
tdtInfoParm *pInfoParm;
{
	static char *_fn_="_chk_array";
	tdtArrayIndex tIndex,*pIndex;
	int  i,rc,n,len,id,attr,size,iHASH;
	int  attr_old,size_old,iCONST_old;
	int *index;

	if (prmnum < 0) return 0;
	else if (!pprmp) return -1;

	attr = iParm[0];
	size = iParm[1];
	memset(&tIndex,0,sizeof(tdtArrayIndex));
	index = tIndex.index;
	for (i=0;i<=MAX_ARRAY_DIM;i++) index[i] = 1;
	index[1] = 10;

	if (prmnum>0 && !stricmp(pprmp[0]->prp,"HASH")) {
		iHASH = 1;
		pprmp++;
		prmnum--;
		if (prmnum > 1) {
		 	/* "%s: ]ȃp[^(nparm=%d)܂B */
			ERROROUT2(FORMAT(267),_fn_,prmnum);
			return ECL_SCRIPT_ERROR;
		}
	}
	else iHASH = 0;
	if (prmnum > 0) {
		if (rc = _set_index(1,prmnum,pprmp,0,index,"_chk_array: ")) return rc;
	}
	n = index[1]*index[2]*index[3];
	if (n < 0) {
		/* %s: ͈͎w([%d,%d,%d])z̍ő(%d)𒴂Ă܂B */
		ERROROUT5(FORMAT(448),_fn_,index[1],index[2],index[3],INT_MAX);
		return ECL_SCRIPT_ERROR;
	}
	pIndex = (tdtArrayIndex *)pInfoParm->pi_data;
	attr_old = pIndex->uAttr[0];
	rc = 0;
	iCONST_old = pInfoParm->pi_aux[1] & D_AUX1_PROTECTED;
	if ((iCONST && !iCONST_old) || (!iCONST && iCONST_old)) {
		/* %s: 萔`قȂĂ܂Bold=%d new=%d */
		ERROROUT3(FORMAT(449),_fn_,iCONST_old,iCONST);
		rc |= 1;
	}
	if (attr_old != iParm[0]) {
		/* %s: f[^^قȂĂ܂Bold=%d new=%d */
		ERROROUT3(FORMAT(450),_fn_,attr_old,iParm[0]);
		rc |= 2;
	}
	if (pIndex->size != size) {
		/* %s: قȂĂ܂Bold=%d new=%d */
		ERROROUT3(FORMAT(451),_fn_,pIndex->size,size);
		rc |= 4;
	}
	for (i=1;i<=MAX_ARRAY_DIM;i++) {
		if (pIndex->index[i] != index[i]) {
			/* %s: %dڂقȂĂ܂Bold=%d new=%d */
			ERROROUT4(FORMAT(452),_fn_,i,pIndex->index[i],index[i]);
			rc |= 8;
		}
	}
	if (rc) rc = -1;
	return rc;
}

/************************************/
/* cl_pr_ex_dim						*/
/************************************/
int cl_pr_ex_dim(leaf, scrct, proc, opt)
Leaf    *leaf;
ScrPrCT *scrct;
ProcCT  *proc;
int     opt;
{
	return cl_pr_ex_def_var(leaf->cmd.prmnum,leaf->cmd.prmp,scrct,proc,opt);
}

/************************************/
/* _redefine_size_zero				*/
/************************************/
int _redefine_size_zero(attr,size0,n,size0_old,n_old,pIndex,pIndex_old)
int attr,size0,n,size0_old,n_old;
tdtArrayIndex *pIndex,*pIndex_old;
{
	static char *_fn_="_redefine_size_zero";
	int  i,len,na,na_old,alsize,size_old,alsize_old,size_min,m;
	char *p,*pp,*p_old,*p1;
	tdtInfoParm **ppParm,*pInfoParm;
/*
printf("%s: attr=%d size0=%d n=%d size0_old=%d n_old=%d\n",_fn_,attr,size0,n,size0_old,n_old);
*/
	alsize = size0 ? size0 : size0_old;
	if (attr == DEF_ZOK_CHAR) alsize++;
	else if (attr == DEF_ZOK_BULK) alsize += sizeof(int);
	if (size0) {
		m = alsize;
		na_old = n_old*sizeof(tdtInfoParm *);
	}
	else {
		m = sizeof(tdtInfoParm *);
		na_old = alsize*n_old;
	}
	na = n*m;
/*
printf("%s: alsize=%d m=%d na_old=%d na=%d\n",_fn_,alsize,m,na_old,na);
*/
	if (na < 0) {
		/* %s: zf[^悪ől(%d)𒴂Ă܂B */
		ERROROUT4(FORMAT(456),_fn_,na,alsize,INT_MAX);
		return ECL_SCRIPT_ERROR;
	}
	if (!(pp=Malloc(na))) {
		/* "%s: %spMallocG[B */
		ERROROUT2(FORMAT(321),_fn_,FORMAT(586));	/* zf[^ */
		return -11;
	}
	if (size0) {
		p = pp;
		ppParm = pIndex_old->pVarIndex;
		for (i=0;i<X_MIN(n,n_old);i++) {
			if (pInfoParm=ppParm[i]) {
				p_old = pInfoParm->pi_data;
				size_old = pInfoParm->pi_dlen;
				size_min = X_MIN(size0,size_old);
/*
printf("%s: size_old=%d size_min=%d na=%d\n",_fn_,size_old,size_min);
*/
				if (attr == DEF_ZOK_CHAR) memzcpy(p,p_old,size_min);
				else if (attr == DEF_ZOK_BULK) {
					memcpy(&len,p_old+size_old,sizeof(int));
					memcpy(p,p_old,size_min);
					len = X_MIN(len,size0);
/*
printf("%s: len=%d\n",_fn_,len);
*/
					memcpy(p+size0,&len,sizeof(int));
				}
				else return -1;
			}
			else {
				if (attr == DEF_ZOK_CHAR) *p = '\0';
				else if (attr == DEF_ZOK_BULK) memset(p,0,alsize);
			}
			p += alsize;
		}
	}
	else {
		p = (char *)pIndex_old->pVarIndex;
		ppParm = (tdtInfoParm **)pp;
		for (i=0;i<X_MIN(n,n_old);i++) {
			if (attr == DEF_ZOK_CHAR) len = strlen(p);
			else if (attr == DEF_ZOK_BULK) memcpy(&len,p+size0_old,sizeof(int));
/*
printf("%s: len=%d\n",_fn_,len);
*/
			if (len > 0) {
				if (!(pInfoParm=(tdtInfoParm *)Malloc(sizeof(tdtInfoParm)))) {
					/* "%s: %spMallocG[B */ /* zf[^\ */
					ERROROUT2(FORMAT(321),_fn_,FORMAT(587));
					return -11;
				}
				ppParm[i] = pInfoParm;
				if (attr == DEF_ZOK_CHAR) {
					if (!(p1=Malloc(len+1))) return -11;
					memzcpy(p1,p,len);
				}
				else if (attr == DEF_ZOK_BULK) {
					if (!(p1=Malloc(len+sizeof(int)))) return -11;
					memzcpy(p1,p,len);
					memcpy(p1+len,&len,sizeof(int));
				}
				else return -1;
				cl_set_parm_char(pInfoParm,p1,len);
				pInfoParm->pi_attr = attr;
				pInfoParm->pi_len = 0;
				pInfoParm->pi_aux[0] = attr;
				pInfoParm->pi_paux = pInfoParm->pi_data;
			}
			else ppParm[i] = NULL;
			p += alsize;
		}
	}
	if (n > n_old) {
		i = m*n_old;
		memset(pp+i,0,na-i);
	}
	pIndex->pVarIndex=(tdtInfoParm **)pp;
	Free(pIndex_old->pVarIndex);
	return 0;
}

/************************************/
/* cl_get_def_alsize				*/
/************************************/
int cl_get_def_alsize(iParmW)
int iParmW[];
{
	int size,attr,alsize;

	attr = iParmW[0];
	size = iParmW[1];
	if (size) {
		alsize = size;
		if (attr == DEF_ZOK_CHAR) alsize++;
		else if (attr == DEF_ZOK_BULK) alsize += sizeof(int);
	}
	else {
		if (attr==DEF_ZOK_CHAR || attr==DEF_ZOK_BULK) {
			attr = DEF_ZOK_VARI;
			size = sizeof(tdtInfoParm);
			alsize = size;
		}
		else return -1;
	}
	iParmW[0] = attr;
	iParmW[1] = size;
	return alsize;
}
