/*		mpav.c		Multiple-Precision Arithmetic	*/
/*
	cc -g -DLINUX -I../include testmpav.c akxcom.a -o testmpav
*/
#include	"akxcommon.h"

int main(void)
{
	MPAV v, w, x, y, z, zz, x3;
	int k,rc;
	int i = 0;
	time_t now;
	double d;
	char buf[40];

	printf("mv_set_a()   -00.08050 --> v\n");
	mv_set_a(&v,"-00.08050");	mv_print("v = ", &v, 1);

	mv_dset(&d,&v);
	printf("mv_dset()    v --> %f\n",d);
	
	mv_mpa2an(&v,buf,sizeof(buf),0);
	printf("mv_mpa2an()    v --> %s\n",buf);
	
	printf("mv_set_a()   0.19 --> w\n");
	mv_set_a(&w,"0.19");	mv_print("w = ", &w, 1);

	printf("mv_set_a()   2.0 --> x\n");
	mv_set_a(&x,"2.0");	mv_print("x = ", &x, 1);

	printf("mv_set_a()   3.0 --> x3\n");
	mv_set_a(&x3,"3.0");	mv_print("x3 = ", &x3, 1);

	printf("mv_set_a()   0.11 --> y\n");
	mv_set_a(&y,"0.11");	mv_print("y = ", &y, 1);

	printf("mv_add()     w(0.19)+y(0.11) --> z(0.3)\n");
	mv_add(&z, &w, &y);	mv_print("z = w + y = ", &z, 1);

	printf("mv_add()     x(2.0)+y(0.11) --> z(2.11)\n");
	mv_add(&z, &x, &y);	mv_print("z = x + y = ", &z, 1);

	printf("mv_sub()     x(2.0)-y(0.11) --> z(1.89)\n");
	mv_sub(&z, &x, &y);	mv_print("z = x - y = ", &z, 1);

	printf("mv_sub()     w(0.19)-y(0.11) --> z(0.08)\n");
	mv_sub(&z, &w, &y);	mv_print("z = w - y = ", &z, 1);

	printf("mv_sub()     x(2.0)-z(0.08) --> zz(1.92)\n");
	mv_sub(&zz, &x, &z);	mv_print("zz = x - z = ", &zz, 1);

	printf("mv_add1()    z(0.08)+x(2.0) --> z(2.08)\n");
	mv_add1(&z, &x);		mv_print("z = z + x = ", &z, 1);

	printf("mv_sub1()    z(2.08)-x(2.0) --> z(0.08)\n");
	mv_sub1(&z, &x);		mv_print("z = z - x = ", &z, 1);

	printf("mv_mul()     x(2.0)*y(0.11) --> z(0.22)\n");
	mv_mul(&z, &x, &y);	mv_print("z = x * y = ", &z, 1);

	printf("mv_mul()     v(-0.0805)*x(2.0) --> z(-0.161)\n");
	mv_mul(&z, &v, &x);	mv_print("z = v * x = ", &z, 1);

	printf("mv_mul1()    z(-0.161)*x(2.0) --> z(-0.322)\n");
	mv_mul1(&z, &x);		mv_print("z = z * x = ", &z, 1);

	printf("mv_div()    y(0.11)/x(0.2) --> z(0.055)\n");
	mv_div(&z, &y, &x);	mv_print("z = y / x = ", &z, 1);

	printf("mv_div()    1/3 --> z(0.3333333...)\n");
	mv_div(&z, mv_get_i(1), &x3);	mv_print("z = 1 / 3 = ", &z, 1);

	printf("mv_div()    x(2.0)/y(0.11) --> z(18.181818...)\n");
	mv_div(&z, &x, &y);	mv_print("z = x / y = ", &z, 1);

	printf("mv_div1()    (2.0)x/y(0.11) --> x(18.181818...)\n");
	mv_div1(&x, &y);		mv_print("x = x / y = ", &x, 1);

	printf("mv_div1()    y(0.11)/x(18.181818...) --> y(0.00605000000...)\n");
	rc=mv_div1(&y, &x);	printf("rc=%d\n",rc);	mv_print("y = y / x = ", &y, 1);

	printf("mv_set_a()   19.0 --> x\n");
	mv_set_a(&x,"19.0");	mv_print("x = ", &x, 1);

	printf("mv_add1()    x+1 --> x(20.0)\n");
	mv_add1(&x, mv_get_i(1));		mv_print("x = x + 1 = ", &x, 1);
#if 0
	printf("mv_div1_s()  x/2 --> x\n");
	mv_div1_s(&x, 2);	mv_print("x = x / 2 = ", x, 1);

	printf("mv_div1_s()  y/-3 --> y\n");
	mv_div1_s(&y, -3);	mv_print("y = y / -3 = ", y, 1);

	printf("mv_set_a()   1.2 --> z\n");
	z = mv_set_a("1.2");	mv_print("z = ", z, 1);

	printf("mv_inv()     1/z --> z\n");
	z = mv_inv(z);		mv_print("z = 1 / z = ", z, 1);
#endif
#if 0
	printf("mv_sqrt()    sqrt(x) --> z\n");
	z = mv_sqrt(x);		mv_print("z = sqrt(x) = ", z, 1);

	printf("mv_sqr()     sqr(z) --> x\n");
	x = mv_sqr(z);		mv_print("x = z * z = ", x, 1);

	printf("mv_pwr_s()   x^3 --> z\n");
	z = mv_pwr_s(x, 3L);	mv_print("z = x ^ 3 = ", z, 1);

	printf("mv_kaijo()   10! --> x\n");
	x = mv_kaijo(10);	mv_print("x = 10! = ", x, 1);

	printf("mv_iset_s()  x --> (long)\n");
						printf("x = 10! = %ld\n", mv_iset_s(x));

	printf("mv_kaijo()   15! --> y\n");
	y = mv_kaijo(15);	mv_print("y = 15! = ", y, 1);

	printf("mv_gcd()     gcd(x,y) --> z\n");
	z = mv_gcd(x, y);	mv_print("z = gcd(x, y) = ", z, 1);

	printf("mv_lcm()     lcm(x,y) --> z\n");
	z = mv_lcm(x, y);	mv_print("z = lcm(x, y) = ", z, 1);

	printf("mv_cmp() exec.\n");
	printf("(x : y) = %d    (y : z) = %d    (z : x) = %d\n",
		mv_cmp(x, y), mv_cmp(y, z), mv_cmp(z, x)); 

	printf("mv_iset(x)   x,y,z --> (double)\n");
	printf("x = %e, y = %e, z = %e\n", mv_iset(x), mv_iset(y), mv_iset(z));

	mv_print("pi()=", pi(), 0);
	mv_print("_PI = ", _PI, 0);

	mv_print("e()=", e(), 0);
	mv_print("_E =", _E, 0);
	mv_print("_2_PI", _2_PI, 0);
	mv_print("_PI_2", _PI_2, 0);
	mv_print("_PI_4", _PI_4, 0);

	x = _PI_4;
	printf("mv_sin()     sin(/4) --> y\n");
	y = mv_sin(x);		mv_print("sin(pi/4) = ", y, 0);

	printf("mv_cos()     cos(/4) --> z\n");
	z = mv_cos(x);		mv_print("cos(pi/4) = ", z, 0);

	printf("mv_set_a()   0.9999 --> x\n");
	x = mv_set_a("0.9999");	mv_print("x = ", x, 1);

	printf("mv_asin()    arc sin(x) --> z\n");
	z = mv_asin(x);		mv_print("asin(x) = ", z, 1);

	printf("mv_acos()    arc cos(x) --> y\n");
	y = mv_acos(x);		mv_print("acos(x) = ", y, 1);

	printf("mv_set_a()   0.0111 --> x\n");
	x = mv_set_a("0.0111");	mv_print("x = ", x, 1);

	printf("mv_asin()    arc sin(x) --> z\n");
	z = mv_asin(x);		mv_print("asin(x) = ", z, 1);

	printf("mv_acos()    arc cos(x) --> y\n");
	y = mv_acos(x);		mv_print("acos(x) = ", y, 1);

	printf("mv_set_a()   -0.9999 --> x\n");
	x = mv_set_a("-0.9999");	mv_print("x = ", x, 1);

	printf("mv_asin()    arc sin(x) --> z\n");
	z = mv_asin(x);		mv_print("asin(x) = ", z, 1);

	printf("mv_acos()    arc cos(x) --> y\n");
	y = mv_acos(x);		mv_print("acos(x) = ", y, 1);

	printf("mv_set_a()   -0.0111 --> x\n");
	x = mv_set_a("-0.0111");	mv_print("x = ", x, 1);

	printf("mv_asin()    arc sin(x) --> z\n");
	z = mv_asin(x);		mv_print("asin(x) = ", z, 1);

	printf("mv_acos()    arc cos(x) --> y\n");
	y = mv_acos(x);		mv_print("acos(x) = ", y, 1);

	printf("mv_set_a()   123.456 --> x\n");
	x = mv_set_a("123.456");	mv_print("x = ", x, 1);

	printf("mv_log()     ln(x) --> z\n");
	z = mv_log(x);		mv_print("log(x) = ", z, 1);

	printf("mv_log10()   log10(x) --> y\n");
	y = mv_log10(x);		mv_print("log10(x) = ", y, 1);

	printf("mv_set_a()   2 --> x\n");
	x = mv_set_a("2");	mv_print("x = ", x, 0);

	printf("mv_x1n()     x^(1/3) --> z\n");
	z = mv_x1n(x, 3);	mv_print("z = 2 ^ (1/3) = ", z, 0);

	printf("mv_sqr()     z^2 --> y\n");
	y = mv_sqr(z);		mv_print("y = z ^ 2 = ", y, 0);

	printf("mv_set_a()   3 --> x\n");
	x = mv_set_a("3");	mv_print("x = ", x, 0);

	printf("mv_x_y()     z^x --> y\n");
	y = mv_x_y(z, x);	mv_print("z ^ 3 = ", y, 0);

	printf("mv_set_a()   3.2879 --> y\n");
	y = mv_set_a("3.2879");	mv_print("y = ", y, 0);

	printf("mv_x_y()     x^y --> z\n");
	z = mv_x_y(x, y);	mv_print("x ^ y = ", z, 0);

	printf("mv_exp()     e^x --> z\n");
	z = mv_exp(x);		mv_print("exp(x) = ", z, 1);

	printf("mv_10()      10^x --> z\n");
	z = mv_10(x);		mv_print("10^(x) = ", z, 1);

	printf("mv_set_a()   1.5 --> x\n");
	x = mv_set_a("1.5");	mv_print("x = ", x, 0);

	printf("mv_hcos()    hcos(x) --> y\n");
	y = mv_hcos(x);		mv_print("hcos(x) = ", y, 1);

	printf("mv_hsin()    hsin(x) --> y\n");
	y = mv_hsin(x);		mv_print("hsin(x) = ", y, 1);

	printf("mv_htan()    htan(x) --> y\n");
	y = mv_htan(x);		mv_print("htan(x) = ", y, 1);

	printf("mv_bino()    5 b 3 --> x\n");
	x = mv_bino( 5,  3);	mv_print(" 5 C 3  = ", x, 0);

	printf("mv_bino()    10 b 5 --> x\n");
	x = mv_bino(10,  5);	mv_print("10 C 5  = ", x, 0);

	printf("mv_bino()    50 b 30 --> x\n");
	x = mv_bino(50, 30);	mv_print("50 C 30 = ", x, 0);

	printf("mv_set_a()   13783.1721389 --> x\n");
	x = mv_set_a("13783.1721389");	mv_print("x = ", x, 0);

	printf("mv_round()   round(x,3) --> y\n");
	y = mv_round(x, 3);	mv_print("round(x, 3) = ", y, 0);

	printf("mv_round()   round(x,0) --> y\n");
	y = mv_round(x, 0);	mv_print("round(x, 0) = ", y, 0);

	printf("mv_round()   round(x,-3) --> y\n");
	y = mv_round(x, -3);	mv_print("round(x, -3) = ", y, 0);

	printf("mv_srand() exec.\n");
	mv_srand(time(&now));
	y = mv_set_a("0.0001");
	for(k = 0; k < 10; k++)
	{
		i = 0;
		do
		{
			x = mv_rand();
			i++;
		} while(mv_cmp(x, y) >= 0);
		printf("count = %ld (target=10000) : ", i);
		mv_print("r = ", x, 1);
	}

	printf("mv_set_a()   3 --> x\n");
	x = mv_set_a("3");	mv_print("x = ", x, 0);

	printf("mv_log()     ln(x) --> y\n");
	y = mv_log(x);		mv_print("ln(3)=", y, 0);

	printf("ln2()       ln(2) --> x\n");
	x = ln2();			mv_print("ln(2)=", x, 0);

	printf("ln625()     ln(0.625) --> y\n");
	y = ln625();		mv_print("ln(.625)=", y, 0);

	printf("mv_mul_s()   x*4 --> z\n");
	z = mv_mul_s(x, 4);	mv_print("4*ln(2) = ", z, 0);

	printf("mv_add1()    y+z --> y\n");
	mv_add1(&y, z);		mv_print("ln(10)=", y, 0);

	printf("mv_div()     x/y --> z\n");
	z = mv_div(x, y);	mv_print("log10(2)=", z, 0);

	printf("ln75()      ln(0.75) --> z\n");
	z = ln75();			mv_print("ln(.75)=", z, 0);

	printf("mv_mul1_s()  x*2 --> x\n");
	mv_mul1_s(&x, 2);	mv_print("x = ", x, 0);

	printf("mv_add1()    z+x --> z\n");
	mv_add1(&z, x);		mv_print("ln(3)=", z, 0);

	printf("mv_div()     z/y --> x\n");
	x = mv_div(z, y);	mv_print("log10(3)=", x, 0);

	printf(" --> x\n");
	x = _PI;			mv_print("x = ", x, 0);

	printf("mv_div1_s()  x/3 --> x\n");
	mv_div1_s(&x, 3);	mv_print("x = ", x, 0);

	printf("mv_tan()     tan(x) --> y\n");
	y = mv_tan(x);		mv_print("tan(x) =", y, 0);

	mv_print("sqrt(3)=", _SQRT3, 0);

	printf("mv_set_a()   0.5 --> x\n");
	x = mv_set_a("0.5");	mv_print("x = ", x, 0);

	printf("mv_acos()    arc cos(x) --> y\n");
	y = mv_acos(x);		mv_print("acos(x)=", y, 0);

	printf("sqrt(3) --> x\n");
	x = _SQRT3;			mv_print("x = ", x, 0);

	printf("mv_div_s()   x/2 --> v\n");
	v = mv_div_s(x, 2);	mv_print("v = ", v, 0);

	printf("mv_asin()    arc sin(v) --> y\n");
	y = mv_asin(v);		mv_print("asin(x)=", y, 0);

	printf("mv_atan()    arc tan(x) --> y\n");
	y = mv_atan(x);		mv_print("atan(x)=", y, 0);

	printf(" --> z\n");
	z = _PI;			mv_print("z = ", z, 0);

	printf("mv_div1_s()  z/3 --> z\n");
	mv_div1_s(&z, 3);	mv_print("pi / 3 =", z, 0);
#endif
	return 1;
}
