/*******************************************/
/*						*/
/*	tails	 			*/
/*						*/
/*		by A.Kobayashi 2001.11.13	*/
/*						*/
/*******************************************/
#include	"akxcommon.h"

#ifndef SS2
#define SS2		0x8e	/* Hankaku Kana */
#define SS3		0x8f	/* G3 AREA      */
#endif

static int _putpos(char *,off_t,int);

int  nfile=0,line_max,opt_line,mode,cr_flg=0,name_flg;
tdtRbCtl *pCt;

void _Exit(stat)
int stat;
{
	exit(stat);
}

int _getopt(argc, argv)
int  argc;
char *argv[];
{
	uchar c1,c2,*p;
	int n,ret,i;
	char parm[256];

	argc--;
	argv++;
	opt_line = -10;
	mode = 0;
	name_flg = 0;

	while (argc-- > 0) {
		p = (uchar *)*argv++;
		c1 = *p;
		if (c1 == '-') {
			p++;
			if ((c2=*p)>='0' && c2<='9') {
				n = atoi((char *)p);
				if (n < 10) n = 10;
				opt_line = -n;
			}
			else if (c2 == 'f') {
				mode = atoi((char *)p+1);
				if (mode <= 0) mode = 1;
			}
			else if (c2 == 'r') cr_flg = 1;
			else if (c2 == 'n') name_flg = -1;
			else if (c2 == '-') {
				p++;
				if (akx_log_set_command_parm(*p,p+1) < 0) return -4;
			}
			else return -3;
		}
		else if (c1 == '+') {
			p++;
			if ((c2=*p)>='0' && c2<='9') {
				n = atoi((char *)p);
				if (n < 10) n = 10;
				opt_line = n;
			}
			else if (c2 == 'n') name_flg = 1;
			else return -3;
		}
		else {
			akxs_rb_set_n(pCt, p);
			nfile++;
			XDEBUGOUTL5(0,"n=%d fname=[%s]",nfile,p,0,0,0);
		}
	}
	if (!nfile) return -2;
	if ((line_max=-opt_line) < 0) line_max = opt_line;
	if (line_max <= 0) line_max = 10;
	XDEBUGOUTL5(0,"opt_line=%d line_max=%d nfile=%d",opt_line,line_max,nfile,0,0);
	line_max++;
	return 0;
}

int main(argc,argv)
int  argc;
char *argv[];
{
	char *p;
	int ret;

	p = akxt_get_last_name("\\/",argv[0]);
	akx_log_set_up_name(p);
	XLOGFLG(X_LOG_NO_ERROR,D_LOG_FLG_STDERR);
	XLOGFLG(X_LOG_NO_PRINT,D_LOG_FLG_STDOUT);
	if (!(pCt = akxs_rb_new(0,0))) {
		XERROROUTL5(0,"akxs_rb_new error!!",0,0,0,0,0);
		_Exit(1);
	}
	if (_getopt(argc, argv) < 0) {
		fprintf(stderr,"usage : %s [-h|-?][--{d|e|p|l}[LOG_PARM]][-r][{-|+}n]\n              [-fSLEEP][[-|+]LINE] file_name ...\n",p);
		fprintf(stderr,"  where\n    LOG_PARM := FLAG,LEVEL,SIZE_MAX,FILE_MAX,OPTION,FILE,PRIORITY]\n\n");
		_Exit(0);
	}

	ret = _ntail();
XDEBUGOUTL5(0,"_ntail ret=%d",ret,0,0,0,0);

	_Exit(0);
}

static off_t _getpos(fname,lpos)
char *fname;
off_t lpos[];
{
	int   c,ret,i,len,flg,kai;
	off_t pos;
	FILE *fp;

	if (fname) {
		fp = fopen(fname,"r");
		if (!fp) {
			XERROROUTL5(0,"file[%s] open error!!",fname,0,0,0,0);
			return -1;
		}
	}
	kai = flg = i = 0;
	pos = 0;
	lpos[i] = pos;
	while ((c=getc(fp)) != EOF) {
		pos++;
		if (cr_flg && (c == '\r')) {
			c = getc(fp);
			if (c == '\n') {
				pos++;
			}
			else {
				ungetc(c,fp);
			}
			kai = 1;
		}
		else if (c == '\n') kai = 1;
		if (kai) {
			if (++i >= line_max) {
				flg = 1;
				i = 0;
			}
XDEBUGOUTL5(10,"i=%d pos=%ld",i,pos,0,0,0);
			lpos[i] = pos;
			kai = 0;
		}
	}
	fclose(fp);
	if (pos != lpos[i]) {
		if (++i >= line_max) {
			flg = 1;
			i = 0;
		}
		lpos[i] = pos;
XDEBUGOUTL5(0,"i=%d pos=%ld",i,pos,0,0,0);
	}
	if (flg) {
		if (++i >= line_max) i = 0;
		pos = lpos[i];
	}
	else pos = 0;
XDEBUGOUTL5(0,"output pos=%ld",pos,0,0,0,0);
	return pos;
}

static int _putpos(fname,pos,max_line)
char *fname;
off_t pos;
int   max_line;
{
	FILE *fp;
	int c,i;

	fp = fopen(fname,"r");
	if (!fp) {
		XERROROUTL5(0,"file[%s] open error!!",fname,0,0,0,0);
		return -2;
	}
XDEBUGOUTL5(0,"max_line=%d pos=%ld",max_line,pos,0,0,0);
	if (name_flg>0 || (!name_flg && nfile>1)) printf("<<<%s>>>\n",fname);
	fseek(fp,pos,0);
	i = 0;
	while ((c=getc(fp)) != EOF) {
		if (cr_flg && (c == '\r')) {
			if ((c=getc(fp)) == EOF) {
				putchar('\n');
				break;
			}
			else if (c != '\n') {
				putchar('\n');
				if (max_line > 0) {
					if (++i >= max_line) break;
				}
			}
		}
		putchar(c);
		if (c=='\n' && max_line>0) {
			if (++i >= max_line) break;
		}
	}
	fclose(fp);
	return 0;
}

int _ntail()
{
	tdtCacheCtlHead *pCH;
	tdtCacheCtl qCt;
	int   ret,i,date_size[4];
	off_t pos,*lpos;
	char *fname;
	struct _Mod {
		time_t    date_c;	/* t@C̍Ō̕ύX */
		off_t     size_c;	/* t@C̍vTCY (oCgP) */
	} *pMod,*pMod_b;
#if 0
		time_t    date_b;	/* Õt@C̍Ō̕ύX */
		off_t     size_b;	/* Õt@C̍vTCY (oCgP) */
	} *pMod;
#endif
	if (!(lpos=(off_t *)Malloc(line_max*sizeof(off_t)))) {
		XERROROUTL5(0,"lpos Malloc error!!",0,0,0,0,0);
		return -1;
	}

	akxs_rb_read(pCt, 0);
	for (i=0;i<nfile;i++) {
		if (!(fname = akxs_rb_read(pCt, 1))) return -1;
		if ((pos=_getpos(fname,lpos)) >= 0) {
			if (opt_line > 0) _putpos(fname,0,line_max-1);
			else _putpos(fname,pos,0);
		}
	}
	if (mode <= 0) return 0;
	
	pCH = akxs_cache_new(nfile);
	if (!pCH) {
		XERROROUTL5(0,"akxs_cache_new error",0,0,0,0,0);
		return -3;
	}
	pCH->ch_interval = 0;
	pCH->ch_opt |= AKX_CACHE_FIXEDKEYL|AKX_CACHE_DATASAVE|AKX_CACHE_IGNCHKERR;
	pCH->ch_cshlen = 1;
	pCH->ch_keylen = sizeof(int);

	akxs_rb_read(pCt, 0);
	for (i=0;i<nfile;i++) {
		if (!(fname = akxs_rb_read(pCt, 1))) return -1;
		qCt.ca_key  = (char *)&i;
		qCt.ca_cmp1 = fname;
		qCt.ca_data = fname;	/* dummy */
		ret = akxs_cache_set(pCH,&qCt);
		if (ret < 0) {
			XERROROUTL5(0,"akxs_cache_set i=%d fname=%s ret=%d",i,fname,ret,0,0);
			return ret;
		}
	}
	for (;;) {
		for (i=0;i<nfile;i++) {
			if ((ret=akxs_cache_chk(pCH,(char *)&i,&qCt)) < 0) {
				XERROROUTL5(0,"akxs_cache_chk i=%d fname=%s ret=%d",i,qCt.ca_cmp1,ret,0,0);
			}
			else {
#if 0
				date_size = (int *)qCt.ca_cmp2;
#else
				pMod = (struct _Mod *)qCt.ca_cmp2;
				pMod_b = (struct _Mod *)(qCt.ca_cmp2+sizeof(time_t)+sizeof(off_t));
/*
akxaxdump("cpCCmp2",qCt.ca_cmp2,24);
*/
/*			
				date_size[0] = pMod->date_c;
				date_size[1] = pMod->size_c;
				date_size[2] = pMod_b->date_c;
				date_size[3] = pMod_b->size_c;
*/
#endif
/*
XDEBUGOUTL5(0,"i=%d date_c=%d size_c=%d date_b=%d size_b=%d",
i,date_size[0],date_size[1],date_size[2],date_size[3]);
*/
				if (ret > 0) {	/* LbVf[^͖ */
					if (pMod->size_c < pMod_b->size_c) pos = _getpos(fname,lpos);
					else pos = pMod_b->size_c;
					_putpos(qCt.ca_cmp1,pos,0);
				}
			}
		}
		sleep(mode);
	}
/*	return 0; */
}
