/*******************************************/
/*						*/
/*	trs	 			*/
/*						*/
/*		by A.Kobayashi 2001.10.24	*/
/*						*/
/*******************************************/
#include	"akxcommon.h"

int  f_nmb,t_nmb,mode,debug_flg=0;
FILE *fp;
tdtREP_STR *tpRep=NULL;
char *fname=NULL,*tfile=NULL;

static void _usage(pn)
char *pn;
{
	static char *h[]=
	{"usage : %s [-h|-?] [--{e|p|d|l}[LOG_PARAMETER] [-{s|e|u}]\n"
	,"            [-from_number] [+to_number] [-t table] [-a replace] [file_name]"
	,"  here\n    LOG_PARAMETER := [FLAG],[LEVEL],[SIZE_MAX],[FILE_MAX],[OPTION],[FILE]"
	};
	char **ph,*p;

	ph = h;
	fprintf(stderr,*ph++,pn);
	while (p = *ph++) fprintf(stderr,"%s\n",p);
}

void _Exit(stat)
int stat;
{
	if (fp) fclose (fp);
	if (tpRep) akxc_rep_str_free(tpRep);
	exit(stat);
}

int yen_proc(dat)
char *dat;
{
	char c,*dp,*p;
	int dl;

	p  = dat;
	dp = dat;
	dl = 0;
	while (c=*p++) {
		if (c=='\\' && *p) {
			c = *p++;
			if (c=='n') c = '\n';
			else if (c=='t') c = '\t';
			else if (c=='r') c = '\r';
		}
		*dp++ = c;
		dl++;
	}
	*dp = c;
	return dl;
}

int _getopt(argc, argv)
int  argc;
char *argv[];
{
	uchar c1,c2,*p;
	int n,ret,i;
	char parm[256],*argv2[8],buf[128];

	argc--;
	argv++;
	fp = NULL;
	f_nmb = 1;
	t_nmb = 0;
	mode = CD_TYPE_UTF8;
	fname = NULL;

	while (argc-- > 0) {
		p = (uchar *)*argv++;
		c1 = *p;
		if (c1 == '-') {
			p++;
			if ((c2=*p)>='0' && c2<='9') {
				n = atoi((char *)p);
				if (n<1 || n>16) return -1;
				f_nmb = n;
			}
			else if (c2 == 'S' || c2 == 's') mode = CD_TYPE_SJIS;
			else if (c2 == 'E' || c2 == 'e') mode = CD_TYPE_EUC;
			else if (c2 == 'U' || c2 == 'u') mode = CD_TYPE_UTF8;
			else if (c2 == 't' || c2 == 'a') {
				p++;
				if (*p) tfile = (char *)p;
				else {
					argc--;
					tfile = *argv++;
				}
				if (!tpRep) {
					if (!(tpRep=akxc_rep_str_new(0,100,10))) {
						XERROROUTL5(0,"RepStrNew error!!",0,0,0,0,0);
						_Exit(3);
					}
				}
				if (c2 == 't') {
					XDEBUGOUTL5(0,"tfile=[%s]",tfile,0,0,0,0);
					if ((ret=akxc_rep_add_file(tpRep,tfile)) < 0) {
						XERROROUTL5(0,"RepAddFile error=%d!!",ret,0,0,0,0);
						_Exit(4);
					}
				}
				else {
					XDEBUGOUTL5(0,"add=[%s]",tfile,0,0,0,0);
					n = akxtgetargv2(tfile,argv2,4,parm,sizeof(parm),5);
					XDEBUGOUTL5(0,"akxtgetargv2 n=%d",n,0,0,0,0);
					for (i=0;i<n;i++) yen_proc(argv2[i]);
					if ((ret=akxc_rep_set_parm(n,argv2,argv2,NULL,buf)) < 0) {
						XERROROUTL5(0,"RepSetParm error=%d!!",ret,0,0,0,0);
						_Exit(5);
					}
					if ((ret=akxc_rep_add_range(tpRep,n,argv2,NULL)) < 0) {
						XERROROUTL5(0,"RepAddRange error=%d!!",ret,0,0,0,0);
						_Exit(6);
					}
				}
			}
			else if (c2 == '-') {
				p++;
				if (akx_log_set_command_parm(*p,p+1) < 0) return -4;
			}
			else return -3;
		}
		else if (c1 == '+') {
			p++;
			if ((c2=*p)>='0' && c2<='9') {
				n = atoi((char *)p);
				if (n<1 || n>16) return -1;
				t_nmb = n;
			}
			else return -3;
		}
		else {
			fname = (char *)p;
			XDEBUGOUTL5(0,"fname=[%s]",fname,0,0,0,0);
		}
	}
	if (t_nmb < f_nmb) t_nmb = f_nmb;
	if (mode==CD_TYPE_EUC  && t_nmb<3) t_nmb = 3;
	if (mode==CD_TYPE_SJIS && t_nmb<2) t_nmb = 2;
	if (mode==CD_TYPE_UTF8  && t_nmb<3) t_nmb = 3;
	XDEBUGOUTL5(0,"f_nmb=%d t_nmb=%d",f_nmb,t_nmb,0,0,0);
	return 0;
}

int _Puts(out_cod)
char *out_cod;
{
	char c;

	while (c = *out_cod++) putchar(c);
	return 0;
}

int _trs()
{
	int   c,ret,i,pos,sap,m,f;
	uchar in_cod[20],out_cod[256],w[20],hantei[20];

	pos = sap = 0;
	while ((pos=akxa_fw_getc(in_cod,t_nmb,fp,pos,sap)) > 0) {
		in_cod[pos] = '\0';
		m = akxqkanjilen2(in_cod,pos);
XDEBUGOUTL5(100,"pos=%d in_cod=[%s] m=%d",pos,in_cod,m,0,0);
		memzcpy(w,in_cod,m);
		f = 1;
XDEBUGOUTL5(100,"tpRep->bytes[%d]=%d w=[%s]",m-1,tpRep->bytes[m-1],w,0,0);
		if (tpRep->bytes[m-1]) {
			ret = akxc_rep_str(tpRep,0,w,out_cod);
			if (ret > 0) {
				_Puts(out_cod);
				f = 0;
			}
		}
		if (f) _Puts(w);

		sap = m;
	}
	return 0;
}

int main(argc,argv)
int  argc;
char *argv[];
{
	char *p;

	p = akxt_get_last_name("\\/",argv[0]);
	akx_log_set_up_name(p);
	XLOGFLG(X_LOG_NO_ERROR,D_LOG_FLG_STDERR);
	XLOGFLG(X_LOG_NO_PRINT,D_LOG_FLG_STDOUT);
	if (_getopt(argc, argv) < 0) {
		_usage(p);
		_Exit(0);
	}

	if (fname) {
		fp = fopen(fname,"rb");
		if (!fp) {
			XERROROUTL5(0,"file[%s] open error!!",fname,0,0,0,0);
			_Exit(2);
		}
	}
	else {
		fname = "stdin";
		fp = stdin;
	}

	akxt_set_code_type(mode);
	_trs();

	_Exit(0);
}
