static    char    sccsid[]="%Z% %M% %I% %E% %U%";
/********************************************************************/
/* <clprdeftype.c>                                                  */
/*      Define process   @                          */
/*                                            (2009/05/17 Ver 0.01) */
/********************************************************************/

#include "colmn.h"

extern CLPRTBL  *pCLprocTable;
extern CLCOMMON CLcommon;
extern int giOptions[];

/************************************/
/*	cl_get_def_attr					*/
/************************************/
int cl_get_def_attr(varnam, vnlen, iParm)
char *varnam;
int   vnlen;
int   iParm[];
{
	int rc,len,id,attr,size,n;
	int dec_pre,dec_sca;
	qSubCommand *sc;
	tdtINFO_PARM *pInfoParm,tInfoParm,tInfoParm2[2];

	attr = dec_pre = dec_sca = 0;
	size = sizeof(tdtINFO_PARM *);

	len = akxnskipto(varnam,vnlen,"(");
	if (sc=cl_get_name_attr(varnam,len,0x01,0x20)) {
		size = sc->size;
		attr = sc->attr;
	}

	if (attr==DEF_ZOK_CHAR || attr==DEF_ZOK_BULK) {
		if (vnlen > len) {
			rc = cl_gx_expsn_obj_opt(varnam+len,vnlen-len,NULL,NULL,&tInfoParm,0);
			if (!rc) rc = cl_get_parm_bin(&tInfoParm,&size,"cl_get_def_attr: ");
			if (rc) {
				ERROROUT2(FORMAT(524),
				          varnam,rc);
				return ECL_SCRIPT_ERROR;
			}
			if (size<=0 /*|| size>USHRT_MAX*/) {
				ERROROUT1(FORMAT(525),size);
				return ECL_SCRIPT_ERROR;
			}
		}
	}
	else if (attr == DEF_ZOK_DECI) {
		if (vnlen > len) {
			rc = cl_gx_expsn_obj_opt(varnam+len,vnlen-len,NULL,NULL,tInfoParm2,D_GX_OPT_PARMINFO2);
			if (!rc) {
				if (n=tInfoParm2[1].pi_pos) {
					pInfoParm = (tdtINFO_PARM *)tInfoParm2[1].pi_data;
					rc = pInfoParm->pi_hlen;
				}
				else pInfoParm = tInfoParm2;
			}
			if (!rc) rc = cl_get_parm_bin(pInfoParm,&dec_pre,"cl_get_def_attr: ");
			if (rc) {
				ERROROUT2(FORMAT(526),varnam,rc);
				return ECL_SCRIPT_ERROR;
			}
			if (dec_pre<=0 || dec_pre>NMPA) {
				ERROROUT1(FORMAT(527),dec_pre);
				return ECL_SCRIPT_ERROR;
			}
			if (n >= 2) {
				rc = cl_get_parm_bin(++pInfoParm,&dec_sca,"cl_get_def_attr: ");
				if (rc) {
					ERROROUT2(FORMAT(528),varnam,rc);
					return ECL_SCRIPT_ERROR;
				}
				if (dec_sca<MIN_DEC_SCALE || dec_sca>MAX_DEC_SCALE) {
					ERROROUT1(FORMAT(529),dec_sca);
					return ECL_SCRIPT_ERROR;
				}
			}
		}
	}
	iParm[0] = attr;
	iParm[1] = size;
	iParm[2] = dec_pre;
	iParm[3] = dec_sca;
/*
printf("cl_get_def_attr:attr=%d size=%d dec_pre=%d dec_sca=%d\n",attr,size, dec_pre,dec_sca);
*/
	return 0;
}

/************************************/
/*	cl_set_parm_init					*/
/************************************/
int cl_set_parm_init(pInfoParm,iParm,opt)
tdtINFO_PARM *pInfoParm;
int iParm[],opt;
{
	int rc,attr,size;
	char *p;

	size = iParm[1];
	switch (attr=iParm[0]) {
		case DEF_ZOK_CHAR:
		case DEF_ZOK_VARI:
			rc = cl_set_parm_char(pInfoParm,NULL,0);
			pInfoParm->pi_attr = attr;
			break;
		case DEF_ZOK_BINA:
			rc = cl_set_parm_bin(pInfoParm,0);
			break;
		case DEF_ZOK_FLOA:
			rc = cl_set_parm_double(pInfoParm,0.0);
			break;
		case DEF_ZOK_DECI:
			if (!(rc=cl_set_parm_mpa(pInfoParm,NULL))) {
				pInfoParm->pi_len = iParm[2];	/* precision */
				pInfoParm->pi_pos = iParm[3];	/* scale */
			}
			break;
		case DEF_ZOK_BULK:
			rc = cl_set_parm_char(pInfoParm,NULL,0);
			pInfoParm->pi_attr = attr;
		/*	pInfoParm->pi_len = size;	*/
			break;
		default:
			rc = -1;
	}
	if ((opt & 0x01) && (attr!=DEF_ZOK_VARI) && !rc) {
		pInfoParm->pi_hlen = size;
		pInfoParm->pi_aux[0] = attr;
		if (attr!=DEF_ZOK_BINA && attr!=DEF_ZOK_FLOA) {
			if (attr == DEF_ZOK_CHAR) size++;
			else if (attr == DEF_ZOK_BULK) size += sizeof(int);
			if (p = Malloc(size)) {
				if (attr == DEF_ZOK_DECI) memcpy(p,pInfoParm->pi_data,size);
				else strcpy(p,pInfoParm->pi_data);
				pInfoParm->pi_scale |= D_DATA_MALLOC;
			}
			else rc = -1;
			pInfoParm->pi_data = p;
		}
		pInfoParm->pi_paux = pInfoParm->pi_data;
	}
	return rc;
}

/************************************/
/*	cl_pr_ex_def_type                 */
/************************************/
int cl_pr_ex_def_type(prmnum, pprmp, scrct, proc, opt)
int      prmnum;
parmList **pprmp;
ScrPrCT  *scrct;
ProcCT   *proc;
int      opt;
{
	XHASHB *pha_vname,*xhp;
	tdtINFO_PARM ***pTBL_vname;
	int  i,iParmNo,rc,vnlen,attr,len,nparm,n,attr_set,iCONTINUE;
	int  size,pos;
	char c,*varnam,*pp,*p,*argv[6];
	tdtINFO_PARM *pInfoParm,tInfoParm,tInfoParm2[2];
	tdtArrayIndex tIndex,*pIndex;
	int *index;
	int dec_pre,dec_sca,iParm[4];
	parmList  *parmName[MAX_MEMBER],*pL,**ppPrm,*prmpi,prmW;
	tdtINFO_PARM *pTypeInfo[MAX_MEMBER];
	tdtDefType *pDeftype;
	int ntype;

	argv[0] = "cl_pr_ex_def_type";
	/* parameter check */
	/* DEFINE TYPE STRUCT name
	      var_type var_name ,
	      var_type var_name		*/
	if (prmnum < 5) {
		ERROROUT2(FORMAT(530),argv[0],prmnum);
		return ECL_EX_DEFINE;
	}

	pha_vname = NULL;
	p = pprmp[1]->prp;
	if (stricmp(p,"STRUCT")) {
		ERROROUT2(FORMAT(531),argv[0],p);
		return ECL_EX_DEFINE;
	}

	varnam = pprmp[2]->prp;
	vnlen  = pprmp[2]->prmlen;
	if (rc=clDefchk_name(varnam,vnlen,argv[0],"^`")) return rc;

	ntype = pos = 0;
	ppPrm = &pprmp[3];
	nparm = prmnum - 3;
	prmpi = *ppPrm;
	while (nparm >= 1) {
		/* ̎擾 */
		if (rc=cl_get_def_attr(p=prmpi->prp,prmpi->prmlen,iParm)) return rc;
#if 1
		attr_set = iParm[0];
		if (!attr_set) iParm[0] = DEF_ZOK_VARI;
#else
		else if (!iParm[0]) {
			ERROROUT2(FORMAT(532),argv[0],p);
			return ECL_EX_DEFINE;
		}
#endif
		attr = iParm[0];
		size = iParm[1];
		if (!(pInfoParm=(tdtINFO_PARM *)Malloc(sizeof(tdtINFO_PARM)))) return -1;
		pTypeInfo[ntype] = pInfoParm;
		cl_set_parm_init(pInfoParm,iParm,0);
		if (attr != DEF_ZOK_VARI) {
		/*	pInfoParm->pi_scale &= ~D_DATA_LPOSDATA;	*/
			pInfoParm->pi_aux[0] = attr;
			pInfoParm->pi_hlen = size;
		}
printf("attr_set=%d nparm=%d\n",attr_set,nparm);
#if 1
		if (attr_set) {
			ppPrm++;nparm--;
			prmpi = *ppPrm;
		}
#else
		ppPrm++;nparm--;
#endif
		if (nparm <= 0) {
			ERROROUT1(FORMAT(533),argv[0]);
			return ECL_EX_DEFINE;
		}

		/* ϐ̎擾 */
		if (!(pL=(parmList *)Malloc(sizeof(parmList)))) return -1;
		parmName[ntype++] = pL;
		*pL = *prmpi;
		pL->prp = Strdup(pL->prp);
		pL->opt = pos;
		if (attr == DEF_ZOK_BULK) size += sizeof(int);
	/*	else if (attr == DEF_ZOK_CHAR) size++;	*/
		if (pInfoParm->pi_aux[0])
			pos += ((size+sizeof(int)-1)/sizeof(int))*sizeof(int);
		len = akxnskipto(p=pL->prp,vnlen=pL->prmlen,",");
		iCONTINUE = 0;
		if (len < 0) return len;
		else if (len < vnlen) {
			*(p+len) = '\0';
			pL->prmlen = len;
			iCONTINUE = 1;
			if (vnlen-len > 1) {
				prmpi = &prmW;
				prmpi->prp = p + len + 1;
				prmpi->prmlen = vnlen - len - 1;
			}
			else {
				ppPrm++;nparm--;
				prmpi = *ppPrm;
			}
		}
		else {
			ppPrm++;nparm--;
			prmpi = *ppPrm;
			if (*(p=ppPrm[0]->prp) == ',') {
				if ((vnlen=ppPrm[0]->prmlen) == 1) {
					nparm--;
					ppPrm++;
					prmpi = *ppPrm;
				}
				else {
					p = prmpi->prp;
					prmW = **ppPrm;
					prmpi = &prmW;
					prmpi->prp = p + 1;
					prmpi->prmlen--;
				}
				iCONTINUE = 1;
			}
		}
		varnam = pL->prp;
		vnlen  = pL->prmlen;
printf("varnam=[%s] vnlen=%d nparm=%d\n",varnam,vnlen,nparm);
		if (rc=clDefchk_name(varnam,vnlen,argv[0],"o")) return rc;
		if (iCONTINUE) continue;

		/* z`̎擾 */
		if (nparm <= 0) break;
		n = 0;
		for (i=0;i<nparm;i++) {
			if (*(ppPrm[i]->prp) == ',') break;
		/*	else if (i >= 3) break;	*/
			n++;
			len = akxnskipto(p=ppPrm[i]->prp,vnlen=ppPrm[i]->prmlen,",");
			if (len < 0) return len;
			else if (len < vnlen) {
				*(p+len) = '\0';
				ppPrm[i]->prmlen = len;
				break;
			}
		}
		if (n > 0) {
			if (rc=_def_array(n,ppPrm,opt|D_GX_OPT_NOALLOC_INDX,iParm,&tIndex,0,0)) return rc;
			attr = iParm[0];
			nparm -= n;
			ppPrm += n;
			pInfoParm->pi_id   = 'R';
			pInfoParm->pi_scale = D_DATA_MALLOC | D_DATA_INDEX_FREE;
			pInfoParm->pi_attr = attr;
			pInfoParm->pi_dlen  = sizeof(tdtArrayIndex);
			if (!(pInfoParm->pi_data = Malloc(sizeof(tdtArrayIndex)))) return -1;
			memcpy(pInfoParm->pi_data,&tIndex,sizeof(tdtArrayIndex));
			varnam = pL->prp;
			vnlen  = pL->prmlen;
			if (!(p=Malloc(vnlen+1))) {
				ERROROUT1("%s: Array name area malloc",argv[0]);
				goto Error;
			}
			strnzcpy(p,varnam,vnlen);
			pInfoParm->pi_pos = (long)p;
			index = tIndex.index;
			size = tIndex.size;
			if (attr=tIndex.uAttr[0]) {
				if (attr == DEF_ZOK_CHAR) size++;
				else if (attr == DEF_ZOK_BULK) size += sizeof(int);
				len = index[1]*index[2]*index[3]*size;
				pos = pL->opt + ((len+sizeof(int)-1)/sizeof(int))*sizeof(int);
			}
			else pos = pL->opt;

DEBUGOUT_InfoParm(194,"cl_pr_ex_def_type: attr=%d size=%d",pInfoParm,attr,size);

		}
		prmpi = *ppPrm;
		if (*(p=prmpi->prp) == ',') {
			if ((vnlen=prmpi->prmlen) == 1) {
				nparm--;
				ppPrm++;
				prmpi = *ppPrm;
			}
			else {
				p = prmpi->prp;
				prmW = **ppPrm;
				prmpi = &prmW;
				prmpi->prp = p + 1;
				prmpi->prmlen--;
			}
		}
	}
#if 1
 	if (!(opt & D_GX_OPT_SET_SCOPE)) {
		if (proc) {
			if (!(giOptions[9] & 0x01) && (scrct->pFlag & D_SCRPT_NEW_LEX))
				opt |= D_GX_OPT_SET_LOCAL;
			else opt |= D_GX_OPT_SET_PRIVATE;
		}
		else opt |= D_GX_OPT_SET_PRIVATE;
	}
#else
	opt |= D_GX_OPT_SET_PRIVATE;
#endif
	attr = DEF_ZOK_BULK;
	varnam = pprmp[2]->prp;
	vnlen  = pprmp[2]->prmlen;
	if ((rc=_chk_define(scrct,proc,varnam,vnlen,opt,argv)) < 0) return rc;
	pha_vname  = (XHASHB *)argv[4];
	pTBL_vname = (tdtINFO_PARM ***)argv[5];

	if ((iParmNo=cl_gx_chk_vnam('s',pha_vname,varnam,vnlen)) < 1) {
		ERROROUT2(FORMAT(534),argv[0],varnam);
		goto Error;
	}
	pInfoParm = cl_get_var_ent(pTBL_vname,iParmNo);
	if (!pInfoParm) return ECL_SCRIPT_ERROR;

	info_parm_clear(pInfoParm);
	pInfoParm->pi_id   = 'P';
	pInfoParm->pi_scale = D_DATA_MALLOC | D_DATA_INDEX_FREE;
	pInfoParm->pi_attr = attr;
	pInfoParm->pi_dlen  = sizeof(tdtDefType);
	pInfoParm->pi_aux[1] |= D_AUX1_PROTECTED;
	if (!(pDeftype=(tdtDefType *)Malloc(sizeof(tdtDefType)))) return -1;
	memset(pDeftype,0,sizeof(tdtDefType));
	pDeftype->size = pos;
	pDeftype->ntype = ntype;
	pInfoParm->pi_data = (char *)pDeftype;
	if (!(pDeftype->vname=(parmList **)Malloc(ntype*sizeof(parmList *)))) return -1;
	memcpy(pDeftype->vname,parmName,ntype*sizeof(parmList *));
	if (!(pDeftype->pType=(tdtINFO_PARM **)Malloc(ntype*sizeof(tdtINFO_PARM *)))) return -1;
	memcpy(pDeftype->pType,pTypeInfo,ntype*sizeof(tdtINFO_PARM *));
	if (!(p=Malloc(vnlen+1))) {
		ERROROUT1("%s: Type def name area malloc",argv[0]);
		goto Error;
	}
	strnzcpy(p,varnam,vnlen);
	pInfoParm->pi_pos = (long)p;
	if (opt & D_GX_OPT_SET_LOCAL) pInfoParm->pi_hlen = proc->ProcGid;
	else if (opt & D_GX_OPT_SET_PRIVATE) pInfoParm->pi_hlen = scrct->ScrGid;

DEBUGOUT_InfoParm(194,"cl_pr_ex_def_type: attr=%d",pInfoParm,attr,0);

	return 0;

 Error:
 	if (tIndex.xhp) akxs_xhashFree(tIndex.xhp);
 	if (tIndex.pVarIndex) Free(tIndex.pVarIndex);
	return ECL_SCRIPT_ERROR;
}

/************************************/
/*	cl_pr_ex_def_var                 */
/************************************/
int cl_pr_ex_def_var(prmnum, pprmp, scrct, proc, opt)
int      prmnum;
parmList **pprmp;
ScrPrCT  *scrct;
ProcCT   *proc;
int      opt;
{
	XHASHB *pha_vname;
	tdtINFO_PARM ***pTBL_vname;
	int  i,j,iParmNo,rc,vnlen,iParm[4],ias,ntype,datalen,check[4],iCONST;
	char *varnam,*p,id,*argv[6];
	tdtINFO_PARM *pInfoParm,tInfoParm,*pParm;
	tdtDefType *pDeftype,*pDeftypeP;
	parmList  **parmName;
	tdtArrayIndex *pIndex;
	int *index,attr,size,len;

	argv[0] = "cl_pr_ex_def_var";
	/* parameter check */
	/* DEFINE VAR [GLOBAL|PUBLIC|PRIVATE|LOCAL] var_name AS type; */
	if (prmnum < 4) {
		ERROROUT2(FORMAT(535),argv[0],prmnum);
		return ECL_EX_DEFINE;
	}

	pha_vname = NULL;
	iCONST = 0;
	check[0] = 2;
	check[1] = 0x03;
	if ((rc=cl_get_def_modifier(prmnum-1,pprmp+1,check,iParm)) < 0) return rc;
	else if (rc > 0) {
		pprmp  += rc;
		prmnum -= rc;
		if (check[2] & 0x01) opt &= ~D_GX_OPT_SET_SCOPE;
		opt |= check[3];
		if (!proc && (opt & D_GX_OPT_SET_LOCAL)) {
			ERROROUT1(FORMAT(536),argv[0]);
			return ECL_SCRIPT_ERROR;
		}
		if (opt & D_GX_OPT_SET_CONST) iCONST = D_AUX1_PROTECTED;
	}
	ias = prmnum-2;
	if (stricmp(p=pprmp[ias]->prp,"AS")) {
		ERROROUT1(FORMAT(537),p);
		return ECL_EX_DEFINE;
	}
	ias++;
	if (rc=cl_get_def_attr(pprmp[ias]->prp,pprmp[ias]->prmlen,iParm)) return rc;
	if (!iParm[0]) {
		varnam = pprmp[ias]->prp;
		vnlen  = pprmp[ias]->prmlen;
		if (rc=clDefchk_name(varnam,vnlen,argv[0],"^`")) return rc;
		if ((rc=cl_conv_parm_opt(pprmp[ias],&tInfoParm,0))==ECL_DEFINED_ARRAY) rc=0;
		else if (rc) return rc;
		if (tInfoParm.pi_id != 'P') {
			ERROROUT1(FORMAT(538),pprmp[3]->prp);
			return ECL_EX_DEFINE;
		}
		pDeftypeP = (tdtDefType *)tInfoParm.pi_data;
	}

 /*	opt &= ~D_GX_OPT_SET_LOCAL;	*/
 	if (!(opt & D_GX_OPT_SET_SCOPE)) {
		if (proc) {
			if (!(giOptions[9] & 0x01) && (scrct->pFlag & D_SCRPT_NEW_LEX))
				opt |= D_GX_OPT_SET_LOCAL;
			else opt |= D_GX_OPT_SET_PRIVATE;
		}
		else opt |= D_GX_OPT_SET_PRIVATE;
	}
	for (i=1;i<prmnum-2;i++) {
		varnam = pprmp[i]->prp;
		vnlen  = pprmp[i]->prmlen;
		if (rc=clDefchk_name(varnam,vnlen,argv[0],"ϐ")) return rc;
		if ((rc=_chk_define(scrct,proc,varnam,vnlen,opt,argv)) < 0) return rc;
		pha_vname  = (XHASHB *)argv[4];
		pTBL_vname = (tdtINFO_PARM ***)argv[5];

		if ((iParmNo=cl_gx_chk_vnam('s',pha_vname,varnam,vnlen)) < 1) {
			ERROROUT1(FORMAT(539),varnam);
			return ECL_EX_DEFINE;
		}
		pInfoParm = cl_get_var_ent(pTBL_vname,iParmNo);
		if (!pInfoParm) return ECL_SCRIPT_ERROR;
		info_parm_clear(pInfoParm);

		if (iParm[0]) {
			if (rc=cl_set_parm_init(pInfoParm,iParm,0x01)) {
				ERROROUT1(FORMAT(540),varnam);
				return rc;
			}
		}
		else {
			if (rc=cl_gx_rep_info_set(pInfoParm,&tInfoParm,1)) return rc;
			pInfoParm->pi_id = 'T';
			if (!(p=Malloc(vnlen+1))) {
				ERROROUT("cl_pr_ex_def_var: Array name area malloc");
				return ECL_EX_DEFINE;
			}
			strnzcpy(p,varnam,vnlen);
			pInfoParm->pi_pos = (long)p;

			pDeftype = (tdtDefType *)pInfoParm->pi_data;
		/*
			if (!(p=Malloc(pDeftype->size+1))) return -1;
			memset(p,0,pDeftype->size+1);
			pDeftype->data = p;
		*/
			ntype = pDeftype->ntype;
			parmName = pDeftype->vname;
			if (!(pDeftype->pType=(tdtINFO_PARM **)Malloc(ntype*sizeof(tdtINFO_PARM *)))) return -1;
			for (j=0;j<ntype;j++) {
				if (!(pParm=(tdtINFO_PARM *)Malloc(sizeof(tdtINFO_PARM)))) return -1;
				pDeftype->pType[j] = pParm;
				cl_gx_copy_info(pParm,pDeftypeP->pType[j]);
				if ((id=pParm->pi_id)=='A' || id=='R') {
					if (!(pIndex = (tdtArrayIndex *)Malloc(sizeof(tdtArrayIndex)))) return -1;
					memcpy(pIndex,pParm->pi_data,sizeof(tdtArrayIndex));
					pParm->pi_data = (char *)pIndex;
					if (attr=pIndex->uAttr[0]) {
					/*
						pIndex->pVarIndex = (tdtINFO_PARM **)(pDeftype->data + parmName[j]->opt);
						pIndex->uAttr[1] = D_ATR1_NO_MALLOC;
					*/
						index = pIndex->index;
						size = pIndex->size;
						if (attr == DEF_ZOK_CHAR) size++;
						len = index[1]*index[2]*index[3]*size;
						if (!(pIndex->pVarIndex=(tdtINFO_PARM **)Malloc(len))) return -10;
						memset(pIndex->pVarIndex,0,len);
					}
					else {
						if (!(pIndex->xhp = akxs_xhashNew2(0,
							pIndex->index[1],0,pIndex->size))) return -9;
					}
				}
				else if (attr=pParm->pi_aux[0]) {
					if (attr!=DEF_ZOK_BINA && attr!=DEF_ZOK_FLOA) {
						size = pParm->pi_hlen;
						if (attr == DEF_ZOK_CHAR) size++;
						else if (attr == DEF_ZOK_BULK)
						/*	size = pParm->pi_len + sizeof(int);	*/
							size += sizeof(int);
						if (p = Malloc(size)) {
							if (attr == DEF_ZOK_DECI) memcpy(p,pParm->pi_data,size);
							else strcpy(p,pParm->pi_data);
							pParm->pi_scale |= D_DATA_MALLOC;
						}
						else rc = -1;
						pParm->pi_data = p;
					}
					pParm->pi_paux = pParm->pi_data;
					pParm->pi_aux[1] &= ~D_AUX1_PROTECTED;
				/*
					if (pParm->pi_aux[0] == DEF_ZOK_CHAR)
						pParm->pi_dlen = strlen(pParm->pi_data);
					else if (pParm->pi_aux[0] == DEF_ZOK_BULK) {
						memcpy(&datalen,pParm->pi_paux,sizeof(int));
						pParm->pi_data += sizeof(int);
						pParm->pi_dlen = datalen;
					}
				*/
				}
			}
		}
		if (opt & D_GX_OPT_SET_LOCAL) pInfoParm->pi_hlen = proc->ProcGid;
		else if (opt & D_GX_OPT_SET_PRIVATE) pInfoParm->pi_hlen = scrct->ScrGid;
		pInfoParm->pi_aux[1] |= iCONST;

DEBUGOUT_InfoParm(194,"cl_pr_ex_def_var:",pInfoParm,0,0);

	}
	return 0;
}

/****************************************/
/*										*/
/****************************************/
int cl_free_deftype(id,pDeftype)
char id;
tdtDefType *pDeftype;
{
	int i,ntype;
	parmList *pL,**pparmL;
	tdtINFO_PARM **ppParm,*pInfoParm;

	ntype = pDeftype->ntype;
	if (id == 'P') {
		pparmL = pDeftype->vname;
		for (i=0;i<ntype;i++) {
			pL = *pparmL++;
			Free(pL->prp);
			Free(pL);
		}
		Free(pDeftype->vname);
	}
	ppParm = pDeftype->pType;
	for (i=0;i<ntype;i++) {
		cl_free_info_parm(*ppParm++);
	}
	return 0;
}
