static char sccsid[]="%Z% %M% %I% %E% %U%";
/************************************************************************/
/*																		*/
/*	akxssrch.c															*/
/*																		*/
/*	쐬 : 2001/02/15 Akito Kobayashi									*/
/*	XV : 2019/08/23 Akito Kobayashi Add akxs_seqr_str(),				*/
/*								,akxs_seqr_str_num(),akxs_seqr_str2()	*/
/*	XV : 2019/09/09 Akito Kobayashi Add akxs_iseq(),akxs_ins_sseq()   */
/*        ,akxs_ins_sseq_array(),akxs_ins_shseq(),akxs_ins_shseq_array()*/
/************************************************************************/
#include "akxcommon.h"

static int _seqsr();
static int _seqss();
static int _seqsd();
static int _seqsi();

int akxs_seqs(func,hashbp)
char func;
HASHB *hashbp;
{
	int i;

	if (!hashbp) return -1;
/*
printf("akxs_seqs: func=%c hashbp->ha_prereg=%08x\n",func,hashbp->ha_prereg);
*/
	switch (func) {
	  case 'r':
	  case 'R':
			i=_seqsr(hashbp);
			break;
	  case 's':
	  case 'S':
			i=_seqss(hashbp);
			break;
	  case 'd':
	  case 'D':
			i=_seqsd(hashbp);
			break;
	  case 'i':
	  case 'I':
			i=_seqsi(hashbp);
			break;
	  default:
			i=-2;
	}
	return (i);
}

static int _seqsi(hp)
HASHB *hp;
{
	int mx,i=0;		/* 2021.7.17 add mx */

	if (hp->ha_maxreg <= 0) i-=4;
	if (!hp->ha_reg) i -= 8;
	if (!hp->ha_next) i -= 16;

	if (i >= 0) {
#if 1	/* 2021.7.17 */
		mx = hp->ha_maxreg + 1;
		memset(hp->ha_reg,0,mx*sizeof(char *));
		memset(hp->ha_next,0,mx);
#else
		memset(hp->ha_reg,0,hp->ha_maxreg*sizeof(char *));
		memset(hp->ha_next,0,hp->ha_maxreg);
#endif
		hp->ha_aux=0;
	}

	return (i);
}

static int _seqss(hp)
HASHB *hp;
{
	int i,lklen,opt;
	char *p,*kp,**rp,*np;
	short klen;

	if (i = _seqsr(hp)) return i;

	rp = (char **)hp->ha_reg;
	np = (char *)hp->ha_next;

#if 1	/* 2021.7.17 */
	for (i=1;i<=hp->ha_aux;i++) {
		if (!np[i]) break;
	}
	if (i > hp->ha_maxreg) return 0;
	if (i > hp->ha_aux) hp->ha_aux++;
#else
	for (i=0;i<hp->ha_aux;i++) {
		if (!np[i]) break;
	}
	if (i >= hp->ha_maxreg) return 0;
	if (i >= hp->ha_aux) hp->ha_aux++;
#endif
	klen = hp->ha_keylen;
	kp = hp->ha_key;
	p = rp[i];
	if (!klen) {
		lklen = strlen(kp) + 1;
	}
	else if (klen > 0) {
		lklen = klen;
	}
	else {
		memcpy(&lklen,kp,sizeof(int));
		if (lklen < 0) return -32;
		lklen += sizeof(int);
	}

	if (p) {
		if (klen <= 0) p = Realloc(p,lklen);
	}
	else p = Malloc(lklen);

	if (p) {
		memcpy(p,kp,lklen);
		if (opt = hp->ha_prereg) opt >>= 16;
		np[i] = 1 | opt;
		rp[i] = p;
/*
printf("seqss:i=%d kp=[%s] np[i]=%08x\n",i,p,np[i]);
*/
	}
	else return -33;
	return i;		/* 2021.7.17 i+1 --> i */
}

static int _seqsr(hp)
HASHB *hp;
{
	int i;
	char *p,*kp,**rp,*np;
	short len,klen;
	int  ldlen,lklen,opt;

	rp = (char **)hp->ha_reg;
	np = (char *)hp->ha_next;
	if (!(kp = hp->ha_key)) return -35;
	if ((klen=hp->ha_keylen) < 0) {
		memcpy(&lklen,kp,sizeof(int));
		if (lklen < 0) return -32;
		kp += sizeof(int);
	}
/*
printf("seqr: klen=%d kp=[%s]\n",klen,kp);
*/
#if 1	/* 2021.7.17 */
	for (i=1;i<=hp->ha_aux;i++) {
#else
	for (i=0;i<hp->ha_aux;i++) {
#endif
		p = rp[i];
		if (!(opt=np[i]) || !p) continue;
		if (opt & ~0x01) opt <<= 16;
		if (!klen) {
/*
printf("seqr:i=%d p=[%s] kp=[%s] opt=%08x\n",i,p,kp,opt);
*/
			if (!akxs_opt_strcmp(p,kp,opt)) break;
		}
		else if (klen > 0) {
			if (!akxs_opt_memcmp(p,kp,klen,opt)) break;
		}
		else {
			memcpy(&ldlen,p,sizeof(int));
			if (lklen == ldlen) {
				if (!akxs_opt_memcmp(p+sizeof(int),kp,lklen,opt)) break;
			}
		}
	}
#if 1	/* 2021.7.17 */
	if (i > hp->ha_aux) i = 0;
#else
	if (i >= hp->ha_aux) i = -1;
#endif

	return i;		/* 2021.7.17 i+1 --> i */
}

static int _seqsd(hp)
HASHB *hp;
{
	int i;
	char *np;

	i = hp->ha_hix;
	if (i > 0 ) {
		if (i > hp->ha_aux) return -34;
	}
	else {
		if ((i=_seqsr(hp)) <= 0) return i;
	}
	np = (char *)hp->ha_next;
	np[i] = 0;		/* 2021.7.17 i-1 --> i */
	return i;
}

HASHB *akxs_seqs_new(sKeyLen,lMaxReg)
short sKeyLen;
int  lMaxReg;
{
	HASHB *tph;
	int l;

	if (lMaxReg <= 0) return NULL;
	if (!(tph=(HASHB *)Malloc(sizeof(HASHB)))) return NULL;
	memset(tph,0,sizeof(HASHB));
	tph->ha_id[0] = 'S';
	tph->ha_id[1] = 'Q';
	tph->ha_keylen = sKeyLen;
	tph->ha_maxreg = lMaxReg;
/*
printf("akxs_seqs_new: sKeyLen=%d lMaxReg=%d id[1]=%c\n",sKeyLen,lMaxReg,tph->ha_id[1]);
*/
	if (!(tph->ha_reg=Malloc((lMaxReg+1)*sizeof(char *)))) {	/* 2021.7.17 lMaxReg --> lMaxReg+1 */
		akxs_seqs_free(tph);
		return NULL;
	}
	if (!(tph->ha_next=(int *)Malloc(lMaxReg+1))) {	/* 2021.7.17 lMaxReg --> lMaxReg+1 */
		akxs_seqs_free(tph);
		return NULL;
	}
	if (akxs_seqs('i',tph)) {
		akxs_seqs_free(tph);
		return NULL;
	}
	return tph;
}

int akxs_seqs_free(hp)
HASHB *hp;
{
#if 1	/* 2021.7.17 */
	int i;
	char **rp;
#endif
	if (hp) {
#if 1	/* 2021.7.17 */
		if (rp = (char **)hp->ha_reg) {
			for (i=1;i<=hp->ha_aux;i++) {
				if (rp[i]) Free(rp[i]);
			}
			Free(rp);
		}
#else
		if (hp->ha_reg) Free(hp->ha_reg);
		if (hp->ha_next) Free(hp->ha_next);
#endif
		Free(hp);
	}
	return 0;
}

static int _xseqs_chk();
static int _xseqs_used();
static int _xseqs_max();

XHASHB *akxs_xseqs_new2(sKeyLen,lMaxReg,lDatLen)
short sKeyLen;
int  lMaxReg,lDatLen;
{
	XHASHB *p;
	int l;
	char c;

	if (lMaxReg <= 0) {
		errno = -1301;
		return NULL;
	}
	if (!(p=(XHASHB *)Malloc(sizeof(XHASHB)))) {
		errno = -1303;
		return NULL;
	}

	if (sKeyLen>0 && sKeyLen<=sizeof(long)) c = 'L';
	else if (sKeyLen>sizeof(long) && sKeyLen<=sizeof(long)*2) c = '2';
	else c = 'X';
/*
printf("akxs_xseqs_new2: sKeyLen=%d lMaxReg=%d lDatLen=%d id[1]=%c\n",sKeyLen,lMaxReg,lDatLen,c);
*/
	p->xha_id[0] = 'S';
	p->xha_id[1] = c;
	p->xha_keylen = sKeyLen;
	p->xha_maxreg = lMaxReg;
	p->xha_prereg = 0;
	p->xha_datlen = lDatLen;
	p->xha_xhix   = 0;
	p->xha_hashb  = NULL;
	p->xha_xhnext = NULL;
	p->xha_datreg = NULL;
	return p;
}

int akxs_xseqs2(tp_xseqsb,cCmnd,cpKey,cppDat)
XHASHB *tp_xseqsb;
char cCmnd, *cpKey;
char **cppDat;		/* cCmnd='S'or's'̂Ƃ́A(char *)Ɠǂݑւ */
{
	XHASHB *tpcur,*tpnext;
	int l,i,offset,len;
	HASHB *tph,ha;
	int ret,opt;
	char cCmd,c,cc;

	if (!tp_xseqsb) return -1;
	cCmd = akxcupper(cCmnd);
	if ((cCmd=='R'||cCmd=='P'||cCmd=='K') && cppDat) *cppDat = NULL;
	switch (cCmd) {
		case 'R':
		case 'S':
		case 'D':
			if (tp_xseqsb->xha_xhix) return _xseqs_chk(tp_xseqsb,cCmd,cpKey,cppDat);
			break;
		case 'K':
		case 'P':
			return _xseqs_chk(tp_xseqsb,cCmd,cpKey,cppDat);
		case 'U':
			return _xseqs_used(tp_xseqsb);
		case 'M':
			return _xseqs_max(tp_xseqsb);
		default:
			return -72;
	}
	if (!cpKey) return -1;
	l = 0;
	offset = 0;
	tpnext = tp_xseqsb;
	while (tpnext) {
		tpcur = tpnext;
		if (!(tph=tpcur->xha_hashb)) {
			if (cCmd == 'R' || cCmd == 'D') return 0;
		/*
			cc = tpcur->xha_id[0];
			c = toupper(cc);
			opt = 0;
			if (c != cc) opt |= AKX_HASX_OPT_CASE_KEY;
		*/
			if (tph=akxs_seqs_new(tpcur->xha_keylen,tpcur->xha_maxreg))
				tpcur->xha_hashb = tph;
			else return errno;
			tph->ha_prereg = tpcur->xha_prereg;
			cc = tpcur->xha_id[0];
			c = toupper(cc);
			if (c != cc) tph->ha_prereg |= AKX_ARGV_USE_ICMP;
/*
printf("akxs_xseqs2: cCmd=%c tph->ha_prereg=%08x\n",cCmd,tph->ha_prereg);
*/
		}
		tph->ha_key = cpKey;
		tph->ha_hix = 0;
		if (cCmd=='S' && cppDat && tpcur->xha_datlen == -2 && tph->ha_id[1]=='L')
			tph->ha_next = (int *)cppDat;
		if (i=akxs_seqs(cCmd,tph)) {
			if (i>0) {
				if ((ret=akxs_dreg_proc(tpcur,cCmd,i,cppDat))<0) return ret;
				i += offset;
			}
			return i;
		}
		tpnext = tpcur->xha_xhnext;
		offset += tpcur->xha_maxreg;
	}
	if (cCmd == 'R' || cCmd == 'D') return i;
	if (!(tpnext=(XHASHB *)Malloc(sizeof(XHASHB)))) return -76;
	tpcur->xha_xhnext = tpnext;
	memcpy(tpnext,tpcur,sizeof(XHASHB));
	tpnext->xha_xhix = l;
	tpnext->xha_hashb = NULL;
	tpnext->xha_xhnext = NULL;
	tpnext->xha_datreg = NULL;
	if ((i = akxs_xseqs2(tpnext,cCmd,cpKey,cppDat))>0) i += offset;
	tpnext->xha_xhix = 0;
	return i;
}

int akxs_xseqs_free(tp_xseqsb)
XHASHB *tp_xseqsb;
{
	HASHB *tph;
	int i;
	char **rpp,*p;

	if (tp_xseqsb) {
		if (tph=tp_xseqsb->xha_hashb) {
#if 1	/* 2021.7.17 */
			akxs_seqs_free(tph);
#else
			akxs_hasx_free(tph);
#endif
		}
		if (p=tp_xseqsb->xha_datreg) {
			if (tp_xseqsb->xha_datlen <= 0) {
				rpp=(char **)p;
#if 1	/* 2021.7.17 */
				if (rpp[0])
#endif
					akxm_cct_mem_free((tdtCONSTCT *)rpp[0]);
			}
			Free(tp_xseqsb->xha_datreg);
		}
		akxs_xseqs_free(tp_xseqsb->xha_xhnext);
		Free(tp_xseqsb);
	}
	return 0;
}

XHASHB *akxs_xseqs_new(sKeyLen,lMaxReg)
short sKeyLen;
int  lMaxReg;
{
	return akxs_xseqs_new2(sKeyLen,lMaxReg,-2);
}

int akxs_xseqs(tp_xseqsb,cCmd,cpKey)
XHASHB *tp_xseqsb;
char cCmd, *cpKey;
{
	return akxs_xseqs2(tp_xseqsb,cCmd,cpKey,NULL);
}

static int _xseqs_chk(tp_xseqsb,cCmd,cpKey,cppDat)
XHASHB *tp_xseqsb;
char cCmd, *cpKey,**cppDat;
{
	XHASHB *tpcur;
	int i,offset,max,next,ix;
	HASHB *tph;
	int ret;
	char cCmdw;

	ret = -1329;
	i = tp_xseqsb->xha_xhix;
	tp_xseqsb->xha_xhix = 0;
	offset = 0;
	tpcur = tp_xseqsb;
	max = tpcur->xha_maxreg;
	while (tpcur) {
		next = offset + max;
		if (next >= i) {
			ret = 0;
			if (tph=tpcur->xha_hashb) {
				tph->ha_hix = ix = i - offset;
				if (cCmd != 'P') tph->ha_key = cpKey;
				else if (cCmd=='S' && cppDat && tpcur->xha_datlen == -2 && tph->ha_id[1]=='L')
					tph->ha_next = (int *)cppDat;
				ret = akxs_seqs(cCmd,tph);
				if (ret > 0) {
					if ((cCmdw=cCmd)=='P' || cCmdw=='K') cCmdw = 'R';
					if ((ret=akxs_dreg_proc(tpcur,cCmdw,ix,cppDat))<0) return ret;
					if ((cCmd == 'P') && cpKey) *(char **)cpKey = tph->ha_key;
					return i;
				}
			}
			break;
		}
		tpcur = tpcur->xha_xhnext;
		offset = next;
	}
	return ret;
}

static int _xseqs_used(tp_xseqsb)
XHASHB *tp_xseqsb;
{
	XHASHB *tpcur;
	int ret,count;
	HASHB *tph;

	count = 0;
	tpcur = tp_xseqsb;
	while (tpcur) {
		tpcur->xha_xhix = 0;
		if (tph=tpcur->xha_hashb) {
			ret = akxs_seqs('U',tph);
			tpcur->xha_xhix = ret;
			if (ret > 0) count += ret;
		}
		tpcur = tpcur->xha_xhnext;
	}
	return count;
}

static int _xseqs_max(tp_xseqsb)
XHASHB *tp_xseqsb;
{
	XHASHB *tpcur;
	int ret,m;
	HASHB *tph;

	m = 0;
	tpcur = tp_xseqsb;
	while (tpcur) {
		m += tpcur->xha_maxreg;
		tpcur = tpcur->xha_xhnext;
	}
	return m;
}

int akxs_seqr_ptr(ptra,max_ptra,ptr)
char *ptra[],*ptr;
int max_ptra;
{
	int i,ii;
/*
printf("akxs_seqr_ptr: ptr=%08x\n",ptr);
*/
	if (!ptra) return -1;
	else if (!ptr) return 0;
	ii = 0;
	for (i=0;i<max_ptra;i++) {
		if (ptra[i] == ptr) {
/*
printf("akxs_seqr_ptr: found ptr=%08x i=%d\n",ptr,i);
*/
			ii= i + 1;
			break;
		}
	}
	return ii;
}

/*
typedef struct tdtBINS_LEAF {
	char *keyp;
	char *datp;
	struct tdtBINS_LEAF *left;
	struct tdtBINS_LEAF *right;
} tdtBINS_LEAF;
*/
HASHB *akxs_bins_new(sKeyLen,sDatLen,iOpt)
short sKeyLen;
short sDatLen;
int   iOpt;
{
	HASHB *tph;

	if (!(tph=(HASHB *)Malloc(sizeof(HASHB)))) return NULL;
	memset(tph,0,sizeof(HASHB));
	tph->ha_id[0] = 'B';
	tph->ha_id[1] = 'S';
	tph->ha_keylen    = sKeyLen;
	tph->ha_maxreg = sDatLen;
	return tph;
}

static void _leaf_free(leaf)
tdtBINS_LEAF *leaf;
{
	if (leaf) {
		if (leaf->keyp) Free(leaf->keyp);
		if (leaf->datp) Free(leaf->datp);
		if (leaf->left)  _leaf_free(leaf->left);
		if (leaf->right) _leaf_free(leaf->right);
printf("_leaf_free: leaf=%08x\n",leaf);
		Free(leaf);
	}
}

int akxs_bins_free(tph)
HASHB *tph;
{
	if (tph) {
		if (tph->ha_reg) _leaf_free((tdtBINS_LEAF *)tph->ha_reg);
		Free(tph);
	}
	return 0;
}

static int _bins_count_leaf(leaf)
tdtBINS_LEAF *leaf;
{
	tdtBINS_LEAF *next;

	if (leaf) {
		if (next=leaf->left)  {
			_bins_count_leaf(next);
			leaf->count_l = next->count_a + 1;
		}
		if (next=leaf->right) {
			_bins_count_leaf(next);
			leaf->count_r = next->count_a + 1;
		}
		leaf->count_a = leaf->count_l + leaf->count_r;
printf("_bins_count_leaf: key=[%s]\n",leaf->keyp);
printf("_bins_count_leaf: count_l=%d count_r=%d\n",leaf->count_l,leaf->count_r);
	}
	return 0;
}

static char *_bins_get_data(datalen,datap)
int datalen;
char *datap;
{
	char *p1,*p2;
	int adlen;

	p2 = NULL;
	if (p1=datap) {
		if (akxt_get_gep_data(datalen,p1,NULL,&adlen) >= 0) {
printf("_bins_get_data: adlen=%d\n",adlen);
			p2 = Memdup(p1,adlen);
		}
	}
	return p2;
}

static tdtBINS_LEAF *_bins_make_leaf(keyp,aklen)
char *keyp;
int  aklen;
{
	tdtBINS_LEAF *leaf;

	if (leaf=(tdtBINS_LEAF *)Malloc(sizeof(tdtBINS_LEAF))) {
		memset(leaf,0,sizeof(tdtBINS_LEAF));
		if (!(leaf->keyp = Memdup(keyp,aklen))) {
			Free(leaf);
			leaf = NULL;
		}
	}
	return leaf;
}

static int _bins_r_key_klen(keylen,keyp1,klen,top_leaf,p_d,p_prev,p_leaf)
int keylen,klen,*p_d;
char *keyp1;
tdtBINS_LEAF *top_leaf,**p_prev,**p_leaf;
{
	int ret,d;
	char *p1,*p2;
	tdtBINS_LEAF *prev,*leaf,*next;

	if (!(p1=keyp1)) return -2;
	d = 0;
	prev = leaf = NULL;
	next = top_leaf;
	while (next) {
		prev = leaf;
		leaf = next;
printf("_bins_r: leaf=%08x L=%08x R=%08x\n",
leaf,leaf->left,leaf->right);
printf("_bins_r: count_l=%d count_r=%d\n",leaf->count_l,leaf->count_r);
		if (p2=leaf->keyp) {
if (!keylen) printf("_bins_r: key=[%s]\n",p2);
			d = akxt_cmp_gep_data(keylen,p1,klen,p2);
printf("_bins_r:    d=%d\n",d);
			if (d > 0) next = leaf->right;
			else if (d < 0) next = leaf->left;
			else {
				ret = 1;
				break;
			}
		}
		else return -4;
	}
	if (p_d)    *p_d    = d;
	if (p_prev) *p_prev = prev;
	if (p_leaf) *p_leaf = leaf;
	return ret;
}

static int _bins_r_key(keylen,keyp1,top_leaf,p_d,p_prev,p_leaf)
int keylen,*p_d;
char *keyp1;
tdtBINS_LEAF *top_leaf,**p_prev,**p_leaf;
{
	char *p1;
	int  klen;

	if (!(p1=keyp1)) return -2;
	if ((klen=akxt_get_gep_data(keylen,p1,&p1,NULL))<0) return -3;
if (!keylen) printf("_bins_r_key: top_leaf=%08x key=[%s]\n",top_leaf,p1);
	return _bins_r_key_klen(keylen,p1,klen,top_leaf,p_d,p_prev,p_leaf);
}

int _bins_proc(func,tph)
char  func;
HASHB *tph;
{
	int keylen,klen,d,aklen,adlen,ret;
	char *p1,*p2;
	tdtBINS_LEAF *prev,*leaf,*next,*next_r,*next_l;

	if (!tph) return -1;
	if (!(p1=tph->ha_key)) return -2;
	keylen = tph->ha_keylen;
	if ((klen=akxt_get_gep_data(keylen,p1,&p1,&aklen))<0) return -3;
if (!keylen) printf("_bins_proc: func=%c key=[%s]\n",func,p1);
	if (func=='S') {
		if (leaf=(tdtBINS_LEAF *)tph->ha_reg) {
			ret = _bins_s_key_klen(tph,p1,klen,aklen,&tph->ha_reg,leaf);
		}
		else {
			if (p1=(char *)tph->ha_next) {
				if (!(p2=_bins_get_data(tph->ha_maxreg,p1))) return -13;
			}
			else p2 = NULL;
			if (!(next=_bins_make_leaf(tph->ha_key,aklen))) return -12;
			next->datp = p2;
			leaf = next;
			tph->ha_reg = (char *)leaf;
printf("_binsrs: s: %c leaf=%08x L=%08x R=%08x\n",
func,next,next->left,next->right);
			ret = 0;
		}
		return ret;
	}

	next = (tdtBINS_LEAF *)tph->ha_reg;
	if ((ret=_bins_r_key_klen(keylen,p1,klen,next,&d,&prev,&leaf)) < 0)
		return ret;

	if (func=='D') {
		if (leaf && !d) {
			/* 폜ꂽleafNĂPOrightNB
			   rightNULL̂Ƃ́AleftNB*/
			next_r = leaf->right;
			next_l = leaf->left;
			if (next_r) next = next_r;
			else next = next_l;
printf("_binsrs: d: %c prev=%08x leaf=%08x L=%08x R=%08x next=%08x\n",
func,prev,leaf,next_l,next_r,next);
			if (prev) {
				/* POleafNĂnextN */
				if (prev->right == leaf)
					prev->right = next;
				else
					prev->left = next;
			}
			else {
				tph->ha_reg = (char *)next;
				prev = next;
			}
			/* rightNꂽ̂Aright͓o^B */
			if (next_r && next_l) {
				if (ret=_bins_s_leaf(keylen,next,next_l)) return ret;
			}
			_bins_count_leaf(prev);
			leaf->right = NULL;
			leaf->left  = NULL;
			_leaf_free(leaf);
			ret = 1;
		}
	}
	else {
		if (leaf && !d) {
			tph->ha_next = (int *)leaf->datp;
			ret = 1;
		}
	}
	return ret;
}

int _bins_s_leaf(keylen,top,aleaf)
int keylen;
tdtBINS_LEAF *top,*aleaf;
{
	int d,ret;
	char *p1;
	tdtBINS_LEAF *leaf;

	if (!(p1=aleaf->keyp)) return -2;
	if ((ret=_bins_r_key(keylen,p1,top,&d,NULL,&leaf))<0) return ret;
	if (leaf) {
		if (d > 0) leaf->right = aleaf;
		else if (d < 0) leaf->left = aleaf;
	}
/*	_bins_count_leaf(top);	*/
	return 0;
}

static int _bins_balance(keylen,pprev,leaf)
int keylen;
tdtBINS_LEAF **pprev,*leaf;
{
	int ret;
	tdtBINS_LEAF *next;

	if (X_DIFF(leaf->count_l,leaf->count_r) > 1) {
		if (leaf->count_l < leaf->count_r) {
			next = leaf->right;
			leaf->count_r = 0;
			leaf->right = NULL;
		}
		else {
			next = leaf->left;
			leaf->count_l = 0;
			leaf->left = NULL;
		}
		*pprev = next;
		ret = _bins_s_leaf(keylen,next,leaf);
	}
	return 0;
}

int _bins_s_key_klen(tph,keyp1,klen,aklen,pprev,leaf)
HASHB *tph;
int klen,aklen;
char *keyp1;
tdtBINS_LEAF **pprev,*leaf;
{
	int ret,d,count,keylen,datalen;
	char *p1,*p2;
	tdtBINS_LEAF **p_prev,*next;

	if (!tph || !keyp1) return -1;
	keylen = tph->ha_keylen;
	ret = 0;
	if (leaf) {
printf("_bins_s_key_klen: leaf=%08x L=%08x R=%08x\n",
leaf,leaf->left,leaf->right);
		if (p2=leaf->keyp) {
if (!keylen) printf("_bins_s_key_klen: key=[%s]\n",p2);
			d = akxt_cmp_gep_data(keylen,keyp1,klen,p2);
printf("_bins_s_key_klen:    d=%d\n",d);
			if (d) {
				if (d > 0) {
					next = leaf->right;
					p_prev = &leaf->right;
				}
				else if (d < 0) {
					next = leaf->left;
					p_prev = &leaf->left;
				}
				if (next) {
					ret= _bins_s_key_klen(tph,keyp1,klen,aklen,p_prev,next);
					count = next->count_a + 1;
					if (next == leaf->right)
						leaf->count_r = count;
					else
						leaf->count_l = count;
					leaf->count_a = leaf->count_l + leaf->count_r;
if (!keylen) printf("_bins_s_key_klen: key=[%s]\n",p2);
printf("_bins_s_key_klen: count_l=%d count_r=%d\n",leaf->count_l,leaf->count_r);						ret = _bins_balance(keylen,pprev,leaf);
					_bins_count_leaf(*pprev);
					return ret;
				}
			}
			if (p1=(char *)tph->ha_next) {
				if (!(p2=_bins_get_data(tph->ha_maxreg,p1))) return -13;
			}
			else p2 = NULL;
			if (d) {
				if (!(next=_bins_make_leaf(tph->ha_key,aklen))) return -12;
				next->datp = p2;
			}
			if (d > 0) {
				leaf->right = next;
				leaf->count_r = 1;
			}
			else if (d < 0) {
				leaf->left = next;
				leaf->count_l = 1;
			}
			else {
				if (leaf->datp) Free(leaf->datp);
				leaf->datp = p2;
				ret = 1;
			}
			leaf->count_a = leaf->count_l + leaf->count_r;
printf("_bins_s_key_klen: leaf=%08x L=%08x R=%08x\n",
leaf,leaf->left,leaf->right);
		}
		else return -4;
	}
	return ret;
}

int akxs_get_KMP_next(char *str, int str_len, int next[])
{
	int i,j,n;

	if (!str || !next) return -1;

	next[0] = -1;
	n = next[0];
	for (i=0;i<str_len;i++) {
		while (n >= 0) {
			if (str[i] == str[n]) break;
			 n = next[n];
		}
		n++;
		j = i + 1;
		if (str[j] == str[n]) next[j] = next[n];
		else next[j] = n;
	}
	return 0;
}

int akxs_find_KMP(char *text, int text_len, char *str, int str_len, int next[])
{
	int ret,text_idx_len,text_idx,n;

	if (!text || !str || !next) return -1;

	if (ret=akxs_get_KMP_next(str,str_len,next)) return ret;

	text_idx_len = text_len - str_len + 1;
	n = 0;
	for (text_idx=0;text_idx<text_idx_len;text_idx++) {
		while (n >= 0) {
			if (text[text_idx] == str[n]) break;
			n = next[n];
		}
		n++;
		if (str_len <= n) return text_idx - str_len + 2;
	}
	return 0;
}

/********************************************************************/
/*  @\ : Pz܂̓O[v\̔z񒆂̕܂͔ԍ	*/
/*		   T[`												*/
/*	 : IN : stra[]   : T[`Ώە|C^z				*/
/*						   1grouṕA󕶎ŏI					*/
/*				max_stra : strãT[`Ώۗvf					*/
/*							< 0 : NULLŏI						*/
/*				str      : T[`								*/
/*				opt      : IvV								*/
/*							= 0x10 : grouping						*/
/*							= 0x20 : O[v擪͔ԍ			*/
/*									 0x10ONƌȂ				*/
/*							= 0x01 : use stricmp()					*/
/*							= 0x02 : use axstricmp()				*/
/*	ԋp : = 0 : vȂ										*/
/*		   > 0 : vsträʒu (擪1)						*/
/*				   opt=0x10̂ON̂ƂAgroup no. (ŏgroup1)	*/
/*				   opt=0x20ON̂ƂA ԍ̈ʒu				*/
/*		   < 0 : |C^NULL										*/
/*	쐬 : 2019/08/23 Akito Kobayashi								*/
/********************************************************************/
int akxs_seqr_str(stra,max_stra,str,opt)
char *stra[],*str;
int max_stra,opt;
{
	int i,ii,ig,opt1,opt2,iNUM,i0;
	char **pp,*p;
/*
printf("akxs_seqr_str: max_stra=%d opt=%08x\n",max_stra,opt);
*/
	if (!stra || !str) return -1;
	if (!max_stra) return 0;
	opt1 = opt & 0x10;
	opt2 = opt & 0x20;
	if (opt2) opt1 = 0x10;
	ii = 0;
	ig = 1;
	iNUM = 0;
	if (opt2) iNUM = 1;
/*
printf("akxs_seqr_str: opt1=%d opt2=%d iNUM=%d str=[%s]\n",opt1,opt2,iNUM,str);
*/
	i0 = 0;
	for (i=0,pp=stra;;i++,pp++) {
		p = *pp;
		if (max_stra >= 0) {
			if (i >= max_stra) break;
		}
		else if (!p) break;
		if (p) {
/*
printf("akxs_seqr_str: i=%d ig=%d i0=%d p=[%s]\n",i,ig,i0,p);
*/
			if (opt1 && !*p) {
				ig++;
				if (opt2) iNUM = 1;
			}
			else if (opt2 && iNUM) {
				i0 = i + 1;
				iNUM = 0;
			}
			else if (!akxs_opt_strcmp(p,str,opt)) {
/*
printf("akxs_seqr_str: found i=%d ig=%d\n",i,ig);
*/
				if (i0 > 0) ii = i0;
				else if (opt1) ii = ig;
				else ii= i + 1;
				break;
			}
		}
	}
/*
printf("akxs_seqr_str: ii=%d\n",ii);
*/
	return ii;
}

/********************************************************************/
/*  @\ : O[v\̔z񒆂̕܂͔ԍT[`		*/
/*   : IN : stra[]   : T[`Ώە|C^z				*/
/*						   group\łA1group͋󕶎ŏI	*/
/*				max_stra : strãT[`Ώۗvf					*/
/*							< 0 : NULLŏI						*/
/*				str      : T[`								*/
/*				opt      : IvV								*/
/*							= 0x01: use stricmp()					*/
/*							= 0x02: use axstricmp()					*/
/*  ԋp : = 0 : vȂ										*/
/*		   > 0 : vstra̔ԍ̈ʒu(擪1)				*/
/*		   < 0 : |C^NULL										*/
/*	쐬 : 2019/08/23 Akito Kobayashi								*/
/********************************************************************/
int akxs_seqr_str_num(stra,max_stra,str,opt)
char *stra[],*str;
int max_stra,opt;
{
	int i,ii,iNUM;
	char **pp,*p;
/*
printf("akxs_seqr_str_num: max_stra=%d opt=%08x\n",max_stra,opt);
*/
	if (!stra || !str) return -1;
	if (!max_stra) return 0;
	iNUM = 1;
/*
printf("akxs_seqr_str_num: iNUM=%d str=[%s]\n",iNUM,str);
*/
	ii = 0;
	for (i=0,pp=stra;;i++,pp++) {
		p = *pp;
		if (max_stra >= 0) {
			if (i >= max_stra) break;
		}
		else if (!p) break;
		if (p) {
/*
printf("akxs_seqr_str_num: i=%d iNUM=%d p=[%s]\n",i,iNUM,p);
*/
			if (!*p) {
				iNUM = 1;
			}
			else if (iNUM) {
				if (!akxs_opt_strcmp(p,str,opt)) {
					ii = i + 1;
/*
printf("akxs_seqr_str_num: found i=%d ig=%d\n",i,ig);
*/
					break;
				}
				iNUM = 0;
			}
		}
	}
/*
printf("akxs_seqr_str_num: ii=%d\n",ii);
*/
	return ii;
}

/********************************************************************/
/*  @\ : ԍƕ̃yA̔z񒆂̕܂͔ԍ		*/
/*		   T[`												*/
/*   : IN : stra[]   : T[`Ώە|C^z				*/
/*						   ԍƕ̃yA						*/
/*				max_stra : strãT[`Ώۗvf					*/
/*							< 0 : NULLŏI						*/
/*				str      : T[`								*/
/*				opt      : IvV								*/
/*							= 0x40 : ԍT[` 				*/
/*							= 0x01 : use stricmp()					*/
/*							= 0x02 : use axstricmp()				*/
/*  ԋp : = 0 : vȂ										*/
/*		   > 0 : vstra̔ԍ̈ʒu(擪1)				*/
/*		   < 0 : |C^NULL										*/
/*	쐬 : 2019/08/23 Akito Kobayashi								*/
/********************************************************************/
int akxs_seqr_str2(stra,max_stra,str,opt)
char *stra[],*str;
int max_stra,opt;
{
	int i,ii,ig,opt4,intval,i1,iNUM,i0;
	char **pp,*p,*p0,*p1;

printf("akxs_seqr_str2: max_stra=%d opt=%08x\n",max_stra,opt);

	if (!stra || !str) return -1;
	opt4 = opt & 0x40;
	if (!max_stra) return 0;
	else if (max_stra > 0) {
		max_stra &= ~0x01;
		if (!max_stra) return 0;
	}

printf("akxs_seqr_str2: str=[%s] max_stra=%d opt4=%d\n",str,max_stra,opt4);

	ii = 0;
	for (i=0,pp=stra;;i+=2) {
		p  = *pp++;
		p1 = *pp++;
		if (max_stra >= 0) {
			if (i >= max_stra) break;
		}
		else if (!p) break;
		if (p) {

printf("akxs_seqr_str2: i=%d p=[%s] p1=[%s]\n",i,p,p1);

			if (opt4) p1 = p;

printf("akxs_seqr_str: p1=[%s]\n",p1);

			if (!akxs_opt_strcmp(p1,str,opt)) {
/*
printf("akxs_seqr_str2: found i=%d ig=%d\n",i,ig);
*/
				ii= i + 1;
				break;
			}
		}
	}
printf("akxs_seqr_str2: ii=%d\n",ii);
	return ii;
}

/********************************************************************/
/*  @\ : Integerz񒆂T[`								*/
/*   : IN : ia[]   : T[`ΏIntegerz						*/
/*				max_ia : iãT[`Ώۗvf						*/
/*				val    : T[`Integerl							*/
/*				opt    : rIvV								*/
/*						 = 0 : ==									*/
/*						 = 1 : &									*/
/*						 = 2 : !=									*/
/*						 = 3 : Ȃől						*/
/*							   ԋpl= 0 : 擪val𒴂Ă	*/
/*  ԋp : = 0 : vȂ										*/
/*		   > 0 : vstra̔ԍ̈ʒu(擪1)				*/
/*		   < 0 : |C^NULL										*/
/*	쐬 : 2019/09/09 Akito Kobayashi								*/
/********************************************************************/
int akxs_iseq_opt(ia,max_ia,val,opt)
int ia[],max_ia,val,opt;
{
	int i,ii,iai,match;

	if (!ia) return -1;
	match = ii = 0;
	for (i=0;i<max_ia;i++) {
		iai = ia[i];
		if (!opt) {
			if (iai == val) match = 1;
		}
		else if (opt == 1) {
			if (iai & val) match = 1;
		}
		else if (opt == 2) {
			if (iai != val) match = 1;
		}
		else if (opt == 3) {
			if (iai > val) {
				ii = i;
				break;
			}
		}
		if (match) {
			ii = i + 1;
			break;
		}
	}
	if (opt==3 && i>=max_ia) ii = max_ia;
	return ii;
}

int akxs_iseq(ia,max_ia,val)
int ia[],max_ia,val;
{
	return akxs_iseq_opt(ia,max_ia,val,0);
}

/********************************************************************/
/*  @\ : ̎wvfʒuɕvf}				*/
/*   : IN : da     : }敶ւ̃|C^					*/
/*				d_pos  : }vfʒu (擪0)						*/
/*						   <0̂Ƃ́A0ƌȂ					*/
/*				max_da : }敶̗vf						*/
/*						   <0̂Ƃ́A0ƌȂ					*/
/*				s_val  : }vfւ̃|C^				*/
/*				size   : vfoCg								*/
/*  ԋp : > 0 : }̗vf (max_da+1)							*/
/*		   < 0 : |C^NULL										*/
/*	쐬 : 2019/09/09 Akito Kobayashi								*/
/********************************************************************/
int akxs_ins_sseq(da,d_pos,max_da,s_val,size)
char *da,*s_val;
int   d_pos,max_da,size;
{
	int i;
	char *pd;

	if (!da || !s_val) return -1;
	if (max_da < 0) max_da = 0;
	if (d_pos < 0) d_pos = 0;
	pd = da + (max_da - 1)*size;
	if (max_da>0 && d_pos>=0 && d_pos<max_da) {
		for (i=d_pos;i<max_da;i++,pd-=size) {
			memcpy(pd+size,pd,size);
		}
	}
	memcpy(pd+size,s_val,size);
	return ++max_da;
}

/********1*********2*********3*********4*********5*********6*********/
/*  @\ : ̎wvfʒuɕvf}				*/
/*   : IN : da     : }敶ւ̃|C^					*/
/*				d_pos  : }vfʒu (擪0)					*/
/*						   <0̂Ƃ́A0ƌȂ					*/
/*				max_da : }敶̗vf						*/
/*						   <0̂Ƃ́A0ƌȂ					*/
/*				sa     : }vfւ̃|C^				*/
/*				s_pos  : }vfʒu (擪0)					*/
/*				n_sa   : }镶̗vf						*/
/*						   <=0̂Ƃ́AȂ					*/
/*				size   : vfoCg								*/
/*				opt    : }vfNAIvV					*/
/*						   <=0 : NAȂ						*/
/*						   = 1 : pXy[XŃNA			*/
/*						   > 1 : [ŃNA					*/
/*  ԋp : > 0 : }̗vf (n_sa)						*/
/*		   < 0 : |C^NULL										*/
/*	쐬 : 2019/09/09 Akito Kobayashi								*/
/********************************************************************/
int akxs_ins_sseq_array(da,d_pos,max_da,sa,s_pos,n_sa,size,opt)
char *da,*sa;
int   d_pos,max_da,s_pos,n_sa,size,opt;
{
	int i;
	char *ps,pad;

	if (!da || !sa) return -1;
	if (s_pos < 0) s_pos = 0;
	if (opt == 1) pad = ' ';
	else if (opt > 1)pad = '\0';
	ps = sa + s_pos*size;
	for (i=0;i<n_sa;i++) {
		max_da = akxs_ins_sseq(da,d_pos,max_da,ps,size);
		if (opt > 0) memset(ps,pad,size);
		d_pos++;
		ps += size;
	}
	return n_sa;
}

/********************************************************************/
/*  @\ : shortz̎wvfʒushortvf}				*/
/*   : IN : da     : }shortzւ̃|C^				*/
/*				d_pos  : }vfʒu (擪0)					*/
/*						   <0̂Ƃ́A0ƌȂ					*/
/*				max_da : }shortz̗vf					*/
/*						   <0̂Ƃ́A0ƌȂ					*/
/*				s_val  : }shortl								*/
/*  ԋp : > 0 : }̗vf (max_da+1)							*/
/*		   < 0 : |C^NULL										*/
/*	쐬 : 2019/09/09 Akito Kobayashi								*/
/********************************************************************/
int akxs_ins_shseq(da,d_pos,max_da,s_val)
short da[],s_val;
int   d_pos,max_da;
{
#if 1
	return akxs_ins_sseq(da,d_pos,max_da,&s_val,sizeof(short));
#else
	int i;
	short *pd;

	if (max_da < 0) max_da = 0;
	if (d_pos < 0) d_pos = 0;
	pd = da + max_da - 1;
	if (max_da>0 && d_pos>=0 && d_pos<max_da) {
		for (i=d_pos;i<max_da;i++,pd--) {
			*(pd+1) = *pd;
		}
	}
	*(pd+1) = s_val;
	return ++max_da;
#endif
}

/********1*********2*********3*********4*********5*********6*********/
/*  @\ : shortz̎wvfʒushortzvf}			*/
/*   : IN : da     : }shortzւ̃|C^				*/
/*				d_pos  : }vfʒu (擪0)					*/
/*						   <0̂Ƃ́A0ƌȂ					*/
/*				max_da : }shortz̗vf					*/
/*						   <0̂Ƃ́A0ƌȂ					*/
/*				sa     : }shortzvfւ̃|C^			*/
/*				s_pos  : }vfʒu (擪0)					*/
/*				n_sa   : }镶̗vf						*/
/*						   <=0̂Ƃ́AȂ					*/
/*				size   : vfoCg								*/
/*				opt    : }vfNAIvV					*/
/*						   <=0 : NAȂ						*/
/*						   >=1 : [ŃNA					*/
/*  ԋp : > 0 : }̗vf (n_sa)						*/
/*		   < 0 : |C^NULL										*/
/*	쐬 : 2019/09/09 Akito Kobayashi								*/
/********************************************************************/
int akxs_ins_shseq_array(da,d_pos,max_da,sa,s_pos,n_sa,opt)
short da[],sa[];
int   d_pos,max_da,s_pos,n_sa,opt;
{
#if 1
	if (opt == 1) opt = 2;
	return akxs_ins_sseq_array(da,d_pos,max_da,sa,s_pos,n_sa,sizeof(short),opt);
#else
	int i;
	short *ps;

	if (s_pos < 0) s_pos = 0;
	ps = sa + s_pos;
	for (i=0;i<n_sa;i++) {
		max_da = akxs_ins_shseq(da,d_pos,max_da,*ps);
		if (opt) *ps = 0;
		d_pos++;
		ps++;
	}
	return n_sa;
#endif
}

/********1*********2*********3*********4*********5*********6*********/
/*  @\ : [̕sPʂŃT[`					*/
/*   : IN : pat     : T[`镶ւ̃|C^				*/
/*				pat_len : T[`镶̒(oCg)			*/
/*				mem     : T[`Ώەւ̃|C^				*/
/*				mem_len : T[`Ώە̒(oCg)			*/
/*  ԋp : > 0 : patɈvs̐擪ʒu(mem̐擪1oCgڂƂ)*/
/*		   < 0 : |C^NULL										*/
/*	쐬 : 2020/12/XX Akito Kobayashi								*/
/********************************************************************/
int akxs_sseq_mline(pat,patlen,mem,memlen)
char *pat,*mem;
int patlen,memlen;
{
	SSP_S ssp;
	int ret,sp,len;

	if (!pat || !mem) return -1;
	ret = 0;
/*
printf("akxs_sseq_mline: patlen=%d pat=[%s]\n",patlen,pat);
*/
	if (patlen>0 && memlen>=patlen) {
		memset(&ssp,0,sizeof(SSP_S));
		sp = 0;
		while ((len=akxtmgetline(mem, memlen, &ssp)) >= 0 ) {
/*
printf("akxs_sseq_mline: len=%d ssp.wd=[%s]\n",len,strmem(ssp.wd,len));
*/
			if (len==patlen && !memcmp(ssp.wd,pat,patlen)) {
				ret = sp + 1;
				break;
			}
			sp = ssp.sp;
		}
	}
	return ret;
}
