/*
 * Decompiled with CFR 0.152.
 */
package jp.nanah.bastub.util;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import jp.nanah.bastub.data.KvData;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BastubUtils {
    private static final Logger logger = LoggerFactory.getLogger(BastubUtils.class);
    private static SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");

    @SafeVarargs
    public static <T> List<T> toValidList(Optional<T> ... vals) {
        ArrayList<T> list = new ArrayList<T>();
        for (Optional<T> v : vals) {
            if (!v.isPresent()) continue;
            list.add(v.get());
        }
        return list;
    }

    public static File getPagedataPath(File dir, String filename, String method, String ext) {
        File fileByMethod = new File(dir, filename + "_" + method + ext);
        if (fileByMethod.exists()) {
            return fileByMethod;
        }
        File fileAll = new File(dir, filename + ext);
        if (fileAll.exists()) {
            return fileAll;
        }
        return fileAll;
    }

    public static void replacePathValue(List<String> valueList, List<String> pathList) {
        for (int i = 0; i < valueList.size(); ++i) {
            int index;
            String val = valueList.get(i);
            if (!val.startsWith("$") || (index = Integer.parseInt(val.substring(1)) - 1) >= pathList.size()) continue;
            valueList.set(i, pathList.get(index));
        }
    }

    public static KvData toKvData(List<String> valueList) {
        int n = valueList.size();
        List<String> k = valueList.subList(0, n - 1);
        String v = valueList.get(n - 1);
        KvData kv = new KvData(k, v);
        return kv;
    }

    public static boolean equalsKey(List<String> v1, List<String> v2) {
        if (v1 == null && v2 == null) {
            return true;
        }
        if (v1 == null || v2 == null) {
            return false;
        }
        if (v1.size() != v2.size()) {
            return false;
        }
        for (int i = 0; i < v1.size(); ++i) {
            if (v1.get(i).equals(v2.get(i))) continue;
            return false;
        }
        return true;
    }

    public static List<String> getRowValueList(Row row, boolean blankOk) {
        ArrayList<String> keyList = new ArrayList<String>();
        int coltop = row.getFirstCellNum();
        short colend = row.getLastCellNum();
        for (int i = coltop; i < colend; ++i) {
            Cell cell = row.getCell(i);
            String s = BastubUtils.getCellText(cell);
            if (i == coltop && StringUtils.startsWith((CharSequence)s, (CharSequence)"#")) break;
            if (StringUtils.isBlank((CharSequence)s) && !blankOk) continue;
            keyList.add(s);
        }
        return keyList;
    }

    public static String getCellText(Cell cell) {
        if (cell == null) {
            return null;
        }
        try {
            if (cell.getCellType() == CellType.STRING) {
                return cell.getStringCellValue();
            }
            if (cell.getCellType() == CellType.NUMERIC) {
                return String.valueOf((int)cell.getNumericCellValue());
            }
            if (cell.getCellType() == CellType.FORMULA) {
                CellType formulaType = cell.getCachedFormulaResultType();
                if (formulaType == CellType.NUMERIC) {
                    return String.valueOf(cell.getNumericCellValue());
                }
                return String.valueOf(cell.getStringCellValue());
            }
            if (cell.getCellType() == CellType._NONE) {
                return cell.getStringCellValue();
            }
        }
        catch (Exception e) {
            logger.warn("\u5909\u63db\u7570\u5e38", (Throwable)e);
        }
        return null;
    }

    public static boolean isBlankRow(Row row) {
        int coltop = row.getFirstCellNum();
        short colend = row.getLastCellNum();
        for (int i = coltop; i <= colend; ++i) {
            Cell cell = row.getCell(i);
            String s = BastubUtils.getCellText(cell);
            if (!StringUtils.isNotBlank((CharSequence)s)) continue;
            return false;
        }
        return true;
    }

    public static void printJsonTree(String path, JSONObject json) throws JSONException {
        Iterator it = json.keys();
        while (it.hasNext()) {
            String here;
            String key = (String)it.next();
            JSONObject val = json.optJSONObject(key);
            String string = here = StringUtils.isEmpty((CharSequence)path) ? key : path + "." + key;
            if (json.optJSONArray(key) != null) {
                logger.debug("** ARRAY **[{}]", (Object)key);
                JSONArray jsarray = json.getJSONArray(key);
                for (int i = 0; i < jsarray.length(); ++i) {
                    if (jsarray.optJSONObject(i) != null) {
                        logger.debug(">>>>[{}]", (Object)here);
                        BastubUtils.printJsonTree(here + "[" + i + "]", jsarray.getJSONObject(i));
                        continue;
                    }
                    logger.debug("*key=[{}] value=[{}]", (Object)(here + "[" + i + "]"), (Object)jsarray.optString(i));
                }
                continue;
            }
            if (json.optJSONObject(key) != null) {
                BastubUtils.printJsonTree(here, json.getJSONObject(key));
                continue;
            }
            logger.debug("@key=[{}] value=[{}]", (Object)here, (Object)json.optString(key));
        }
    }

    public static int getColumnNoForReplace(String v, List<Row> rowList, String defaultColumnName) {
        if (rowList.size() <= 1) {
            return -1;
        }
        boolean isToNumber = v.endsWith("#N");
        if (isToNumber) {
            v = v.substring(0, v.length() - 2);
        }
        if (v.startsWith("${") && v.endsWith("}")) {
            String matchName = v.substring(2, v.length() - 1);
            if (matchName.equals("")) {
                matchName = defaultColumnName;
            }
            Row row = rowList.get(0);
            int coltop = row.getFirstCellNum();
            short colend = row.getLastCellNum();
            for (int i = coltop; i <= colend; ++i) {
                String cellv = BastubUtils.getCellText(row.getCell(i));
                if (cellv == null || !cellv.equals(matchName)) continue;
                return i;
            }
        }
        return -1;
    }

    public static int getNumberLast(String s, int n) {
        int last = s.indexOf("}", n);
        if (last < 0) {
            return -1;
        }
        for (int i = n - 1; i >= 0; --i) {
            char c = s.charAt(i);
            if (Character.isWhitespace(c)) continue;
            if (c != ':') break;
            return last + 1;
        }
        return -1;
    }

    public static boolean isArrayExists(JSONObject json) throws JSONException {
        Iterator it = json.keys();
        while (it.hasNext()) {
            boolean b;
            String key = (String)it.next();
            if (json.optJSONArray(key) != null) {
                return true;
            }
            if (json.optJSONObject(key) == null || !(b = BastubUtils.isArrayExists(json.getJSONObject(key)))) continue;
            return true;
        }
        return false;
    }

    public static synchronized String replaceEmbedText(String s) {
        s = s.replaceAll("##SYSYMD##", dateFormat.format(new Date()));
        s = s.replaceAll("##SYSMSEC##", String.valueOf(System.currentTimeMillis()));
        return s;
    }

    public static boolean equals(List<String> list1, List<String> list2) {
        if (list1.size() != list2.size()) {
            return false;
        }
        for (int i = 0; i < list1.size(); ++i) {
            if (StringUtils.equals((CharSequence)list1.get(i), (CharSequence)list2.get(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean equalsTail(List<String> list1, List<String> list2) {
        int size2;
        int size1 = list1.size();
        if (size1 < (size2 = list2.size())) {
            list2 = list2.subList(size2 - size1, size2);
        } else if (size1 > size2) {
            list1 = list1.subList(size1 - size2, size1);
        }
        return BastubUtils.equals(list1, list2);
    }
}

