/*
 * Decompiled with CFR 0.152.
 */
package org.ccc.atools.command;

import org.ccc.atools.command.ICommand;
import org.ccc.atools.command.extention.ICommandDelegate;
import org.ccc.atools.mediator.Console;

public abstract class AbstractCommand
implements ICommand {
    protected ICommandDelegate commandDelegate;
    protected String input;
    protected String output;
    protected Object option;

    public ICommandDelegate getCommandDelegate() {
        return this.commandDelegate;
    }

    public String getInput() {
        return this.input;
    }

    public String getOutput() {
        return this.output;
    }

    public Object getOption() {
        return this.option;
    }

    @Override
    public void setCommand(ICommandDelegate commandDelegate, String input, String output, Object option) {
        this.commandDelegate = commandDelegate;
        this.input = input;
        this.output = output;
        this.option = option;
    }

    @Override
    public void execute() {
        String[] command = this.preExecute();
        try {
            if (this.option instanceof Console) {
                ((Console)this.option).execForConsole(command);
            }
        }
        finally {
            this.postExecute();
        }
    }

    protected String[] preExecute() {
        return new String[0];
    }

    protected String[] postExecute() {
        return new String[0];
    }

    @Override
    public int getResult(String input, String output) {
        if (this.input != null && this.output != null && this.input.equals(input) && this.output.equals(output) && this.option instanceof Console) {
            return ((Console)this.option).getResultForConsole();
        }
        return 0;
    }
}

