/*
 * Decompiled with CFR 0.152.
 */
package org.ccc.atools.ui.view.filter;

import java.util.ArrayList;
import java.util.Map;
import org.ccc.atools.command.extention.CommandInfo;
import org.ccc.atools.command.extention.CommandRegistry;
import org.ccc.atools.command.extention.ICommandDelegate;
import org.ccc.atools.command.filter.FilteringConverter;
import org.ccc.atools.command.filter.extention.CommandFilterInfo;
import org.ccc.atools.command.filter.extention.CommandFilterRegistry;
import org.ccc.atools.command.filter.extention.ICommandFilterDelegate;
import org.ccc.atools.internal.command.NullConverter;
import org.ccc.atools.mediator.AToolUI;
import org.ccc.atools.message.Messages;
import org.ccc.atools.ui.view.ConvertView;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;

public class FilteringConverterView
extends ConvertView {
    private static final String SCALE_MENU_LABEL = Messages.ConvertView_SCALE_MENU_LABEL;
    private static final String SCALE_TO_COPY_ACTION_MASSAGE_LABEL = Messages.ConvertView_SCALE_TO_COPY_ACTION_MASSAGE_LABEL;
    public static final String ID = "org.ccc.HighConverterView";
    String filter;

    @Override
    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.ajustDiff(parent);
    }

    private void ajustDiff(Composite parent) {
        this.ajustDiffForEditFilter(parent);
        this.ajustActionBars();
    }

    private void ajustDiffForEditFilter(Composite parent) {
        this.ajustDiffForEditFilterByCommandField(parent);
        this.ajustDiffForEditFilterByActionBars();
    }

    private void removeSelectionListener(Button button) {
        Listener listener2;
        if (!button.isListening(13)) {
            return;
        }
        if (!button.isListening(14)) {
            return;
        }
        ArrayList<Listener> selectionListeners = new ArrayList<Listener>();
        Listener[] listenerArray = button.getListeners(13);
        int n = listenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            listener2 = listenerArray[n2];
            selectionListeners.add(listener2);
            ++n2;
        }
        listenerArray = button.getListeners(14);
        n = listenerArray.length;
        n2 = 0;
        while (n2 < n) {
            listener2 = listenerArray[n2];
            selectionListeners.add(listener2);
            ++n2;
        }
        for (Listener listener2 : selectionListeners) {
            TypedListener typedListener;
            SWTEventListener eventListener;
            if (!(listener2 instanceof TypedListener) || !((eventListener = (typedListener = (TypedListener)listener2).getEventListener()) instanceof SelectionListener)) continue;
            button.removeSelectionListener((SelectionListener)eventListener);
        }
    }

    private void ajustDiffForEditFilterByCommandField(Composite parent) {
        this.removeSelectionListener(this.commandButton);
        this.commandButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (FilteringConverterView.this.commandButton.getClass().isInstance(e.getSource()) && FilteringConverterView.this.commandButton.isEnabled()) {
                    FilteringConverter converter = null;
                    converter = FilteringConverterView.this.scale == null ? new FilteringConverter() : new FilteringConverter(FilteringConverterView.this.scale);
                    ICommandDelegate commandDelegate = null;
                    if (FilteringConverterView.this.encode == null) {
                        commandDelegate = new NullConverter();
                    } else {
                        Map<String, CommandInfo> encodeToCommandInfos = CommandRegistry.getInstance().getEncodeToCommandInfos();
                        CommandInfo commandInfo = encodeToCommandInfos.get(FilteringConverterView.this.encode);
                        commandDelegate = commandInfo.getCommand();
                    }
                    if (FilteringConverterView.this.filter != null) {
                        Map<String, CommandFilterInfo> filterToCommandFilterInfos = CommandFilterRegistry.getInstance().getFilterToCommandFilterInfos();
                        CommandFilterInfo commandFilterInfo = filterToCommandFilterInfos.get(FilteringConverterView.this.filter);
                        ICommandFilterDelegate commandFilterDelegate = commandFilterInfo.getCommandFilter();
                        converter.setCommandFilterDelegate(commandFilterDelegate);
                    }
                    converter.setCommand(commandDelegate, FilteringConverterView.this.fileInfo.getSourcePath().toOSString(), FilteringConverterView.this.fileInfo.getTargetPath().toOSString(), new AToolUI());
                    FilteringConverterView.this.commandManager.setCommand(converter);
                    FilteringConverterView.this.commandManager.execute();
                }
            }
        });
    }

    private void ajustDiffForEditFilterByActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        IMenuManager manager = bars.getMenuManager();
        MenuManager subMenu3 = new MenuManager("Filter Type");
        subMenu3.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJS_TASK_TSK"));
        ArrayList<String> filters = new ArrayList<String>(CommandFilterRegistry.getInstance().getFilterToCommandFilterInfos().keySet());
        filters.sort(String::compareTo);
        for (String filterType : filters) {
            Action action = new Action(filterType, 8){

                public void run() {
                    FilteringConverterView.this.filter = filterType;
                }
            };
            subMenu3.add((IAction)action);
        }
        manager.add((IContributionItem)subMenu3);
        manager.add((IContributionItem)new Separator());
    }

    private void ajustActionBars() {
        this.ajustActionBarsOfScale();
        this.ajustActionBarsOfEncode();
    }

    private void ajustActionBarsOfScale() {
        IActionBars bars = this.getViewSite().getActionBars();
        MenuManager menu = this.findMenu(bars.getMenuManager().getItems(), SCALE_MENU_LABEL);
        if (menu != null) {
            IContributionItem[] iContributionItemArray = menu.getItems();
            int n = iContributionItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                IContributionItem item = iContributionItemArray[n2];
                if (item instanceof ActionContributionItem) {
                    IAction action = ((ActionContributionItem)item).getAction();
                    if (SCALE_TO_COPY_ACTION_MASSAGE_LABEL.equals(action.getText())) {
                        action.setChecked(true);
                        action.run();
                    } else {
                        if (action.isChecked()) {
                            action.setChecked(false);
                        }
                        action.setEnabled(false);
                    }
                }
                ++n2;
            }
        }
    }

    private void ajustActionBarsOfEncode() {
        IActionBars bars = this.getViewSite().getActionBars();
        MenuManager menu = this.findMenu(bars.getMenuManager().getItems(), "Encode Type");
        if (menu != null) {
            IContributionItem[] iContributionItemArray = menu.getItems();
            int n = iContributionItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                IAction action;
                IContributionItem item = iContributionItemArray[n2];
                if (item instanceof ActionContributionItem && (action = ((ActionContributionItem)item).getAction()).isChecked()) {
                    action.run();
                }
                ++n2;
            }
        }
    }

    private MenuManager findMenu(IContributionItem[] children, String name) {
        IContributionItem[] iContributionItemArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            MenuManager subMenu;
            IContributionItem child = iContributionItemArray[n2];
            MenuManager menu = this.findMenuManager(child, name);
            if (menu != null) {
                return menu;
            }
            if (child instanceof MenuManager && (subMenu = this.findMenu(((MenuManager)child).getItems(), name)) != null) {
                return subMenu;
            }
            ++n2;
        }
        return null;
    }

    private MenuManager findMenuManager(IContributionItem parent, String name) {
        MenuManager menu;
        if (parent instanceof MenuManager && name.equals((menu = (MenuManager)parent).getMenuText())) {
            return menu;
        }
        return null;
    }
}

