/*
 Copyright (C) 2022 Momi-g
 Copyright 2005 The Geany contributors

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 3 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program. If not, see <http://www.gnu.org/licenses/>.
*/

/*SH_doc
title=emsnip section=3 repnl=\040

@name emsnip
@_brief geany plugin, snippet complete with end match instead of word match
@_syno -
@tl_dr
		@(code)@
	// build shared lib, emsnip.so
	~$ cc emsnip.c -o emsnip.so -shared -fPIC `pkg-config --cflags geany`
	~$ cp emsnip.so ~/.config/geany/plugins/	#mkdir if /plugins isnt
	
	//plugin_load: run geany >> menubar >> tool >> plugins and set keybind
	//test working  'else if[tab]' and 'helloif[tab]'
		@()@
@_desc
	geany uses snippet complete with word match and needs leading 
	blankchar (whitechar).
	--
		@(code)
	eg) hello for[tab]	>> hello for(;;){} (replace)
	    hellofor[tab] >> hellofor (no replace)
		@()
	--
	this plugin allows you to use end match complete.
	--
		@(code)
	eg) hello for[tab]	>> hello for(;;){}
	    hellofor[tab] >> hellofor(;;){}
		@()
	--
	conflicting keybinds priority is undefined. maybe exec after default 
	keybindings. --
	geany srccode editor.c >> on_key_press_event() uses glib foreach() which
	uses liner list search. --
	--
	restrictions: --
	- snippet trigger strsz is hardcoded, must be less than 6 bytes --
	- dont set keybinding to 'space key'
@_eg
		@(code)@
	--snippets.conf
	...
	({=(){}
	
	--editor
	main({[tab]    >> main(){}
	myfunc({[tab]  >> myfunc(){}
	(dfl needs leading space, 'main ({[tab]' >> 'main (){}' )
		@()@

@return_value -
@notes	-
@conforming_to POSIX.1-2001+, needs 'pkg-config' 'geanyplugin.h'
@COPYRIGHT
	Copyright 2022 momi-g, GPLv3+ --
	Copyright 2005 The Geany contributors
@_ver 2022-06-08 v1.0.3 (2022-05-13 v1.0.0)
@_see
	https://raw.githubusercontent.com/geany/geany/master/HACKING
	https://www.geany.org/manual/reference/
//SH_docE*/
/* tool macros */
#ifndef ERRact
#include <stdio.h>
 #if (199901L <= __STDC_VERSION__ +0)	/* nealy 200112L, _POSIX_C_SOURCE	c99*/
	#include <sys/types.h>
	#include <unistd.h>
	#define ERRactag	__func__, getpid()
 #else
	#define ERRactag	"func:c99+", 0
 #endif
 #include <string.h>
 #include <errno.h>
 #define ERRact(xpr, msg, act)	if(xpr){ int en_=errno; fprintf(stderr, \
	"ERR: %s %d %s() pid:%d %s msg:%s sys:%s\n",__FILE__,__LINE__, ERRactag \
	, "hit(" #xpr ")", msg, strerror(en_) ); act; }
 #define STOP(xpr, msg)	ERRact(xpr, msg, fputs("STOP\n",stderr);exit(1) )
#endif

#define loop(a)		for(int lpcnt=1;lpcnt<=(a);lpcnt++)
/*tool end*/


#include <geany/geanyplugin.h>	/*SH_co* `pkg-config --cflags geany --libs geany` */

//dbgtool
#define gpf(...) gpf_impl( __LINE__, __VA_ARGS__)
#define gpf_impl(...) gpf_impl_(__VA_ARGS__)
#define gpf_impl_(n, ...) {char sbuf[100]={0};snprintf((void*)sbuf, 99, __VA_ARGS__); strcat(sbuf, " :" #n); dialogs_show_msgbox(GTK_MESSAGE_INFO, (void*)sbuf);}

//trigger maxsz
#define EMAX 6

// plugin connector
static gboolean fs_load(GeanyPlugin* obj, gpointer udata);
static void fs_unload(GeanyPlugin* obj, gpointer udata);
static void fs_helpcb(GeanyPlugin* obj, gpointer udata);
//static void fs_cfgcb(GeanyPlugin* obj, gpointer udata);
//static void fs_act(guint keyid);
static gboolean fs_act(GeanyKeyBinding* key, guint keyid, gpointer user_data);

void geany_load_module(GeanyPlugin* pobj){
	pobj->info->name = "emsnip";
	pobj->info->description = "snippets complete with end match instead of word match";
	pobj->info->version = "v1.0.3"+1;
	pobj->info->author = "momi-g <dmy@dmy.dmy>";

	pobj->funcs->init = fs_load;	
	pobj->funcs->cleanup = fs_unload;
	pobj->funcs->configure = NULL; //fs_cfgcb;
	pobj->funcs->help = fs_helpcb;	
	pobj->funcs->callbacks = NULL;

	GEANY_PLUGIN_REGISTER(pobj, 226);
	return;
}

static const char* hmsg =
"EMSNIP(3)                  Library Functions Manual                  EMSNIP(3)\n"
"\n"
"\n"
"\n"
"NAME\n"
"       emsnip  - geany plugin, snippet complete with end match instead of word\n"
"       match\n"
"\n"
"SYNOPSIS\n"
"       -\n"
"\n"
"\n"
"\n"
"TL_DR\n"
"       // build shared lib, emsnip.so\n"
"       ~$ cc emsnip.c -o emsnip.so -shared -fPIC `pkg-config --cflags geany`\n"
"       ~$ cp emsnip.so ~/.config/geany/plugins/     #mkdir if /plugins isnt\n"
"\n"
"       //plugin_load: run geany >> menubar >> tool >> plugins and set keybind\n"
"       //test working  'else if[tab]' and 'helloif[tab]'\n"
"\n"
"\n"
"DESCRIPTION\n"
"       geany  uses  snippet  complete  with  word  match  and  needs   leading\n"
"       blankchar (whitechar).\n"
"\n"
"            eg) hello for[tab]  >> hello for(;;){} (replace)\n"
"                hellofor[tab] >> hellofor (no replace)\n"
"\n"
"       this plugin allows you to use end match complete.\n"
"\n"
"            eg) hello for[tab]  >> hello for(;;){}\n"
"                hellofor[tab] >> hellofor(;;){}\n"
"\n"
"       conflicting  keybinds  priority  is undefined. maybe exec after default\n"
"       keybindings.\n"
"       geany srccode editor.c  >>  on_key_press_event()  uses  glib  foreach()\n"
"       which uses liner list search.\n"
"\n"
"       restrictions:\n"
"       - snippet trigger strsz is hardcoded, must be less than 6 bytes\n"
"       - dont set keybinding to 'space key'\n"
"\n"
"EXSAMPLE\n"
"       --snippets.conf\n"
"       ...\n"
"       ({=(){}\n"
"\n"
"       --editor\n"
"       main({[tab]    >> main(){}\n"
"       myfunc({[tab]  >> myfunc(){}\n"
"       (dfl needs leading space, 'main ({[tab]' >> 'main (){}' )\n"
"\n"
"\n"
"RETURN_VALUE\n"
"       -\n"
"\n"
"NOTES\n"
"       -\n"
"\n"
"CONFORMING_TO\n"
"       POSIX.1-2001+, needs 'pkg-config' 'geanyplugin.h'\n"
"\n"
"COPYRIGHT\n"
"       Copyright 2022 momi-g, GPLv3+\n"
"       Copyright 2005 The Geany contributors\n"
"\n"
"VERSION\n"
"       2022-06-08 v1.0.3 (2022-05-13 v1.0.0)\n"
"\n"
"SEE_ALSO\n"
"       https://raw.githubusercontent.com/geany/geany/master/HACKING\n"
"       https://www.geany.org/manual/reference/\n"
"\n"
"\n"
"\n"
"                                                                     EMSNIP(3)\n"
;

static void showhelp(const char* s){
    GtkWidget *tx, *w, *scr_v;
    GtkTextBuffer* tbuf;

    w = gtk_window_new(GTK_WINDOW_TOPLEVEL);
    gtk_window_set_default_size(GTK_WINDOW(w), 600, 400);
    
    scr_v = gtk_scrolled_window_new(NULL, NULL); 
    tx = gtk_text_view_new();

    tbuf = gtk_text_view_get_buffer(GTK_TEXT_VIEW(tx));
    gtk_text_buffer_set_text(tbuf, s, -1);

    gtk_container_add(GTK_CONTAINER(scr_v), tx);
    gtk_container_add(GTK_CONTAINER(w), scr_v);
    gtk_widget_show_all(w);
}



static void fs_helpcb(GeanyPlugin* pobj, gpointer udata){
	showhelp(hmsg);
//	dialogs_show_msgbox(GTK_MESSAGE_INFO, hmsg);
}

static gboolean fs_load(GeanyPlugin* pobj, gpointer udata){
	GeanyKeyGroup *key_group;
	key_group = plugin_set_key_group(pobj, "emsnip", 1, NULL);
	keybindings_set_item_full(key_group		/* GeanyKeyGroup* */
		, 0 /* groupid, 0,1,2... above ag3 idx */
		, 0	/* dfl-key GDK_KEY_j etc.  but set 0 to avoid user keybind conflict */
		, 0	/* dfl-mod GDK_CONTROL_MASK */
		, "emsnip"	/* namestr: APIname to use in config.ini "str" == myf() bindings */
		, "run emsnip"	/* label: desc in keybind config window */
		, NULL	/* additionally, GtkWidget* (btn etc) exec this kb. set NULL if nouse */
		, fs_act	/* gboolean f(GeanyKeyBinding *key, guint keyid, gpointer user_data) */
		, pobj	/* void* udata you want to pass the cb */
		, NULL	/* destructor, free() etc */ 
	);
	return TRUE;
}
static void fs_unload(GeanyPlugin* obj, gpointer udata){ ; }

static int f_emsnip_act(int keyid, GeanyPlugin* pobj);
gboolean fs_act(GeanyKeyBinding* kobj, guint keyid, gpointer udata){
//	dialogs_show_msgbox(GTK_MESSAGE_INFO, "123");
	GeanyPlugin* pobj = udata;
	int rc = f_emsnip_act(keyid, pobj);
// true/false == eat/fall-through 
// https://www.geany.org/manual/reference/keybindings_8h.html
	if(rc){return FALSE;}
	return TRUE;
}
//plugin connector end


//emsnip code 

#include "emsnip.h"
//#include "msgp.h"

extern GeanyMainWidgets		main_widgets;
extern GeanyEditorPrefs		editor_prefs;
extern GeanyKeyGroup* keybindings_get_core_group(guint id);
extern GeanyKeyBinding* keybindings_lookup_item(guint group_id, guint key_id);

static GHashTable *snippet_hash = NULL;
static gboolean at_eol(ScintillaObject *sci, gint pos);
static int do_replace(GeanyEditor* editor, gint pos, char** kv);

//static int f_emsnip_act(int keyid, GeanyPlugin* pobj);
static char** emsnip_word_stem(GeanyDocument* doc, char* extstr);
static char* f_gettail(GeanyDocument *doc);


// copied: keybindings.c/cb_func_editor_action()
static int f_emsnip_act(int keyid, GeanyPlugin* pobj){
//keyid doesnt use
	snippet_hash = g_hash_table_new_full(
		g_str_hash, g_str_equal, g_free, (GDestroyNotify) g_hash_table_destroy
	);

	GeanyDocument *doc = document_get_current();
	GtkWidget *focusw = gtk_window_get_focus(
		GTK_WINDOW(pobj->geany_data->main_widgets->window)
	);
//skip if sci_widget has no nofocus
	if (doc == NULL || focusw != GTK_WIDGET(doc->editor->sci) ){ return 1; }

//copied: keybindings.c/check_snippet_completion(doc);
	ScintillaObject *sci = doc->editor->sci;
	gint pos = sci_get_current_position(sci);
	if(! pobj->geany_data->editor_prefs->complete_snippets){return 1;}	//skip if nouse flg: snippet 

//copied: editor.c/editor_complete_snippet()
	if (sci_has_selection(sci)){ return 1;}	//skip if cursor stat is 'str_select'

//specialcase: kb==spc: works only at eol or while_flg
// useless geany API and doc. omit spc keybind flg
//keybindings.h
//plugin API lookup_item >> get_item
//	int b_spc = (keybindings_lookup_item(GEANY_KEY_GROUP_EDITOR
//		, GEANY_KEYS_EDITOR_COMPLETESNIPPET)->key == GDK_KEY_space);
//	GeanyKeyGroup* g = keybindings_get_core_group(GEANY_KEY_GROUP_EDITOR);
//	int b_spc = (keybindings_get_item(g, GEANY_KEYS_EDITOR_COMPLETESNIPPET)->key == GDK_KEY_space);

//原因不明だがflg,eol系はスキップしないと中途補完がきかないようだ。
//	int b_spc=0;
//	int b_wflg = editor_prefs.complete_snippets_whilst_editing;
//	int b_wflg = pobj->geany_data->editor_prefs->complete_snippets_whilst_editing;
//	int b_eol  = at_eol(sci, pos);
//	while(b_spc){
//		if(b_eol){break;}
//		if(b_wflg){break;}
//		return 1;
//	}
// skip_end
//--core_code: editor.c/editor_complete_snippet()
//get geany snippet hash
	int extid = doc->editor->document->file_type->id;
	GeanyFiletype* ft = filetypes_index(extid);

//get ematch snip
	char** kv = emsnip_word_stem(doc, ft->name);
	if(kv==NULL){ kv = emsnip_word_stem(doc, "Default"); }
	if(kv==NULL){ return 1;}		//no snippet

//do replace
	sci_start_undo_action(sci);	/* needed because we insert a space separately from construct */
	do_replace(doc->editor, pos, kv);
	sci_end_undo_action(sci);

//suc
	return 0;
}	

//get endstr matching snippet. check both XXX.ext/"Default" hash
//editor.c/editor_read_word_stem()
static char** emsnip_word_stem(GeanyDocument* doc, char* extstr){
	static char* kv[2] = {NULL, NULL};
	
	char* key = NULL;
	char* val = NULL;
	char** rp = NULL;
	
	if(0){
lb_RTN:;
		if(val){
			kv[0] = key;
			kv[1] = val;
			rp = (char**)kv;
		}
		return rp;
	}

	char* s = f_gettail(doc);
	int lsz = strlen(s);
	if( lsz==0 ){ goto lb_RTN; }
	key = s + lsz;

	void* tp = NULL;
	if(strcmp(extstr, "Default") ){tp = doc->editor;}
	for(;;){
//gpf("@%s/%s\n", key, val);
		key--;
		if(key<s){break;}
		val = (char*)editor_find_snippet(tp, key); // p=NULL >> default, not null>>ext
		if(val){break;}
	}
	goto lb_RTN;
}

//editor.c/read_current_word(), get current line
char* f_gettail(GeanyDocument *doc){
	ScintillaObject *sci = doc->editor->sci;
	int cpos = sci_get_current_position(sci);
	int lnum = sci_get_line_from_position(sci, cpos);
	//	int lpos = sci_get_position_from_line(sci, lnum);
	char* p = sci_get_line(sci, lnum);

	int spos = sci_get_position_from_line(sci, lnum);
	int lpos = cpos - spos;

	char* ep = p + lpos;
	if(*ep=='\n'){ep--;}
	if(*ep=='\r'){ep--;}
	
	if(ep-p+1>EMAX){ p = ep-EMAX+1; }
	static char sbuf[EMAX+1]={0};
	int sz=ep-p+1;
	memcpy(sbuf, p, sz);
	sbuf[sz]=0;
	return sbuf;
}

//copied: editor.c / at_eol()
static gboolean at_eol(ScintillaObject *sci, gint pos){
	gint lnum = sci_get_line_from_position(sci, pos);
	for(;;pos++) {
		gchar c = sci_get_char_at(sci, pos);
		if(c != ' ' && c != '\t'){ break; }
	}
	return (pos == sci_get_line_end_position(sci, lnum) );
}

// copied: editor.c/snippets_complete_constructs()
static int do_replace(GeanyEditor* editor, gint pos, char** kv){
	ScintillaObject *sci = editor->sci;
	char* src = kv[0];
	char* rep = kv[1];
	int srcsz = strlen(src);
	
	sci_set_selection_start(sci, pos - srcsz);
	sci_set_selection_end(sci, pos);
	sci_replace_sel(sci, "");
	pos -= srcsz;

	editor_insert_snippet(editor, pos, rep);
	sci_scroll_caret(sci);
 	return 0;
}


/*SH_SMP
#include "emsnip.h"	//SH_co* -static *
#include <stdio.h>

int main(int argc, char** argv) {
	puts("hw");
	return 0;
}
//~$ gcc src.c
//SH_SMPE*/


/*
 change log
 --
2022-06-08	Momi-g	<dmy@dmy.dmy>

	* configure.ac: fix autotools files

2022-06-01	Momi-g	<dmy@dmy.dmy>

	* emsnip.sh.c: cmtout _act() >> space+at_eol skipcode

2022-05-28	Momi-g	<dmy@dmy.dmy>

	* emsnip.sh.c: improve gettail(), do_replace()

2022-05-25	Momi-g	<dmy@dmy.dmy>

	* emsnip.sh.c: refactoring. v1.0.1

2022-05-18	Momi-g	<dmy@dmy.dmy>

	* emsnip.sh.c: init
*/

