/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.users.yutang.omegat.plugin.stats2excel;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.util.Properties;

public class Settings {
    private final File file;
    private final Properties properties;
    private final String TEMPLATE_VERSION = "TemplateVersion";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Settings(File file) throws IOException {
        this.file = file;
        this.properties = new Properties(this.getDefaultProperties());
        if (file.isFile()) {
            BufferedReader reader = null;
            try {
                FileInputStream in = new FileInputStream(file);
                reader = new BufferedReader(new InputStreamReader((InputStream)in, "UTF-8"));
                this.properties.load(reader);
            }
            finally {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
    }

    public String getTemplateVersion() {
        return this.properties.getProperty("TemplateVersion");
    }

    public void setTemplateVersion(String versionString) {
        this.properties.setProperty("TemplateVersion", versionString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() throws IOException {
        Writer writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(this.file));
            this.properties.store(writer, null);
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private Properties getDefaultProperties() {
        Properties p = new Properties();
        p.setProperty("TemplateVersion", "V1");
        return p;
    }
}

