/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.util;

public final class Platform {
    private static OsType osType = OsType.OTHER;

    private Platform() {
    }

    public static OsType getOsType() {
        return osType;
    }

    public static final boolean isWebStart() {
        return System.getProperty("javawebstart.version") != null;
    }

    static {
        String osName = System.getProperty("os.name");
        String osArch = System.getProperty("os.arch");
        if (osName != null && osArch != null) {
            if (osName.startsWith("Linux")) {
                osType = osArch.contains("64") ? OsType.LINUX64 : OsType.LINUX32;
            } else if (osName.startsWith("Mac")) {
                osType = osArch.contains("64") ? OsType.MAC64 : OsType.MAC32;
            } else if (osName.startsWith("Windows")) {
                osType = osArch.contains("64") ? OsType.WIN64 : OsType.WIN32;
            }
        }
    }

    public static enum OsType {
        LINUX64,
        LINUX32,
        MAC64,
        MAC32,
        WIN64,
        WIN32,
        OTHER;

    }
}

