static	char	sccsid[]="%Z% %M% %I% %E% %U%";
/******************************************************************************
*                                                                             *
*      ړI@@F                                                 *
*                                                                             *
*      ֐@@@F@int cl_gx_rep_set( pparmList , ppmList )               *
*                      (O)parmList  *pparmList                                *
*                      (I)prmList  *pprmList                                  *
*                                                                             *
*      ߂l@@@F@ERROR                                    @            *
*                      NORMAL                                                 *
*                                                                             *
*      Tv@@F@                                                       *
*                                                                             *
******************************************************************************/
#include <colmn.h>

extern int giOptions[];
/* extern CLPRTBL CLprocTable;	*/
extern GlobalCt  *pGlobTable;
extern tdtIterate_ctl gtIter_ctl[];

/*static int _tmp_list_info_set();*/
static int _array_hash_clr();
static int _list_array_set();

/****************************************/
/*										*/
/****************************************/
int cl_gx_rep_set(pparmList ,pInfoParm)
parmList  *pparmList;
tdtInfoParm *pInfoParm;
{
	int		rc;
	ScrPrCT *pSPCT;
	tdtInfoParm *pInfoParmW;

	pSPCT = cl_search_src_ct();

	if (rc= cl_gx_get_info_parm(pSPCT,'s',pparmList,&pInfoParmW)) {
		return rc;
	}
#if 1	/* 2021.10.27 */
	return cl_gx_rep_info_als(pInfoParmW ,pInfoParm ,1);
#else
	return cl_gx_rep_info_set(pInfoParmW ,pInfoParm ,1);
#endif
}

/****************************************/
/*										*/
/****************************************/
int cl_gx_rep_set_global( pparmList ,pInfoParm )
parmList  *pparmList;
tdtInfoParm *pInfoParm;
{
	/* %s: %sɂ͑ł܂B */
	ERROROUT2(FORMAT(126),"cl_gx_rep_set_global",pparmList->prp);
	return ECL_SCRIPT_ERROR;
}

/****************************************/
/*										*/
/****************************************/
int _get_num_msg_no(pInfoParm,msg_no,opt,pix0)
tdtInfoParm *pInfoParm;
int msg_no,opt,*pix0;
{
	int iRc,ix0;

	iRc = -1;
	ix0 = 0;
	if (msg_no <= 0) msg_no = 577;	/* (%d)słB */
	if (pInfoParm && pix0) {
		iRc = 0;
		if (pInfoParm->pi_dlen > 0) {
			if (iRc = cl_get_parm_bin(pInfoParm,&ix0,"_get_start_pos.ix0:")) return iRc;
			if (ix0 < 0) {
				ERROROUT1(FORMAT(msg_no),ix0);	/* EEE(%d)słB */
				iRc = -1;
			}
		}
		else if (opt & 0x01) iRc = C_NULL_PARM;
		*pix0 = ix0;
	}
/*
printf("_get_num_msg_no: ix0=%d iRc=%d\n",ix0,iRc);
*/
	return iRc;
}

/****************************************/
/*										*/
/****************************************/
int _get_array_info(nparm,ppParm,pIndex,ppTBL,iParm,opt)
int  nparm;
tdtInfoParm *ppParm[];
tdtArrayIndex *pIndex;
tdtInfoParm ****ppTBL;
int iParm[],opt;
{
	tdtArrayIndex *pIndexW;
	int iRc;

	pIndexW = pIndex;
	iRc = _get_array_info_ref(nparm,ppParm,&pIndexW,ppTBL,iParm,opt);
	if (!iRc || iRc==2000) {
		if (pIndexW != pIndex) memcpy(pIndex,pIndexW,sizeof(tdtArrayIndex));
	}
	return iRc;
}

/********1*********2*********3*********4*********5*******/
/*	F	ppIndex : *ppIndex ɂ́A&tIndex A		*/
/*					    ݒ肳Ă邱				*/
/*					  *ppIndex ɂ́AA or R ̂ƂA	*/
/*						zpIndexԂB		*/
/********************************************************/
int _get_array_info_ref(nparm,ppParm,ppIndex,ppTBL,iParm,opt)
int  nparm;
tdtInfoParm *ppParm[];
tdtArrayIndex **ppIndex;
tdtInfoParm ****ppTBL;
int iParm[],opt;
{
	tdtInfoParm *pInfoParm;
	int iRc,ix0,*index;
	XHASHB *xhp;
	tdtArrayIndex *pIndex;

	pInfoParm = ppParm[0];
	if (opt & 0x02) {
		if (iRc = cl_check_use_mapped_array(pInfoParm)) return iRc;
	}
	pIndex = *ppIndex;
/*
printf("_get_array_info_ref:1 pIndex=%08x Index=%08x\n",pIndex,pIndex->index);
*/
	if (iRc = cl_get_array_info_ref(pInfoParm,ppIndex,ppTBL,iParm)) return iRc;
	pIndex = *ppIndex;
/*
printf("_get_array_info_ref:2 pIndex=%08x Index=%08x\n",pIndex,pIndex->index);
*/
	if ((opt & 0x01) && pIndex->xhp) {
		iParm[0] = 0;		/* Jnʒu */
		return 2000;
	}
	if (iRc = cl_check_use_hash_array(pInfoParm,pIndex)) return iRc;

	ix0 = 0;
	if (nparm >= 2) {
		if (iRc = _get_num_msg_no(ppParm[1],222,0,&ix0)) return iRc;
	}
/*
printf("_get_array_info_ref: ix0=%d iParm[1]..[3]=%d %d %d\n",ix0,iParm[1],iParm[2],iParm[3]);
*/
	iParm[0] = ix0;		/* Jnʒu */
	iParm[1] -= ix0;	/* ővf - Jnʒu */
	iParm[3] = iParm[3] - iParm[2] + 1 - ix0;	/* Jnʒuݒςݗvf̐擪̍őʒu܂ł̗vf */
	iParm[2] += ix0;	/* off_set + Jnʒu */
/*
printf("_get_array_info_ref: ix0=%d iParm[1]..[3]=%d %d %d\n",ix0,iParm[1],iParm[2],iParm[3]);
*/
	return 0;
}

/****************************************/
/*										*/
/****************************************/
int _get_array_info_used_ref(nparm,ppParm,ppIndex,ppTBL,iParm,opt)
int  nparm;
tdtInfoParm *ppParm[];
tdtArrayIndex **ppIndex;
tdtInfoParm ****ppTBL;
int iParm[],opt;
{
	tdtInfoParm ***pTBL,*pInfoParm;
	int iRc,*pSize;
	char c;

	if (iRc = _get_array_info_ref(nparm,ppParm,ppIndex,ppTBL,iParm,opt)) return iRc;
	pInfoParm = ppParm[0];
	c = pInfoParm->pi_id;
/*
printf("_get_array_info_used: c=[%c] iParm[0]..[3] =%d %d %d %d\n",c,iParm[0],iParm[1],iParm[2],iParm[3]);
*/
	if (c!='R' && c!='A') {
		if (ppTBL) {
			pTBL = *ppTBL;
			pSize = (int *)pTBL[0];
			iParm[3] = pSize[7] - (iParm[2] - 1);	/* 6-->7 2020.4.30 *//* 1-->3 2021.5.9 */
		}
	}
DEBUGOUTL4(194,"_get_array_info_used: iParm[0]..[3] =%d %d %d %d",iParm[0],iParm[1],iParm[2],iParm[3]);
	return 0;
}

/****************************************/
/*										*/
/****************************************/
int _get_array_info_used(nparm,ppParm,pIndex,ppTBL,iParm,opt)
int  nparm;
tdtInfoParm *ppParm[];
tdtArrayIndex *pIndex;
tdtInfoParm ****ppTBL;
int iParm[],opt;
{
	tdtArrayIndex *pIndexW;
	int iRc;

	pIndexW = pIndex;
	iRc = _get_array_info_used_ref(nparm,ppParm,&pIndexW,ppTBL,iParm,opt);
	if (!iRc || iRc==2000) {
		if (pIndexW != pIndex) memcpy(pIndex,pIndexW,sizeof(tdtArrayIndex));
	}
	return iRc;
}

/****************************************/
/*										*/
/****************************************/
static int _get_array_num(nparm,ppParm,nm1,pNum)
int  nparm;
tdtInfoParm *ppParm[];
int nm1,*pNum;
{
	tdtInfoParm *pInfoParm;
	int nm,iRc;

	nm = nm1;
/*
printf("_get_array_num: nparm=%d nm1=%d nm=%d\n",nparm,nm1,nm);
*/
	if (nparm >= 1) {
		if ((iRc=_get_num_msg_no(ppParm[0],223,0x01,&nm)) == C_NULL_PARM) nm = nm1;
		else if (iRc) return iRc;
		else if (nm1>0 && nm>nm1) {
			if (cl_get_option(22,0) & 0x01) {
					/* f[^(%d)ž(%d)𒴂Ă܂B܂B */
				ERROROUT2(FORMAT(224),nm,nm1);
			}
			nm = nm1;
		}
	}
	*pNum = nm;
	return 0;
}

/****************************************/
/*										*/
/****************************************/
int cl_set_array(pWork,nparm,ppParm)
char *pWork;
int  nparm;
tdtInfoParm *ppParm[];
{
	tdtInfoParm *pInfoParm,*pInfoParmW,tInfoParm,**ppParmW,*pInfoP;
	tdtInfoParm ***pTBL;
	int iRc,n,i,ix0,ix,nm,count,len,attr,nset,ii,type,iCOMPLEX;
	char c,*name,*p1;
	tdtArrayIndex *pIndex,tIndex;
	int *index,iParm[4];
	tdtDefType *pDeftype;

	nm = 0;
	memcpy(pWork,&nm,sizeof(int));

	nm = nparm - 2;
	pIndex = &tIndex;
/*
printf("cl_set_array:Enter pIndex=%08x Index=%08x\n",pIndex,pIndex->index);
*/
	iRc = _get_array_info_ref(nparm,ppParm,&pIndex,&pTBL,iParm,3);
	if (iRc == 2000) {
		if (iRc=_array_hash_clr(ppParm[0]->pi_data)) return iRc;
		for (i=count=0;i<nm;i+=2) {
			if ((len=parm_to_char_tmp(ppParm[i+2],&p1,0)) < 0) return len;
			else if (len > 0) {
				if (i+1<nm && !cl_is_null_parm(pInfoParm=ppParm[i+3])) {
					if (!(pInfoParmW=(tdtInfoParm *)Malloc(sizeof(tdtInfoParm)))) return -1;
					if (iRc = cl_gx_rep_info_set_ign(pInfoParmW,pInfoParm,1)) return iRc;
					ix = akxs_xhash2(pIndex->xhp,'s',p1,&pInfoParmW);
					if (ix <= 0) {
						if (ix == 0) ix = -12;
						return ix;
					}
					count++;
				}
			}
		}
		memcpy(pWork,&count,sizeof(int));
		return 0;
	}
	else if (iRc) return iRc;

DEBUGOUTL5(194,"cl_set_array: nm=%d iParm=%d %d %d %d",nm,iParm[0],iParm[1],iParm[2],iParm[3]);

	iCOMPLEX = ppParm[0]->pi_alen & (D_AULN_COMPLEX_DATA | D_AULN_RANGE_DATA);
/*
printf("cl_set_array: iCOMPLEX=%08x\n",iCOMPLEX);
*/
	ix0 = iParm[0];
	ix  = iParm[2];
	n = 1;
	attr = pIndex->uAttr[0];
	pInfoP = pIndex->pInfoType;

DEBUGOUT_InfoParm(194,"cl_set_array: attr=%d pInfoP=",pInfoP,attr,0);

	if (pInfoP) n = 0;
	else if ((!attr || attr==DEF_ZOK_VARI) && !pInfoP) {
		nset = iParm[3] - iParm[2] + 1;
		for (i=0;i<nset;i++,ix++) {
			pInfoParmW = cl_get_array_and_var_ent_opt(pIndex,pTBL,ix,'r');
			if (pInfoParmW) {
				if ((c=pInfoParmW->pi_id)=='T' || c=='R' || c=='A') {
					n = 0;
					break;
				}
			}
		}
		ix  = iParm[2];
	}
	if (n && nm>iParm[1]) {
		if (cl_get_option(22,0) & 0x01) {
				/* f[^(%d)ž(%d)𒴂Ă܂B܂B */
			ERROROUT2(FORMAT(224),nm,iParm[1]);
		}
		nm = iParm[1];
	}
/*
printf("cl_set_array:2 pIndex=%08x Index=%08x\n",pIndex,pIndex->index);
*/
DEBUGOUTL3(194,"cl_set_array: n=%d nm=%d ix=%d",n,nm,ix);

	count = ii = 0;
	for (i=count=0;i<iParm[1];i++,ix++) {
		if (ii >= nm) break;
		pInfoParmW = cl_get_array_and_var_ent(pIndex,pTBL,ix);
		if (pInfoParmW) {
			pInfoParmW->pi_alen |= iCOMPLEX;
#if 1	/* 2022.12.07 */
		  if (pInfoP) {
#else
			if (pInfoP && !pInfoParmW->pi_id) {
#endif
				if (iRc=cl_gx_rep_info_set(pInfoParmW,pInfoP,1)) return iRc;
				type = pInfoP->pi_aux[0];

DEBUGOUTL2(194,"cl_set_array: i=%d type=%d",i,type);

				if (type == D_AUX0_TYPE_STRUCT) {
					pDeftype = (tdtDefType *)pInfoP->pi_data;
					if (iRc=_def_var_struct(pInfoParmW,pDeftype,(char *)pInfoP->pi_pos,0)) return iRc;
				}
				else {
					if (type == D_AUX0_TYPE_ARRAY) {
						pInfoParmW->pi_id = 'R';
						if (iRc=_def_var_array_member(pInfoParmW)) return iRc;
					}
					else pInfoParmW->pi_id = 'A';
				}
				pInfoParmW->pi_hlen = ppParm[0]->pi_hlen;	/* add 2021.3.30 */
#if 0	/* 2022.12.07 */
			}
#endif

DEBUGOUTL4(194,"cl_set_array: nm=%d i=%d ii=%d id=[%c]",nm,i,ii,pInfoParmW->pi_id);

			if ((c=pInfoParmW->pi_id) == 'T') {
				if (iRc=cl_set_struct(&n,pInfoParmW,nm-ii,&ppParm[ii+2])) return iRc;
				ii += n;
				count += n;
			}
			else if (c=='R' || c=='A') {
				if (!(ppParmW=(tdtInfoParm **)cl_tmp_const_malloc(sizeof(tdtInfoParm *)*(nm-ii+2)))) return ECL_MALLOC_ERROR;
				ppParmW[0] = pInfoParmW;
				ppParmW[1] = &tInfoParm;
				cl_set_parm_bin(&tInfoParm,0);
				mem_cpy_addr(&ppParmW[2],&ppParm[ii+2],nm-ii);
				if ((iRc=cl_set_array(&n,nm-ii+2,ppParmW)) < 0) return iRc;
				ii += n;
				count += n;
			}
#if 1	/* 2022.12.07 */
		  }
#endif
			else {
				pInfoParm = ppParm[ii+2];
				if (!cl_is_null_parm(pInfoParm)) {
					if (iRc=cl_gx_rep_info_set(pInfoParmW,pInfoParm,1)) return iRc;
					count++;
				}
				ii++;
			}
		}
		else {
			return -1;
		}
	}
	memcpy(pWork,&count,sizeof(int));

	return 0;
}

/****************************************/
/*										*/
/****************************************/
static int _list_copy_info(pCt,pCtI)
tdtRbCtl *pCt,*pCtI;
{
	tdtInfoParm *p,*pInfoParm;
	int iCHK,rc=0;

DEBUGOUTL2(120,"_list_copy_info:Enter pCt=%08x pCtI=%08x",pCt,pCtI);

	if (!pCt || !pCtI) return -1;
	if (pCt == pCtI) return 0;
	iCHK = 1;
	akxs_rb_read(pCtI,0);
	while (p=(tdtInfoParm *)akxs_rb_read(pCtI,1)) {
DEBUGOUT_InfoParm(198,"_list_copy_info: ",p,0,0);
		if (iCHK && p->pi_id==D_DATA_ID_UNDEFVAR) {
			rc = ECL_NDEFVAR_ERROR;
			break;
		}
		if (!(pInfoParm=(tdtInfoParm *)cl_tmp_const_malloc(sizeof(tdtInfoParm))))
			return ECL_MALLOC_ERROR;
		rc = _tmp_list_info_set(pInfoParm,p);
		if (!cl_tmp_rbset_n(pCt,pInfoParm)) return ECL_MALLOC_ERROR;
	}
DEBUGOUTL1(120,"_list_copy_info:Exit rc=%d",rc);
	return rc;
}

/****************************************/
/*										*/
/****************************************/
int _tmp_list_copy(pInfoParmO,pInfoParmI)
tdtInfoParm *pInfoParmO,*pInfoParmI;
{
	int rc;
	tdtRbCtl *pCt,*pCtI;

DEBUGOUTL2(120,"_tmp_list_copy:Enter pInfoParmO=%08x pInfoParmI=%08x",pInfoParmO,pInfoParmI);

	if (!pInfoParmO || !pInfoParmI) return -1;
	if (pInfoParmO == pInfoParmI) return 0;
/*
printf("_tmp_list_copy: id=[%c]\n",pInfoParmI->pi_id);
*/
	if (!(pCt = cl_tmp_rb_new(0,0,NULL))) return ECL_MALLOC_ERROR;
	pInfoParmO->pi_data = (char *)pCt;
	pInfoParmO->pi_scale &= ~D_DATA_MALLOC;
	pCtI = (tdtRbCtl *)pInfoParmI->pi_data;
	rc = _list_copy_info(pCt,pCtI);
DEBUGOUTL1(120,"_tmp_list_info_set:Exit rc=%d",rc);
	return rc;
}

/****************************************/
/*										*/
/****************************************/
int _tmp_list_info_set(pInfoParmO ,pInfoParmI)
tdtInfoParm  *pInfoParmO, *pInfoParmI;
{
	int rc;
	char c;

DEBUGOUTL(120,"_tmp_list_info_set:Enter");

	if (!pInfoParmO || !pInfoParmI) return -1;
	if (pInfoParmO == pInfoParmI) return 0;
	*pInfoParmO = *pInfoParmI;
DEBUGOUT_InfoParm(198,"_tmp_list_info_set: pInfoParmI=",pInfoParmI,0,0);
	if ((c=pInfoParmO->pi_id)==D_DATA_ID_LIST || c==D_DATA_ID_NARABI) {
		if ((rc=_tmp_list_copy(pInfoParmO,pInfoParmI)) < 0) return rc;
	}
	else {
		if (rc=cl_gx_rep_info_copy_data(pInfoParmO,pInfoParmI,1 | D_GX_OPT_ALC_TMP,NULL)) return rc;
		if (pInfoParmO->pi_id == ' ') pInfoParmO->pi_aux[1] |= D_AUX1_PROTECTED;
DEBUGOUT_InfoParm(198,"_tmp_list_info_set: pInfoParmO=",pInfoParmO,0,0);
	}
DEBUGOUTL(120,"_tmp_list_info_set:Exit ret=0");
	return 0;
}

#if 0	/* 2021.3.27 */
/****************************************/
/*										*/
/****************************************/
static int _list_copy_range(pCt,pInfoParm)
tdtRbCtl *pCt;
tdtInfoParm *pInfoParm;
{
	tdtInfoParm *pInfoParm1;
	int i,rc;
	char id;

	rc = 0;
	return rc;
}

/****************************************/
/*										*/
/****************************************/
static int _list_copy_struct(pCt,pInfoParm)
tdtRbCtl *pCt;
tdtInfoParm *pInfoParm;
{
	tdtInfoParm *pInfoParm1;
	int i,rc;
	char id;

	rc = 0;
	return rc;
}

/****************************************/
/*										*/
/****************************************/
static int _list_copy_array(pCt,pInfoParm)
tdtRbCtl *pCt;
tdtInfoParm *pInfoParm;
{
	int i,iParm[4],ix1,nm1,iRc,m1,ic,iHOLD_ERROR;
	char dummy[256];
	tdtArrayIndex tIndex1;
	XHASHB *xhp;
	tdtInfoParm *pParmI,***pTBL1,tInfoParm,*pInfoParm1;

	if (iRc=cl_get_array_info(pInfoParm,&tIndex1,&pTBL1,iParm)) return iRc;
	if (xhp=tIndex1.xhp) {
		nm1 = iParm[1];
		m1  = iParm[3];
		if (!m1) nm1 = 0;
	}
	else {
		nm1 = iParm[3] - iParm[2] + 1;	/* iParm[2],iParm[3]́AParmNoł̒lɂȂĂ */
		m1  = nm1;
	}
	ix1  = iParm[2];
/*
printf("_list_copy_array: nm1=%d ix1=%d m1=%d\n",nm1,ix1,m1);
*/
	ic = 0;
	iHOLD_ERROR = 0;
	for (i=0;i<nm1;i++,ix1++) {
		if ((iRc=cl_array_get_info_parm(&pParmI,&tIndex1,pTBL1,ix1,'r')) < 0) break;
		iRc = 0;
		if (xhp) {
			if (ic >= m1) break;
			if (pParmI) {
				strnzcpy(dummy,xhp->xha_hashb->ha_key,sizeof(dummy)-1);
				cl_set_parm_char(&tInfoParm,dummy,strlen(dummy));
				iRc = _set_list(pCt,&tInfoParm);
				ic++;
			}
		}
		if (iRc >= 0) {
			iRc = _set_list(pCt,pParmI);
			if (iRc == D_AULN_HOLD_ERROR) {
				iHOLD_ERROR = D_AULN_HOLD_ERROR;
				iRc = 0;
			}
		}
		if (iRc < 0) break;
	}
	if (!iRc) iRc = iHOLD_ERROR;
	return iRc;
}

/****************************************/
/*										*/
/****************************************/
int _set_list(pCt,p)
tdtRbCtl *pCt;
tdtInfoParm *p;
{
	tdtInfoParm *pInfoParm1;
	int rc,f;
	char id;

DEBUGOUT_InfoParm(198,"_set_list:Enter ",p,0,0);

	f = 1;
	id = p->pi_id;
	if (p->pi_aux[0] & DEF_ZOK_DATA) {
		if (p->pi_alen & D_AULN_RANGE_DATA) {
			f = 0;
			rc = _list_copy_range(pCt,p);
		}
		else if (id == 'T') {
			f = 0;
			rc = _list_copy_struct(pCt,p);
		}
		else if (id=='A' || id=='R') {
			f = 0;
			rc = _list_copy_array(pCt,p);
		}
	}
	if (f) {
		if (!(pInfoParm1=(tdtInfoParm *)cl_tmp_const_malloc(sizeof(tdtInfoParm))))
			return ECL_MALLOC_ERROR;
		if ((rc=_tmp_list_info_set(pInfoParm1,p)) < 0) return rc;
DEBUGOUT_InfoParm(198,"_set_list: ",pInfoParm1,0,0);
		if (!cl_tmp_rbset_n(pCt,pInfoParm1)) return ECL_MALLOC_ERROR;
		if (pInfoParm1->pi_alen & D_AULN_HOLD_ERROR) rc = D_AULN_HOLD_ERROR;
	}
	return rc;
}
#endif
/****************************************/
/*										*/
/****************************************/
int cl_set_list(pInfoParmW,nparm,ppParm)
tdtInfoParm *pInfoParmW;
int  nparm;
tdtInfoParm *ppParm[];
{
	tdtInfoParm *pInfoParm1,*pInfoParm2, *p;
	int i,rc,opt1,iHOLD_ERROR,f;
	tdtRbCtl *pCt;

	opt1 = pGlobTable->options[4] & 0x01;
#if 1	/* 2022.6.14 */
	cl_none_parm(pInfoParmW);
#else
	cl_null_parm(pInfoParmW);
#endif
	pInfoParmW->pi_aux[1] |= D_AUX1_PROTECTED;
	if (nparm > 0 || opt1) {
		pInfoParmW->pi_id   = D_DATA_ID_LIST;
		pInfoParmW->pi_attr = DEF_ZOK_BULK;
		pInfoParmW->pi_dlen  = sizeof(tdtRbCtl);
		if (!(pCt = cl_tmp_rb_new(0,0,NULL))) return ECL_MALLOC_ERROR;
		pInfoParmW->pi_data = (char *)pCt;
		pInfoParmW->pi_alen &= ~(D_AULN_NULL_PARM | D_AULN_NONE_PARM);
		pInfoParmW->pi_aux[1] &= ~D_AUX1_PROTECTED;
	}
	iHOLD_ERROR = 0;
	for (i=0;i<nparm;i++) {
		p = ppParm[i];
DEBUGOUT_InfoParm(197,"cl_set_list:s: i=%d",p,i,0);
#if 0	/* 2021.3.27 */
		rc = _set_list(pCt,p);
		if (rc == D_AULN_HOLD_ERROR) {
			iHOLD_ERROR = D_AULN_HOLD_ERROR;
			rc = 0;
		}
#else
#if 0	/* 2021.3.27 */
		f = 1;
		id = p->pi_id;
		if (p->pi_aux[0] & DEF_ZOK_DATA) {
			if (p->pi_alen & D_AULN_RANGE_DATA) {
				f = 0;
				if ((rc=_list_copy_range(pCt,p)) < 0) return rc;
			}
			else if (c == 'T') {
				f = 0;
				if ((rc=_list_copy_struct(pCt,p)) < 0) return rc;
			}
			else if (id=='A' || id=='R') {
				f = 0;
				if ((rc=_list_copy_array(pCt,p)) < 0) return rc;
			}
		}
		if (f) {
			if (!(pInfoParm1=(tdtInfoParm *)cl_tmp_const_malloc(sizeof(tdtInfoParm))))
				return ECL_MALLOC_ERROR;
			if ((rc=_tmp_list_info_set(pInfoParm1,p)) < 0) return rc;
DEBUGOUT_InfoParm(198,"cl_set_list:d: i=%d",pInfoParm1,i,0);
			if (!cl_tmp_rbset_n(pCt,pInfoParm1)) return ECL_MALLOC_ERROR;
			if (pInfoParm1->pi_alen & D_AULN_HOLD_ERROR) iHOLD_ERROR = D_AULN_HOLD_ERROR;
		}
#else
		if (!(pInfoParm1=(tdtInfoParm *)cl_tmp_const_malloc(sizeof(tdtInfoParm))))
			return ECL_MALLOC_ERROR;
		if ((rc=_tmp_list_info_set(pInfoParm1,p)) < 0) return rc;
DEBUGOUT_InfoParm(198,"cl_set_list:d: i=%d",pInfoParm1,i,0);
		if (!cl_tmp_rbset_n(pCt,pInfoParm1)) return ECL_MALLOC_ERROR;
		if (pInfoParm1->pi_alen & D_AULN_HOLD_ERROR) iHOLD_ERROR = D_AULN_HOLD_ERROR;
#endif
#endif
	}
	pInfoParmW->pi_alen |= iHOLD_ERROR;
	return 0;
}

/****************************************/
/*										*/
/****************************************/
tdtRbCtl *cl_tmp_rb_new(lBS,lRM,pConstCt)
long lBS,lRM;
ConstantCt *pConstCt;
{
	char *(*m_alloc)();

	if (pConstCt) m_alloc = cl_const_ct_malloc;
	else  m_alloc = cl_tmp_const_malloc;
/*
printf("cl_tmp_rb_new: m_alloc=%08x pConstCt=%08x\n",m_alloc,pConstCt);
*/
	return akxs_rb_new2(lBS,lRM,m_alloc,pConstCt);
}

/****************************************/
/*										*/
/****************************************/
char *cl_tmp_rbset_n(pCt, addr)
tdtRbCtl *pCt;
char *addr;
{
	return akxs_rb_set_n(pCt, addr);
}

/****************************************/
/*										*/
/****************************************/
int cl_cons_list(pInfoParmW,nparm,ppParm)
tdtInfoParm *pInfoParmW;
int  nparm;
tdtInfoParm *ppParm[];
{
	tdtInfoParm *pInfoParm1,*pInfoParm2, *p;
	int i,rc,opt1;
	tdtRbCtl *pCt;
	char c,c0;

DEBUGOUTL2(120,"cl_cons_list:Enter nparm=%d ppParm=%08x",nparm,ppParm);

	opt1 = cl_get_option(5,0) & 0x01;
	cl_null_data(pInfoParmW);
	if (nparm > 0 || opt1) {
		pInfoParmW->pi_id   = D_DATA_ID_LIST;
		pInfoParmW->pi_attr = DEF_ZOK_BULK;
		pInfoParmW->pi_dlen  = sizeof(tdtRbCtl);
		if (!(pCt = cl_tmp_rb_new(0,0,NULL))) return ECL_MALLOC_ERROR;
		pInfoParmW->pi_data = (char *)pCt;
		if (nparm > 0) {
#if 1	/* 2021.4.7 */
			if ((c0=ppParm[0]->pi_id)==D_DATA_ID_NARABI || c0==D_DATA_ID_LIST)
				pInfoParmW->pi_id = c0;
#else
			if (ppParm[0]->pi_id==D_DATA_ID_NARABI)
				pInfoParmW->pi_id = D_DATA_ID_NARABI;
#endif
		}
	}
/*	c0 = pInfoParmW->pi_id;	*//* del 2021.4.7 */
	for (i=0;i<nparm;i++) {
		p = ppParm[i];
#if 1	/* 2021.4.7 */
		if (((c=p->pi_id)==D_DATA_ID_LIST || c==D_DATA_ID_NARABI) &&
		    (c==c0 || (c0!=D_DATA_ID_NARABI && c0!=D_DATA_ID_LIST))) {
			pInfoParmW->pi_id = c0 = c;
#else
		if (((c=p->pi_id)==D_DATA_ID_LIST || c==D_DATA_ID_NARABI) && c==c0) {
#endif
			if ((rc=_list_copy_info(pCt,p->pi_data)) < 0) return rc;
		}
		else if (p->pi_aux[0] & DEF_ZOK_DATA) {
			if ((rc=_list_array_set(pCt,p)) < 0) return rc;
		}
		else if (!cl_is_null_parm(p)) {
			if (!(pInfoParm1=(tdtInfoParm *)cl_tmp_const_malloc(sizeof(tdtInfoParm))))
				return ECL_MALLOC_ERROR;
			if ((rc=_tmp_list_info_set(pInfoParm1,p)) < 0) return rc;
			if (!cl_tmp_rbset_n(pCt,pInfoParm1)) return ECL_MALLOC_ERROR;
		}
	}
DEBUGOUTL(120,"cl_cons_list:Exit ret=0");
	return 0;
}

/****************************************/
/*										*/
/****************************************/
int cl_func_list(pInfoParmW,nparm,ppParm)
tdtInfoParm *pInfoParmW;
int  nparm;
tdtInfoParm *ppParm[];
{
	int  ret,len;
	char w1[32],*p1;
	tdtInfoParm **pp;

	memset(pInfoParmW,0,sizeof(tdtInfoParm));
	ret = 0;
	p1 = w1;
	if ((len = parm_to_char(ppParm[0],&p1,NULL)) < 0) {
		ERROROUT(FORMAT(225));	/* w肪słB */
		return len;
	}
	nparm--;
	pp = &ppParm[1];
	if (!stricmp(p1,"LIST")||!stricmp(p1,"APPEND"))
		ret = cl_set_list(pInfoParmW,nparm,pp);
	else if (!stricmp(p1,"FIRST")) ret = cl_ope_list(pInfoParmW,NULL,nparm,pp,D_FUC_FIRST,0);
	else if (!stricmp(p1,"REST")) ret = cl_ope_list(pInfoParmW,NULL,nparm,pp,D_FUC_REST,0);
	else if (!stricmp(p1,"CONS")) ret = cl_cons_list(pInfoParmW,nparm,pp);
	else if (!stricmp(p1,"LIST_REF")) ret = cl_ope_list(pInfoParmW,NULL,nparm,pp,D_FUC_LIST_REF,0);
	else {
		ERROROUT1(FORMAT(226),p1);	/* w(%s)słB */
		ret = ECL_SCRIPT_ERROR;
	}
	return ret;
}

/****************************************/
/*										*/
/****************************************/
int cl_ope_list(pInfoParmW,pdummy,nparm,ppParm,ope,dummy)
tdtInfoParm *pInfoParmW;
int  nparm,ope,dummy;
tdtInfoParm *ppParm[];
char *pdummy;
{
	tdtInfoParm *pInfoParm,*p,tInfoParm;
	int rc,n,opt1,i,m,iCONST;
	tdtRbCtl *pCt;
	char id;

	rc = 0;
	cl_null_data(pInfoParmW);
	pInfoParm = ppParm[0];
	if (cl_is_null_parm(pInfoParm) || cl_is_null_data(pInfoParm)) return 0;
	if ((id=pInfoParm->pi_id)!=D_DATA_ID_LIST && id!=D_DATA_ID_NARABI) {
		ERROROUT(FORMAT(227));	/* Xgł͂܂B */
		return ECL_SCRIPT_ERROR;
	}
	if (ope == D_FUC_FIRST) {
		pCt = (tdtRbCtl *)pInfoParm->pi_data;
		if (p = (tdtInfoParm *)akxs_rb_get(pCt)) {
			if ((id=p->pi_id)==D_DATA_ID_LIST || id==D_DATA_ID_NARABI)
				rc = _tmp_list_info_set(pInfoParmW,p);
			else {
				cl_gx_copy_info(pInfoParmW,p);
				pInfoParmW->pi_scale &= ~D_DATA_MALLOC;
			}
		}
	}
	else if (ope == D_FUC_REST) {
		rc = _tmp_list_info_set(pInfoParmW,pInfoParm);
/*
CHKSAVEINFO("cl_ope_list");
*/
		opt1 = pGlobTable->options[4] & 0x01;
		n = akxs_rb_used(pCt=(tdtRbCtl *)pInfoParmW->pi_data);
		if (n>1 || opt1) {
			if (nparm > 1) {
				if ((rc=cl_get_parm_bin(ppParm[1],&m,"cl_ope_list REST:"))<0) return rc;
				rc = 0;
				m = X_MIN(n,m);
				for (i=0;i<m;i++) if (!akxs_rb_get_n(pCt)) break;
			}
			else akxs_rb_get_n(pCt);
		}
		else cl_null_data(pInfoParmW);
	}
	else if (ope == D_FUC_LIST_REF) {
		iCONST = pInfoParm->pi_aux[1] & D_AUX1_PROTECTED;
		pCt = (tdtRbCtl *)pInfoParm->pi_data;
		if ((n=akxs_rb_used(pCt)) <= 0) return 0;
		if (nparm > 1) {
			if ((rc=cl_get_parm_bin(ppParm[1],&m,"cl_ope_list REF:"))<0) return rc;
		}
		else m = 0;
		rc = 0;
		if (m < 0) {
			ERROROUT1(FORMAT(228),m);	/* Qƈʒu(%d)słB */
			return ECL_SCRIPT_ERROR;
		}
		if (m < n) {
			akxs_rb_read(pCt,0);
			for (i=0;i<=m;i++) if (!(p=(tdtInfoParm *)akxs_rb_read(pCt,1))) break;
			if (p) {
				if (dummy & D_GX_OPT_GET_ADDR) {
					cl_set_parm_long(pInfoParmW,(long)p);
					pInfoParmW->pi_id = 'S';
				}
				else {
					if ((id=p->pi_id)==D_DATA_ID_LIST || id==D_DATA_ID_NARABI)
						rc = _tmp_list_info_set(pInfoParmW,p);
					else
						cl_gx_copy_info(pInfoParmW,p);
				}
				pInfoParmW->pi_aux[1] |= iCONST;
DEBUGOUT_InfoParm(194,"cl_ope_list: p=",p,0,0);
DEBUGOUT_InfoParm(194,"cl_ope_list: ope=%d pInfoParmW=",pInfoParmW,ope,0);
			}
		}
	}
	return rc;
}

/****************************************/
/*										*/
/****************************************/
int cl_func_index(pWork,nparm,ppParm)
char *pWork;
int  nparm;
tdtInfoParm *ppParm[];
{
	int i,n,ix;
	tdtInfoParm *ppm[MAX_ARRAY_DIM+1];

	ppm[0] = ppParm[0];
	n = X_MIN(nparm,MAX_ARRAY_DIM);
	for (i=1;i<n;i++) ppm[i+1] = ppParm[i];
	ix = cl_gx_array_bexp(NULL,nparm+1,ppm,0);
#if 1	/* 2021.10.5*/
	if (!ix) {
		ERROROUT1(FORMAT(203),"cl_func_index");	/* %s: f[^ݒłB*/
	}
#endif
	if (ix >= 0) ix--;
	memcpy(pWork,&ix,sizeof(int));
	if (ix > 0) ix = 0;
	return ix;
}

/****************************************/
/*										*/
/****************************************/
static int _array_cpy(pWork,nparm,ppParm)
char *pWork;
int  nparm;
tdtInfoParm *ppParm[];
{
	tdtInfoParm *pInfoParm,*pInfoParmW,rInfoParm;
	tdtInfoParm ***pTBL1,***pTBL2;
	int iRc,n,i,ix1,ix2,nm,nm1,nm2,count;
	tdtArrayIndex tIndex1,tIndex2,*pIndex;
	int *index1,*index2,iParm[4];
	char c,*name,*cpKey,*cpDat,*pVal;
	XHASHB *xhpI,*xhpO;

	nm = 0;
	memcpy(pWork,&nm,sizeof(int));
	if (iRc = _get_array_info(nparm,ppParm,&tIndex1,&pTBL1,iParm,3)) {
		if (iRc == 2000) xhpO = tIndex1.xhp;
		else return iRc;
	}
	else xhpO = NULL;
	nm1  = iParm[1];
	ix1  = iParm[2];
/*
printf("_array_cpy: nm1=%d ix1=%d\n",nm1,ix1);
*/
#if 1
	/* zQƏ`FbN */
	if (!gtIter_ctl[0].itc_circ_ref) {
		if (!(gtIter_ctl[0].itc_circ_ref=akxs_layer_new(10,cl_tmp_const_malloc,NULL))) return -215212104;
	}
#else
  if (gtIter_ctl[0].itc_circ_ref) {
#endif
	/* zQƂ`FbN */
	if (pTBL1) name = "$()";
	else name = (char *)ppParm[0]->pi_pos;
	pVal = cl_get_circ_addr(&tIndex1,pTBL1);
	if ((iRc=_iterate_circ_ref(&gtIter_ctl[0],pVal,name)) == 1) return 0;
	else if (iRc < 0) return iRc;
#if 0
  }
#endif
	if (iRc = _get_array_info_used(nparm-2,&ppParm[2],&tIndex2,&pTBL2,iParm,1)) {
		if (iRc == 2000) xhpI = tIndex2.xhp;
		else return iRc;
	}
	else xhpI = NULL;
	nm2  = iParm[1];
	ix2  = iParm[2];
/*
printf("_array_cpy: nm2=%d ix2=%d\n",nm2,ix2);
*/

	if (!((xhpO && xhpI)||(!xhpO && !xhpI))) {
		/* array_to Azzł͂܂B */
		if (!xhpO) ERROROUT1(FORMAT(229),"_array_cpy: array_to");
		/* array_from Azzł͂܂B */
		else if (!xhpI) ERROROUT1(FORMAT(229),"_array_cpy: array_from");
		return -1;
	}

	if (nm2 < nm1) nm1 = nm2;
	nm = nm1;
	if (iRc = _get_array_num(nparm-4,&ppParm[4],nm1,&nm)) return iRc;

	if (xhpO) {
		if (iRc=_array_hash_clr(pIndex=(tdtArrayIndex *)ppParm[0]->pi_data)) return iRc;
		xhpO = pIndex->xhp;
	}
/*
printf("_array_cpy: nm=%d nm1=%d\n",nm,nm1);
*/
	for (count=0,i=1;;i++) {
		if (xhpI) {
			if (i>nm1 || count>=nm) break;
			xhpI->xha_xhix = i;
			if ((iRc=akxs_xhash2(xhpI,'P',&cpKey,&cpDat)) > 0) {
				memcpy(&pInfoParm,cpDat,sizeof(tdtInfoParm *));
				if (!(pInfoParmW=(tdtInfoParm *)Malloc(sizeof(tdtInfoParm)))) return -1;
				memset(pInfoParmW,0,sizeof(tdtInfoParm));
				ix1 = akxs_xhash2(xhpO,'s',cpKey,&pInfoParmW);
				if (ix1 <= 0) {
					if (ix1 == 0) ix1 = -12;
					return ix1;
				}
			}
			else if (iRc < 0) return iRc;
			else continue;
		}
		else {
			if (i > nm) break;
			pInfoParmW = cl_get_array_and_var_ent(&tIndex1,pTBL1,ix1);
			pInfoParm  = cl_get_array_and_var_ent_opt(&tIndex2,pTBL2,ix2,'r');
			ix1++;
			ix2++;
		}
		if (pInfoParmW && pInfoParm) {
			if (iRc=cl_gx_rep_info_set(pInfoParmW,pInfoParm,1)) return iRc;
		}
		else {
			return -1;
		}
		count++;
	}
	memcpy(pWork,&count,sizeof(int));

	return 0;
}

/****************************************/
/*										*/
/****************************************/
static int _array_hash_clr(pIndex)
tdtArrayIndex *pIndex;
{
	int iRc,lMaxReg,lDatLen;
	XHASHB *xhp;

	if ((iRc=akxs_xhash2(xhp=pIndex->xhp,'u',NULL,NULL)) > 0) {
		lMaxReg = xhp->xha_maxreg;
		lDatLen = xhp->xha_datlen;
		akxs_xhash_free(xhp);
		if (!(pIndex->xhp = akxs_xhash_new2(0,lMaxReg,0,lDatLen))) return -9;
		iRc = 0;
	}
	return iRc;
}

/****************************************/
/*										*/
/****************************************/
static int _array_clr(pWork,nparm,ppParm)
char *pWork;
int  nparm;
tdtInfoParm *ppParm[];
{
	tdtInfoParm *pInfoParm,*pInfoParmW,rInfoParm;
	tdtInfoParm ***pTBL;
	int iRc,n,i,ix,nm,nm1,count,iNULL,atr,*pSize;
	char c,*name;
	tdtArrayIndex tIndex,*pIndex;
	int *index,iParm[4];

	nm = 0;
	memcpy(pWork,&nm,sizeof(int));

	pIndex = &tIndex;
	if (iRc = _get_array_info_used_ref(nparm,ppParm,&pIndex,&pTBL,iParm,3)) {
		if (iRc == 2000) iRc = _array_hash_clr(ppParm[0]->pi_data);
		return iRc;
	}
	nm1 = iParm[1];		/* ővf */
	ix  = iParm[2];		/* off_set + Jnʒu */
/*	cl_get_array_index(ppParm[0],&pIndex);	*/
	if (pTBL) atr = DEF_ZOK_VARI;
	else atr = pIndex->uAttr[0];
	index = pIndex->index;
/*
printf("_array_clr: index=%d %d %d %d %d\n",index[0],index[1],index[2],index[3],index[4]);
*/
	nm = nm1;
	/* NAw肳Ănmɂ̒lBAnm<=ővf */
	if (iRc = _get_array_num(nparm-3,&ppParm[3],nm1,&nm)) return iRc;
/*
printf("_array_clr: ix=%d nm1=%d nm=%d pTBL=%08x atr=%d\n",ix,nm1,nm,pTBL,atr);
*/
	iNULL = 0;
	/* NAlȗNULLl̂Ƃ́Aݒɂ */
	if (nparm >= 3) {
		pInfoParm = ppParm[2];
		if (cl_is_null_parm(pInfoParm) && atr==DEF_ZOK_VARI) {
			cl_parm_set0(pInfoParm);
			iNULL = 1;
		}
	}
	else {
		pInfoParm = &rInfoParm;
		cl_null_parm(pInfoParm);
		if (atr == DEF_ZOK_VARI) {
			cl_parm_set0(pInfoParm);
		/*	iNULL = 1;	2021.7.2 */
		}
		iNULL = 1;
	}
#if 1	/* 2021.7.2 */
	if (iNULL) {	/* NAlȗNULLl̂Ƃ́AĂL܂Ŗݒɂ */
		nm1 = iParm[3];		/* ݒςݗvfōővfԍ̗vf܂ł̗vf */
		if (nm > nm1) nm = nm1;	/* w̃NA(nm)<=̐(nm1)ɂȂ */
	}
#endif
	for (i=count=0;i<nm;i++,ix++) {
		pInfoParmW = cl_get_array_and_var_ent(pIndex,pTBL,ix);
		if (pInfoParmW) {
#if 1	/* 2021.10.27 */
			if (iRc=cl_gx_rep_info_data(pInfoParmW,pInfoParm,1)) return iRc;
#else
			if (iRc=cl_gx_rep_info_set(pInfoParmW,pInfoParm,1)) return iRc;
#endif
		}
		else {
			return -1;
		}
		count++;
	}
/*
printf("_array_clr: ix=%d nm1=%d nm=%d iNULL=%d\n",ix,nm1,nm,iNULL);
printf("_array_clr: index=%d %d %d %d %d\n",index[0],index[1],index[2],index[3],index[4]);
*/
/*	if (iNULL) {	2021.6.30 */
	/* ݒςݗvfōővfԍ̗vf܂ŖݒɂA̐[ɂ */
	if (iNULL && nm1==nm) {
		ix = iParm[2] - 1;
		if (pTBL) {
			pSize = (int *)pTBL[0];
		/*	if (pSize[7] <= (index[2] + index[3] - 1))	2021.6.30 */
#if 1	/* 2023.2.10 */
			nm1 = pSize[7];
/*
printf("_array_clr: ix=%d pSize[7]=%d\n",ix,pSize[7]);
*/
			cl_set_max_var_ent(pSize,-1);
			nm = 0;
			for (i=nm1;i>=1;i--) {
				if (pInfoParm = cl_get_var_ent(pTBL,i)) {
					if (!(cl_is_null_parm(pInfoParm) || cl_is_undef_parm(pInfoParm))) {
						nm = i;
						break;
					}
				}
			}
			if (nm) cl_set_max_var_ent(pSize,nm);
#else
			cl_set_max_var_ent(pSize,-1);
			cl_set_max_var_ent(pSize,ix);
#endif
		}
	/*	if (index2 <= nm) {	2021.6.30 */
#if 1	/* 2023.2.9 */
		index[2] = 0;
#else
		else {
			index[2] = ix;
		}
#endif
	}
	memcpy(pWork,&count,sizeof(int));

	return 0;
}

/********1*********2*********3*********4*********5*********6*********7***/
/*			cmp_opt		: rIvV								*/
/*							= 0x01 : rΏۂ̐܂߂đSĂA		*/
/*									 vƂA1Ԃ				*/
/*	ԋp :  cmp_opt0x01												*/
/*			=0̂ƂAv											*/
/*			=1̂ƂA1/0=v/sv									*/
/********1*********2*********3*********4*********5*********6*********7***/
static int _array_cmp(pWork,nparm,ppParm,cmp_opt)
char *pWork;
int  nparm;
tdtInfoParm *ppParm[];
int cmp_opt;
{
	tdtInfoParm *pInfoParm1,*pInfoParm2,*pInfoParm3;
	tdtInfoParm ***pTBL1,***pTBL2;
	int iRc,n,i,ix1,ix2,nm,nm1,nm2,len,iAns,iParm[4],count,match,nu1,nu2,nm3,nmc,nu;
	tdtArrayIndex tIndex1,tIndex2;
	char *p1,*pAns;
	char *cpKey,*cpDat,*pVal;
	char id1,id2;
	XHASHB *xhp1,*xhp2,*xhp;
/*
printf("_array_cmp: nparm=%d cmp_opt=%08x\n",nparm,cmp_opt);
*/
	/* zQƏ`FbN */
	if (!gtIter_ctl[0].itc_circ_ref) {
		if (!(gtIter_ctl[0].itc_circ_ref=akxs_layer_new(10,cl_tmp_const_malloc,NULL))) return -215212104;
		if (!(gtIter_ctl[1].itc_circ_ref=akxs_layer_new(10,cl_tmp_const_malloc,NULL))) return -215212104;
	}

	iAns = 0;
	memcpy(pWork,&iAns,sizeof(int));
	pInfoParm1 = ppParm[0];
	pInfoParm2 = ppParm[2];
	if ((id1=pInfoParm1->pi_id) != (id2=pInfoParm2->pi_id)) {
		/* %s: p[^̃f[^hc(id1=%c id2=%c)Ă܂B */
		ERROROUT3(FORMAT(241),"_array_cmp",id1,id2);
		return -1;
	}
	p1 = "==";
	if (nparm >= 6) {
		pInfoParm3 = ppParm[5];
		if (iRc=cl_check_attr(pInfoParm3,DEF_ZOK_CHAR,"_array_cmp.cmp")) return iRc;
		if (pInfoParm3->pi_dlen > 0) {
			p1 = pInfoParm3->pi_data;
			if (!strcmp(p1,"=")) p1 = "==";
			if (_get_comp_no(p1,0x11) < 0) return ECL_SCRIPT_ERROR;
		}
	}
	if (id1=='L' || id1=='N') {
		ix1 = ix2 = nm = 0;
		if (iRc=_get_num_msg_no(ppParm[1],222,0,&ix1)) return iRc;
		if (nparm >= 4) {
			if (iRc=_get_num_msg_no(ppParm[3],222,0,&ix2)) return iRc;
		}
		if (iRc = _get_array_num(nparm-4,&ppParm[4],-1,&nm)) return iRc;
		iParm[0] = ix1;
		iParm[1] = ix2;
		iParm[2] = nm;
		if ((iAns=cl_comp_list(p1,pInfoParm1,pInfoParm2,iParm,0)) >= 0) {
			memcpy(pWork,&iAns,sizeof(int));
			iRc = 0;
		}
		else iRc = iAns;
		return iRc;
	}
	if (iRc = _get_array_info_used(nparm,ppParm,&tIndex1,&pTBL1,iParm,1)) {
		if (iRc == 2000) xhp1 = tIndex1.xhp;
		else return iRc;
	}
	else xhp1 = NULL;

	/* zQƂ`FbN */
	pVal = cl_get_circ_addr(&tIndex1,pTBL1);
	if ((iRc=_iterate_circ_ref(&gtIter_ctl[0],pVal,(char *)ppParm[0]->pi_pos)) == 1) return 0;
	else if (iRc < 0) return iRc;

	nm1  = iParm[1];
	ix1  = iParm[2];
	nu1  = iParm[3];
/*
printf("_array_cmp: nm1=%d ix1=%d nu1=%d\n",nm1,ix1,nu1);
*/
	if (iRc = _get_array_info_used(nparm-2,&ppParm[2],&tIndex2,&pTBL2,iParm,1)) {
		if (iRc == 2000) xhp2 = tIndex2.xhp;
		else return iRc;
	}
	else xhp2 = NULL;

	/* zQƂ`FbN */
	pVal = cl_get_circ_addr(&tIndex2,pTBL2);
	if ((iRc=_iterate_circ_ref(&gtIter_ctl[1],pVal,(char *)ppParm[2]->pi_pos)) == 1) return 0;
	else if (iRc < 0) return iRc;

	nm2  = iParm[1];
	ix2  = iParm[2];
	nu2  = iParm[3];
/*
printf("_array_cmp: nm2=%d ix2=%d nu2=%d\n",nm2,ix2,nu2);
*/
	if (!((xhp1 && xhp2)||(!xhp1 && !xhp2))) {
		/* array1 Azzł͂܂B */
		if (!xhp1) ERROROUT1(FORMAT(229),"_array_cmp: array1");
		/* array2 Azzł͂܂B */
		else if (!xhp2) ERROROUT1(FORMAT(229),"_array_cmp: array2");
		return -1;
	}

	nm3 = X_MIN(nm1,nm2);
	nmc = nm3;
	if (iRc = _get_array_num(nparm-4,&ppParm[4],nm3,&nmc)) return iRc;
	nm = nmc;
	if (nu1 < nm) nm = nu1;
	if (nu2 < nm) nm = nu2;
/*
printf("_array_cmp: nm3=%d nm=%d cmp_opt=%02x nu1=%d nu2=%d\n",nm3,nm,cmp_opt,nu1,nu2);
*/
	if (cmp_opt & 0x01) {
		nu = X_MIN(nu1,nu2);
		if (nmc>=nu && nu1!=nu2) return 0;
	}
	nm1 = nm3;
/*
printf("_array_cmp: nm=%d\n",nm);
*/
	if (xhp1) {
		if (nm1 < nm2) {
			nm1 = nm2;
			xhp  = xhp1;
			xhp1 = xhp2;
			xhp2 = xhp;
		}
/*
printf("_array_cmp: HASH nm1=%d\n",nm1);
*/
	}
	count=match=0;
	for (i=1;;i++) {
		if (xhp1) {
			if (i>nm1 || count>=nm) break;
			xhp1->xha_xhix = i;
			if ((iRc=akxs_xhash2(xhp1,'P',&cpKey,&cpDat)) > 0) {
/*
printf("_array_cmp: HASH cpKey=[%s]\n",cpKey);
*/
				memcpy(&pInfoParm1,cpDat,sizeof(tdtInfoParm *));
				if ((iRc=akxs_xhash2(xhp2,'R',cpKey,&cpDat)) > 0) {
					memcpy(&pInfoParm2,cpDat,sizeof(tdtInfoParm *));
				}
				else if (iRc < 0) return iRc;
				else continue;
			}
			else if (iRc < 0) return iRc;
			else continue;
		}
		else {
			if (i > nm) break;
			pInfoParm1 = cl_get_array_and_var_ent_opt(&tIndex1,pTBL1,ix1,'r');
			pInfoParm2 = cl_get_array_and_var_ent_opt(&tIndex2,pTBL2,ix2,'r');
			ix1++;
			ix2++;
		}
		if (pInfoParm1 && pInfoParm2) {
			count++;
/*
printf("_array_cmp: count=%d\n",count);
*/
			pAns = (char *)&iAns;
			if ((iRc=cl_cmpt_comp_opt(&pAns,p1,pInfoParm1,pInfoParm2,0,NULL,cmp_opt)) < 0) iAns = 0;
		/*	if (!iAns) break; */
			if (iAns) match++;
		}
		else {
			return -1;
		}
	}
	if (cmp_opt & 0x01) {
		if (match == nm) match = 1;
		else match = 0;
	}
	memcpy(pWork,&match,sizeof(int));
	return 0;
}

/****************************************/
/*										*/
/****************************************/
static int _array_bxp(pWork,nparm,ppParm)
char *pWork;
int  nparm;
tdtInfoParm *ppParm[];
{
	tdtInfoParm *pInfoParm1,*pInfoParmW,*pInfoParm2,tInfoParm;
	tdtInfoParm ***pTBL1,***pTBL2,***pTBL3;
	int iRc,n,i,ix1,ix2,ix3,nm,nm1,nm2,nm3,len,count,iParm[4],nu2,nu3;
	tdtArrayIndex *pIndex1,tIndex1,tIndex2,tIndex3,*pIndex;
	XHASHB *xhp1,*xhp2,*xhp3,*xhp;
	char *p1,*cpKey,*cpDat;

	count = 0;
	memcpy(pWork,&count,sizeof(int));

	pIndex1 = &tIndex1;
	if (iRc = _get_array_info_used_ref(nparm,ppParm,&pIndex1,&pTBL1,iParm,3)) {
		if (iRc == 2000) xhp1 = pIndex1->xhp;
		else return iRc;
	}
	else xhp1 = NULL;
	nm1  = iParm[1];
	ix1  = iParm[2];

	if (iRc = _get_array_info_used(nparm-2,&ppParm[2],&tIndex2,&pTBL2,iParm,1)) {
		if (iRc == 2000) xhp2 = tIndex2.xhp;
		else return iRc;
	}
	else xhp2 = NULL;
	nm2  = iParm[1];
	ix2  = iParm[2];
	nu2  = iParm[3];

	if (iRc = _get_array_info_used(nparm-4,&ppParm[4],&tIndex3,&pTBL3,iParm,1)) {
		if (iRc == 2000) xhp3 = tIndex3.xhp;
		else return iRc;
	}
	else xhp3 = NULL;
	nm3  = iParm[1];
	ix3  = iParm[2];
	nu3  = iParm[3];

	if (!((xhp1 && xhp2 && xhp3)||(!xhp1 && !xhp2 && !xhp3))) {
		/* array_to Azzł͂܂B */
		if (!xhp1) ERROROUT1(FORMAT(229),"_array_bxp: array_to");
		/* array_1 Azzł͂܂B */
		if (!xhp2) ERROROUT1(FORMAT(229),"_array_bxp: array_1");
		/* array_2 Azzł͂܂B */
		if (!xhp3) ERROROUT1(FORMAT(229),"_array_bxp: array_2");
		return -1;
	}

	if (nm2 < nm1) nm1 = nm2;
	if (nm3 < nm1) nm1 = nm3;
	if (iRc = _get_array_num(nparm-6,&ppParm[6],nm1,&nm)) return iRc;
	if (nu2 < nm) nm = nu2;
	if (nu3 < nm) nm = nu3;
/*
printf("_array_bxp: nm1=%d nm=%d\n",nm1,nm);
*/
	p1 = "+";
	if (nparm >= 8) {
		pInfoParmW = ppParm[7];
		if (iRc=cl_check_attr(pInfoParmW,DEF_ZOK_CHAR,"_array_bxp.bxp")) return iRc;
		if (pInfoParmW->pi_dlen > 0) p1 = pInfoParmW->pi_data;
	}

	if (xhp1) {
		if (iRc=_array_hash_clr(pIndex=(tdtArrayIndex *)ppParm[0]->pi_data)) return iRc;
		nm1 = nm2;
		if (nm2 < nm3) {
			nm1 = nm3;
			xhp  = xhp2;
			xhp2 = xhp3;
			xhp3 = xhp;
		}
/*
printf("_array_bxp: HASH nm1=%d\n",nm1);
*/
	}

	for (count=0,i=1;;i++) {
		if (xhp2) {
			if (i>nm1 || count>=nm) break;
			xhp2->xha_xhix = i;
			if ((iRc=akxs_xhash2(xhp2,'P',&cpKey,&cpDat)) > 0) {
/*
printf("_array_bxp: HASH cpKey=[%s]\n",cpKey);
*/
				memcpy(&pInfoParm1,cpDat,sizeof(tdtInfoParm *));
			/*	if ((iRc=akxs_xhash2(xhp3,'R',cpKey,&cpDat)) > 0) {	*/
				iRc = akxs_xhash2(xhp3,'R',cpKey,&cpDat);
/*
printf("_array_bxp: HASH iRc=%d\n",iRc);
*/
				if (iRc > 0) {
					memcpy(&pInfoParm2,cpDat,sizeof(tdtInfoParm *));
				}
				else if (iRc < 0) return iRc;
				else continue;
			}
			else if (iRc < 0) return iRc;
			else continue;
		}
		else {
			if (i > nm) break;
			pInfoParmW = cl_get_array_and_var_ent(pIndex1,pTBL1,ix1);
			pInfoParm1 = cl_get_array_and_var_ent_opt(&tIndex2,pTBL2,ix2,'r');
			pInfoParm2 = cl_get_array_and_var_ent_opt(&tIndex3,pTBL3,ix3,'r');
			ix1++;
			ix2++;
			ix3++;
		}
		if (pInfoParm1 && pInfoParm2) {
			if (iRc=cl_gx_bexp(&tInfoParm,pInfoParm1,p1,pInfoParm2,0,0)) return iRc;
			if (xhp2) {
				if (!(pInfoParmW=(tdtInfoParm *)Malloc(sizeof(tdtInfoParm)))) return -1;
				if (iRc=cl_gx_rep_info_set_ign(pInfoParmW,&tInfoParm,1)) return iRc;
				ix1 = akxs_xhash2(xhp1,'s',cpKey,&pInfoParmW);
				if (ix1 <= 0) {
					if (ix1 == 0) ix1 = -12;
					return ix1;
				}
			}
			else {
				if (!pInfoParmW) return -1;
				if (iRc=cl_gx_rep_info_set(pInfoParmW,&tInfoParm,1)) return iRc;
			}
			count++;
		}
		else {
			return -1;
		}
	}
	memcpy(pWork,&count,sizeof(int));
	return 0;
}

/****************************************/
/*										*/
/****************************************/
int cl_array_ope_opt(pAns,nparm,ppParm,ope,cmp_opt)
long *pAns;
int  nparm;
tdtInfoParm *ppParm[];
int  ope;
int  cmp_opt;
{
	int ret,ok_opt,*pWork,iAns;

DEBUGOUT_InfoParm(110,"cl_array_ope_opt:Enter ope=%d cmp_opt=%d ppParm[0]=",ppParm[0],ope,cmp_opt);
if (nparm > 2) {
DEBUGOUT_InfoParm(110,"                 ppParm[2]=",ppParm[2],0,0);
}
	ok_opt = 0x02 | 0x08 | 0x1000;
	if (cl_check_data_id(ppParm[0],~ok_opt)) return ECL_SCRIPT_ERROR;
	if (ope != D_FUC_ARRAY_CLR) {
		if (cl_check_data_id(ppParm[2],~ok_opt)) return ECL_SCRIPT_ERROR;
	}
	if (ope == D_FUC_ARRAY_BXP) {
		if (cl_check_data_id(ppParm[4],~ok_opt)) return ECL_SCRIPT_ERROR;
	}

	pWork = &iAns;
	if      (ope == D_FUC_ARRAY_CPY) ret = _array_cpy(pWork,nparm,ppParm);
	else if (ope == D_FUC_ARRAY_CLR) ret = _array_clr(pWork,nparm,ppParm);
	else if (ope == D_FUC_ARRAY_CMP) ret = _array_cmp(pWork,nparm,ppParm,cmp_opt);
	else if (ope == D_FUC_ARRAY_BXP) ret = _array_bxp(pWork,nparm,ppParm);
	*pAns = iAns;
/*
printf("cl_array_ope_opt: ret=%d\n",ret);
*/
	return ret;
}

/****************************************/
/*										*/
/****************************************/
int cl_array_ope(pWork,pOperator,nparm,ppParm,ope,opt)
char *pWork,*pOperator;
int  nparm,ope,opt;
tdtInfoParm *ppParm[];
{
	return cl_array_ope_opt(pWork,nparm,ppParm,ope,0);
}

/****************************************/
/*										*/
/****************************************/
static int _list_array_set(pCt,pInfoParmI)
tdtRbCtl *pCt;
tdtInfoParm *pInfoParmI;
{
	tdtInfoParm *pInfoParm1,*pInfoParm;
	tdtInfoParm ***pTBL;
	int iRc,n,i,ix,nm,len,iAns,iParm[4],count,match;
	tdtArrayIndex tIndex;
	char *p1;
	char *cpKey,*cpDat;
	XHASHB *xhp;

	if (iRc = _get_array_info(1,&pInfoParmI,&tIndex,&pTBL,iParm,3)) {
		if (iRc == 2000) xhp = tIndex.xhp;
		return iRc;
	}
	else xhp = NULL;
	nm = iParm[1];
	ix = iParm[2];

	for (i=1;i<=nm;i++,ix++) {
		if (xhp) {
			xhp->xha_xhix = i;
			if ((iRc=akxs_xhash2(xhp,'P',&cpKey,&cpDat)) > 0) {
				memcpy(&pInfoParm,cpDat,sizeof(tdtInfoParm *));
			}
			else if (iRc < 0) return iRc;
			else continue;
		}
		else {
			pInfoParm = cl_get_array_and_var_ent_opt(&tIndex,pTBL,ix,'r');
		}
		if (pInfoParm) {
			if (cl_is_undef_parm(pInfoParm) || cl_is_null_parm(pInfoParm)) continue;
			if (!(pInfoParm1=(tdtInfoParm *)cl_tmp_const_malloc(sizeof(tdtInfoParm))))
				return ECL_MALLOC_ERROR;
			if ((iRc=_tmp_list_info_set(pInfoParm1,pInfoParm)) < 0) return iRc;
			if (!cl_tmp_rbset_n(pCt,pInfoParm1)) return ECL_MALLOC_ERROR;
		}
		else {
			return -1;
		}
	}

	return iRc;
}
