/*
 *  TOPPERS Software
 *      Toyohashi Open Platform for Embedded Real-Time Systems
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2004-2009 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  L쌠҂́Cȉ(1)`(4)̏𖞂ꍇɌC{\tgEF
 *  Ai{\tgEFAς̂܂ށDȉjgpEE
 *  ρEĔzziȉCpƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *      ܂C{\tgEFÃ[U܂̓Gh[ÛȂ闝
 *      RɊÂCL쌠҂TOPPERSvWFNg
 *      Ɛӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̎gpړI
 *  ɑ΂K܂߂āCȂۏ؂sȂD܂C{\tgEF
 *  A̗pɂ蒼ړI܂͊ԐړIɐȂ鑹QɊւĂC
 *  ̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: t_stddef.h 1513 2009-04-22 07:35:20Z ertl-hiro $
 */

/*
 *		TOPPERSʃwb_t@C
 *
 *  TOPPERS֘ÂׂẴ\[Xt@CŃCN[hׂwb_t@C
 *  DẽJ[l\tgEFAiŋʂɗp邱Ƃz肵Ă
 *  DTOPPERS̊ẽJ[l\tgEFAiŋʂɗpf[^^C
 *  萔C}N̒`Ȃǂ܂ށD
 *
 *  AZũ\[Xt@C炱̃t@CCN[h鎞
 *  ́CTOPPERS_MACRO_ONLY`ĂDɂC}N`ȊO
 *  悤ɂȂĂD
 *
 *  ̃t@CCN[hOɃCN[hĂׂt@C
 *  ͂ȂD
 */

#ifndef TOPPERS_T_STDDEF_H
#define TOPPERS_T_STDDEF_H

#ifdef __cplusplus
extern "C" {
#endif

/*
 *  ^[Qbgˑ
 */
//#include "target_stddef.h"
#include <stddef.h>
#include <stdint.h>

/*
 *  C/EC++throw()ɑΏ邽߂̒`
 */
#if !defined(__cplusplus) || defined(__embedded_cplusplus)
#define throw()
#endif

#ifndef TOPPERS_MACRO_ONLY

/*
 *  ^[Qbgˑ̃f[^^̃}ÑftHg`
 */
#ifndef TOPPERS_bool
#define TOPPERS_bool	int				/* u[^ */
#endif /* TOPPERS_bool */

#ifndef TOPPERS_size
#define TOPPERS_size	uintptr_t		/* TCY^ */
#endif /* TOPPERS_size */

#ifndef TOPPERS_fp
struct TOPPERS_dummy_t { int TOPPERS_dummy_field; };
typedef	void			(*TOPPERS_fp_t)(struct TOPPERS_dummy_t);
#define TOPPERS_fp		TOPPERS_fp_t	/* vŐNԒn */
#endif /* TOPPERS_fp */

/*
 *  ʃf[^^
 */
typedef TOPPERS_bool	bool_t;		/* ^Ul */
typedef unsigned char	char_t;		/* ̕^ */

typedef signed int		int_t;		/* RȃTCY̕t */
typedef unsigned int	uint_t;		/* RȃTCY̕ */

typedef signed long		long_t;		/* ߂̃TCY̕t */
typedef unsigned long	ulong_t;	/* ߂̃TCY̕ */

typedef int_t			FN;			/* @\R[h */
typedef	int_t			ER;			/* G[R[h */
typedef	int_t			ID;			/* IuWFNgIDԍ */
typedef	uint_t			ATR;		/* IuWFNg̑ */
typedef	uint_t			STAT;		/* IuWFNg̏ */
typedef	uint_t			MODE;		/* T[rXR[̓샂[h */
typedef	int_t			PRI;		/* Dx */
typedef	TOPPERS_size	SIZE;		/* ̈̃TCY */

typedef	int_t			TMO;		/* ^CAEgw */
typedef	uint_t			RELTIM;		/* Ύ */
typedef	ulong_t			SYSTIM;		/* VXe */
typedef	ulong_t			SYSUTM;		/* \]pVXe */

typedef	TOPPERS_fp		FP;			/* vŐNԒn */

typedef	int_t			ER_BOOL;	/* G[R[h܂͐^Ul */
typedef	int_t			ER_ID;		/* G[R[h܂IDԍ */
typedef	int_t			ER_UINT;	/* G[R[h܂͕ */

typedef	uint32_t		ACPTN;		/* ANZXp^[ */
typedef	struct acvct {				/* ANZXxN^ */
	ACPTN		acptn1;				/* ʏ푀1̃ANZXp^[ */
	ACPTN		acptn2;				/* ʏ푀2̃ANZXp^[ */
	ACPTN		acptn3;				/* Ǘ̃ANZXp^[ */
	ACPTN		acptn4;				/* QƑ̃ANZXp^[ */
} ACVCT;

#endif /* TOPPERS_MACRO_ONLY */

/*
 *  萔}N
 */
#ifndef UINT_C
#define UINT_C(val)		(val ## U)		/* uint_t^̒萔}N */
#endif /* UINT_C */

#ifndef ULONG_C
#define ULONG_C(val)	(val ## UL)		/* ulong_t^̒萔}N */
#endif /* ULONG_C */

/*
 *  ʒ萔
 */
#ifndef NULL
#define NULL		0			/* |C^ */
#endif /* NULL */

#ifndef true
#define true		1			/* ^ */
#endif /* true */

#ifndef false
#define false		0			/* U */
#endif /* false */

#define E_OK		0			/* I */

/*
 *  CG[R[h
 */
#define E_SYS		(-5)		/* VXeG[ */
#define E_NOSPT		(-9)		/* T|[g@\ */
#define E_RSFN		(-10)		/* \@\R[h */
#define E_RSATR		(-11)		/* \񑮐 */
#define E_PAR		(-17)		/* p[^G[ */
#define E_ID		(-18)		/* sIDԍ */
#define E_CTX		(-25)		/* ReLXgG[ */
#define E_MACV		(-26)		/* ANZXᔽ */
#define E_OACV		(-27)		/* IuWFNgANZXᔽ */
#define E_ILUSE		(-28)		/* T[rXR[sgp */
#define E_NOMEM		(-33)		/* s */
#define E_NOID		(-34)		/* IDԍs */
#define E_NORES		(-35)		/* s */
#define E_OBJ		(-41)		/* IuWFNgԃG[ */
#define E_NOEXS		(-42)		/* IuWFNg */
#define E_QOVR		(-43)		/* L[COI[o[t[ */
#define E_RLWAI		(-49)		/* ҂Ԃ̋ */
#define E_TMOUT		(-50)		/* |[Os܂̓^CAEg */
#define E_DLT		(-51)		/* ҂IuWFNg̍폜 */
#define E_CLS		(-52)		/* ҂IuWFNg̏ԕω */
#define E_WBLK		(-57)		/* mubLOt */
#define E_BOVR		(-58)		/* obt@I[o[t[ */

/*
 *  IuWFNg
 */
#define TA_NULL		UINT_C(0)	/* IuWFNgw肵Ȃ */

/*
 *  ^CAEgw
 */
#define TMO_POL		0			/* |[O */
#define TMO_FEVR	(-1)		/* iv҂ */
#define TMO_NBLK	(-2)		/* mubLO */

/*
 *  ANZXp^[
 */
#define TACP_KERNEL		(0U)	/* J[lhCɃANZX */
#define TACP_SHARED		(~0U)	/* ׂẴhCANZX */

/*
 *  ^Ɋւo߂̃}N
 */
#ifndef offsetof
#define	offsetof(structure, field)	((uintptr_t) &(((structure *) 0)->field))
#endif /* offsetof */

#ifndef alignof
#define alignof(type)	offsetof(struct { char field1; type field2; }, field2)
#endif /* alignof */

#ifndef ALIGN_TYPE				/* ACg̃`FbN */
#define ALIGN_TYPE(addr, type) \
						((((uintptr_t)(addr)) & (alignof(type) - 1)) == 0U)
#endif /* ALIGN_TYPE */

/*
 *  assert}N
 */
#undef assert
#ifndef NDEBUG
#define assert(exp)		((void)((exp) ? 0 : (TOPPERS_assert_fail(#exp, \
							__FILE__, __LINE__), TOPPERS_assert_abort(), 0)))
#else /* NDEBUG */
#define assert(exp)		((void) 0)
#endif /* NDEBUG */

#ifdef __cplusplus
}
#endif

/*
 *  G[R[hE}N
 *
 *  ȉ̃}N`́Ct2̕␔ŕ\ĂCEVtg
 *  Zqi>>jZpVtg邱Ƃ肵ĂDłȂJ
 *  ł́Ctarget_stddef.hł̒`㏑Ȃ΂ȂȂD
 *
 *  MERCD}N̒`́CCG[R[hł邱Ƃ肵ĂD
 *  łȂꍇC2̒`vȂȂD
 */
#ifndef ERCD
#define ERCD(mercd, sercd) \
				((ER)((((uint_t) sercd) << 8) | (((uint_t) mercd) & 0xffU)))
#endif /* ERCD */

#ifndef MERCD
#ifdef INT8_MAX
#define MERCD(ercd)		((ER)((int8_t)(ercd)))
#else /* INT8_MAX */
#define MERCD(ercd)		((ER)(((uint_t) ercd) | ~0xffU))
#endif /* INT8_MAX */
#endif /* MERCD */

#ifndef SERCD
#define SERCD(ercd)		((ER)((ercd) >> 8))
#endif /* SERCD */

/*
 *  ANZXp^[}N
 */
#define TACP(domid)		(1U << ((domid) - 1))	/* domidɃANZX */

/*
 *  ΎԁiRELTIMjɎwłől
 */
#if UINT_MAX < LONG_MAX
#define TMAX_RELTIM		((RELTIM) UINT_MAX)
#else /* UINT_MAX < LONG_MAX */
#define TMAX_RELTIM		((RELTIM) LONG_MAX)
#endif /* UINT_MAX < LONG_MAX */

#endif /* TOPPERS_T_STDDEF_H */
