/*
 * The MIT License (MIT)
 * 
 * Copyright (c) 2014 Yuki SAKAI
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 ******************************************************************************/

/*******************************************************************************
 * Include ********************************************************************/
#if !defined(REMPIC_H__)
#  include <rempic.h>
#endif
#if !defined(_STDIO_H_) && !defined(_STDIO_H)
#  include <stdio.h>
#endif
#if !defined(_STRING_H_) && !defined(_STRING_H)
#  include <string.h>
#endif
#if !defined(_STDLIB_H_) && !defined(_STDLIB_H)
#  include <stdlib.h>
#endif
#if !defined(_UNISTD_H_) && !defined(_UNISTD_H)
#  include <unistd.h>
#endif


/*******************************************************************************
 * Extension check ************************************************************/
unsigned int ext_chk (unsigned char *ext)
{
  if      (strcmp ((char *)ext, "jpg" )==0) {return GEXTJPG; }
  else if (strcmp ((char *)ext, "JPG" )==0) {return GEXTJPG; }
  else if (strcmp ((char *)ext, "jpeg")==0) {return GEXTJPEG;}
  else if (strcmp ((char *)ext, "png" )==0) {return GEXTPNG; }
  else if (strcmp ((char *)ext, "PNG" )==0) {return GEXTPNG; }
  else if (strcmp ((char *)ext, "gif" )==0) {return GEXTGIF; }
  else if (strcmp ((char *)ext, "GIF" )==0) {return GEXTGIF; }

  return GEXTNOGRAPHIC;
}
