/*
 * The MIT License (MIT)
 * 
 * Copyright (c) 2014 Yuki SAKAI
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 ******************************************************************************/

/*******************************************************************************
 * Include ********************************************************************/
#if !defined(REMPIC_H__)
#  include <rempic.h>
#endif
#if !defined(_STDIO_H_) && !defined(_STDIO_H)
#  include <stdio.h>
#endif
#if !defined(_STRING_H_) && !defined(_STRING_H)
#  include <string.h>
#endif
#if !defined(_STDLIB_H_) && !defined(_STDLIB_H)
#  include <stdlib.h>
#endif
#if !defined(_UNISTD_H_) && !defined(_UNISTD_H)
#  include <unistd.h>
#endif

/*//========================================================================\\*
 *|| Jpeg check                                                             ||*
 *\\========================================================================//*/
/*******************************************************************************
 * jpeg check APP0 ************************************************************/
static int jpeg_chk_app0 (picInfo *pinfo, unsigned char *data, off_t len)
{
  data+=2; /* skip head length */
  if (strncmp ((char *)data, "JFIF", 4)!=0) {goto err_proc;}
  else if (*(data+4)!=0x00)                 {goto err_proc;}
  data+=5;
  data+=2;                           /* skip version */
  pinfo->perUnit  = *data; data+=1;  /* unit */
  
  pinfo->fm = 0;
  return 1;
 err_proc:
  pinfo->fm = 1;
  return 0;
}
/*******************************************************************************
 * jpeg check SOF0 ************************************************************/
static int jpeg_chk_sof0 (picInfo *pinfo, unsigned char *data, off_t len)
{
  data+=2; /* skip head length */
  /*if (*(data+0)!=0x08) {goto err_proc;}*/
  data+=1;
  pinfo->img_y = ((unsigned short)(*data)<<8) | ((unsigned short)*(data+1)); data+=2;
  pinfo->img_x = ((unsigned short)(*data)<<8) | ((unsigned short)*(data+1)); data+=2;
  if (1 && FLGCHK(flags, FLGDEBUGMODE)) {printf ("img_x: %ld, img_y: %ld\n", pinfo->img_x, pinfo->img_y);}
  
  pinfo->fm = 0;
  return 1;

  pinfo->fm = 1;
  return 0;
}

/*******************************************************************************
 * jpeg check(jpg,jpeg) *******************************************************/
void jpeg_chk (int fd, picInfo *pinfo)
{
  unsigned int  masize;
  unsigned char *ifpot, *ifoff, br;
  off_t         rlen, off_set, size;
  int           i, rrtn;
  
  pinfo->fm = 0;
  /*******************************************************************
   * Get File size and allocate memory ******************************/
  masize = MIN((unsigned int)pinfo->fsize, (unsigned int)MAXMALLOCSIZE);
  if ((ifpot=(unsigned char *)malloc_init (masize))==NULL) {return ;}
  ifoff = ifpot;
  br = rlen = off_set = 0;

  
  /*-Get packet info from input file and dividing flow Start--------*/
  while ((rrtn=read (fd, ifoff, (masize-rlen)))>=0) {
    rlen = (off_t)rrtn + rlen;
    if (rlen<0) {free (ifpot); return;}
    ifoff = ifpot;
    if (off_set==0 && rlen==0) {pinfo->fm = 1; br=1; break;}

    /*-Get packet info from read data Start-------------------------*/
    while (rlen>=2) {
      if (off_set==0) { /* SOL */
	if (0 && FLGCHK(flags, FLGDEBUGMODE)) {printf ("SOL\n");}
	if (!(*ifoff==0xff && *(ifoff+1)==0xd8)) {
	  pinfo->fm = 1;
	  br=1; break;
	}
	size = 2;
      } else if (*ifoff==0xff && *(ifoff+1)==0xe0) { /* APP0 */
	if (0 && FLGCHK(flags, FLGDEBUGMODE)) {printf ("APP0\n");}
	if (rlen<4) {break;}
	size = *(ifoff+2); size <<=8; size += *(ifoff+3);
	if      (rlen<(size+2)) {break;}
	else if (!jpeg_chk_app0 (pinfo, ifoff+2, size)) {br=1; break;}
	size+=2;
      } else if (*ifoff==0xff && *(ifoff+1)==0xdb) { /* DQT */
	if (0 && FLGCHK(flags, FLGDEBUGMODE)) {printf ("DQT\n");}
	if (rlen<4) {break;}
	size = *(ifoff+2); size <<=8; size += *(ifoff+3);
	if (rlen<(size+2)) {break;}
	size+=2;
      } else if (*ifoff==0xff && *(ifoff+1)==0xc4) { /* DHT */
	if (0 && FLGCHK(flags, FLGDEBUGMODE)) {printf ("DHT\n");}
	if (rlen<4) {break;}
	size = *(ifoff+2); size <<=8; size += *(ifoff+3);
	if (rlen<(size+2)) {break;}
	size+=2;
      } else if (*ifoff==0xff && *(ifoff+1)==0xc0) { /* SOF0 */
	if (0 && FLGCHK(flags, FLGDEBUGMODE)) {printf ("SOF0\n");}
	if (rlen<4) {break;}
	size = *(ifoff+2); size <<=8; size += *(ifoff+3);
	if (rlen<(size+2)) {break;}
	else if (!jpeg_chk_sof0 (pinfo, ifoff+2, size)) {br=1; break;}
	size+=2;
      } else if (*ifoff==0xff && *(ifoff+1)==0xc1) { /* SOF1 */
	if (0 && FLGCHK(flags, FLGDEBUGMODE)) {printf ("SOF1\n");}
	if (rlen<4) {break;}
	size = *(ifoff+2); size <<=8; size += *(ifoff+3);
	if (rlen<(size+2)) {break;}
	else if (!jpeg_chk_sof0 (pinfo, ifoff+2, size)) {br=1; break;}
	size+=2;
      } else if (*ifoff==0xff && *(ifoff+1)==0xc2) { /* SOF2 */
	if (0 && FLGCHK(flags, FLGDEBUGMODE)) {printf ("SOF2\n");}
	if (rlen<4) {break;}
	size = *(ifoff+2); size <<=8; size += *(ifoff+3);
	if (rlen<(size+2)) {break;}
	else if (!jpeg_chk_sof0 (pinfo, ifoff+2, size)) {br=1; break;}
	size+=2;
      } else if (*ifoff==0xff && *(ifoff+1)==0xd9) { /* EOL */
	if (0 && FLGCHK(flags, FLGDEBUGMODE)) {printf ("EOL\n");}
	if (rlen<4) {break;}
	size = *(ifoff+2); size <<=8; size += *(ifoff+3);
	if (rlen<(size+2)) {break;}
	size+=2;
      } else if (*ifoff==0xff && *(ifoff+1)==0xe1) { /* APP1 */
	if (0 && FLGCHK(flags, FLGDEBUGMODE)) {printf ("APP1\n");}
	if (rlen<4) {break;}
	size = *(ifoff+2); size <<=8; size += *(ifoff+3);
	if (rlen<(size+2)) {break;}
	size+=2;
      } else if (*ifoff==0xff && *(ifoff+1)==0xe2) { /* APP2 */
	if (0 && FLGCHK(flags, FLGDEBUGMODE)) {printf ("APP1\n");}
	if (rlen<4) {break;}
	size = *(ifoff+2); size <<=8; size += *(ifoff+3);
	if (rlen<(size+2)) {break;}
	size+=2;
      } else if (*ifoff==0xff && *(ifoff+1)==0xe3) { /* APP3 */
	if (0 && FLGCHK(flags, FLGDEBUGMODE)) {printf ("APP3\n");}
	if (rlen<4) {break;}
	size = *(ifoff+2); size <<=8; size += *(ifoff+3);
	if (rlen<(size+2)) {break;}
	size+=2;
      } else if (*ifoff==0xff && *(ifoff+1)==0xe4) { /* APP4 */
	if (0 && FLGCHK(flags, FLGDEBUGMODE)) {printf ("APP4\n");}
	if (rlen<4) {break;}
	size = *(ifoff+2); size <<=8; size += *(ifoff+3);
	if (rlen<(size+2)) {break;}
	size+=2;
      } else if (*ifoff==0xff && *(ifoff+1)==0xe5) { /* APP5 */
	if (0 && FLGCHK(flags, FLGDEBUGMODE)) {printf ("APP5\n");}
	if (rlen<4) {break;}
	size = *(ifoff+2); size <<=8; size += *(ifoff+3);
	if (rlen<(size+2)) {break;}
	size+=2;
      } else if (*ifoff==0xff && *(ifoff+1)==0xe6) { /* APP6 */
	if (0 && FLGCHK(flags, FLGDEBUGMODE)) {printf ("APP6\n");}
	if (rlen<4) {break;}
	size = *(ifoff+2); size <<=8; size += *(ifoff+3);
	if (rlen<(size+2)) {break;}
	size+=2;
      } else if (*ifoff==0xff && *(ifoff+1)==0xe7) { /* APP7 */
	if (0 && FLGCHK(flags, FLGDEBUGMODE)) {printf ("APP7\n");}
	if (rlen<4) {break;}
	size = *(ifoff+2); size <<=8; size += *(ifoff+3);
	if (rlen<(size+2)) {break;}
	size+=2;
      } else if (*ifoff==0xff && *(ifoff+1)==0xe8) { /* APP8 */
	if (0 && FLGCHK(flags, FLGDEBUGMODE)) {printf ("APP8\n");}
	if (rlen<4) {break;}
	size = *(ifoff+2); size <<=8; size += *(ifoff+3);
	if (rlen<(size+2)) {break;}
	size+=2;
      } else if (*ifoff==0xff && *(ifoff+1)==0xe9) { /* APP9 */
	if (0 && FLGCHK(flags, FLGDEBUGMODE)) {printf ("APP9\n");}
	if (rlen<4) {break;}
	size = *(ifoff+2); size <<=8; size += *(ifoff+3);
	if (rlen<(size+2)) {break;}
	size+=2;
      } else if (*ifoff==0xff && *(ifoff+1)==0xea) { /* APPa */
	if (0 && FLGCHK(flags, FLGDEBUGMODE)) {printf ("APPa\n");}
	if (rlen<4) {break;}
	size = *(ifoff+2); size <<=8; size += *(ifoff+3);
	if (rlen<(size+2)) {break;}
	size+=2;
      } else if (*ifoff==0xff && *(ifoff+1)==0xeb) { /* APPb */
	if (0 && FLGCHK(flags, FLGDEBUGMODE)) {printf ("APPb\n");}
	if (rlen<4) {break;}
	size = *(ifoff+2); size <<=8; size += *(ifoff+3);
	if (rlen<(size+2)) {break;}
	size+=2;
      } else if (*ifoff==0xff && *(ifoff+1)==0xec) { /* APPc */
	if (0 && FLGCHK(flags, FLGDEBUGMODE)) {printf ("APPc\n");}
	if (rlen<4) {break;}
	size = *(ifoff+2); size <<=8; size += *(ifoff+3);
	if (rlen<(size+2)) {break;}
	size+=2;
      } else if (*ifoff==0xff && *(ifoff+1)==0xed) { /* APPd */
	if (0 && FLGCHK(flags, FLGDEBUGMODE)) {printf ("APPd\n");}
	if (rlen<4) {break;}
	size = *(ifoff+2); size <<=8; size += *(ifoff+3);
	/*printf ("appd size: 0x%4X\n", size);*/
	if (rlen<(size+2)) {break;}
	size+=2;
      } else if (*ifoff==0xff && *(ifoff+1)==0xee) { /* APPe */
	if (0 && FLGCHK(flags, FLGDEBUGMODE)) {printf ("APPe\n");}
	if (rlen<4) {break;}
	size = *(ifoff+2); size <<=8; size += *(ifoff+3);
	/*printf ("appd size: 0x%4X\n", size);*/
	if (rlen<(size+2)) {break;}
	size+=2;
      } else if (*ifoff==0xff && *(ifoff+1)==0xef) { /* APPf */
	if (0 && FLGCHK(flags, FLGDEBUGMODE)) {printf ("APPf\n");}
	if (rlen<4) {break;}
	size = *(ifoff+2); size <<=8; size += *(ifoff+3);
	/*printf ("appd size: 0x%4X\n", size);*/
	if (rlen<(size+2)) {break;}
	size+=2;
      } else if (*ifoff==0xff && *(ifoff+1)==0xda) { /* SOS */
	if (0 && FLGCHK(flags, FLGDEBUGMODE)) {printf ("SOS\n");}
	if (rlen<4) {break;}
	size = *(ifoff+2); size <<=8; size += *(ifoff+3);
	if (rlen<(size+2)) {break;}
	size+=2;
      } else if (*ifoff==0xff && *(ifoff+1)==0xfe) { /* comment */
	if (0 && FLGCHK(flags, FLGDEBUGMODE)) {printf ("comment\n");}
	if (rlen<4) {break;}
	size = *(ifoff+2); size <<=8; size += *(ifoff+3);
	if (rlen<(size+2)) {break;}
	size+=2;
      } else {
	if (0 && FLGCHK(flags, FLGDEBUGMODE)) {printf ("else: 0x%2X%2X\n", *ifoff, *(ifoff+1));}
	br=1; break;
      }
      /*if (1 && FLGCHK(flags, FLGDEBUGMODE)) {printf ("size: 0x%4X%\n", size);}*/
      
      if (pinfo->img_x!=0 && pinfo->img_y!=0) {br=1; break;}
      rlen -= size; ifoff += size; off_set += size;
    }
    if (br) {break;}
    
    
    /*-Get packet info from read data End---------------------------*/
    for (i=0; i<rlen; i++) {*(ifpot+i) = *(ifoff+i);}
    ifoff = ifpot + rlen;
  }
  if (pinfo->img_x==0 || pinfo->img_y==0) {pinfo->fm = 1;}
  /*-Get packet info from input file and dividing flow End----------*/
  free (ifpot);

  return ;
}

