/*
 * The MIT License (MIT)
 * 
 * Copyright (c) 2014 Yuki SAKAI
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 ******************************************************************************/

/*******************************************************************************
 * Include ********************************************************************/
#if !defined(REMPIC_H__)
#  include <rempic.h>
#endif
#if !defined(_SYS_STAT_H_) && !defined(_SYS_STAT_H)
#  include <sys/stat.h>
#endif
#if !defined(_STDIO_H_) && !defined(_STDIO_H)
#  include <stdio.h>
#endif
#if !defined(_STDLIB_H_) && !defined(_STDLIB_H)
#  include <stdlib.h>
#endif
#if !defined(_ERRNO_H_) && !defined(_ERRNO_H)
#  include <errno.h>
#endif



/*******************************************************************************
 * Path processing ************************************************************/
int path_proc (spname *pArray, unsigned int FileNum)
{
  int   i;
  int   rtn;

  if      (pArray==NULL) {fprintf (patherr, "no path\n"); return PPRABORT;}
  else if (FileNum==0  ) {fprintf (patherr, "no path\n"); return PPRABORT;}

  for (i=0; i<FileNum; i++) {
    /***************************************************************************
     * Get Path info **********************************************************/
    errno = 0;
    if (lstat ((char *)pArray[i].path, &(pArray[i].sb))<0) {
      switch (errno) {
      case EACCES      : fprintf (patherr, "%s: Can't access this path\n"       , pArray[i].path);                break;
      case ELOOP       : fprintf (patherr, "%s: Symbolic link is many\n"        , pArray[i].path);                break;
      case ENAMETOOLONG: fprintf (patherr, "%s: Path name is long\n"            , pArray[i].path);                break;
      case ENOENT      : fprintf (patherr, "%s: No such file or directory\n"    , pArray[i].path);                break;
      case ENOMEM      : fprintf (patherr, "%s: Empty memory\n"                 , pArray[i].path); goto stop_err; break;
      case ENOTDIR     : fprintf (patherr, "%s: Path is not directory or file\n", pArray[i].path);                break;
      }
      continue;
    }
    if      (S_ISREG(pArray[i].sb.st_mode)) {pArray[i].ft = SPFTFILE;  }
    else if (S_ISDIR(pArray[i].sb.st_mode)) {pArray[i].ft = SPFTDIR;   }
    else                                    {pArray[i].ft = SPFTOTHERS;}

    /***************************************************************************
     * Path processing ********************************************************/
    if (pArray[i].ft==SPFTFILE) {
      /* remove check and remove process */
      remove_chk (pArray[i]);
    } else if (pArray[i].ft==SPFTDIR) {
      /*=Directory read check=================================================*/
      if (FLGCHK(flags, FLGRECURSIVE)) {
	rtn = open_dir (&pArray[i]);
	if (rtn==PPRABORT)        {}
	else if (rtn==PPRALLKILL) {goto stop_err;}
	else {
	  rtn = path_proc (pArray[i].farray, pArray[i].fnum);
	  free (pArray[i].farray);
	  if (rtn==PPRALLKILL) {goto stop_err;}
	}
      }
    }
  }

  return 1;

 stop_err:
  return 0;
}


/*******************************************************************************
 * Main processing ************************************************************/
int main (int argc, char **argv)
{
  /**Option Processing Block***************************************************/
  if      (opt_proc (argc, argv)<0)               {goto non_proc_err;}
  else if (path_proc (patharray, FirstPathNum)<0) {goto non_proc_err;}
  free (patharray);
  
  return 0;

 non_proc_err:
  return 1;
}
