/*
 * The MIT License (MIT)
 * 
 * Copyright (c) 2014 Yuki SAKAI
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 ******************************************************************************/

#ifndef REMPIC_H__
#define REMPIC_H__ __DATE__

/*******************************************************************************
 * Include ********************************************************************/
#if !defined(MACRO_H_)
#  include <macro.h>
#endif
#if !defined(_SYS_PARAM_H_) && !defined(_SYS_PARAM_H)
#  include <sys/param.h>
#endif
#if !defined(_STDIO_H_) && !defined(_STDIO_H)
#  include <stdio.h>
#endif
#if !defined(_SYS_STAT_H_) && !defined(_SYS_STAT_H)
#  include <sys/stat.h>
#endif


/*******************************************************************************
 * Define *********************************************************************/
/*=Program state==============================================================*/
#define VERSION         "1.0.0"                 /* Program version            */
/*=Option Flags===============================================================*/
#define FLGALL          0x000003ff              /* All flags bits             */
#define FLGDEBUGMODE    0x00000001              /* Debug Mode ON (-D)         */
#define FLGRECURSIVE    0x00000002              /* Directory Recursive ON (-r)*/
#define FLGRMPICBADFILE 0x00000004              /* rm picture badfile (-b)    */
#define FLGALLFILES     0x00000008              /* target is ALL files (-a)   */
#define FLGRMUPPERSIZE  0x00000010              /* rm upper picture bytes (-S)*/
#define FLGRMLOWERSIZE  0x00000020              /* rm lower picture bytes (-s)*/
#define FLGRMUPPERX     0x00000040              /* rm upper picture x (-X)    */
#define FLGRMLOWERX     0x00000080              /* rm lower picture x (-x)    */
#define FLGRMUPPERY     0x00000100              /* rm upper picture y (-Y)    */
#define FLGRMLOWERY     0x00000200              /* rm lower picture y (-y)    */
/*=Path Process Return========================================================*/
#define PPRALLKILL      -1
#define PPRABORT        -2
/*=Remove check===============================================================*/
#define RMCHKINIT       0
#define RMCHKREMOVE     1
#define RMCHKSAVE       2
/*=Graphic extension==========================================================*/
#define GEXTERROR       0x00000000
#define GEXTNOGRAPHIC   0x00000001
#define GEXTGRAPHICALL  0x0000001e
#define GEXTJPG         0x00000002
#define GEXTPNG         0x00000004
#define GEXTJPEG        0x00000008
#define GEXTGIF         0x00000010
/*=Graphic config=============================================================*/
#define MAXMALLOCSIZE   0x1fffff                /* Max allocate memory size   */
/*=Graphic config(JPEG)=======================================================*/
#define JPGMARKSOL      0x1
#define JPGMARKEOL      0x2

/*******************************************************************************
 * Save Path name *************************************************************/
/*=File Type define===========================================================*/
#define SPFTINIT        0x00                    /* File type init             */
#define SPFTFILE        0x01                    /* File type is normal        */
#define SPFTDIR         0x02                    /* File type is dir           */
#define SPFTOTHERS      0x03                    /* Other file type            */
#define SPFTUNKNOWN     0x04                    /* File type is unknown       */
/*=structure==================================================================*/
typedef struct SAVEPATHNAME {
  struct SAVEPATHNAME *farray;
  unsigned char ft;               /* File Type */
  unsigned char path[MAXPATHLEN]; /* path name */
  unsigned int  fnum;             /* This directory have File number */
  struct stat   sb;
} spname;

/*******************************************************************************
 * Pic info *******************************************************************/
typedef struct {
  unsigned char  fm;
  unsigned int   ft;
  unsigned char  perUnit;
  off_t          fsize;
  unsigned long  img_x, img_y;
} picInfo;


/*******************************************************************************
 * Global functions ***********************************************************/
/*=file_chk===================================================================*/
void jpeg_chk (int fd, picInfo *pinfo);
unsigned int ext_chk (unsigned char *ext);
/*=open_dir===================================================================*/
int open_dir (spname *pspn);
/*=option.c===================================================================*/
int opt_proc (int argc, char **argv);
/*=remove.c===================================================================*/
int remove_chk (spname finfo);
/*=stdlib.c===================================================================*/
void * malloc_init (size_t size);
/*=usage.c====================================================================*/
void usage (void);
/*=jpg_chk====================================================================*/
void jpeg_chk (int fd, picInfo *pinfo);
/*=png_chk====================================================================*/
void png_chk (int fd, picInfo *pinfo);
/*=gif_chk====================================================================*/
void gif_chk (int fd, picInfo *pinfo);

/*******************************************************************************
 * Global variables ***********************************************************/
/*-Program state--------------------------------------------------------------*/
char *pname;                                    /* Program name               */
/*-Option Process-------------------------------------------------------------*/
unsigned int flags;
spname       *patharray;
unsigned int FirstPathNum;
unsigned int TargetFileType;
off_t        UpperSize, LowerSize;
unsigned int UpperX, LowerX;
unsigned int UpperY, LowerY;
/*-Error Output---------------------------------------------------------------*/
FILE *debugout;
FILE *usageout;
FILE *patherr;


#endif /* REMPIC_H__ */
