/*
	vfderr.h

	Virtual Floppy Disk driver control routines error message
	Copyright (C) 2003 Kenji Kato
*/

#ifndef _VFDERR_H_
#define _VFDERR_H_

//
//  Values are 32 bit values layed out as follows:
//
//   3 3 2 2 2 2 2 2 2 2 2 2 1 1 1 1 1 1 1 1 1 1
//   1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0
//  +---+-+-+-----------------------+-------------------------------+
//  |Sev|C|R|     Facility          |               Code            |
//  +---+-+-+-----------------------+-------------------------------+
//
//  where
//
//      Sev - is the severity code
//
//          00 - Success
//          01 - Informational
//          10 - Warning
//          11 - Error
//
//      C - is the Customer code flag
//
//      R - is a reserved bit
//
//      Facility - is the facility code
//
//      Code - is the facility's status code
//
//
// Define the facility codes
//
#define FACILITY_VFD                     0xFFF


//
// Define the severity codes
//


//
// MessageId: VFD_ERROR_DRIVER_FILE
//
// MessageText:
//
//  The file is not a Virtual FD driver, or the file is corrupt.
//
#define VFD_ERROR_DRIVER_FILE            ((DWORD)0xCFFF1001L)

//
// MessageId: VFD_ERROR_DRIVER_VERSION
//
// MessageText:
//
//  The Virtual FD driver version mismatch.
//
#define VFD_ERROR_DRIVER_VERSION         ((DWORD)0xCFFF1002L)

//
// MessageId: VFD_ERROR_DRIVER_LOCATION
//
// MessageText:
//
//  The Virtual FD driver cannot be started from a network drive.
//
#define VFD_ERROR_DRIVER_LOCATION        ((DWORD)0xCFFF1003L)

//
// MessageId: VFD_ERROR_ALREADY_LINKED
//
// MessageText:
//
//  The Virtual FD drive has a drive letter already assigned.
//
#define VFD_ERROR_ALREADY_LINKED         ((DWORD)0xCFFF1004L)

//
// MessageId: VFD_ERROR_IMAGE_SIZE
//
// MessageText:
//
//  Invalid image file size.
//
#define VFD_ERROR_IMAGE_SIZE             ((DWORD)0xCFFF1005L)

//
// MessageId: VFD_ERROR_IMAGE_ATTRIBUTE
//
// MessageText:
//
//  The file is either compressed or encrypted.
//
#define VFD_ERROR_IMAGE_ATTRIBUTE        ((DWORD)0xCFFF1006L)

//
// MessageId: VFD_ERROR_CREATE_READONLY
//
// MessageText:
//
//  Cannot create a new image file read-only.
//
#define VFD_ERROR_CREATE_READONLY        ((DWORD)0xCFFF1007L)

//
// MessageId: VFD_ERROR_DIRECTORY
//
// MessageText:
//
//  Specified path is a directory.
//
#define VFD_ERROR_DIRECTORY              ((DWORD)0xCFFF1008L)

//
//	Error number handling macro
//
#define IS_VFD_ERROR(x)	((((x) >> 16) & FACILITY_VFD) == FACILITY_VFD)

#endif	// _VFDERR_H_
