<?php

require_once('SimgPorter.php');

/**
 * 認証ポーター
 * @author System Concept
 *
 */
class AuthPorter extends SimgPorter {

	/**
	 * チェック処理
	 * @param $event イベント
	 * @param $output 出力
	 * @param $parameter パラメータ
	 * @param $db DB
	 * @return true/false=継続/中断
	 */
	public function check($event, $output, $parameter, $db) {
		$ret = false;
		if($event == EVENT_INDEX) {
			$ret = true;
		} else {
			$name = simg_get_value($parameter->get(P_USER_NAME), null);
			$pass = simg_get_value($parameter->get(P_USER_PASSWORD), '');
			$user = $db->findUser($name);
			if($this->userCheck($user, $name, $pass)) {
				$ret = true;
				setcookie(P_USER_NAME, $name);
				setcookie(P_USER_PASSWORD, $pass);
			} else {
				$output->setTemplate(TEMPLATE_LOGIN);
				if(!is_null($name)) {
					$output->setError(ERR_AUTHENTICATION_FAULT);
				}
			}
		}
		return $ret;
	}

	/**
	 * ユーザチェック
	 * @param $user ユーザ情報
	 * @param $name ユーザ名
	 * @param $pass パスワード
	 * @return true/false=OK/NG
	 */
	private function userCheck($user, $name, $pass) {
		$ret = false;
		if(!is_null($user)) {
			if($user[AT_NAME] == $name && $user[AT_PASSWORD] == $pass) {
				$ret = true;
			}
		}
		return $ret;
	}

	/**
	 * 優先順位取得
	 * @return 優先順位（値が小さい程優先順位が高い）
	*/
	public function getPriority() {
		return 1;
	}
}

?>
