<?php

require_once('Log.php');

/**
 * ログクラス
*/
class SimgLog {

	/**
	 * インスタンス
	 */
	static private $instance = null;
	/**
	 * PEARログインスタンス
	 */
	private $log = null;

	/**
	 * 構築
	 */
	private function __construct() {
		$this->log = null;
	}
	/**
	 * シングルトンインスタンス取得
	 * @return インスタンス
	 */
	public static function getInstance() {
		if(!isset(self::$instance)) {
			self::$instance = new SimgLog();
		}
		return self::$instance;
	}
	/**
	 * 初期化
	 * @param $logfilepath ログファイルパス
	 * @param $title タイトル
	 * @param $conf ログ関連パラメータ
	 */
	public function initialize($logfilepath, $title, $conf = array('mode'=>0777,'lineFormat' => '%1$s %3$s %2$s [%6$s]%5$s - %4$s','timeFormat'=>'%Y/%m/%d %H:%M:%S')) {
		$this->log = Log::singleton('file', $logfilepath, $title, $conf);
	}
	/**
	 * ログ出力
	 * @param $logtype ログタイプ
	 * @param $format 書式
	 * 可変引数：sprintfと同様
	 * [$logtype]
	 * PEAR_LOG_EMERG
	 * PEAR_LOG_ALERT
	 * PEAR_LOG_CRIT
	 * PEAR_LOG_ERR
	 * PEAR_LOG_WARNING
	 * PEAR_LOG_NOTICE
	 * PEAR_LOG_INFO
	 * PEAR_LOG_DEBUG
	 */
	public function put($logtype, $format) {
		if($this->log != null) {
			@$args = func_get_args();
			@array_shift($args);
			@$this->log ->log(call_user_func_array("sprintf", $args));
		}
	}
}

?>
