<?php

require_once('Smarty.class.php');
require_once('simg-functions.php');
require_once('SimgLog.php');

define('SS_PARAM_QUERY', 'query');
define('SS_PARAM_DIRECTORY', 'directory');
define('SS_PARAM_VALUE', 'value');
define('SS_PARAM_ASSOC', 'assoc');

/**
 * プラグイン初期化
 * @param $smarty Smartyインスタンス
 */
function simg_smarty_initialize($smarty) {
	$smarty->registerPlugin(Smarty::PLUGIN_FUNCTION, 'ss_url', '__make_url');
	$smarty->registerPlugin(Smarty::PLUGIN_FUNCTION, 'ss_json_decode', '__json_decode');
	$smarty->registerPlugin(Smarty::PLUGIN_FUNCTION, 'ss_json_encode', '__json_encode');
	$smarty->registerPlugin(Smarty::PLUGIN_FUNCTION, 'ss_url_encode', '__url_encode');
}

/**
 * URL作成
 */
function __make_url($params, &$smarty) {
	$queries = array();
	$wq = simg_get_array_value($params, SS_PARAM_QUERY, null);
	if($wq != null && strlen($wq) > 0) {
		parse_str($wq, $queries);
	}
	//SimgLog::getInstance()->put(PEAR_LOG_DEBUG, "__make_url queries: [%s]", print_r($queries, true));
	$dir = simg_get_array_value($params, SS_PARAM_DIRECTORY, '');
	return simg_make_url($dir, $queries);
}

/**
 * JSON文字列デコード
 */
function __json_decode($params, &$smarty) {
	$v = simg_get_array_value($params, SS_PARAM_VALUE, '');
	$a = simg_get_array_value($params, SS_PARAM_ASSOC, false);
	return json_decode($v, $a);
}

/**
 * JSON文字列エンコード
 */
function __json_encode($params, &$smarty) {
	$v = simg_get_array_value($params, SS_PARAM_VALUE, '');
	return json_encode($v);
}

/**
 * URLエンコード
 */
function __url_encode($params, &$smarty) {
	$v = simg_get_array_value($params, SS_PARAM_VALUE, '');
	return rawurlencode($v);
}

?>
