/*
 * Decompiled with CFR 0.152.
 */
package webScraping.core;

import java.util.logging.Formatter;
import java.util.logging.LogRecord;

class HtmlFormatter
extends Formatter {
    HtmlFormatter() {
    }

    @Override
    public synchronized String format(LogRecord aRecord) {
        StringBuffer message = new StringBuffer(100);
        long millis = aRecord.getMillis();
        String time = String.format("%tF %<tT", millis);
        message.append(time);
        message.append(' ');
        message.append(aRecord.getLevel());
        message.append('<');
        String methodName = aRecord.getSourceMethodName();
        message.append(methodName != null ? methodName : "N/A");
        message.append('>');
        message.append(this.formatMessage(aRecord));
        message.append('\n');
        Throwable throwable = aRecord.getThrown();
        if (throwable != null) {
            message.append(throwable.toString());
            message.append('\n');
            for (StackTraceElement trace : throwable.getStackTrace()) {
                message.append('\t');
                message.append(trace.toString());
                message.append('\n');
            }
        }
        return message.toString();
    }
}

