﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Configuration;
using System.IO;
using System.Text.RegularExpressions;

namespace JCLEmulator
{
    class analizeClass
    {
        string jobname { get; set; }
        Dictionary<string, string> ddparam { get;set;}
        Dictionary<string, string> convertList { get; set; }
        Dictionary<string, string> values { get; set; }
        Dictionary<string, int> RCCODE { get; set; }

        public analizeClass()
        {
            this.jobname = "";
            this.ddparam = new Dictionary<string, string>();
            this.convertList = new Dictionary<string, string>();
            this.values = new Dictionary<string, string>();
            RCCODE = new Dictionary<string, int>();
        }

        public analizeClass(string jobname, Dictionary<string, string> ddparam, Dictionary<string, string> convertList, Dictionary<string, string> values)
        {
            this.jobname = jobname;
            this.ddparam = ddparam;
            this.convertList = convertList;
            this.values = values;
            RCCODE = new Dictionary<string, int>();
        }

        /// <summary>
        /// JCL実行用メソッド
        /// </summary>
        public int JCLExecute()
        {
            StreamReader sr = new StreamReader(getFilePath(), Encoding.GetEncoding(ConfigurationManager.AppSettings["fileEncoding"]));
            
            string seekline = sr.ReadLine();
            bool nextflag = true;

            //１行づつ読む
            while (nextflag)
            {
                string bufferline = seekline;

                if (sr.Peek() > -1) { nextflag = false; }

                //キー判定
                if (Regex.IsMatch(seekline, regxConst.jobKey, RegexOptions.IgnoreCase))
                {
                    //JOBの場合
                    if (nextflag) { seekline = sr.ReadLine(); }

                }
                else if (Regex.IsMatch(seekline, regxConst.procKey, RegexOptions.IgnoreCase))
                {
                    //PROCの場合

                    //次行に流れていないか検索
                    bufferline = nextLineCheck(bufferline, out seekline, sr, out nextflag);

                    getValueData(bufferline, regxConst.procKey);

                }
                else if (Regex.IsMatch(seekline, regxConst.setKey, RegexOptions.IgnoreCase))
                {
                    //SETの場合

                    //次行に流れていないか検索
                    bufferline = nextLineCheck(bufferline, out seekline, sr, out nextflag);

                    getValueData(bufferline, regxConst.setKey);

                }
                else if (Regex.IsMatch(seekline, regxConst.setValueKey, RegexOptions.IgnoreCase))
                {
                    //SETVALUEの場合

                    //次行に流れていないか検索
                    bufferline = nextLineCheck(bufferline, out seekline, sr, out nextflag);

                    getValueData(bufferline, regxConst.setValueKey);

                }
                else if (Regex.IsMatch(seekline, regxConst.execPGMKey, RegexOptions.IgnoreCase))
                {
                    //PGMの場合

                    //次行に流れていないか検索
                    bufferline = nextLineCheck(bufferline, out seekline, sr, out nextflag);

                    //変数取得
                    Dictionary<string, string> getValuesList = splitmapper(Regex.Match(bufferline, regxConst.execPGMKey, RegexOptions.IgnoreCase).Groups[1].Value);

                    //CONDチェック
                    if (getCONDCHECK(getValuesList))
                    {
                        analizeClass execlass = new analizeClass();
                        execlass.jobname = getValuesList["PGM"];
                        execlass.convertList = convertList;

                        foreach (string keysdata in getValuesList.Keys)
                        {
                            if (!keysdata.Contains("PGM")) execlass.values.Add(keysdata, getValuesList[keysdata]);
                        }

                        //DDチェック

                    }
                }

            }
        }

        /// <summary>
        /// PGM実行用メソッド
        /// </summary>
        public int PGMExecute()
        {
            System.Diagnostics.Process p =
    System.Diagnostics.Process.Start("C:\\test\\1.txt");
            p.WaitForExit();
        }

        /// <summary>
        /// 実行パス取得用メソッド
        /// </summary>
        private string getFilePath()
        {
            if (convertList.ContainsKey(jobname))
            {
                return convertList[jobname];
            }
            else
            {
                return Path.Combine(ConfigurationManager.AppSettings["folderPath"], jobname);
            }
        }

        /// <summary>
        /// 変数分解メソッド
        /// </summary>
        private Dictionary<string,string> splitmapper(string target)
        {
            Dictionary<string,string> list = new Dictionary<string,string>();
            string[] KeysString = regx.getMathers(target, regxConst.splitvalue);
            string[] valueString = target.Split(KeysString, StringSplitOptions.RemoveEmptyEntries);

            for (int i = 0;i < KeysString.Length;i++)
            {
                list.Add(KeysString[i].Replace("=", ""), replaceMapper(valueString[i]));
            }

            return list;

        }

        /// <summary>
        /// 変数置換メソッド
        /// </summary>
        private string replaceMapper(string targetString)
        {
            string bufferString = targetString.TrimEnd(',').TrimStart(new char[] { '"', '\'' }).TrimEnd(new char[] { '"', '\'' });

            foreach (string keyString in this.values.Keys)
            {
                bufferString = bufferString.Replace("&&" + keyString, this.values[keyString]);
                bufferString = bufferString.Replace("&" + keyString, this.values[keyString]);
                bufferString = bufferString.Replace("%" + keyString, this.values[keyString]);

            }

            return bufferString;
        }

        /// <summary>
        /// 次行を探索
        /// </summary>
        private string nextLineCheck(string targetString, out string seekline,StreamReader sr,out bool nextflag)
        {
            string bufferline = targetString;

            //次のシーク行初期化
            seekline = null;
            nextflag = true;

            //次の行に続いているかチェック
            if (sr.Peek() > -1)
            {
                while (Regex.IsMatch(seekline = sr.ReadLine(), regxConst.nextstep, RegexOptions.IgnoreCase))
                {
                    bufferline = bufferline.Replace("\r\n", "") + seekline.Replace("\r\n", "");
                    if (sr.Peek() == -1) {
                        nextflag = false;
                        break; 
                    }
                }     
            }
            else
            {
                nextflag = false;
            }

            return bufferline;
        }

        /// <summary>
        /// 変数取得メソッド
        /// </summary>
        private void getValueData(string bufferline, string propkey)
        {
            //変数取得
            Dictionary<string, string> getValuesList = splitmapper(Regex.Match(bufferline, propkey, RegexOptions.IgnoreCase).Groups[1].Value);

            //変数格納
            foreach (string keyString in getValuesList.Keys)
            {
                if (!this.values.ContainsKey(keyString))
                {
                    this.values.Add(keyString, getValuesList[keyString]);
                }
            }
        }

        /// <summary>
        /// CONDチェックメソッド
        /// </summary>
        private bool getCONDCHECK(Dictionary<string,string> paramlist)
        {
            bool checkflag = true;

            foreach(string keyString in paramlist.Keys){

                if (keyString.Contains("COND"))
                {
                    string code = paramlist[keyString].Split(',')[0].Replace("(", "").Trim();
                    string exact = paramlist[keyString].Split(',')[1].Replace(")", "").Trim();

                    //ステップ指定あり
                    if (paramlist[keyString].Length == 3)
                    {
                        string stepString = paramlist[keyString].Split(',')[2].Replace(")", "").Trim();
                        checkflag = EXCATCHECK(exact, int.Parse(code), RCCODE[stepString]);
                    }
                    else
                    {
                        //ステップ指定なし
                        foreach(int checkcode in RCCODE.Values){

                            if (!EXCATCHECK(exact, int.Parse(code), checkcode))
                            {
                                checkflag = false;
                            }
                        }
                    }

                    break;
                }
            }

            return checkflag;
        }

        /// <summary>
        /// 条件チェック
        /// </summary>
        private bool EXCATCHECK(string exact,int code,int checkcode)
        {
            if (exact.Contains("GT"))
            {
                if (checkcode >= code) return true;
            }
            else if (exact.Contains("GE"))
            {
                if (checkcode > code) return true;
            }
            else if (exact.Contains("EQ"))
            {
                if (checkcode != code) return true;
            }
            else if (exact.Contains("LT"))
            {
                if (checkcode <= code) return true;
            }
            else if (exact.Contains("LE"))
            {
                if (checkcode < code) return true;
            }
            else if (exact.Contains("NE"))
            {
                if (checkcode == code) return true;
            }

            return false;
        }
    }
}
