/*
 *  TOPPERS/ASP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Advanced Standard Profile Kernel
 * 
 *  Copyright (C) 2008 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 *  Copyright (C) 2010 by Meika Sugimoto
 * 
 *  L쌠҂́Cȉ(1)`(4)̏𖞂ꍇɌC{\tgEF
 *  Ai{\tgEFAς̂܂ށDȉjgpEE
 *  ρEĔzziȉCpƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *      ܂C{\tgEFÃ[U܂̓Gh[ÛȂ闝
 *      RɊÂCL쌠҂TOPPERSvWFNg
 *      Ɛӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̎gpړI
 *  ɑ΂K܂߂āCȂۏ؂sȂD܂C{\tgEF
 *  A̗pɂ蒼ړI܂͊ԐړIɐȂ鑹QɊւĂC
 *  ̐ӔC𕉂ȂD
 * 
 */
 
 /*
 *  TOPPERS/SSP̃TvvO
 */

#include <kernel.h>
#include <sil.h>
#include "kernel_cfg.h"
#include "pdic/rx600-SIM-CONSOLE/Console.h"
#include "syssvc/serial.h"

#include "sample1.h"

/*
 *  Oo
 */
#define LOGPUT(str)	\
	Console_puts( (const char_t *)(str) , sizeof(str)/sizeof((str)[0]))

#define TASKLOG(tskno , message , buf)		\
	do										\
	{										\
		LOGPUT("Task ");					\
		(buf)[0] = (tskno) + '0';			\
		LOGPUT(buf);						\
		LOGPUT(" " message ".\n");			\
	} while(0)

/*
 *  VXeT[rX̃G[nhO
 */
#define SVC(expression)			\
	if((expression) < 0)		\
	{							\
		LOGPUT("Error at : ");	\
		LOGPUT(__FILE__);		\
		LOGPUT(" caused by ");	\
		LOGPUT(#expression);	\
		LOGPUT(".\n");			\
	}

/*
 *  s^XNւ̃bZ[Ẅ
 */
char_t message[3];

/*
 *  [v
 */
ulong_t	task_loop;		/* ^XNł̃[v */


void init_task(intptr_t exinf)
{
#ifndef TASK_LOOP
	volatile ulong_t	i;
	SYSTIM	stime1, stime2;
#endif /* TASK_LOOP */
	
	/* VA|[g̃I[v */
	SVC(serial_opn_por(SIO_PORTID));
	SVC(serial_ctl_por(SIO_PORTID , IOCTL_CRLF));
	
	/* NbZ[W̏o */
	LOGPUT("Sample program starts.\n");
	
	/* C^XN̋N */
	SVC(act_tsk(MAIN_TASK));

	/*
 	 *  [v񐔂̐ݒ
	 *
	 *  TASK_LOOP}N`ĂꍇC肹ɁCTASK_LOOPɒ
	 *  `ꂽlC^XNł̃[v񐔂ƂD
	 *
	 *  MEASURE_TWICE}N`ĂꍇC1ڂ̑茋ʂ̂
	 *  āC2ڂ̑茋ʂgD1ڂ̑͒߂̎Ԃo邽߁D
	 */
#ifdef TASK_LOOP
	task_loop = TASK_LOOP;
#else /* TASK_LOOP */

	task_loop = LOOP_REF;
	SVC(get_tim(&stime1));
//	for (i = 0; i < task_loop; i++);
	SVC(get_tim(&stime2));
	task_loop = LOOP_REF * 400UL / (stime2 - stime1);

#endif /* TASK_LOOP */

}


void main_task(intptr_t exinf)
{
	static ID tskid = TASK1;
	static uint_t tskno = 1;
	char_t c;
	
	LOGPUT("task running\n");
	/* VA|[g̕M */
	if(serial_rea_dat(SIO_PORTID , &c , 1) > 0)
	{
		switch(c)
		{
		case 'e':
		case 'z':
		case 'Z':
		case 'r':
			message[tskno] = c;
		    break;
		case '1':
			tskid = TASK1;
			tskno = 0;
			break;
		case '2':
			tskid = TASK2;
			tskno = 1;
			break;
		case '3':
			tskid = TASK3;
			tskno = 2;
			break;
		case 'a':
			SVC(act_tsk(tskid));
			break;
		case 'Q':
			LOGPUT("Sample program ends.");
			ext_ker();
			break;
		default:
			/* G[\ */
			LOGPUT("Unknown command.");
			break;
		}
	}
}


void task(intptr_t exinf)
{
	/* exinf̓^XNԍ  */
	uint_t tskno = (uint_t)exinf;
	char_t command;
	char_t buf[1];
	bool_t cont = true;
	const ID next_tskid[3] = { TASK2 , TASK3 , TASK1 };
	volatile ulong_t	i;
	
	TASKLOG(tskno , "activate" , buf);
	
	do
	{
		for (i = 0; i < task_loop; i++)
			;
		
		/* ^XNԍ̕\ */
		TASKLOG(tskno , "running" , buf);
		
		/* R}h擾CbZ[ẄNA */
		command = message[tskno - 1];
		message[tskno - 1] = 0;
		
		switch(command)
		{
		case 'e':
			cont = false;
			TASKLOG(tskno , "exit" , buf);
			break;
		case 'r':
			SVC(act_tsk(next_tskid[tskno - 1]));
			cont = false;
			break;
		case 'z':
			RAISE_CPU_EXCEPTION;
			break;
		default:
			break;
		}
	}while(cont == true);
}

void cyclic_handler(intptr_t exinf)
{
	ID tskid = (ID)exinf;
	
	SVC(iact_tsk(tskid));
}

#ifdef TEST_EXC
void exc_handler(void *p_excinf)
{
	LOGPUT("CPU exception handler.\n");
	ext_ker();
}
#endif /* TEST_EXC */

