/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.db;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import org.apache.flink.streaming.connectors.db.CustomSerializationDBState;
import org.apache.flink.streaming.connectors.db.DBSerializer;
import org.apache.flink.streaming.connectors.db.DBStateIterator;
import org.apache.flink.streaming.connectors.db.DBStateWithIterator;
import org.apache.flink.streaming.connectors.db.DefaultDBSerializer;
import org.fusesource.leveldbjni.JniDBFactory;
import org.iq80.leveldb.DB;
import org.iq80.leveldb.DBIterator;
import org.iq80.leveldb.Options;

public class LevelDBState<K extends Serializable, V extends Serializable>
extends CustomSerializationDBState<K, V>
implements DBStateWithIterator<K, V> {
    private DB database;

    public LevelDBState(String dbName, DBSerializer<K> keySerializer, DBSerializer<V> valueSerializer) {
        super(keySerializer, valueSerializer);
        Options options = new Options();
        File file = new File(dbName);
        options.createIfMissing(true);
        try {
            JniDBFactory.factory.destroy(file, options);
            this.database = JniDBFactory.factory.open(file, options);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public LevelDBState(String dbName) {
        this(dbName, new DefaultDBSerializer(), new DefaultDBSerializer());
    }

    @Override
    public void close() {
        try {
            this.database.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void put(K key, V value) {
        this.database.put(this.keySerializer.write(key), this.valueSerializer.write(value));
    }

    @Override
    public V get(K key) {
        byte[] serializedValue = this.database.get(this.keySerializer.write(key));
        if (serializedValue != null) {
            return (V)this.valueSerializer.read(serializedValue);
        }
        throw new RuntimeException("No such entry at key " + key);
    }

    @Override
    public void remove(K key) {
        this.database.delete(this.keySerializer.write(key));
    }

    @Override
    public DBStateIterator<K, V> getIterator() {
        return new LevelDBStateIterator();
    }

    private class LevelDBStateIterator
    extends DBStateIterator<K, V> {
        private DBIterator iterator;

        public LevelDBStateIterator() {
            this.iterator = LevelDBState.this.database.iterator();
            this.iterator.seekToFirst();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public K getNextKey() {
            return LevelDBState.this.keySerializer.read((byte[])this.iterator.peekNext().getKey());
        }

        @Override
        public V getNextValue() {
            return LevelDBState.this.valueSerializer.read((byte[])this.iterator.peekNext().getValue());
        }

        @Override
        public void next() {
            this.iterator.next();
        }
    }
}

