/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.db;

import java.io.IOException;
import java.net.InetSocketAddress;
import net.spy.memcached.MemcachedClient;
import org.apache.flink.streaming.connectors.db.DBState;

public class MemcachedState<V>
implements DBState<String, V> {
    private MemcachedClient memcached;

    public MemcachedState() {
        try {
            this.memcached = new MemcachedClient(new InetSocketAddress[]{new InetSocketAddress("localhost", 11211)});
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public MemcachedState(String hostname, int portNum) {
        try {
            this.memcached = new MemcachedClient(new InetSocketAddress[]{new InetSocketAddress(hostname, portNum)});
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() {
        this.memcached.shutdown();
    }

    @Override
    public void put(String key, V value) {
        this.memcached.set(key, 0, value);
    }

    @Override
    public V get(String key) {
        return (V)this.memcached.get(key);
    }

    @Override
    public void remove(String key) {
        this.memcached.delete(key.toString());
    }
}

