/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.flume;

import org.apache.flink.streaming.api.datastream.DataStreamSink;
import org.apache.flink.streaming.api.environment.LocalStreamEnvironment;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.connectors.flume.FlumeSink;
import org.apache.flink.streaming.connectors.flume.FlumeSource;
import org.apache.flink.streaming.connectors.util.SerializationSchema;
import org.apache.flink.streaming.connectors.util.SimpleStringSchema;

public class FlumeTopology {
    public static void main(String[] args) throws Exception {
        LocalStreamEnvironment env = StreamExecutionEnvironment.createLocalEnvironment((int)1);
        DataStreamSink dataStream1 = env.addSource(new FlumeSource<String>("localhost", 41414, new SimpleStringSchema())).addSink(new FlumeSink<String>("localhost", 42424, new StringToByteSerializer()));
        env.execute();
    }

    public static class StringToByteSerializer
    implements SerializationSchema<String, byte[]> {
        private static final long serialVersionUID = 1L;

        @Override
        public byte[] serialize(String element) {
            return element.getBytes();
        }
    }
}

