/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.kafka;

import java.util.Properties;
import kafka.javaapi.producer.Producer;
import kafka.producer.KeyedMessage;
import kafka.producer.ProducerConfig;
import org.apache.flink.streaming.api.function.sink.RichSinkFunction;
import org.apache.flink.streaming.connectors.util.SerializationSchema;

public class KafkaSink<IN, OUT>
extends RichSinkFunction<IN> {
    private static final long serialVersionUID = 1L;
    private Producer<Integer, OUT> producer;
    private Properties props;
    private String topicId;
    private String brokerAddr;
    private boolean initDone = false;
    private SerializationSchema<IN, OUT> scheme;

    public KafkaSink(String topicId, String brokerAddr, SerializationSchema<IN, OUT> serializationSchema) {
        this.topicId = topicId;
        this.brokerAddr = brokerAddr;
        this.scheme = serializationSchema;
    }

    public void initialize() {
        this.props = new Properties();
        this.props.put("metadata.broker.list", this.brokerAddr);
        this.props.put("serializer.class", "kafka.serializer.StringEncoder");
        this.props.put("request.required.acks", "1");
        ProducerConfig config = new ProducerConfig(this.props);
        this.producer = new Producer(config);
        this.initDone = true;
    }

    public void invoke(IN next) {
        if (!this.initDone) {
            this.initialize();
        }
        this.producer.send(new KeyedMessage(this.topicId, this.scheme.serialize(next)));
    }

    public void close() {
        this.producer.close();
    }
}

