/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.kafka;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import kafka.consumer.Consumer;
import kafka.consumer.ConsumerConfig;
import kafka.consumer.ConsumerIterator;
import kafka.consumer.KafkaStream;
import kafka.javaapi.consumer.ConsumerConnector;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.connectors.ConnectorSource;
import org.apache.flink.streaming.connectors.util.DeserializationSchema;
import org.apache.flink.util.Collector;

public class KafkaSource<OUT>
extends ConnectorSource<OUT> {
    private static final long serialVersionUID = 1L;
    private final String zkQuorum;
    private final String groupId;
    private final String topicId;
    private ConsumerConnector consumer;
    OUT outTuple;

    public KafkaSource(String zkQuorum, String groupId, String topicId, DeserializationSchema<OUT> deserializationSchema) {
        super(deserializationSchema);
        this.zkQuorum = zkQuorum;
        this.groupId = groupId;
        this.topicId = topicId;
    }

    private void initializeConnection() {
        Properties props = new Properties();
        props.put("zookeeper.connect", this.zkQuorum);
        props.put("group.id", this.groupId);
        props.put("zookeeper.session.timeout.ms", "2000");
        props.put("zookeeper.sync.time.ms", "200");
        props.put("auto.commit.interval.ms", "1000");
        this.consumer = Consumer.createJavaConsumerConnector((ConsumerConfig)new ConsumerConfig(props));
    }

    public void invoke(Collector<OUT> collector) throws Exception {
        Object out;
        Map consumerMap = this.consumer.createMessageStreams(Collections.singletonMap(this.topicId, 1));
        KafkaStream stream = (KafkaStream)((List)consumerMap.get(this.topicId)).get(0);
        ConsumerIterator it = stream.iterator();
        while (it.hasNext() && !this.schema.isEndOfStream(out = this.schema.deserialize((byte[])it.next().message()))) {
            collector.collect(out);
        }
        this.consumer.shutdown();
    }

    public void open(Configuration config) {
        this.initializeConnection();
    }
}

