/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.kafka;

import org.apache.flink.streaming.api.datastream.DataStreamSink;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.function.source.SourceFunction;
import org.apache.flink.streaming.connectors.kafka.KafkaSink;
import org.apache.flink.streaming.connectors.kafka.KafkaSource;
import org.apache.flink.streaming.connectors.util.SimpleStringSchema;
import org.apache.flink.util.Collector;

public class KafkaTopology {
    public static void main(String[] args) throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        DataStreamSink stream1 = env.addSource(new KafkaSource<String>("localhost:2181", "group", "test", new SimpleStringSchema())).print();
        DataStreamSink stream2 = env.addSource((SourceFunction)new MySource()).addSink(new KafkaSink<String, String>("test", "localhost:9092", new SimpleStringSchema()));
        env.execute();
    }

    public static final class MySource
    implements SourceFunction<String> {
        private static final long serialVersionUID = 1L;

        public void invoke(Collector<String> collector) throws Exception {
            for (int i = 0; i < 10; ++i) {
                collector.collect((Object)new String(Integer.toString(i)));
            }
            collector.collect((Object)new String("q"));
        }
    }
}

