/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.rabbitmq;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.QueueingConsumer;
import java.io.IOException;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.connectors.ConnectorSource;
import org.apache.flink.streaming.connectors.util.DeserializationSchema;
import org.apache.flink.util.Collector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RMQSource<OUT>
extends ConnectorSource<OUT> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(RMQSource.class);
    private final String QUEUE_NAME;
    private final String HOST_NAME;
    private transient ConnectionFactory factory;
    private transient Connection connection;
    private transient Channel channel;
    private transient QueueingConsumer consumer;
    private transient QueueingConsumer.Delivery delivery;
    OUT out;

    public RMQSource(String HOST_NAME, String QUEUE_NAME, DeserializationSchema<OUT> deserializationSchema) {
        super(deserializationSchema);
        this.HOST_NAME = HOST_NAME;
        this.QUEUE_NAME = QUEUE_NAME;
    }

    private void initializeConnection() {
        this.factory = new ConnectionFactory();
        this.factory.setHost(this.HOST_NAME);
        try {
            this.connection = this.factory.newConnection();
            this.channel = this.connection.createChannel();
            this.channel.queueDeclare(this.QUEUE_NAME, false, false, false, null);
            this.consumer = new QueueingConsumer(this.channel);
            this.channel.basicConsume(this.QUEUE_NAME, true, (Consumer)this.consumer);
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot create RMQ connection with " + this.QUEUE_NAME + " at " + this.HOST_NAME, e);
        }
    }

    public void invoke(Collector<OUT> collector) throws Exception {
        while (true) {
            block3: {
                try {
                    this.delivery = this.consumer.nextDelivery();
                }
                catch (Exception e) {
                    if (!LOG.isErrorEnabled()) break block3;
                    LOG.error("Cannot recieve RMQ message {} at {}", (Object)this.QUEUE_NAME, (Object)this.HOST_NAME);
                }
            }
            this.out = this.schema.deserialize(this.delivery.getBody());
            if (this.schema.isEndOfStream(this.out)) break;
            collector.collect(this.out);
        }
    }

    public void open(Configuration config) {
        this.initializeConnection();
    }

    public void close() {
        try {
            this.connection.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Error while closing RMQ connection with " + this.QUEUE_NAME + " at " + this.HOST_NAME, e);
        }
    }
}

