/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.rabbitmq;

import java.io.Serializable;
import org.apache.flink.streaming.api.datastream.DataStreamSink;
import org.apache.flink.streaming.api.environment.LocalStreamEnvironment;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.connectors.rabbitmq.RMQSink;
import org.apache.flink.streaming.connectors.rabbitmq.RMQSource;
import org.apache.flink.streaming.connectors.util.SerializationSchema;
import org.apache.flink.streaming.connectors.util.SimpleStringSchema;

public class RMQTopology {
    public static void main(String[] args) throws Exception {
        LocalStreamEnvironment env = StreamExecutionEnvironment.createLocalEnvironment((int)1);
        DataStreamSink dataStream1 = env.addSource(new RMQSource<String>("localhost", "hello", new SimpleStringSchema())).print();
        DataStreamSink dataStream2 = env.fromElements((Serializable[])new String[]{"one", "two", "three", "four", "five", "q"}).addSink(new RMQSink<String>("localhost", "hello", new StringToByteSerializer()));
        env.execute();
    }

    public static class StringToByteSerializer
    implements SerializationSchema<String, byte[]> {
        private static final long serialVersionUID = 1L;

        @Override
        public byte[] serialize(String element) {
            return element.getBytes();
        }
    }
}

