/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.twitter;

import com.twitter.hbc.ClientBuilder;
import com.twitter.hbc.core.endpoint.StatusesSampleEndpoint;
import com.twitter.hbc.core.endpoint.StreamingEndpoint;
import com.twitter.hbc.core.processor.HosebirdMessageProcessor;
import com.twitter.hbc.core.processor.StringDelimitedProcessor;
import com.twitter.hbc.httpclient.BasicClient;
import com.twitter.hbc.httpclient.auth.Authentication;
import com.twitter.hbc.httpclient.auth.OAuth1;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Properties;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.function.source.RichParallelSourceFunction;
import org.apache.flink.util.Collector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TwitterSource
extends RichParallelSourceFunction<String> {
    private static final Logger LOG = LoggerFactory.getLogger(TwitterSource.class);
    private static final long serialVersionUID = 1L;
    private String authPath;
    private transient BlockingQueue<String> queue;
    private int queueSize = 10000;
    private transient BasicClient client;
    private int waitSec = 5;
    private boolean streaming;
    private int numberOfTweets;

    public TwitterSource(String authPath) {
        this.authPath = authPath;
        this.streaming = true;
    }

    public TwitterSource(String authPath, int numberOfTweets) {
        this.authPath = authPath;
        this.streaming = false;
        this.numberOfTweets = numberOfTweets;
    }

    public void open(Configuration parameters) throws Exception {
        this.initializeConnection();
    }

    public void invoke(Collector<String> collector) throws Exception {
        if (this.streaming) {
            this.collectMessages(collector);
        } else {
            this.collectFiniteMessages(collector);
        }
    }

    public void close() throws Exception {
        this.closeConnection();
    }

    private void initializeConnection() {
        if (LOG.isInfoEnabled()) {
            LOG.info("Initializing Twitter Streaming API connection");
        }
        this.queue = new LinkedBlockingQueue<String>(this.queueSize);
        StatusesSampleEndpoint endpoint = new StatusesSampleEndpoint();
        endpoint.stallWarnings(false);
        OAuth1 auth = this.authenticate();
        this.initializeClient(endpoint, (Authentication)auth);
        if (LOG.isInfoEnabled()) {
            LOG.info("Twitter Streaming API connection established successfully");
        }
    }

    private OAuth1 authenticate() {
        Properties authenticationProperties = this.loadAuthenticationProperties();
        return new OAuth1(authenticationProperties.getProperty("consumerKey"), authenticationProperties.getProperty("consumerSecret"), authenticationProperties.getProperty("token"), authenticationProperties.getProperty("secret"));
    }

    private Properties loadAuthenticationProperties() {
        Properties properties = new Properties();
        try {
            FileInputStream input = new FileInputStream(this.authPath);
            properties.load(input);
            ((InputStream)input).close();
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot open .properties file: " + this.authPath, e);
        }
        return properties;
    }

    private void initializeClient(StatusesSampleEndpoint endpoint, Authentication auth) {
        this.client = new ClientBuilder().name("twitterSourceClient").hosts("https://stream.twitter.com").endpoint((StreamingEndpoint)endpoint).authentication(auth).processor((HosebirdMessageProcessor)new StringDelimitedProcessor(this.queue)).build();
        this.client.connect();
    }

    protected void collectFiniteMessages(Collector<String> collector) {
        if (LOG.isInfoEnabled()) {
            LOG.info("Collecting tweets");
        }
        for (int i = 0; i < this.numberOfTweets; ++i) {
            this.collectOneMessage(collector);
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("Collecting tweets finished");
        }
    }

    protected void collectMessages(Collector<String> collector) {
        if (LOG.isInfoEnabled()) {
            LOG.info("Tweet-stream begins");
        }
        while (true) {
            this.collectOneMessage(collector);
        }
    }

    protected void collectOneMessage(Collector<String> collector) {
        if (this.client.isDone() && LOG.isErrorEnabled()) {
            LOG.error("Client connection closed unexpectedly: {}", (Object)this.client.getExitEvent().getMessage());
        }
        try {
            String msg = this.queue.poll(this.waitSec, TimeUnit.SECONDS);
            if (msg != null) {
                collector.collect((Object)msg);
            } else if (LOG.isInfoEnabled()) {
                LOG.info("Did not receive a message in {} seconds", (Object)this.waitSec);
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException("'Waiting for tweet' thread is interrupted", e);
        }
    }

    private void closeConnection() {
        if (LOG.isInfoEnabled()) {
            LOG.info("Initiating connection close");
        }
        this.client.stop();
        if (LOG.isInfoEnabled()) {
            LOG.info("Connection closed successfully");
        }
    }

    public int getQueueSize() {
        return this.queueSize;
    }

    public void setQueueSize(int queueSize) {
        this.queueSize = queueSize;
    }

    public int getWaitSec() {
        return this.waitSec;
    }

    public void setWaitSec(int waitSec) {
        this.waitSec = waitSec;
    }
}

