/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.twitter;

import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.function.source.SourceFunction;
import org.apache.flink.streaming.connectors.json.JSONParseFlatMap;
import org.apache.flink.streaming.connectors.twitter.TwitterSource;
import org.apache.flink.util.Collector;
import org.apache.sling.commons.json.JSONException;

public class TwitterTopology {
    private static final int NUMBEROFTWEETS = 100;

    public static void main(String[] args) throws Exception {
        String path = new String();
        if (args == null || args.length != 1) {
            System.err.println("USAGE:\nTwitterLocal <pathToPropertiesFile>");
            return;
        }
        path = args[0];
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        DataStreamSource streamSource = env.addSource((SourceFunction)new TwitterSource(path, 100));
        SingleOutputStreamOperator dataStream = streamSource.flatMap((FlatMapFunction)new SelectLanguageFlatMap()).map((MapFunction)new MapFunction<String, Tuple2<String, Integer>>(){
            private static final long serialVersionUID = 1L;

            public Tuple2<String, Integer> map(String value) throws Exception {
                return new Tuple2((Object)value, (Object)1);
            }
        }).groupBy(new int[]{0}).sum(1);
        dataStream.print();
        env.execute();
    }

    public static class SelectLanguageFlatMap
    extends JSONParseFlatMap<String, String> {
        private static final long serialVersionUID = 1L;

        public void flatMap(String value, Collector<String> out) throws Exception {
            try {
                out.collect((Object)this.getString(value, "lang"));
            }
            catch (JSONException e) {
                out.collect((Object)"");
            }
        }
    }
}

