/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.DescribeInstanceStatusRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class DescribeInstanceStatusRequestMarshaller
implements Marshaller<Request<DescribeInstanceStatusRequest>, DescribeInstanceStatusRequest> {
    @Override
    public Request<DescribeInstanceStatusRequest> marshall(DescribeInstanceStatusRequest describeInstanceStatusRequest) {
        if (describeInstanceStatusRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeInstanceStatusRequest> request = new DefaultRequest<DescribeInstanceStatusRequest>(describeInstanceStatusRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeInstanceStatus");
        request.addParameter("Version", "2014-05-01");
        List<String> instanceIdsList = describeInstanceStatusRequest.getInstanceIds();
        int instanceIdsListIndex = 1;
        for (String instanceIdsListValue : instanceIdsList) {
            if (instanceIdsListValue != null) {
                request.addParameter("InstanceId." + instanceIdsListIndex, StringUtils.fromString(instanceIdsListValue));
            }
            ++instanceIdsListIndex;
        }
        List<Filter> filtersList = describeInstanceStatusRequest.getFilters();
        int filtersListIndex = 1;
        for (Filter filtersListValue : filtersList) {
            Filter filterMember = filtersListValue;
            if (filterMember != null) {
                if (filterMember.getName() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString(filterMember.getName()));
                }
                List<String> valuesList = filterMember.getValues();
                int valuesListIndex = 1;
                for (String valuesListValue : valuesList) {
                    if (valuesListValue != null) {
                        request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString(valuesListValue));
                    }
                    ++valuesListIndex;
                }
            }
            ++filtersListIndex;
        }
        if (describeInstanceStatusRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString(describeInstanceStatusRequest.getNextToken()));
        }
        if (describeInstanceStatusRequest.getMaxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger(describeInstanceStatusRequest.getMaxResults()));
        }
        if (describeInstanceStatusRequest.isIncludeAllInstances() != null) {
            request.addParameter("IncludeAllInstances", StringUtils.fromBoolean(describeInstanceStatusRequest.isIncludeAllInstances()));
        }
        return request;
    }
}

