/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworks.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.opsworks.model.DescribeStacksRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class DescribeStacksRequestMarshaller
implements Marshaller<Request<DescribeStacksRequest>, DescribeStacksRequest> {
    @Override
    public Request<DescribeStacksRequest> marshall(DescribeStacksRequest describeStacksRequest) {
        if (describeStacksRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeStacksRequest> request = new DefaultRequest<DescribeStacksRequest>(describeStacksRequest, "AWSOpsWorks");
        String target = "OpsWorks_20130218.DescribeStacks";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            ListWithAutoConstructFlag stackIdsList = (ListWithAutoConstructFlag)describeStacksRequest.getStackIds();
            if (!(stackIdsList == null || stackIdsList.isAutoConstruct() && stackIdsList.isEmpty())) {
                jsonWriter.key("StackIds");
                jsonWriter.array();
                for (String stackIdsListValue : stackIdsList) {
                    if (stackIdsListValue == null) continue;
                    jsonWriter.value(stackIdsListValue);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

