/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.joauth;

import com.google.common.io.BaseEncoding;
import java.nio.charset.Charset;

class Base64Util {
    private static final int BITS_PER_ENCODED_BYTE = 6;
    private static final int BYTES_PER_ENCODED_BLOCK = 4;
    private static final byte[] DECODE_TABLE = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, 62, -1, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, 63, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51};
    private static final Charset UTF_8 = Charset.forName("UTF-8");

    Base64Util() {
    }

    public static boolean equals(String base64, byte[] bytes) {
        byte[] in = base64.getBytes(UTF_8);
        int length = in.length;
        boolean eof = false;
        int bitWorkArea = 0;
        int modulus = 0;
        int pos = 0;
        for (int i = 0; i < length && !eof; ++i) {
            byte result;
            byte b = in[i];
            if (b == 61) {
                eof = true;
                continue;
            }
            if (b < 0 || b >= DECODE_TABLE.length || (result = DECODE_TABLE[b]) < 0) continue;
            modulus = (modulus + 1) % 4;
            bitWorkArea = (bitWorkArea << 6) + result;
            if (modulus != 0) continue;
            if (bytes[pos] != (byte)(bitWorkArea >> 16 & 0xFF)) {
                return false;
            }
            if (bytes[++pos] != (byte)(bitWorkArea >> 8 & 0xFF)) {
                return false;
            }
            if (bytes[++pos] != (byte)(bitWorkArea & 0xFF)) {
                return false;
            }
            ++pos;
        }
        if (eof && modulus != 0) {
            switch (modulus) {
                case 2: {
                    if (bytes[pos] != (byte)((bitWorkArea >>= 4) & 0xFF)) {
                        return false;
                    }
                    ++pos;
                    break;
                }
                case 3: {
                    if (bytes[pos] != (byte)((bitWorkArea >>= 2) >> 8 & 0xFF)) {
                        return false;
                    }
                    if (bytes[++pos] != (byte)(bitWorkArea & 0xFF)) {
                        return false;
                    }
                    ++pos;
                }
            }
        }
        return pos == bytes.length;
    }

    static String encode(byte[] bytes) {
        return BaseEncoding.base64().encode(bytes);
    }

    static byte[] decode(String str) {
        return BaseEncoding.base64().decode((CharSequence)str);
    }
}

