/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.joauth;

import com.twitter.joauth.Request;
import com.twitter.joauth.keyvalue.KeyValueHandler;
import java.util.ArrayList;
import java.util.List;

public class OAuthParams {
    public static final OAuthParamsHelper STANDARD_OAUTH_PARAMS_HELPER = new StandardOAuthParamsHelperImpl();
    public static final String BEARER_TOKEN = "Bearer";
    public static final String CLIENT_ID = "client_id";
    public static final String OAUTH_TOKEN = "oauth_token";
    public static final String OAUTH_CONSUMER_KEY = "oauth_consumer_key";
    public static final String OAUTH_SIGNATURE = "oauth_signature";
    public static final String OAUTH_NONCE = "oauth_nonce";
    public static final String OAUTH_TIMESTAMP = "oauth_timestamp";
    public static final String OAUTH_SIGNATURE_METHOD = "oauth_signature_method";
    public static final String OAUTH_VERSION = "oauth_version";
    public static final String NORMALIZED_REQUEST = "normalized_request";
    public static final String UNSET = "(unset)";
    public static final String HMAC_SHA1 = "HMAC-SHA1";
    public static final String ONE_DOT_OH = "1.0";
    public static final String ONE_DOT_OH_A = "1.0a";
    public static final String OAUTH1_HEADER_AUTHTYPE = "oauth";
    public static final String OAUTH2_HEADER_AUTHTYPE = "bearer";

    private static String valueOrUnset(String value) {
        return value == null ? UNSET : value;
    }

    public static class StandardOAuthParamsHelperImpl
    implements OAuthParamsHelper {
        @Override
        public Long parseTimestamp(String str) {
            try {
                return Long.parseLong(str);
            }
            catch (Exception e) {
                return null;
            }
        }

        @Override
        public String processKey(String str) {
            return str;
        }

        @Override
        public String processSignature(String str) {
            return str;
        }
    }

    public static interface OAuthParamsHelper {
        public Long parseTimestamp(String var1);

        public String processSignature(String var1);

        public String processKey(String var1);
    }

    public static class OAuthParamsBuilder {
        private OAuthParamsHelper helper;
        public String v2Token;
        public String token;
        public String consumerKey;
        public String nonce;
        public Long timestampSecs = -1L;
        public String timestampStr;
        public String signature;
        public String signatureMethod;
        public String version;
        private KeyValueHandler.DuplicateKeyValueHandler paramsHandler = new KeyValueHandler.DuplicateKeyValueHandler();
        private KeyValueHandler.SingleKeyValueHandler otherOAuthParamsHandler = new KeyValueHandler.SingleKeyValueHandler();
        public KeyValueHandler headerHandler = new KeyValueHandler(){

            @Override
            public void handle(String key, String value) {
                OAuthParamsBuilder.this.handleKeyValue(key, value, true);
            }
        };
        public KeyValueHandler queryHandler = new KeyValueHandler(){

            @Override
            public void handle(String key, String value) {
                OAuthParamsBuilder.this.handleKeyValue(key, value, false);
            }
        };

        public OAuthParamsBuilder(OAuthParamsHelper helper) {
            this.helper = helper;
        }

        private boolean notEmpty(String value) {
            return value != null && !value.equals("");
        }

        private void handleKeyValue(String key, String value, boolean fromHeader) {
            if (OAuthParams.BEARER_TOKEN.equals(key)) {
                if (fromHeader && this.notEmpty(value)) {
                    this.v2Token = value;
                }
            } else if (OAuthParams.CLIENT_ID.equals(key)) {
                if (fromHeader && this.notEmpty(value)) {
                    this.consumerKey = value;
                }
            } else if (OAuthParams.OAUTH_TOKEN.equals(key)) {
                if (value != null) {
                    this.token = value.trim();
                }
            } else if (OAuthParams.OAUTH_CONSUMER_KEY.equals(key)) {
                if (this.notEmpty(value)) {
                    this.consumerKey = value;
                }
            } else if (OAuthParams.OAUTH_NONCE.equals(key)) {
                if (this.notEmpty(value)) {
                    this.nonce = value;
                }
            } else if (OAuthParams.OAUTH_TIMESTAMP.equals(key)) {
                Long timestamp = this.helper.parseTimestamp(value);
                if (timestamp != null) {
                    this.timestampSecs = timestamp;
                    this.timestampStr = value;
                }
            } else if (OAuthParams.OAUTH_SIGNATURE.equals(key)) {
                if (this.notEmpty(value)) {
                    this.signature = this.helper.processSignature(value);
                }
            } else if (OAuthParams.OAUTH_SIGNATURE_METHOD.equals(key)) {
                if (this.notEmpty(value)) {
                    this.signatureMethod = value;
                }
            } else if (OAuthParams.OAUTH_VERSION.equals(key)) {
                if (this.notEmpty(value)) {
                    this.version = value;
                }
            } else if (key.startsWith("oauth_")) {
                this.otherOAuthParamsHandler.handle(key, value);
            } else if (!fromHeader) {
                this.paramsHandler.handle(key, value);
            }
        }

        public String toString() {
            return String.format("%s=%s,%s=%s,%s=%s,%s=%s,%s=%s(->%s),%s=%s,%s=%s,%s=%s", OAuthParams.BEARER_TOKEN, OAuthParams.valueOrUnset(this.v2Token), OAuthParams.OAUTH_TOKEN, OAuthParams.valueOrUnset(this.token), OAuthParams.OAUTH_CONSUMER_KEY, OAuthParams.valueOrUnset(this.consumerKey), OAuthParams.OAUTH_NONCE, OAuthParams.valueOrUnset(this.nonce), OAuthParams.OAUTH_TIMESTAMP, this.timestampStr, this.timestampSecs, OAuthParams.OAUTH_SIGNATURE, OAuthParams.valueOrUnset(this.signature), OAuthParams.OAUTH_SIGNATURE_METHOD, OAuthParams.valueOrUnset(this.signatureMethod), OAuthParams.OAUTH_VERSION, OAuthParams.valueOrUnset(this.version));
        }

        public boolean isOAuth2() {
            return this.v2Token != null && !this.isOAuth1() && !this.isOAuth1TwoLegged();
        }

        public boolean isOAuth1TwoLegged() {
            return (this.token == null || "".equals(this.token)) && this.consumerKey != null && this.nonce != null && this.timestampStr != null && this.signature != null && this.signatureMethod != null;
        }

        public boolean isOAuth1() {
            return this.token != null && !"".equals(this.token) && this.consumerKey != null && this.nonce != null && this.timestampStr != null && this.signature != null && this.signatureMethod != null;
        }

        public String oAuth2Token() {
            return this.v2Token;
        }

        public List<Request.Pair> otherParams() {
            List<Request.Pair> list = this.paramsHandler.toList();
            list.addAll(this.otherOAuthParamsHandler.toList());
            return list;
        }

        public OAuth1Params oAuth1Params() {
            return new OAuth1Params(this.token, this.consumerKey, this.nonce, this.timestampSecs, this.timestampStr, this.signature, this.signatureMethod, this.version);
        }
    }

    public static class OAuth1Params {
        private final String token;
        private final String consumerKey;
        private final String nonce;
        private final Long timestampSecs;
        private final String timestampStr;
        private final String signature;
        private final String signatureMethod;
        private final String version;

        public OAuth1Params(String token, String consumerKey, String nonce, Long timestampSecs, String timestampStr, String signature, String signatureMethod, String version) {
            this.token = token;
            this.consumerKey = consumerKey;
            this.nonce = nonce;
            this.timestampSecs = timestampSecs;
            this.timestampStr = timestampStr;
            this.signature = signature;
            this.signatureMethod = signatureMethod;
            this.version = version;
        }

        public String token() {
            return this.token;
        }

        public String consumerKey() {
            return this.consumerKey;
        }

        public String nonce() {
            return this.nonce;
        }

        public Long timestampSecs() {
            return this.timestampSecs;
        }

        public String timestampStr() {
            return this.timestampStr;
        }

        public String signature() {
            return this.signature;
        }

        public String signatureMethod() {
            return this.signatureMethod;
        }

        public String version() {
            return this.version;
        }

        public List<Request.Pair> toList(boolean includeSig) {
            ArrayList<Request.Pair> buf = new ArrayList<Request.Pair>();
            buf.add(new Request.Pair(OAuthParams.OAUTH_CONSUMER_KEY, this.consumerKey));
            buf.add(new Request.Pair(OAuthParams.OAUTH_NONCE, this.nonce));
            if (this.token != null) {
                buf.add(new Request.Pair(OAuthParams.OAUTH_TOKEN, this.token));
            }
            if (includeSig) {
                buf.add(new Request.Pair(OAuthParams.OAUTH_SIGNATURE, this.signature));
            }
            buf.add(new Request.Pair(OAuthParams.OAUTH_SIGNATURE_METHOD, this.signatureMethod));
            buf.add(new Request.Pair(OAuthParams.OAUTH_TIMESTAMP, this.timestampStr));
            if (this.version != null) {
                buf.add(new Request.Pair(OAuthParams.OAUTH_VERSION, this.version));
            }
            return buf;
        }

        public String toString() {
            return String.format("%s=%s,%s=%s,%s=%s,%s=%s(->%s),%s=%s,%s=%s,%s=%s", OAuthParams.OAUTH_TOKEN, OAuthParams.valueOrUnset(this.token), OAuthParams.OAUTH_CONSUMER_KEY, OAuthParams.valueOrUnset(this.consumerKey), OAuthParams.OAUTH_NONCE, OAuthParams.valueOrUnset(this.nonce), OAuthParams.OAUTH_TIMESTAMP, this.timestampStr, this.timestampSecs, OAuthParams.OAUTH_SIGNATURE, OAuthParams.valueOrUnset(this.signature), OAuthParams.OAUTH_SIGNATURE_METHOD, OAuthParams.valueOrUnset(this.signatureMethod), OAuthParams.OAUTH_VERSION, OAuthParams.valueOrUnset(this.version));
        }
    }
}

