/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.spargel.java;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.apache.flink.api.common.aggregators.Aggregator;
import org.apache.flink.api.common.functions.RichCoGroupFunction;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.operators.CoGroupOperator;
import org.apache.flink.api.java.operators.CustomUnaryOperation;
import org.apache.flink.api.java.operators.DeltaIteration;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.api.java.typeutils.ResultTypeQueryable;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.spargel.java.MessageIterator;
import org.apache.flink.spargel.java.MessagingFunction;
import org.apache.flink.spargel.java.VertexUpdateFunction;
import org.apache.flink.util.Collector;

public class VertexCentricIteration<VertexKey extends Comparable<VertexKey>, VertexValue, Message, EdgeValue>
implements CustomUnaryOperation<Tuple2<VertexKey, VertexValue>, Tuple2<VertexKey, VertexValue>> {
    private final VertexUpdateFunction<VertexKey, VertexValue, Message> updateFunction;
    private final MessagingFunction<VertexKey, VertexValue, Message, EdgeValue> messagingFunction;
    private final DataSet<Tuple2<VertexKey, VertexKey>> edgesWithoutValue;
    private final DataSet<Tuple3<VertexKey, VertexKey, EdgeValue>> edgesWithValue;
    private final Map<String, Aggregator<?>> aggregators;
    private final int maximumNumberOfIterations;
    private final List<Tuple2<String, DataSet<?>>> bcVarsUpdate = new ArrayList(4);
    private final List<Tuple2<String, DataSet<?>>> bcVarsMessaging = new ArrayList(4);
    private final TypeInformation<Message> messageType;
    private DataSet<Tuple2<VertexKey, VertexValue>> initialVertices;
    private String name;
    private int parallelism = -1;
    private boolean unmanagedSolutionSet;

    private VertexCentricIteration(VertexUpdateFunction<VertexKey, VertexValue, Message> uf, MessagingFunction<VertexKey, VertexValue, Message, EdgeValue> mf, DataSet<Tuple2<VertexKey, VertexKey>> edgesWithoutValue, int maximumNumberOfIterations) {
        Validate.notNull(uf);
        Validate.notNull(mf);
        Validate.notNull(edgesWithoutValue);
        Validate.isTrue((maximumNumberOfIterations > 0 ? 1 : 0) != 0, (String)"The maximum number of iterations must be at least one.", (Object[])new Object[0]);
        TypeInformation edgesType = edgesWithoutValue.getType();
        Validate.isTrue((edgesType.isTupleType() && edgesType.getArity() == 2 ? 1 : 0) != 0, (String)"The edges data set (for edges without edge values) must consist of 2-tuples.", (Object[])new Object[0]);
        TupleTypeInfo tupleInfo = (TupleTypeInfo)edgesType;
        Validate.isTrue((tupleInfo.getTypeAt(0).equals(tupleInfo.getTypeAt(1)) && Comparable.class.isAssignableFrom(tupleInfo.getTypeAt(0).getTypeClass()) ? 1 : 0) != 0, (String)"Both tuple fields (source and target vertex id) must be of the data type that represents the vertex key and implement the java.lang.Comparable interface.", (Object[])new Object[0]);
        this.updateFunction = uf;
        this.messagingFunction = mf;
        this.edgesWithoutValue = edgesWithoutValue;
        this.edgesWithValue = null;
        this.maximumNumberOfIterations = maximumNumberOfIterations;
        this.aggregators = new HashMap();
        this.messageType = this.getMessageType(mf);
    }

    private VertexCentricIteration(VertexUpdateFunction<VertexKey, VertexValue, Message> uf, MessagingFunction<VertexKey, VertexValue, Message, EdgeValue> mf, DataSet<Tuple3<VertexKey, VertexKey, EdgeValue>> edgesWithValue, int maximumNumberOfIterations, boolean edgeHasValueMarker) {
        Validate.notNull(uf);
        Validate.notNull(mf);
        Validate.notNull(edgesWithValue);
        Validate.isTrue((maximumNumberOfIterations > 0 ? 1 : 0) != 0, (String)"The maximum number of iterations must be at least one.", (Object[])new Object[0]);
        TypeInformation edgesType = edgesWithValue.getType();
        Validate.isTrue((edgesType.isTupleType() && edgesType.getArity() == 3 ? 1 : 0) != 0, (String)"The edges data set (for edges with edge values) must consist of 3-tuples.", (Object[])new Object[0]);
        TupleTypeInfo tupleInfo = (TupleTypeInfo)edgesType;
        Validate.isTrue((tupleInfo.getTypeAt(0).equals(tupleInfo.getTypeAt(1)) && Comparable.class.isAssignableFrom(tupleInfo.getTypeAt(0).getTypeClass()) ? 1 : 0) != 0, (String)"The first two tuple fields (source and target vertex id) must be of the data type that represents the vertex key and implement the java.lang.Comparable interface.", (Object[])new Object[0]);
        Validate.isTrue((maximumNumberOfIterations > 0 ? 1 : 0) != 0, (String)"The maximum number of iterations must be at least one.", (Object[])new Object[0]);
        this.updateFunction = uf;
        this.messagingFunction = mf;
        this.edgesWithoutValue = null;
        this.edgesWithValue = edgesWithValue;
        this.maximumNumberOfIterations = maximumNumberOfIterations;
        this.aggregators = new HashMap();
        this.messageType = this.getMessageType(mf);
    }

    private TypeInformation<Message> getMessageType(MessagingFunction<VertexKey, VertexValue, Message, EdgeValue> mf) {
        return TypeExtractor.createTypeInfo(MessagingFunction.class, mf.getClass(), (int)2, null, null);
    }

    public void registerAggregator(String name, Aggregator<?> aggregator) {
        this.aggregators.put(name, aggregator);
    }

    public void addBroadcastSetForMessagingFunction(String name, DataSet<?> data) {
        this.bcVarsMessaging.add(new Tuple2((Object)name, data));
    }

    public void addBroadcastSetForUpdateFunction(String name, DataSet<?> data) {
        this.bcVarsUpdate.add(new Tuple2((Object)name, data));
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setParallelism(int parallelism) {
        Validate.isTrue((parallelism > 0 || parallelism == -1 ? 1 : 0) != 0, (String)"The degree of parallelism must be positive, or -1 (use default).", (Object[])new Object[0]);
        this.parallelism = parallelism;
    }

    public int getParallelism() {
        return this.parallelism;
    }

    public void setSolutionSetUnmanagedMemory(boolean unmanaged) {
        this.unmanagedSolutionSet = unmanaged;
    }

    public boolean isSolutionSetUnmanagedMemory() {
        return this.unmanagedSolutionSet;
    }

    public void setInput(DataSet<Tuple2<VertexKey, VertexValue>> inputData) {
        TypeInformation inputType = inputData.getType();
        Validate.isTrue((inputType.isTupleType() && inputType.getArity() == 2 ? 1 : 0) != 0, (String)"The input data set (the initial vertices) must consist of 2-tuples.", (Object[])new Object[0]);
        TypeInformation keyType = ((TupleTypeInfo)inputType).getTypeAt(0);
        TypeInformation edgeType = this.edgesWithoutValue != null ? this.edgesWithoutValue.getType() : this.edgesWithValue.getType();
        TypeInformation edgeKeyType = ((TupleTypeInfo)edgeType).getTypeAt(0);
        Validate.isTrue((boolean)keyType.equals(edgeKeyType), (String)"The first tuple field (the vertex id) of the input data set (the initial vertices) must be the same data type as the first fields of the edge data set (the source vertex id). Here, the key type for the vertex ids is '%s' and the key type  for the edges is '%s'.", (Object[])new Object[]{keyType, edgeKeyType});
        this.initialVertices = inputData;
    }

    public DataSet<Tuple2<VertexKey, VertexValue>> createResult() {
        CoGroupOperator messages;
        RichCoGroupFunction messenger;
        if (this.initialVertices == null) {
            throw new IllegalStateException("The input data set has not been set.");
        }
        TypeInformation vertexTypes = this.initialVertices.getType();
        TypeInformation keyType = ((TupleTypeInfo)this.initialVertices.getType()).getTypeAt(0);
        TupleTypeInfo messageTypeInfo = new TupleTypeInfo(new TypeInformation[]{keyType, this.messageType});
        String name = this.name != null ? this.name : "Vertex-centric iteration (" + this.updateFunction + " | " + this.messagingFunction + ")";
        int[] zeroKeyPos = new int[]{0};
        DeltaIteration iteration = this.initialVertices.iterateDelta(this.initialVertices, this.maximumNumberOfIterations, zeroKeyPos);
        iteration.name(name);
        iteration.parallelism(this.parallelism);
        iteration.setSolutionSetUnManaged(this.unmanagedSolutionSet);
        for (Map.Entry<String, Aggregator<?>> entry : this.aggregators.entrySet()) {
            iteration.registerAggregator(entry.getKey(), entry.getValue());
        }
        if (this.edgesWithoutValue != null) {
            messenger = new MessagingUdfNoEdgeValues(this.messagingFunction, (TypeInformation)messageTypeInfo);
            messages = this.edgesWithoutValue.coGroup((DataSet)iteration.getWorkset()).where(new int[]{0}).equalTo(new int[]{0}).with(messenger);
        } else {
            messenger = new MessagingUdfWithEdgeValues(this.messagingFunction, (TypeInformation)messageTypeInfo);
            messages = this.edgesWithValue.coGroup((DataSet)iteration.getWorkset()).where(new int[]{0}).equalTo(new int[]{0}).with(messenger);
        }
        messages = (CoGroupOperator)messages.name("Messaging");
        for (Tuple2<String, DataSet<?>> e : this.bcVarsMessaging) {
            messages = (CoGroupOperator)messages.withBroadcastSet((DataSet)e.f1, (String)e.f0);
        }
        VertexUpdateUdf updateUdf = new VertexUpdateUdf(this.updateFunction, vertexTypes);
        CoGroupOperator updates = messages.coGroup((DataSet)iteration.getSolutionSet()).where(new int[]{0}).equalTo(new int[]{0}).with(updateUdf);
        updates = (CoGroupOperator)updates.name("Vertex State Updates");
        for (Tuple2<String, DataSet<?>> e : this.bcVarsUpdate) {
            updates = (CoGroupOperator)updates.withBroadcastSet((DataSet)e.f1, (String)e.f0);
        }
        ((CoGroupOperator)updates.withConstantSetFirst(new String[]{"0"})).withConstantSetSecond(new String[]{"0"});
        return iteration.closeWith((DataSet)updates, (DataSet)updates);
    }

    public static final <VertexKey extends Comparable<VertexKey>, VertexValue, Message> VertexCentricIteration<VertexKey, VertexValue, Message, ?> withPlainEdges(DataSet<Tuple2<VertexKey, VertexKey>> edgesWithoutValue, VertexUpdateFunction<VertexKey, VertexValue, Message> vertexUpdateFunction, MessagingFunction<VertexKey, VertexValue, Message, ?> messagingFunction, int maximumNumberOfIterations) {
        MessagingFunction<VertexKey, VertexValue, Message, ?> tmf = messagingFunction;
        return new VertexCentricIteration(vertexUpdateFunction, tmf, edgesWithoutValue, maximumNumberOfIterations);
    }

    public static final <VertexKey extends Comparable<VertexKey>, VertexValue, Message, EdgeValue> VertexCentricIteration<VertexKey, VertexValue, Message, EdgeValue> withValuedEdges(DataSet<Tuple3<VertexKey, VertexKey, EdgeValue>> edgesWithValue, VertexUpdateFunction<VertexKey, VertexValue, Message> uf, MessagingFunction<VertexKey, VertexValue, Message, EdgeValue> mf, int maximumNumberOfIterations) {
        return new VertexCentricIteration<VertexKey, VertexValue, Message, EdgeValue>(uf, mf, edgesWithValue, maximumNumberOfIterations, true);
    }

    private static final class MessagingUdfWithEdgeValues<VertexKey extends Comparable<VertexKey>, VertexValue, Message, EdgeValue>
    extends RichCoGroupFunction<Tuple3<VertexKey, VertexKey, EdgeValue>, Tuple2<VertexKey, VertexValue>, Tuple2<VertexKey, Message>>
    implements ResultTypeQueryable<Tuple2<VertexKey, Message>> {
        private static final long serialVersionUID = 1L;
        private final MessagingFunction<VertexKey, VertexValue, Message, EdgeValue> messagingFunction;
        private transient TypeInformation<Tuple2<VertexKey, Message>> resultType;

        private MessagingUdfWithEdgeValues(MessagingFunction<VertexKey, VertexValue, Message, EdgeValue> messagingFunction, TypeInformation<Tuple2<VertexKey, Message>> resultType) {
            this.messagingFunction = messagingFunction;
            this.resultType = resultType;
        }

        public void coGroup(Iterable<Tuple3<VertexKey, VertexKey, EdgeValue>> edges, Iterable<Tuple2<VertexKey, VertexValue>> state, Collector<Tuple2<VertexKey, Message>> out) throws Exception {
            Iterator<Tuple2<VertexKey, VertexValue>> stateIter = state.iterator();
            if (stateIter.hasNext()) {
                Tuple2<VertexKey, VertexValue> newVertexState = stateIter.next();
                this.messagingFunction.set(edges.iterator(), out);
                this.messagingFunction.sendMessages((Comparable)newVertexState.f0, newVertexState.f1);
            }
        }

        public void open(Configuration parameters) throws Exception {
            if (this.getIterationRuntimeContext().getSuperstepNumber() == 1) {
                this.messagingFunction.init(this.getIterationRuntimeContext(), true);
            }
            this.messagingFunction.preSuperstep();
        }

        public void close() throws Exception {
            this.messagingFunction.postSuperstep();
        }

        public TypeInformation<Tuple2<VertexKey, Message>> getProducedType() {
            return this.resultType;
        }
    }

    private static final class MessagingUdfNoEdgeValues<VertexKey extends Comparable<VertexKey>, VertexValue, Message>
    extends RichCoGroupFunction<Tuple2<VertexKey, VertexKey>, Tuple2<VertexKey, VertexValue>, Tuple2<VertexKey, Message>>
    implements ResultTypeQueryable<Tuple2<VertexKey, Message>> {
        private static final long serialVersionUID = 1L;
        private final MessagingFunction<VertexKey, VertexValue, Message, ?> messagingFunction;
        private transient TypeInformation<Tuple2<VertexKey, Message>> resultType;

        private MessagingUdfNoEdgeValues(MessagingFunction<VertexKey, VertexValue, Message, ?> messagingFunction, TypeInformation<Tuple2<VertexKey, Message>> resultType) {
            this.messagingFunction = messagingFunction;
            this.resultType = resultType;
        }

        public void coGroup(Iterable<Tuple2<VertexKey, VertexKey>> edges, Iterable<Tuple2<VertexKey, VertexValue>> state, Collector<Tuple2<VertexKey, Message>> out) throws Exception {
            Iterator<Tuple2<VertexKey, VertexValue>> stateIter = state.iterator();
            if (stateIter.hasNext()) {
                Tuple2<VertexKey, VertexValue> newVertexState = stateIter.next();
                this.messagingFunction.set(edges.iterator(), out);
                this.messagingFunction.sendMessages((Comparable)newVertexState.f0, newVertexState.f1);
            }
        }

        public void open(Configuration parameters) throws Exception {
            if (this.getIterationRuntimeContext().getSuperstepNumber() == 1) {
                this.messagingFunction.init(this.getIterationRuntimeContext(), false);
            }
            this.messagingFunction.preSuperstep();
        }

        public void close() throws Exception {
            this.messagingFunction.postSuperstep();
        }

        public TypeInformation<Tuple2<VertexKey, Message>> getProducedType() {
            return this.resultType;
        }
    }

    private static final class VertexUpdateUdf<VertexKey extends Comparable<VertexKey>, VertexValue, Message>
    extends RichCoGroupFunction<Tuple2<VertexKey, Message>, Tuple2<VertexKey, VertexValue>, Tuple2<VertexKey, VertexValue>>
    implements ResultTypeQueryable<Tuple2<VertexKey, VertexValue>> {
        private static final long serialVersionUID = 1L;
        private final VertexUpdateFunction<VertexKey, VertexValue, Message> vertexUpdateFunction;
        private final MessageIterator<Message> messageIter = new MessageIterator();
        private transient TypeInformation<Tuple2<VertexKey, VertexValue>> resultType;

        private VertexUpdateUdf(VertexUpdateFunction<VertexKey, VertexValue, Message> vertexUpdateFunction, TypeInformation<Tuple2<VertexKey, VertexValue>> resultType) {
            this.vertexUpdateFunction = vertexUpdateFunction;
            this.resultType = resultType;
        }

        public void coGroup(Iterable<Tuple2<VertexKey, Message>> messages, Iterable<Tuple2<VertexKey, VertexValue>> vertex, Collector<Tuple2<VertexKey, VertexValue>> out) throws Exception {
            Iterator<Tuple2<VertexKey, VertexValue>> vertexIter = vertex.iterator();
            if (!vertexIter.hasNext()) {
                Iterator<Tuple2<VertexKey, Message>> messageIter = messages.iterator();
                if (messageIter.hasNext()) {
                    String message = "Target vertex does not exist!.";
                    try {
                        Tuple2<VertexKey, Message> next = messageIter.next();
                        message = "Target vertex '" + next.f0 + "' does not exist!.";
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                    throw new Exception(message);
                }
                throw new Exception();
            }
            Tuple2<VertexKey, VertexValue> vertexState = vertexIter.next();
            Iterator downcastIter = messages.iterator();
            this.messageIter.setSource(downcastIter);
            this.vertexUpdateFunction.setOutput(vertexState, out);
            this.vertexUpdateFunction.updateVertex((Comparable)vertexState.f0, vertexState.f1, this.messageIter);
        }

        public void open(Configuration parameters) throws Exception {
            if (this.getIterationRuntimeContext().getSuperstepNumber() == 1) {
                this.vertexUpdateFunction.init(this.getIterationRuntimeContext());
            }
            this.vertexUpdateFunction.preSuperstep();
        }

        public void close() throws Exception {
            this.vertexUpdateFunction.postSuperstep();
        }

        public TypeInformation<Tuple2<VertexKey, VertexValue>> getProducedType() {
            return this.resultType;
        }
    }
}

