/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.spargel.java.examples;

import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.operators.MapOperator;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.spargel.java.MessageIterator;
import org.apache.flink.spargel.java.MessagingFunction;
import org.apache.flink.spargel.java.VertexCentricIteration;
import org.apache.flink.spargel.java.VertexUpdateFunction;
import org.apache.flink.types.NullValue;

public class SpargelConnectedComponents {
    public static void main(String[] args) throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource vertexIds = env.generateSequence(0L, 10L);
        DataSource edges = env.fromElements((Object[])new Tuple2[]{new Tuple2((Object)0L, (Object)2L), new Tuple2((Object)2L, (Object)4L), new Tuple2((Object)4L, (Object)8L), new Tuple2((Object)1L, (Object)5L), new Tuple2((Object)3L, (Object)7L), new Tuple2((Object)3L, (Object)9L)});
        MapOperator initialVertices = vertexIds.map((MapFunction)new IdAssigner());
        DataSet result = initialVertices.runOperation(VertexCentricIteration.withPlainEdges(edges, new CCUpdater(), new CCMessager(), 100));
        result.print();
        env.execute("Spargel Connected Components");
    }

    public static final class IdAssigner
    implements MapFunction<Long, Tuple2<Long, Long>> {
        public Tuple2<Long, Long> map(Long value) {
            return new Tuple2((Object)value, (Object)value);
        }
    }

    public static final class CCMessager
    extends MessagingFunction<Long, Long, Long, NullValue> {
        @Override
        public void sendMessages(Long vertexId, Long componentId) {
            this.sendMessageToAllNeighbors(componentId);
        }
    }

    public static final class CCUpdater
    extends VertexUpdateFunction<Long, Long, Long> {
        @Override
        public void updateVertex(Long vertexKey, Long vertexValue, MessageIterator<Long> inMessages) {
            long min = Long.MAX_VALUE;
            for (long msg : inMessages) {
                min = Math.min(min, msg);
            }
            if (min < vertexValue) {
                this.setNewVertexValue(min);
            }
        }
    }
}

