/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.mapred.DeprecatedQueueConfigurationParser;
import org.apache.hadoop.mapred.Queue;
import org.apache.hadoop.mapred.QueueConfigurationParser;

@InterfaceAudience.Private
public class QueueManager {
    private static final Log LOG = LogFactory.getLog(QueueManager.class);
    private Map<String, Queue> leafQueues = new HashMap<String, Queue>();
    private Map<String, Queue> allQueues = new HashMap<String, Queue>();
    public static final String QUEUE_CONF_FILE_NAME = "mapred-queues.xml";
    static final String QUEUE_CONF_DEFAULT_FILE_NAME = "mapred-queues-default.xml";
    static final String QUEUE_CONF_PROPERTY_NAME_PREFIX = "mapred.queue.";
    private Queue root = null;
    private boolean areAclsEnabled = false;
    static final String MSG_REFRESH_FAILURE_WITH_CHANGE_OF_HIERARCHY = "Unable to refresh queues because queue-hierarchy changed. Retaining existing configuration. ";
    static final String MSG_REFRESH_FAILURE_WITH_SCHEDULER_FAILURE = "Scheduler couldn't refresh it's queues with the new configuration properties. Retaining existing configuration throughout the system.";

    static QueueConfigurationParser getQueueConfigurationParser(Configuration conf, boolean reloadConf, boolean areAclsEnabled) {
        if (conf != null && conf.get("mapred.queue.names") != null) {
            if (reloadConf) {
                conf.reloadConfiguration();
            }
            return new DeprecatedQueueConfigurationParser(conf);
        }
        URL xmlInUrl = Thread.currentThread().getContextClassLoader().getResource(QUEUE_CONF_FILE_NAME);
        if (xmlInUrl == null) {
            xmlInUrl = Thread.currentThread().getContextClassLoader().getResource(QUEUE_CONF_DEFAULT_FILE_NAME);
            assert (xmlInUrl != null);
        }
        InputStream stream = null;
        try {
            stream = xmlInUrl.openStream();
            QueueConfigurationParser queueConfigurationParser = new QueueConfigurationParser(new BufferedInputStream(stream), areAclsEnabled);
            return queueConfigurationParser;
        }
        catch (IOException ioe) {
            throw new RuntimeException("Couldn't open queue configuration at " + xmlInUrl, ioe);
        }
        finally {
            IOUtils.closeStream((Closeable)stream);
        }
    }

    QueueManager() {
        this(false);
    }

    QueueManager(boolean areAclsEnabled) {
        this.areAclsEnabled = areAclsEnabled;
        this.initialize(QueueManager.getQueueConfigurationParser(null, false, areAclsEnabled));
    }

    public QueueManager(Configuration clusterConf) {
        this.areAclsEnabled = clusterConf.getBoolean("mapreduce.cluster.acls.enabled", false);
        this.initialize(QueueManager.getQueueConfigurationParser(clusterConf, false, this.areAclsEnabled));
    }

    QueueManager(String confFile, boolean areAclsEnabled) {
        this.areAclsEnabled = areAclsEnabled;
        QueueConfigurationParser cp = new QueueConfigurationParser(confFile, areAclsEnabled);
        this.initialize(cp);
    }

    private void initialize(QueueConfigurationParser cp) {
        this.root = cp.getRoot();
        this.leafQueues.clear();
        this.allQueues.clear();
        this.leafQueues = this.getRoot().getLeafQueues();
        this.allQueues.putAll(this.getRoot().getInnerQueues());
        this.allQueues.putAll(this.leafQueues);
        LOG.info((Object)("AllQueues : " + this.allQueues + "; LeafQueues : " + this.leafQueues));
    }

    public static final String toFullPropertyName(String queue, String property) {
        return QUEUE_CONF_PROPERTY_NAME_PREFIX + queue + "." + property;
    }

    Queue getRoot() {
        return this.root;
    }
}

