/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client;

import java.io.File;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.List;
import org.apache.flink.api.common.JobExecutionResult;
import org.apache.flink.api.common.Plan;
import org.apache.flink.api.common.PlanExecutor;
import org.apache.flink.client.program.Client;
import org.apache.flink.client.program.JobWithJars;
import org.apache.flink.client.program.PackagedProgram;
import org.apache.flink.compiler.plan.OptimizedPlan;
import org.apache.flink.compiler.plandump.PlanJSONDumpGenerator;
import org.apache.flink.configuration.Configuration;

public class RemoteExecutor
extends PlanExecutor {
    private final List<String> jarFiles;
    private final InetSocketAddress address;

    public RemoteExecutor(String hostname, int port) {
        this(hostname, port, Collections.emptyList());
    }

    public RemoteExecutor(String hostname, int port, String jarFile) {
        this(hostname, port, Collections.singletonList(jarFile));
    }

    public RemoteExecutor(String hostport, String jarFile) {
        this(RemoteExecutor.getInetFromHostport(hostport), Collections.singletonList(jarFile));
    }

    public RemoteExecutor(String hostname, int port, List<String> jarFiles) {
        this(new InetSocketAddress(hostname, port), jarFiles);
    }

    public RemoteExecutor(InetSocketAddress inet, List<String> jarFiles) {
        this.jarFiles = jarFiles;
        this.address = inet;
    }

    public static InetSocketAddress getInetFromHostport(String hostport) {
        URI uri;
        try {
            uri = new URI("my://" + hostport);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Could not identify hostname and port", e);
        }
        String host = uri.getHost();
        int port = uri.getPort();
        if (host == null || port == -1) {
            throw new RuntimeException("Could not identify hostname and port");
        }
        return new InetSocketAddress(host, port);
    }

    public JobExecutionResult executePlan(Plan plan) throws Exception {
        JobWithJars p = new JobWithJars(plan, this.jarFiles);
        Client c = new Client(this.address, new Configuration(), p.getUserCodeClassLoader());
        return c.run(p, -1, true);
    }

    public JobExecutionResult executePlanWithJars(JobWithJars p) throws Exception {
        Client c = new Client(this.address, new Configuration(), p.getUserCodeClassLoader());
        return c.run(p, -1, true);
    }

    public JobExecutionResult executeJar(String jarPath, String assemblerClass, String[] args) throws Exception {
        File jarFile = new File(jarPath);
        PackagedProgram program = new PackagedProgram(jarFile, assemblerClass, args);
        Client c = new Client(this.address, new Configuration(), program.getUserCodeClassLoader());
        return c.run(program.getPlanWithJars(), -1, true);
    }

    public String getOptimizerPlanAsJSON(Plan plan) throws Exception {
        JobWithJars p = new JobWithJars(plan, this.jarFiles);
        Client c = new Client(this.address, new Configuration(), p.getUserCodeClassLoader());
        OptimizedPlan op = c.getOptimizedPlan(p, -1);
        PlanJSONDumpGenerator jsonGen = new PlanJSONDumpGenerator();
        return jsonGen.getOptimizerPlanAsJSON(op);
    }
}

