/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.minicluster;

import java.lang.reflect.Method;
import org.apache.flink.api.common.io.FileInputFormat;
import org.apache.flink.api.common.io.FileOutputFormat;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.GlobalConfiguration;
import org.apache.flink.runtime.ExecutionMode;
import org.apache.flink.runtime.client.JobClient;
import org.apache.flink.runtime.instance.InstanceManager;
import org.apache.flink.runtime.instance.LocalInstanceManager;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobmanager.JobManager;
import org.apache.flink.runtime.taskmanager.TaskManager;
import org.apache.flink.runtime.util.EnvironmentInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NepheleMiniCluster {
    private static final Logger LOG = LoggerFactory.getLogger(NepheleMiniCluster.class);
    private static final int DEFAULT_JM_RPC_PORT = 6498;
    private static final int DEFAULT_TM_RPC_PORT = 6501;
    private static final int DEFAULT_TM_DATA_PORT = 7501;
    private static final long DEFAULT_MEMORY_SIZE = -1L;
    private static final int DEFAULT_NUM_TASK_MANAGER = 1;
    private static final boolean DEFAULT_LAZY_MEMORY_ALLOCATION = true;
    private static final int DEFAULT_TASK_MANAGER_NUM_SLOTS = 1;
    private final Object startStopLock = new Object();
    private int jobManagerRpcPort = 6498;
    private int taskManagerRpcPort = 6501;
    private int taskManagerDataPort = 7501;
    private int numTaskManager = 1;
    private int taskManagerNumSlots = 1;
    private long memorySize = -1L;
    private String configDir;
    private String hdfsConfigFile;
    private boolean lazyMemoryAllocation = true;
    private boolean defaultOverwriteFiles = false;
    private boolean defaultAlwaysCreateDirectory = false;
    private JobManager jobManager;

    public int getJobManagerRpcPort() {
        return this.jobManagerRpcPort;
    }

    public void setJobManagerRpcPort(int jobManagerRpcPort) {
        this.jobManagerRpcPort = jobManagerRpcPort;
    }

    public int getTaskManagerRpcPort() {
        return this.taskManagerRpcPort;
    }

    public void setTaskManagerRpcPort(int taskManagerRpcPort) {
        this.taskManagerRpcPort = taskManagerRpcPort;
    }

    public int getTaskManagerDataPort() {
        return this.taskManagerDataPort;
    }

    public void setTaskManagerDataPort(int taskManagerDataPort) {
        this.taskManagerDataPort = taskManagerDataPort;
    }

    public long getMemorySize() {
        return this.memorySize;
    }

    public void setMemorySize(long memorySize) {
        this.memorySize = memorySize;
    }

    public String getConfigDir() {
        return this.configDir;
    }

    public void setConfigDir(String configDir) {
        this.configDir = configDir;
    }

    public String getHdfsConfigFile() {
        return this.hdfsConfigFile;
    }

    public void setHdfsConfigFile(String hdfsConfigFile) {
        this.hdfsConfigFile = hdfsConfigFile;
    }

    public boolean isLazyMemoryAllocation() {
        return this.lazyMemoryAllocation;
    }

    public void setLazyMemoryAllocation(boolean lazyMemoryAllocation) {
        this.lazyMemoryAllocation = lazyMemoryAllocation;
    }

    public boolean isDefaultOverwriteFiles() {
        return this.defaultOverwriteFiles;
    }

    public void setDefaultOverwriteFiles(boolean defaultOverwriteFiles) {
        this.defaultOverwriteFiles = defaultOverwriteFiles;
    }

    public boolean isDefaultAlwaysCreateDirectory() {
        return this.defaultAlwaysCreateDirectory;
    }

    public void setDefaultAlwaysCreateDirectory(boolean defaultAlwaysCreateDirectory) {
        this.defaultAlwaysCreateDirectory = defaultAlwaysCreateDirectory;
    }

    public void setNumTaskManager(int numTaskManager) {
        this.numTaskManager = numTaskManager;
    }

    public int getNumTaskManager() {
        return this.numTaskManager;
    }

    public void setTaskManagerNumSlots(int taskManagerNumSlots) {
        this.taskManagerNumSlots = taskManagerNumSlots;
    }

    public int getTaskManagerNumSlots() {
        return this.taskManagerNumSlots;
    }

    public JobClient getJobClient(JobGraph jobGraph) throws Exception {
        Configuration configuration = jobGraph.getJobConfiguration();
        configuration.setString("jobmanager.rpc.address", "localhost");
        configuration.setInteger("jobmanager.rpc.port", this.jobManagerRpcPort);
        return new JobClient(jobGraph, configuration, this.getClass().getClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws Exception {
        String forkNumberString = System.getProperty("forkNumber");
        int forkNumber = -1;
        try {
            forkNumber = Integer.parseInt(forkNumberString);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (forkNumber != -1) {
            this.jobManagerRpcPort = 1024 + forkNumber * 300;
            this.taskManagerRpcPort = 1024 + forkNumber * 300 + 100;
            this.taskManagerDataPort = 1024 + forkNumber * 300 + 200;
        }
        Object object = this.startStopLock;
        synchronized (object) {
            if (this.configDir != null) {
                GlobalConfiguration.loadConfiguration((String)this.configDir);
            } else {
                Configuration conf = NepheleMiniCluster.getMiniclusterDefaultConfig(this.jobManagerRpcPort, this.taskManagerRpcPort, this.taskManagerDataPort, this.memorySize, this.hdfsConfigFile, this.lazyMemoryAllocation, this.defaultOverwriteFiles, this.defaultAlwaysCreateDirectory, this.taskManagerNumSlots, this.numTaskManager);
                GlobalConfiguration.includeConfiguration((Configuration)conf);
            }
            NepheleMiniCluster.initializeIOFormatClasses();
            Thread[] allThreads = new Thread[Thread.activeCount()];
            int numThreads = Thread.enumerate(allThreads);
            for (int i = 0; i < numThreads; ++i) {
                Thread t = allThreads[i];
                String name = t.getName();
                if (!name.startsWith("Flink-IPC")) continue;
                t.join();
            }
            this.jobManager = new JobManager(ExecutionMode.LOCAL);
            this.waitForJobManagerToBecomeReady(this.taskManagerNumSlots * this.numTaskManager);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws Exception {
        Object object = this.startStopLock;
        synchronized (object) {
            if (this.jobManager != null) {
                this.jobManager.shutdown();
                this.jobManager = null;
            }
        }
    }

    public TaskManager[] getTaskManagers() {
        InstanceManager im;
        JobManager jm = this.jobManager;
        if (jm != null && (im = jm.getInstanceManager()) instanceof LocalInstanceManager) {
            return ((LocalInstanceManager)im).getTaskManagers();
        }
        return null;
    }

    private void waitForJobManagerToBecomeReady(int numSlots) throws InterruptedException {
        TaskManager[] tms;
        if (numSlots < 0) {
            numSlots = 1;
        }
        while (this.jobManager.getNumberOfSlotsAvailableToScheduler() < numSlots) {
            Thread.sleep(50L);
        }
        for (TaskManager tm : tms = this.getTaskManagers()) {
            while (tm.getRegisteredId() == null) {
                Thread.sleep(10L);
            }
        }
    }

    private static void initializeIOFormatClasses() {
        try {
            Method im = FileInputFormat.class.getDeclaredMethod("initDefaultsFromConfiguration", new Class[0]);
            im.setAccessible(true);
            im.invoke(null, new Object[0]);
            Method om = FileOutputFormat.class.getDeclaredMethod("initDefaultsFromConfiguration", new Class[0]);
            om.setAccessible(true);
            om.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            LOG.error("Cannot (re) initialize the globally loaded defaults. Some classes might mot follow the specified default behavior.");
        }
    }

    public static Configuration getMiniclusterDefaultConfig(int jobManagerRpcPort, int taskManagerRpcPort, int taskManagerDataPort, long memorySize, String hdfsConfigFile, boolean lazyMemory, boolean defaultOverwriteFiles, boolean defaultAlwaysCreateDirectory, int taskManagerNumSlots, int numTaskManager) {
        Configuration config = new Configuration();
        config.setString("jobmanager.rpc.address", "localhost");
        config.setInteger("jobmanager.rpc.port", jobManagerRpcPort);
        config.setInteger("taskmanager.rpc.port", taskManagerRpcPort);
        config.setInteger("taskmanager.data.port", taskManagerDataPort);
        config.setInteger("jobmanager.rpc.numhandler", 2);
        config.setBoolean("taskmanager.memory.lazyalloc", lazyMemory);
        config.setInteger("jobclient.polling.interval", 2);
        if (hdfsConfigFile != null) {
            config.setString("fs.hdfs.hdfsdefault", hdfsConfigFile);
        }
        config.setBoolean("fs.overwrite-files", defaultOverwriteFiles);
        config.setBoolean("fs.output.always-create-directory", defaultAlwaysCreateDirectory);
        if (memorySize < 0L) {
            memorySize = EnvironmentInformation.getSizeOfFreeHeapMemoryWithDefrag();
            long bufferMem = GlobalConfiguration.getLong((String)"taskmanager.network.numberOfBuffers", (long)2048L) * GlobalConfiguration.getLong((String)"taskmanager.network.bufferSizeInBytes", (long)32768L);
            memorySize -= bufferMem * (long)numTaskManager;
            memorySize = (long)((float)memorySize * 0.7f);
            memorySize >>>= 20;
        }
        config.setLong("taskmanager.memory.size", memorySize /= (long)numTaskManager);
        config.setInteger("localinstancemanager.numtaskmanager", numTaskManager);
        config.setInteger("taskmanager.numberOfTaskSlots", taskManagerNumSlots);
        return config;
    }
}

