/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.web;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Comparator;
import java.util.GregorianCalendar;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;

public class JobsServlet
extends HttpServlet {
    private static final long serialVersionUID = -1373210261957434273L;
    private static final String ACTION_PARAM_NAME = "action";
    private static final String ACTION_LIST_VALUE = "list";
    private static final String ACTION_DELETE_VALUE = "delete";
    private static final String FILENAME_PARAM_NAME = "filename";
    private static final String CONTENT_TYPE_PLAIN = "text/plain";
    private static final Comparator<File> FILE_SORTER = new Comparator<File>(){

        @Override
        public int compare(File o1, File o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };
    private final File tmpDir;
    private final File destinationDir;
    private final String targetPage;

    public JobsServlet(File jobsDir, File tmpDir, String targetPage) {
        this.tmpDir = tmpDir;
        this.destinationDir = jobsDir;
        this.targetPage = targetPage;
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        if (!this.tmpDir.isDirectory() || !this.tmpDir.canWrite()) {
            throw new ServletException(this.tmpDir.getAbsolutePath() + " is not a writable directory");
        }
        if (!this.destinationDir.isDirectory() || !this.destinationDir.canWrite()) {
            throw new ServletException(this.destinationDir.getAbsolutePath() + " is not a writable directory");
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String action = req.getParameter(ACTION_PARAM_NAME);
        if (action.equals(ACTION_LIST_VALUE)) {
            GregorianCalendar cal = new GregorianCalendar();
            File[] files = this.destinationDir.listFiles();
            Arrays.sort(files, FILE_SORTER);
            resp.setStatus(200);
            resp.setContentType(CONTENT_TYPE_PLAIN);
            PrintWriter writer = resp.getWriter();
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].getName().endsWith(".jar")) continue;
                cal.setTimeInMillis(files[i].lastModified());
                writer.println(files[i].getName() + '\t' + (cal.get(2) + 1) + '/' + cal.get(5) + '/' + cal.get(1) + ' ' + cal.get(11) + ':' + cal.get(12) + ':' + cal.get(13));
            }
        } else if (action.equals(ACTION_DELETE_VALUE)) {
            String filename = req.getParameter(FILENAME_PARAM_NAME);
            if (filename == null || filename.length() == 0) {
                resp.setStatus(400);
            } else {
                File f = new File(this.destinationDir, filename);
                if (!f.exists() || f.isDirectory()) {
                    resp.setStatus(404);
                }
                f.delete();
                resp.setStatus(200);
            }
        } else {
            resp.setStatus(400);
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (!ServletFileUpload.isMultipartContent((HttpServletRequest)req)) {
            resp.sendError(400);
            return;
        }
        DiskFileItemFactory fileItemFactory = new DiskFileItemFactory();
        fileItemFactory.setSizeThreshold(0x1400000);
        fileItemFactory.setRepository(this.tmpDir);
        String filename = null;
        ServletFileUpload uploadHandler = new ServletFileUpload((FileItemFactory)fileItemFactory);
        try {
            for (FileItem item : uploadHandler.parseRequest(req)) {
                if (item.isFormField() || !item.getFieldName().equals("upload_jar_file")) continue;
                filename = item.getName();
                File file = new File(this.destinationDir, filename);
                item.write(file);
                break;
            }
        }
        catch (FileUploadException ex) {
            resp.sendError(406, "Invalid Fileupload.");
            return;
        }
        catch (Exception ex) {
            resp.sendError(500, "An unknown error occurred during the file upload.");
            return;
        }
        resp.sendRedirect(this.targetPage);
    }
}

