/*
 * Decompiled with CFR 0.152.
 */
package clover.com.google.gson;

import clover.com.google.gson.FieldNamingStrategy;
import clover.com.google.gson.JsonArray;
import clover.com.google.gson.JsonElement;
import clover.com.google.gson.JsonNull;
import clover.com.google.gson.JsonObject;
import clover.com.google.gson.JsonSerializationContext;
import clover.com.google.gson.JsonSerializer;
import clover.com.google.gson.ObjectNavigator;
import clover.com.google.gson.ObjectNavigatorFactory;
import clover.com.google.gson.ParameterizedTypeHandlerMap;
import clover.com.google.gson.Preconditions;
import clover.com.google.gson.TypeInfoArray;
import clover.com.google.gson.TypeInfoFactory;
import java.lang.reflect.Array;
import java.lang.reflect.Field;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class JsonSerializationVisitor
implements ObjectNavigator.Visitor {
    private final ObjectNavigatorFactory factory;
    private final ParameterizedTypeHandlerMap<JsonSerializer<?>> serializers;
    private final boolean serializeNulls;
    private final JsonSerializationContext context;
    private JsonElement root;
    static /* synthetic */ Class class$java$lang$Object;

    JsonSerializationVisitor(ObjectNavigatorFactory factory, boolean serializeNulls, ParameterizedTypeHandlerMap<JsonSerializer<?>> serializers, JsonSerializationContext context) {
        this.factory = factory;
        this.serializeNulls = serializeNulls;
        this.serializers = serializers;
        this.context = context;
    }

    @Override
    public Object getTarget() {
        return null;
    }

    @Override
    public void startVisitingObject(Object node) {
        this.assignToRoot(new JsonObject());
    }

    @Override
    public void visitArray(Object array, Object arrayType) {
        this.assignToRoot(new JsonArray());
        int length = Array.getLength(array);
        TypeInfoArray fieldTypeInfo = TypeInfoFactory.getTypeInfoForArray(arrayType);
        Object componentType = fieldTypeInfo.getSecondLevelType();
        for (int i = 0; i < length; ++i) {
            Object child = Array.get(array, i);
            this.addAsArrayElement(componentType, child);
        }
    }

    @Override
    public void visitArrayField(Field f, Object typeOfF, Object obj) {
        if (this.isFieldNull(f, obj)) {
            if (this.serializeNulls) {
                this.addChildAsElement(f, JsonNull.createJsonNull());
            }
        } else {
            Object array = this.getFieldValue(f, obj);
            this.addAsChildOfObject(f, typeOfF, array);
        }
    }

    @Override
    public void visitObjectField(Field f, Object typeOfF, Object obj) {
        if (this.isFieldNull(f, obj)) {
            if (this.serializeNulls) {
                this.addChildAsElement(f, JsonNull.createJsonNull());
            }
        } else {
            Object fieldValue = this.getFieldValue(f, obj);
            if (fieldValue != null) {
                Class<?> clazz = class$java$lang$Object;
                if (clazz == null) {
                    clazz = class$java$lang$Object = new Object[0].getClass().getComponentType();
                }
                if (typeOfF == clazz) {
                    typeOfF = fieldValue.getClass();
                }
            }
            this.addAsChildOfObject(f, typeOfF, fieldValue);
        }
    }

    private void addAsChildOfObject(Field f, Object fieldType, Object fieldValue) {
        JsonElement childElement = this.getJsonElementForChild(fieldType, fieldValue);
        this.addChildAsElement(f, childElement);
    }

    private void addChildAsElement(Field f, JsonElement childElement) {
        FieldNamingStrategy namingPolicy = this.factory.getFieldNamingPolicy();
        this.root.getAsJsonObject().add(namingPolicy.translateName(f), childElement);
    }

    private void addAsArrayElement(Object elementType, Object elementValue) {
        if (elementValue == null) {
            this.root.getAsJsonArray().add(JsonNull.createJsonNull());
        } else {
            JsonElement childElement = this.getJsonElementForChild(elementType, elementValue);
            this.root.getAsJsonArray().add(childElement);
        }
    }

    private JsonElement getJsonElementForChild(Object fieldType, Object fieldValue) {
        ObjectNavigator on = this.factory.create(fieldValue, fieldType);
        JsonSerializationVisitor childVisitor = new JsonSerializationVisitor(this.factory, this.serializeNulls, this.serializers, this.context);
        on.accept(childVisitor);
        return childVisitor.getJsonElement();
    }

    @Override
    public boolean visitUsingCustomHandler(Object obj, Object objType) {
        JsonSerializer<?> serializer = this.serializers.getHandlerFor(objType);
        if (serializer != null) {
            if (obj == null) {
                this.assignToRoot(JsonNull.createJsonNull());
            } else {
                this.assignToRoot(serializer.serialize(obj, objType, this.context));
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean visitFieldUsingCustomHandler(Field f, Object actualTypeOfField, Object parent) {
        try {
            Preconditions.checkState(this.root.isJsonObject());
            Object obj = f.get(parent);
            if (obj == null) {
                if (this.serializeNulls) {
                    this.addChildAsElement(f, JsonNull.createJsonNull());
                }
                return true;
            }
            JsonSerializer<?> serializer = this.serializers.getHandlerFor(actualTypeOfField);
            if (serializer != null) {
                JsonElement child = serializer.serialize(obj, actualTypeOfField, this.context);
                this.addChildAsElement(f, child);
                return true;
            }
            return false;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException();
        }
    }

    private void assignToRoot(JsonElement newRoot) {
        Preconditions.checkNotNull(newRoot);
        this.root = newRoot;
    }

    private boolean isFieldNull(Field f, Object obj) {
        return this.getFieldValue(f, obj) == null;
    }

    private Object getFieldValue(Field f, Object obj) {
        try {
            return f.get(obj);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public JsonElement getJsonElement() {
        return this.root;
    }
}

