/*
 * Decompiled with CFR 0.152.
 */
package clover.com.google.gson;

import clover.com.google.gson.Preconditions;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Primitives {
    public static final Map<Class<?>, Class<?>> PRIMITIVE_TO_WRAPPER_TYPE;
    public static final Map<Class<?>, Class<?>> WRAPPER_TO_PRIMITIVE_TYPE;
    static /* synthetic */ Class class$java$lang$Void;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Integer;

    private Primitives() {
    }

    private static void add(Map<Class<?>, Class<?>> forward, Map<Class<?>, Class<?>> backward, Class<?> key, Class<?> value) {
        forward.put(key, value);
        backward.put(value, key);
    }

    public static boolean isWrapperType(Class<?> type) {
        return WRAPPER_TO_PRIMITIVE_TYPE.containsKey(Primitives.checkNotNull(type));
    }

    private static Class<?> checkNotNull(Class<?> type) {
        Preconditions.checkNotNull(type);
        return type;
    }

    public static <T> Class<T> wrap(Class<T> type) {
        Primitives.checkNotNull(type);
        Class<?> wrapped = PRIMITIVE_TO_WRAPPER_TYPE.get(type);
        return wrapped == null ? type : wrapped;
    }

    public static <T> Class<T> unwrap(Class<T> type) {
        Primitives.checkNotNull(type);
        Class<?> unwrapped = WRAPPER_TO_PRIMITIVE_TYPE.get(type);
        return unwrapped == null ? type : unwrapped;
    }

    static {
        HashMap primToWrap = new HashMap(16);
        HashMap wrapToPrim = new HashMap(16);
        Class<?> clazz = class$java$lang$Boolean;
        if (clazz == null) {
            clazz = class$java$lang$Boolean = new Boolean[0].getClass().getComponentType();
        }
        Primitives.add(primToWrap, wrapToPrim, Boolean.TYPE, clazz);
        Class<?> clazz2 = class$java$lang$Byte;
        if (clazz2 == null) {
            clazz2 = class$java$lang$Byte = new Byte[0].getClass().getComponentType();
        }
        Primitives.add(primToWrap, wrapToPrim, Byte.TYPE, clazz2);
        Class<?> clazz3 = class$java$lang$Character;
        if (clazz3 == null) {
            clazz3 = class$java$lang$Character = new Character[0].getClass().getComponentType();
        }
        Primitives.add(primToWrap, wrapToPrim, Character.TYPE, clazz3);
        Class<?> clazz4 = class$java$lang$Double;
        if (clazz4 == null) {
            clazz4 = class$java$lang$Double = new Double[0].getClass().getComponentType();
        }
        Primitives.add(primToWrap, wrapToPrim, Double.TYPE, clazz4);
        Class<?> clazz5 = class$java$lang$Float;
        if (clazz5 == null) {
            clazz5 = class$java$lang$Float = new Float[0].getClass().getComponentType();
        }
        Primitives.add(primToWrap, wrapToPrim, Float.TYPE, clazz5);
        Class<?> clazz6 = class$java$lang$Integer;
        if (clazz6 == null) {
            clazz6 = class$java$lang$Integer = new Integer[0].getClass().getComponentType();
        }
        Primitives.add(primToWrap, wrapToPrim, Integer.TYPE, clazz6);
        Class<?> clazz7 = class$java$lang$Long;
        if (clazz7 == null) {
            clazz7 = class$java$lang$Long = new Long[0].getClass().getComponentType();
        }
        Primitives.add(primToWrap, wrapToPrim, Long.TYPE, clazz7);
        Class<?> clazz8 = class$java$lang$Short;
        if (clazz8 == null) {
            clazz8 = class$java$lang$Short = new Short[0].getClass().getComponentType();
        }
        Primitives.add(primToWrap, wrapToPrim, Short.TYPE, clazz8);
        Class<?> clazz9 = class$java$lang$Void;
        if (clazz9 == null) {
            clazz9 = class$java$lang$Void = new Void[0].getClass().getComponentType();
        }
        Primitives.add(primToWrap, wrapToPrim, Void.TYPE, clazz9);
        PRIMITIVE_TO_WRAPPER_TYPE = Collections.unmodifiableMap(primToWrap);
        WRAPPER_TO_PRIMITIVE_TYPE = Collections.unmodifiableMap(wrapToPrim);
    }
}

